/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tiff;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import loci.common.ByteArrayHandle;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.codec.CodecOptions;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.IFDType;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiffSaver {
    private static final Logger LOGGER = LoggerFactory.getLogger(TiffSaver.class);
    protected RandomAccessOutputStream out;
    protected String filename;
    protected ByteArrayHandle bytes;
    private boolean bigTiff = false;
    private boolean sequentialWrite = false;
    private CodecOptions options;

    public TiffSaver(String filename) throws IOException {
        this(new RandomAccessOutputStream(filename), filename);
    }

    public TiffSaver(RandomAccessOutputStream out, String filename) {
        if (out == null) {
            throw new IllegalArgumentException("Output stream expected to be not-null");
        }
        if (filename == null) {
            throw new IllegalArgumentException("Filename expected to be not null");
        }
        this.out = out;
        this.filename = filename;
    }

    public TiffSaver(RandomAccessOutputStream out, ByteArrayHandle bytes) {
        if (out == null) {
            throw new IllegalArgumentException("Output stream expected to be not-null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Bytes expected to be not null");
        }
        this.out = out;
        this.bytes = bytes;
    }

    public void setWritingSequentially(boolean sequential) {
        this.sequentialWrite = sequential;
    }

    public RandomAccessOutputStream getStream() {
        return this.out;
    }

    public void setLittleEndian(boolean littleEndian) {
        this.out.order(littleEndian);
    }

    public void setBigTiff(boolean bigTiff) {
        this.bigTiff = bigTiff;
    }

    public boolean isLittleEndian() {
        return this.out.isLittleEndian();
    }

    public boolean isBigTiff() {
        return this.bigTiff;
    }

    public void setCodecOptions(CodecOptions options) {
        this.options = options;
    }

    public void writeHeader() throws IOException {
        this.out.seek(0L);
        if (this.isLittleEndian()) {
            this.out.writeByte(73);
            this.out.writeByte(73);
        } else {
            this.out.writeByte(77);
            this.out.writeByte(77);
        }
        if (this.bigTiff) {
            this.out.writeShort(43);
        } else {
            this.out.writeShort(42);
        }
        if (this.bigTiff) {
            this.out.writeShort(8);
            this.out.writeShort(0);
            this.out.writeLong(16L);
        } else {
            this.out.writeInt(8);
        }
    }

    public void writeImage(byte[][] buf, IFDList ifds, int pixelType) throws FormatException, IOException {
        if (ifds == null) {
            throw new FormatException("IFD cannot be null");
        }
        if (buf == null) {
            throw new FormatException("Image data cannot be null");
        }
        for (int i = 0; i < ifds.size(); ++i) {
            if (i >= buf.length) continue;
            this.writeImage(buf[i], (IFD)ifds.get(i), i, pixelType, i == ifds.size() - 1);
        }
    }

    public void writeImage(byte[] buf, IFD ifd, int no, int pixelType, boolean last) throws FormatException, IOException {
        if (ifd == null) {
            throw new FormatException("IFD cannot be null");
        }
        int w = (int)ifd.getImageWidth();
        int h = (int)ifd.getImageLength();
        this.writeImage(buf, ifd, no, pixelType, 0, 0, w, h, last);
    }

    public void writeImage(byte[] buf, IFD ifd, int no, int pixelType, int x, int y, int w, int h, boolean last) throws FormatException, IOException {
        this.writeImage(buf, ifd, no, pixelType, x, y, w, h, last, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(byte[] buf, IFD ifd, int no, int pixelType, int x, int y, int w, int h, boolean last, Integer nChannels, boolean copyDirectly) throws FormatException, IOException {
        ByteArrayOutputStream[] stripBuf;
        int nStrips;
        int tileHeight;
        int tileWidth;
        TiffCompression compression;
        boolean interleaved;
        LOGGER.debug("Attempting to write image.");
        if (buf == null) {
            throw new FormatException("Image data cannot be null");
        }
        if (ifd == null) {
            throw new FormatException("IFD cannot be null");
        }
        TiffSaver tiffSaver = this;
        synchronized (tiffSaver) {
            int effectiveStrips;
            int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
            int blockSize = w * h * bytesPerPixel;
            if (nChannels == null) {
                nChannels = buf.length / (w * h * bytesPerPixel);
            }
            interleaved = ifd.getPlanarConfiguration() == 1;
            this.makeValidIFD(ifd, pixelType, nChannels);
            compression = ifd.getCompression();
            tileWidth = (int)ifd.getTileWidth();
            tileHeight = (int)ifd.getTileLength();
            int tilesPerRow = (int)ifd.getTilesPerRow();
            int rowsPerStrip = (int)ifd.getRowsPerStrip()[0];
            int stripSize = rowsPerStrip * tileWidth * bytesPerPixel;
            nStrips = (w + tileWidth - 1) / tileWidth * ((h + tileHeight - 1) / tileHeight);
            if (interleaved) {
                stripSize *= nChannels.intValue();
            } else {
                nStrips *= nChannels.intValue();
            }
            stripBuf = new ByteArrayOutputStream[nStrips];
            DataOutputStream[] stripOut = new DataOutputStream[nStrips];
            for (int strip = 0; strip < nStrips; ++strip) {
                stripBuf[strip] = new ByteArrayOutputStream(stripSize);
                stripOut[strip] = new DataOutputStream(stripBuf[strip]);
            }
            int[] bps = ifd.getBitsPerSample();
            int n = effectiveStrips = !interleaved ? nStrips / nChannels : nStrips;
            if (effectiveStrips == 1 && copyDirectly) {
                stripOut[0].write(buf);
            } else {
                for (int strip = 0; strip < effectiveStrips; ++strip) {
                    int xOffset = strip % tilesPerRow * tileWidth;
                    int yOffset = strip / tilesPerRow * tileHeight;
                    for (int row = 0; row < tileHeight; ++row) {
                        for (int col = 0; col < tileWidth; ++col) {
                            int ndx = ((row + yOffset) * w + col + xOffset) * bytesPerPixel;
                            for (int c = 0; c < nChannels; ++c) {
                                for (int n2 = 0; n2 < bps[c] / 8; ++n2) {
                                    int off;
                                    if (interleaved) {
                                        off = ndx * nChannels + c * bytesPerPixel + n2;
                                        if (row >= h || col >= w) {
                                            stripOut[strip].writeByte(0);
                                            continue;
                                        }
                                        if (off < buf.length) {
                                            stripOut[strip].writeByte(buf[off]);
                                            continue;
                                        }
                                        stripOut[strip].writeByte(0);
                                        continue;
                                    }
                                    off = c * blockSize + ndx + n2;
                                    if (row >= h || col >= w) {
                                        stripOut[strip].writeByte(0);
                                        continue;
                                    }
                                    if (off < buf.length) {
                                        stripOut[c * (nStrips / nChannels) + strip].writeByte(buf[off]);
                                        continue;
                                    }
                                    stripOut[strip].writeByte(0);
                                }
                            }
                        }
                    }
                }
            }
        }
        byte[][] strips = new byte[nStrips][];
        for (int strip = 0; strip < nStrips; ++strip) {
            strips[strip] = stripBuf[strip].toByteArray();
            TiffCompression.difference(strips[strip], ifd);
            CodecOptions codecOptions = compression.getCompressionCodecOptions(ifd, this.options);
            codecOptions.height = tileHeight;
            codecOptions.width = tileWidth;
            codecOptions.channels = interleaved ? nChannels : 1;
            strips[strip] = compression.compress(strips[strip], codecOptions);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug(String.format("Compressed strip %d/%d length %d", strip + 1, nStrips, strips[strip].length));
        }
        TiffSaver tiffSaver2 = this;
        synchronized (tiffSaver2) {
            this.writeImageIFD(ifd, no, strips, nChannels, last, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageIFD(IFD ifd, int no, byte[][] strips, int nChannels, boolean last, int x, int y) throws FormatException, IOException {
        LOGGER.debug("Attempting to write image IFD.");
        int tilesPerRow = (int)ifd.getTilesPerRow();
        int tilesPerColumn = (int)ifd.getTilesPerColumn();
        boolean interleaved = ifd.getPlanarConfiguration() == 1;
        boolean isTiled = ifd.isTiled();
        if (!this.sequentialWrite) {
            RandomAccessInputStream in = null;
            if (this.filename != null) {
                in = new RandomAccessInputStream(this.filename);
            } else if (this.bytes != null) {
                in = new RandomAccessInputStream(this.bytes);
            } else {
                throw new IllegalArgumentException("Filename and bytes are null, cannot create new input stream!");
            }
            try {
                TiffParser parser = new TiffParser(in);
                long[] ifdOffsets = parser.getIFDOffsets();
                LOGGER.debug("IFD offsets: {}", (Object)Arrays.toString(ifdOffsets));
                if (no < ifdOffsets.length) {
                    this.out.seek(ifdOffsets[no]);
                    LOGGER.debug("Reading IFD from {} in non-sequential write.", (Object)ifdOffsets[no]);
                    ifd = parser.getIFD(ifdOffsets[no]);
                }
            }
            finally {
                in.close();
            }
        }
        ArrayList<Long> byteCounts = new ArrayList<Long>();
        ArrayList<Long> offsets = new ArrayList<Long>();
        long totalTiles = tilesPerRow * tilesPerColumn;
        if (!interleaved) {
            totalTiles *= (long)nChannels;
        }
        if (ifd.containsKey(279) || ifd.containsKey(325)) {
            long[] ifdByteCounts;
            for (long stripByteCount : ifdByteCounts = isTiled ? ifd.getIFDLongArray(325) : ifd.getStripByteCounts()) {
                byteCounts.add(stripByteCount);
            }
        } else {
            while ((long)byteCounts.size() < totalTiles) {
                byteCounts.add(0L);
            }
        }
        int tileOrStripOffsetX = x / (int)ifd.getTileWidth();
        int tileOrStripOffsetY = y / (int)ifd.getTileLength();
        int firstOffset = tileOrStripOffsetY * tilesPerRow + tileOrStripOffsetX;
        if (ifd.containsKey(273) || ifd.containsKey(324)) {
            long[] ifdOffsets = isTiled ? ifd.getIFDLongArray(324) : ifd.getStripOffsets();
            for (int i = 0; i < ifdOffsets.length; ++i) {
                offsets.add(ifdOffsets[i]);
            }
        } else {
            while ((long)offsets.size() < totalTiles) {
                offsets.add(0L);
            }
        }
        if (isTiled) {
            ifd.putIFDValue(325, this.toPrimitiveArray(byteCounts));
            ifd.putIFDValue(324, this.toPrimitiveArray(offsets));
        } else {
            ifd.putIFDValue(279, this.toPrimitiveArray(byteCounts));
            ifd.putIFDValue(273, this.toPrimitiveArray(offsets));
        }
        long fp = this.out.getFilePointer();
        this.writeIFD(ifd, 0L);
        for (int i = 0; i < strips.length; ++i) {
            this.out.seek(this.out.length());
            int thisOffset = firstOffset + i;
            offsets.set(thisOffset, this.out.getFilePointer());
            byteCounts.set(thisOffset, new Long(strips[i].length));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Writing tile/strip %d/%d size: %d offset: %d", thisOffset + 1, totalTiles, byteCounts.get(thisOffset), offsets.get(thisOffset)));
            }
            this.out.write(strips[i]);
        }
        if (isTiled) {
            ifd.putIFDValue(325, this.toPrimitiveArray(byteCounts));
            ifd.putIFDValue(324, this.toPrimitiveArray(offsets));
        } else {
            ifd.putIFDValue(279, this.toPrimitiveArray(byteCounts));
            ifd.putIFDValue(273, this.toPrimitiveArray(offsets));
        }
        long endFP = this.out.getFilePointer();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Offset before IFD write: {} Seeking to: {}", (Object)this.out.getFilePointer(), (Object)fp);
        }
        this.out.seek(fp);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Writing tile/strip offsets: {}", (Object)Arrays.toString(this.toPrimitiveArray(offsets)));
            LOGGER.debug("Writing tile/strip byte counts: {}", (Object)Arrays.toString(this.toPrimitiveArray(byteCounts)));
        }
        this.writeIFD(ifd, last ? 0L : endFP);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Offset after IFD write: {}", (Object)this.out.getFilePointer());
        }
    }

    public void writeIFD(IFD ifd, long nextOffset) throws FormatException, IOException {
        TreeSet keys = new TreeSet(ifd.keySet());
        int keyCount = keys.size();
        if (ifd.containsKey(new Integer(0))) {
            --keyCount;
        }
        if (ifd.containsKey(new Integer(1))) {
            --keyCount;
        }
        if (ifd.containsKey(new Integer(3))) {
            --keyCount;
        }
        long fp = this.out.getFilePointer();
        int bytesPerEntry = this.bigTiff ? 20 : 12;
        int ifdBytes = (this.bigTiff ? 16 : 6) + bytesPerEntry * keyCount;
        if (this.bigTiff) {
            this.out.writeLong(keyCount);
        } else {
            this.out.writeShort(keyCount);
        }
        ByteArrayHandle extra = new ByteArrayHandle();
        RandomAccessOutputStream extraStream = new RandomAccessOutputStream(extra);
        for (Integer key : keys) {
            if (key.equals(0) || key.equals(1) || key.equals(3)) continue;
            Object value = ifd.get(key);
            this.writeIFDValue(extraStream, (long)ifdBytes + fp, key, value);
        }
        if (this.bigTiff) {
            this.out.seek(this.out.getFilePointer());
        }
        this.writeIntValue(this.out, nextOffset);
        this.out.write(extra.getBytes(), 0, (int)extra.length());
    }

    public void writeIFDValue(RandomAccessOutputStream extraOut, long offset, int tag, Object value) throws FormatException, IOException {
        extraOut.order(this.isLittleEndian());
        if (value instanceof Short) {
            value = new short[]{(Short)value};
        } else if (value instanceof Integer) {
            value = new int[]{(Integer)value};
        } else if (value instanceof Long) {
            value = new long[]{(Long)value};
        } else if (value instanceof TiffRational) {
            value = new TiffRational[]{(TiffRational)value};
        } else if (value instanceof Float) {
            value = new float[]{((Float)value).floatValue()};
        } else if (value instanceof Double) {
            value = new double[]{(Double)value};
        }
        int dataLength = this.bigTiff ? 8 : 4;
        this.out.writeShort(tag);
        if (value instanceof short[]) {
            short[] q = (short[])value;
            this.out.writeShort(IFDType.BYTE.getCode());
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeByte(q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    this.out.writeByte(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
            }
        } else if (value instanceof String) {
            char[] q = ((String)value).toCharArray();
            this.out.writeShort(IFDType.ASCII.getCode());
            this.writeIntValue(this.out, q.length + 1);
            if (q.length < dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeByte(q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    this.out.writeByte(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte(q[i]);
                }
                extraOut.writeByte(0);
            }
        } else if (value instanceof int[]) {
            int[] q = (int[])value;
            this.out.writeShort(IFDType.SHORT.getCode());
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength / 2) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeShort(q[i]);
                }
                for (i = q.length; i < dataLength / 2; ++i) {
                    this.out.writeShort(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeShort(q[i]);
                }
            }
        } else if (value instanceof long[]) {
            int div;
            long[] q = (long[])value;
            int type = this.bigTiff ? IFDType.LONG8.getCode() : IFDType.LONG.getCode();
            this.out.writeShort(type);
            this.writeIntValue(this.out, q.length);
            int n = div = this.bigTiff ? 8 : 4;
            if (q.length <= dataLength / div) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.writeIntValue(this.out, q[0]);
                }
                for (i = q.length; i < dataLength / div; ++i) {
                    this.writeIntValue(this.out, 0L);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    this.writeIntValue(extraOut, q[i]);
                }
            }
        } else if (value instanceof TiffRational[]) {
            Object[] q = value;
            this.out.writeShort(IFDType.RATIONAL.getCode());
            this.writeIntValue(this.out, q.length);
            if (this.bigTiff && q.length == 1) {
                this.out.writeInt((int)((TiffRational)q[0]).getNumerator());
                this.out.writeInt((int)((TiffRational)q[0]).getDenominator());
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeInt((int)((TiffRational)q[i]).getNumerator());
                    extraOut.writeInt((int)((TiffRational)q[i]).getDenominator());
                }
            }
        } else if (value instanceof float[]) {
            float[] q = (float[])value;
            this.out.writeShort(IFDType.FLOAT.getCode());
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength / 4) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeFloat(q[0]);
                }
                for (i = q.length; i < dataLength / 4; ++i) {
                    this.out.writeInt(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeFloat(q[i]);
                }
            }
        } else if (value instanceof double[]) {
            double[] q = (double[])value;
            this.out.writeShort(IFDType.DOUBLE.getCode());
            this.writeIntValue(this.out, q.length);
            this.writeIntValue(this.out, offset + extraOut.length());
            for (int i = 0; i < q.length; ++i) {
                extraOut.writeDouble(q[i]);
            }
        } else {
            throw new FormatException("Unknown IFD value type (" + value.getClass().getName() + "): " + value);
        }
    }

    public void overwriteLastIFDOffset(RandomAccessInputStream raf) throws FormatException, IOException {
        if (raf == null) {
            throw new FormatException("Output cannot be null");
        }
        TiffParser parser = new TiffParser(raf);
        long[] offsets = parser.getIFDOffsets();
        this.out.seek(raf.getFilePointer() - (long)(this.bigTiff ? 8 : 4));
        this.writeIntValue(this.out, 0L);
    }

    public void overwriteIFDValue(RandomAccessInputStream raf, int ifd, int tag, Object value) throws FormatException, IOException {
        if (raf == null) {
            throw new FormatException("Output cannot be null");
        }
        LOGGER.debug("overwriteIFDValue (ifd={}; tag={}; value={})", ifd, tag, value);
        raf.seek(0L);
        TiffParser parser = new TiffParser(raf);
        Boolean valid = parser.checkHeader();
        if (valid == null) {
            throw new FormatException("Invalid TIFF header");
        }
        boolean little = valid;
        boolean bigTiff = parser.isBigTiff();
        this.setLittleEndian(little);
        this.setBigTiff(bigTiff);
        long offset = bigTiff ? 8L : 4L;
        int bytesPerEntry = bigTiff ? 20 : 12;
        raf.seek(offset);
        long[] offsets = parser.getIFDOffsets();
        if (ifd >= offsets.length) {
            throw new FormatException("No such IFD (" + ifd + " of " + offsets.length + ")");
        }
        raf.seek(offsets[ifd]);
        long num = bigTiff ? raf.readLong() : (long)raf.readUnsignedShort();
        int i = 0;
        while ((long)i < num) {
            raf.seek(offsets[ifd] + (long)(bigTiff ? 8 : 2) + (long)(bytesPerEntry * i));
            TiffIFDEntry entry = parser.readTiffIFDEntry();
            if (entry.getTag() == tag) {
                long newOffset;
                int newCount;
                ByteArrayHandle ifdBuf = new ByteArrayHandle(bytesPerEntry);
                RandomAccessOutputStream ifdOut = new RandomAccessOutputStream(ifdBuf);
                ByteArrayHandle extraBuf = new ByteArrayHandle();
                RandomAccessOutputStream extraOut = new RandomAccessOutputStream(extraBuf);
                extraOut.order(little);
                TiffSaver saver = new TiffSaver(ifdOut, ifdBuf);
                saver.setLittleEndian(this.isLittleEndian());
                saver.writeIFDValue(extraOut, entry.getValueOffset(), tag, value);
                ifdBuf.seek(0L);
                extraBuf.seek(0L);
                short newTag = ifdBuf.readShort();
                short newType = ifdBuf.readShort();
                if (bigTiff) {
                    newCount = ifdBuf.readInt();
                    newOffset = ifdBuf.readLong();
                } else {
                    newCount = ifdBuf.readInt();
                    newOffset = ifdBuf.readInt();
                }
                LOGGER.debug("overwriteIFDValue:");
                LOGGER.debug("\told ({});", (Object)entry);
                LOGGER.debug("\tnew: (tag={}; type={}; count={}; offset={})", (int)newTag, (int)newType, newCount, newOffset);
                if (extraBuf.length() == 0L) {
                    LOGGER.debug("overwriteIFDValue: new entry is inline");
                } else if (entry.getValueOffset() + (long)(entry.getValueCount() * entry.getType().getBytesPerElement()) == raf.length()) {
                    newOffset = entry.getValueOffset();
                    LOGGER.debug("overwriteIFDValue: old entry is at EOF");
                } else if (newCount <= entry.getValueCount()) {
                    newOffset = entry.getValueOffset();
                    LOGGER.debug("overwriteIFDValue: new entry is <= old entry");
                } else {
                    newOffset = raf.length();
                    LOGGER.debug("overwriteIFDValue: old entry will be orphaned");
                }
                this.out.seek(offsets[ifd] + (long)(bigTiff ? 8 : 2) + (long)(bytesPerEntry * i) + 2L);
                this.out.writeShort(newType);
                this.writeIntValue(this.out, newCount);
                this.writeIntValue(this.out, newOffset);
                if (extraBuf.length() > 0L) {
                    this.out.seek(newOffset);
                    this.out.write(extraBuf.getByteBuffer(), 0, newCount);
                }
                return;
            }
            ++i;
        }
        throw new FormatException("Tag not found (" + IFD.getIFDTagName(tag) + ")");
    }

    public void overwriteComment(RandomAccessInputStream in, Object value) throws FormatException, IOException {
        this.overwriteIFDValue(in, 0, 270, value);
    }

    private long[] toPrimitiveArray(List<Long> l) {
        long[] toReturn = new long[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            toReturn[i] = l.get(i);
        }
        return toReturn;
    }

    private void writeIntValue(RandomAccessOutputStream out, long offset) throws IOException {
        if (this.bigTiff) {
            out.writeLong(offset);
        } else {
            out.writeInt((int)offset);
        }
    }

    private void makeValidIFD(IFD ifd, int pixelType, int nChannels) {
        boolean indexed;
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int bps = 8 * bytesPerPixel;
        int[] bpsArray = new int[nChannels];
        Arrays.fill(bpsArray, bps);
        ifd.putIFDValue(258, bpsArray);
        if (FormatTools.isFloatingPoint(pixelType)) {
            ifd.putIFDValue(339, 3);
        }
        if (ifd.getIFDValue(259) == null) {
            ifd.putIFDValue(259, TiffCompression.UNCOMPRESSED.getCode());
        }
        boolean bl = indexed = nChannels == 1 && ifd.getIFDValue(320) != null;
        PhotoInterp pi = indexed ? PhotoInterp.RGB_PALETTE : (nChannels == 1 ? PhotoInterp.BLACK_IS_ZERO : PhotoInterp.RGB);
        ifd.putIFDValue(262, pi.getCode());
        ifd.putIFDValue(277, nChannels);
        if (ifd.get(282) == null) {
            ifd.putIFDValue(282, new TiffRational(1L, 1L));
        }
        if (ifd.get(283) == null) {
            ifd.putIFDValue(283, new TiffRational(1L, 1L));
        }
        if (ifd.get(305) == null) {
            ifd.putIFDValue(305, "OME Bio-Formats");
        }
        if (ifd.get(278) == null && ifd.get(322) == null && ifd.get(323) == null) {
            ifd.putIFDValue(278, new long[]{1L});
        }
        if (ifd.get(270) == null) {
            ifd.putIFDValue(270, "");
        }
    }
}

