/*
 * Decompiled with CFR 0.152.
 */
package ome.specification;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import ome.specification.SchemaResolver;
import org.w3c.dom.Document;

public class OmeValidator {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public boolean isValidFile(File file2, File schema) {
        try {
            Document theDocument = this.parseFile(file2, schema);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidFile(File file2, StreamSource[] schemaStreamArray) {
        try {
            Document theDocument = this.parseFileWithStreamArray(file2, schemaStreamArray);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void validateFile(File file2, StreamSource[] schemaStreamArray) throws Exception {
        Document theDocument = this.parseFileWithStreamArray(file2, schemaStreamArray);
    }

    public void validateFile(File file2, File schema) throws Exception {
        Document theDocument = this.parseFile(file2, schema);
    }

    public void validateFileToStdError(File file2, StreamSource[] schemaStreamArray) throws Exception {
        Document theDocument = this.parseFileWithStreamArrayToSdtErr(file2, schemaStreamArray);
    }

    public Document parseFile(File file2, File schema) throws Exception {
        if (file2 == null) {
            throw new IllegalArgumentException("No file to parse.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        if (schema != null) {
            dbf.setValidating(true);
            dbf.setNamespaceAware(true);
            dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            dbf.setAttribute(JAXP_SCHEMA_SOURCE, schema);
        }
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.parse(file2);
    }

    public Document parseFileWithStreamArray(File file2, StreamSource[] schemaStreamArray) throws Exception {
        if (file2 == null) {
            throw new IllegalArgumentException("No file to parse.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        SchemaFactory sFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        SchemaResolver theTestClassResolver = new SchemaResolver();
        sFactory.setResourceResolver(theTestClassResolver);
        Schema theSchema = sFactory.newSchema(schemaStreamArray);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document theDoc = builder.parse(file2);
        Validator validator = theSchema.newValidator();
        validator.validate(new DOMSource(theDoc));
        return theDoc;
    }

    public Document parseFileWithStreamArrayToSdtErr(File file2, StreamSource[] schemaStreamArray) throws Exception {
        if (file2 == null) {
            throw new IllegalArgumentException("No file to parse.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        SchemaFactory sFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        SchemaResolver theTestClassResolver = new SchemaResolver();
        sFactory.setResourceResolver(theTestClassResolver);
        Schema theSchema = sFactory.newSchema(schemaStreamArray);
        dbf.setSchema(theSchema);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document theDoc = builder.parse(file2);
        return theDoc;
    }
}

