/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.meta;

import loci.common.DataTools;
import ome.xml.meta.MetadataRoot;
import ome.xml.meta.MetadataStore;
import ome.xml.model.AffineTransform;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.LineCap;
import ome.xml.model.enums.Marker;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class FilterMetadata
implements MetadataStore {
    private MetadataStore store;
    private boolean filter;

    public FilterMetadata(MetadataStore store, boolean filter) {
        this.store = store;
        this.filter = filter;
    }

    @Override
    public void createRoot() {
        this.store.createRoot();
    }

    @Override
    public MetadataRoot getRoot() {
        return this.store.getRoot();
    }

    @Override
    public void setRoot(MetadataRoot root) {
        this.store.setRoot(root);
    }

    @Override
    @Deprecated
    public void setRoot(Object root) {
        this.store.setRoot(root);
    }

    @Override
    public void setUUID(String uuid) {
        this.store.setUUID(uuid);
    }

    @Override
    public void setPixelsBinDataBigEndian(Boolean bigEndian, int imageIndex, int binDataIndex) {
        this.store.setPixelsBinDataBigEndian(bigEndian, imageIndex, binDataIndex);
    }

    @Override
    public void setMaskBinData(byte[] binData, int ROIIndex, int shapeIndex) {
        this.store.setMaskBinData(binData, ROIIndex, shapeIndex);
    }

    @Override
    public void setArcID(String id, int instrumentIndex, int lightSourceIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setArcID(id, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setArcLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setArcLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setArcManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setArcManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setArcModel(String model, int instrumentIndex, int lightSourceIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setArcModel(model, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setArcPower(Double power, int instrumentIndex, int lightSourceIndex) {
        this.store.setArcPower(power, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setArcSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setArcSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setArcType(ArcType type, int instrumentIndex, int lightSourceIndex) {
        this.store.setArcType(type, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setBinaryFileFileName(String fileName, int fileAnnotationIndex) {
        fileName = this.filter ? DataTools.sanitize(fileName) : fileName;
        this.store.setBinaryFileFileName(fileName, fileAnnotationIndex);
    }

    @Override
    public void setBinaryFileMIMEType(String mimeType, int fileAnnotationIndex) {
        mimeType = this.filter ? DataTools.sanitize(mimeType) : mimeType;
        this.store.setBinaryFileMIMEType(mimeType, fileAnnotationIndex);
    }

    @Override
    public void setBinaryFileSize(NonNegativeLong size, int fileAnnotationIndex) {
        this.store.setBinaryFileSize(size, fileAnnotationIndex);
    }

    @Override
    public void setBinaryOnlyMetadataFile(String metadataFile) {
        metadataFile = this.filter ? DataTools.sanitize(metadataFile) : metadataFile;
        this.store.setBinaryOnlyMetadataFile(metadataFile);
    }

    @Override
    public void setBinaryOnlyUUID(String uuid) {
        uuid = this.filter ? DataTools.sanitize(uuid) : uuid;
        this.store.setBinaryOnlyUUID(uuid);
    }

    @Override
    public void setBooleanAnnotationAnnotationRef(String annotation, int booleanAnnotationIndex, int annotationRefIndex) {
        this.store.setBooleanAnnotationAnnotationRef(annotation, booleanAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setBooleanAnnotationAnnotator(String annotator, int booleanAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setBooleanAnnotationAnnotator(annotator, booleanAnnotationIndex);
    }

    @Override
    public void setBooleanAnnotationDescription(String description, int booleanAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setBooleanAnnotationDescription(description, booleanAnnotationIndex);
    }

    @Override
    public void setBooleanAnnotationID(String id, int booleanAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setBooleanAnnotationID(id, booleanAnnotationIndex);
    }

    @Override
    public void setBooleanAnnotationNamespace(String namespace, int booleanAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setBooleanAnnotationNamespace(namespace, booleanAnnotationIndex);
    }

    @Override
    public void setBooleanAnnotationValue(Boolean value, int booleanAnnotationIndex) {
        this.store.setBooleanAnnotationValue(value, booleanAnnotationIndex);
    }

    @Override
    public void setChannelAcquisitionMode(AcquisitionMode acquisitionMode, int imageIndex, int channelIndex) {
        this.store.setChannelAcquisitionMode(acquisitionMode, imageIndex, channelIndex);
    }

    @Override
    public void setChannelAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        this.store.setChannelAnnotationRef(annotation, imageIndex, channelIndex, annotationRefIndex);
    }

    @Override
    public void setChannelColor(Color color, int imageIndex, int channelIndex) {
        this.store.setChannelColor(color, imageIndex, channelIndex);
    }

    @Override
    public void setChannelContrastMethod(ContrastMethod contrastMethod, int imageIndex, int channelIndex) {
        this.store.setChannelContrastMethod(contrastMethod, imageIndex, channelIndex);
    }

    @Override
    public void setChannelEmissionWavelength(PositiveInteger emissionWavelength, int imageIndex, int channelIndex) {
        this.store.setChannelEmissionWavelength(emissionWavelength, imageIndex, channelIndex);
    }

    @Override
    public void setChannelExcitationWavelength(PositiveInteger excitationWavelength, int imageIndex, int channelIndex) {
        this.store.setChannelExcitationWavelength(excitationWavelength, imageIndex, channelIndex);
    }

    @Override
    public void setChannelFilterSetRef(String filterSet, int imageIndex, int channelIndex) {
        this.store.setChannelFilterSetRef(filterSet, imageIndex, channelIndex);
    }

    @Override
    public void setChannelFluor(String fluor, int imageIndex, int channelIndex) {
        fluor = this.filter ? DataTools.sanitize(fluor) : fluor;
        this.store.setChannelFluor(fluor, imageIndex, channelIndex);
    }

    @Override
    public void setChannelID(String id, int imageIndex, int channelIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setChannelID(id, imageIndex, channelIndex);
    }

    @Override
    public void setChannelIlluminationType(IlluminationType illuminationType, int imageIndex, int channelIndex) {
        this.store.setChannelIlluminationType(illuminationType, imageIndex, channelIndex);
    }

    @Override
    public void setChannelNDFilter(Double ndFilter, int imageIndex, int channelIndex) {
        this.store.setChannelNDFilter(ndFilter, imageIndex, channelIndex);
    }

    @Override
    public void setChannelName(String name, int imageIndex, int channelIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setChannelName(name, imageIndex, channelIndex);
    }

    @Override
    public void setChannelPinholeSize(Double pinholeSize, int imageIndex, int channelIndex) {
        this.store.setChannelPinholeSize(pinholeSize, imageIndex, channelIndex);
    }

    @Override
    public void setChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int channelIndex) {
        this.store.setChannelPockelCellSetting(pockelCellSetting, imageIndex, channelIndex);
    }

    @Override
    public void setChannelSamplesPerPixel(PositiveInteger samplesPerPixel, int imageIndex, int channelIndex) {
        this.store.setChannelSamplesPerPixel(samplesPerPixel, imageIndex, channelIndex);
    }

    @Override
    public void setCommentAnnotationAnnotationRef(String annotation, int commentAnnotationIndex, int annotationRefIndex) {
        this.store.setCommentAnnotationAnnotationRef(annotation, commentAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setCommentAnnotationAnnotator(String annotator, int commentAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setCommentAnnotationAnnotator(annotator, commentAnnotationIndex);
    }

    @Override
    public void setCommentAnnotationDescription(String description, int commentAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setCommentAnnotationDescription(description, commentAnnotationIndex);
    }

    @Override
    public void setCommentAnnotationID(String id, int commentAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setCommentAnnotationID(id, commentAnnotationIndex);
    }

    @Override
    public void setCommentAnnotationNamespace(String namespace, int commentAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setCommentAnnotationNamespace(namespace, commentAnnotationIndex);
    }

    @Override
    public void setCommentAnnotationValue(String value, int commentAnnotationIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setCommentAnnotationValue(value, commentAnnotationIndex);
    }

    @Override
    public void setDatasetAnnotationRef(String annotation, int datasetIndex, int annotationRefIndex) {
        this.store.setDatasetAnnotationRef(annotation, datasetIndex, annotationRefIndex);
    }

    @Override
    public void setDatasetDescription(String description, int datasetIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setDatasetDescription(description, datasetIndex);
    }

    @Override
    public void setDatasetExperimenterGroupRef(String experimenterGroup, int datasetIndex) {
        this.store.setDatasetExperimenterGroupRef(experimenterGroup, datasetIndex);
    }

    @Override
    public void setDatasetExperimenterRef(String experimenter, int datasetIndex) {
        this.store.setDatasetExperimenterRef(experimenter, datasetIndex);
    }

    @Override
    public void setDatasetID(String id, int datasetIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDatasetID(id, datasetIndex);
    }

    @Override
    public void setDatasetImageRef(String image, int datasetIndex, int imageRefIndex) {
        this.store.setDatasetImageRef(image, datasetIndex, imageRefIndex);
    }

    @Override
    public void setDatasetName(String name, int datasetIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setDatasetName(name, datasetIndex);
    }

    @Override
    public void setDetectorAmplificationGain(Double amplificationGain, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorAmplificationGain(amplificationGain, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorGain(Double gain, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorGain(gain, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDetectorID(id, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorLotNumber(String lotNumber, int instrumentIndex, int detectorIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setDetectorLotNumber(lotNumber, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setDetectorManufacturer(manufacturer, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setDetectorModel(model, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorOffset(Double offset, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorOffset(offset, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setDetectorSerialNumber(serialNumber, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorType(DetectorType type, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorType(type, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorVoltage(Double voltage, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorVoltage(voltage, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorZoom(Double zoom, int instrumentIndex, int detectorIndex) {
        this.store.setDetectorZoom(zoom, instrumentIndex, detectorIndex);
    }

    @Override
    public void setDetectorSettingsBinning(Binning binning, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsBinning(binning, imageIndex, channelIndex);
    }

    @Override
    public void setDetectorSettingsGain(Double gain, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsGain(gain, imageIndex, channelIndex);
    }

    @Override
    public void setDetectorSettingsID(String id, int imageIndex, int channelIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDetectorSettingsID(id, imageIndex, channelIndex);
    }

    @Override
    public void setDetectorSettingsIntegration(PositiveInteger integration, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsIntegration(integration, imageIndex, channelIndex);
    }

    @Override
    public void setDetectorSettingsOffset(Double offset, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsOffset(offset, imageIndex, channelIndex);
    }

    @Override
    public void setDetectorSettingsReadOutRate(Double readOutRate, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsReadOutRate(readOutRate, imageIndex, channelIndex);
    }

    @Override
    public void setDetectorSettingsVoltage(Double voltage, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsVoltage(voltage, imageIndex, channelIndex);
    }

    @Override
    public void setDetectorSettingsZoom(Double zoom, int imageIndex, int channelIndex) {
        this.store.setDetectorSettingsZoom(zoom, imageIndex, channelIndex);
    }

    @Override
    public void setDichroicID(String id, int instrumentIndex, int dichroicIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDichroicID(id, instrumentIndex, dichroicIndex);
    }

    @Override
    public void setDichroicLotNumber(String lotNumber, int instrumentIndex, int dichroicIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setDichroicLotNumber(lotNumber, instrumentIndex, dichroicIndex);
    }

    @Override
    public void setDichroicManufacturer(String manufacturer, int instrumentIndex, int dichroicIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setDichroicManufacturer(manufacturer, instrumentIndex, dichroicIndex);
    }

    @Override
    public void setDichroicModel(String model, int instrumentIndex, int dichroicIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setDichroicModel(model, instrumentIndex, dichroicIndex);
    }

    @Override
    public void setDichroicSerialNumber(String serialNumber, int instrumentIndex, int dichroicIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setDichroicSerialNumber(serialNumber, instrumentIndex, dichroicIndex);
    }

    @Override
    public void setDoubleAnnotationAnnotationRef(String annotation, int doubleAnnotationIndex, int annotationRefIndex) {
        this.store.setDoubleAnnotationAnnotationRef(annotation, doubleAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setDoubleAnnotationAnnotator(String annotator, int doubleAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setDoubleAnnotationAnnotator(annotator, doubleAnnotationIndex);
    }

    @Override
    public void setDoubleAnnotationDescription(String description, int doubleAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setDoubleAnnotationDescription(description, doubleAnnotationIndex);
    }

    @Override
    public void setDoubleAnnotationID(String id, int doubleAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setDoubleAnnotationID(id, doubleAnnotationIndex);
    }

    @Override
    public void setDoubleAnnotationNamespace(String namespace, int doubleAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setDoubleAnnotationNamespace(namespace, doubleAnnotationIndex);
    }

    @Override
    public void setDoubleAnnotationValue(Double value, int doubleAnnotationIndex) {
        this.store.setDoubleAnnotationValue(value, doubleAnnotationIndex);
    }

    @Override
    public void setEllipseFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        this.store.setEllipseFillColor(fillColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        this.store.setEllipseFillRule(fillRule, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        this.store.setEllipseFontFamily(fontFamily, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setEllipseFontSize(fontSize, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        this.store.setEllipseFontStyle(fontStyle, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setEllipseID(id, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        this.store.setEllipseLineCap(lineCap, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        this.store.setEllipseLocked(locked, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        this.store.setEllipseStrokeColor(strokeColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setEllipseStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setEllipseStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseText(String text, int ROIIndex, int shapeIndex) {
        text = this.filter ? DataTools.sanitize(text) : text;
        this.store.setEllipseText(text, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setEllipseTheC(theC, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setEllipseTheT(theT, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setEllipseTheZ(theZ, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        this.store.setEllipseTransform(transform, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        this.store.setEllipseVisible(visible, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseRadiusX(Double radiusX, int ROIIndex, int shapeIndex) {
        this.store.setEllipseRadiusX(radiusX, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseRadiusY(Double radiusY, int ROIIndex, int shapeIndex) {
        this.store.setEllipseRadiusY(radiusY, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setEllipseX(x, ROIIndex, shapeIndex);
    }

    @Override
    public void setEllipseY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setEllipseY(y, ROIIndex, shapeIndex);
    }

    @Override
    public void setExperimentDescription(String description, int experimentIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setExperimentDescription(description, experimentIndex);
    }

    @Override
    public void setExperimentExperimenterRef(String experimenter, int experimentIndex) {
        this.store.setExperimentExperimenterRef(experimenter, experimentIndex);
    }

    @Override
    public void setExperimentID(String id, int experimentIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setExperimentID(id, experimentIndex);
    }

    @Override
    public void setExperimentType(ExperimentType type, int experimentIndex) {
        this.store.setExperimentType(type, experimentIndex);
    }

    @Override
    public void setExperimenterAnnotationRef(String annotation, int experimenterIndex, int annotationRefIndex) {
        this.store.setExperimenterAnnotationRef(annotation, experimenterIndex, annotationRefIndex);
    }

    @Override
    public void setExperimenterEmail(String email, int experimenterIndex) {
        email = this.filter ? DataTools.sanitize(email) : email;
        this.store.setExperimenterEmail(email, experimenterIndex);
    }

    @Override
    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        firstName = this.filter ? DataTools.sanitize(firstName) : firstName;
        this.store.setExperimenterFirstName(firstName, experimenterIndex);
    }

    @Override
    public void setExperimenterID(String id, int experimenterIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setExperimenterID(id, experimenterIndex);
    }

    @Override
    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        institution = this.filter ? DataTools.sanitize(institution) : institution;
        this.store.setExperimenterInstitution(institution, experimenterIndex);
    }

    @Override
    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        lastName = this.filter ? DataTools.sanitize(lastName) : lastName;
        this.store.setExperimenterLastName(lastName, experimenterIndex);
    }

    @Override
    public void setExperimenterMiddleName(String middleName, int experimenterIndex) {
        middleName = this.filter ? DataTools.sanitize(middleName) : middleName;
        this.store.setExperimenterMiddleName(middleName, experimenterIndex);
    }

    @Override
    public void setExperimenterUserName(String userName, int experimenterIndex) {
        userName = this.filter ? DataTools.sanitize(userName) : userName;
        this.store.setExperimenterUserName(userName, experimenterIndex);
    }

    @Override
    public void setExperimenterGroupAnnotationRef(String annotation, int experimenterGroupIndex, int annotationRefIndex) {
        this.store.setExperimenterGroupAnnotationRef(annotation, experimenterGroupIndex, annotationRefIndex);
    }

    @Override
    public void setExperimenterGroupDescription(String description, int experimenterGroupIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setExperimenterGroupDescription(description, experimenterGroupIndex);
    }

    @Override
    public void setExperimenterGroupExperimenterRef(String experimenter, int experimenterGroupIndex, int experimenterRefIndex) {
        this.store.setExperimenterGroupExperimenterRef(experimenter, experimenterGroupIndex, experimenterRefIndex);
    }

    @Override
    public void setExperimenterGroupID(String id, int experimenterGroupIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setExperimenterGroupID(id, experimenterGroupIndex);
    }

    @Override
    public void setExperimenterGroupLeader(String leader, int experimenterGroupIndex, int leaderIndex) {
        this.store.setExperimenterGroupLeader(leader, experimenterGroupIndex, leaderIndex);
    }

    @Override
    public void setExperimenterGroupName(String name, int experimenterGroupIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setExperimenterGroupName(name, experimenterGroupIndex);
    }

    @Override
    public void setFilamentID(String id, int instrumentIndex, int lightSourceIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setFilamentID(id, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setFilamentLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setFilamentLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setFilamentManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setFilamentManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setFilamentModel(String model, int instrumentIndex, int lightSourceIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setFilamentModel(model, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setFilamentPower(Double power, int instrumentIndex, int lightSourceIndex) {
        this.store.setFilamentPower(power, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setFilamentSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setFilamentSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setFilamentType(FilamentType type, int instrumentIndex, int lightSourceIndex) {
        this.store.setFilamentType(type, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setFileAnnotationAnnotationRef(String annotation, int fileAnnotationIndex, int annotationRefIndex) {
        this.store.setFileAnnotationAnnotationRef(annotation, fileAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setFileAnnotationAnnotator(String annotator, int fileAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setFileAnnotationAnnotator(annotator, fileAnnotationIndex);
    }

    @Override
    public void setFileAnnotationDescription(String description, int fileAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setFileAnnotationDescription(description, fileAnnotationIndex);
    }

    @Override
    public void setFileAnnotationID(String id, int fileAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setFileAnnotationID(id, fileAnnotationIndex);
    }

    @Override
    public void setFileAnnotationNamespace(String namespace, int fileAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setFileAnnotationNamespace(namespace, fileAnnotationIndex);
    }

    @Override
    public void setFilterFilterWheel(String filterWheel, int instrumentIndex, int filterIndex) {
        filterWheel = this.filter ? DataTools.sanitize(filterWheel) : filterWheel;
        this.store.setFilterFilterWheel(filterWheel, instrumentIndex, filterIndex);
    }

    @Override
    public void setFilterID(String id, int instrumentIndex, int filterIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setFilterID(id, instrumentIndex, filterIndex);
    }

    @Override
    public void setFilterLotNumber(String lotNumber, int instrumentIndex, int filterIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setFilterLotNumber(lotNumber, instrumentIndex, filterIndex);
    }

    @Override
    public void setFilterManufacturer(String manufacturer, int instrumentIndex, int filterIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setFilterManufacturer(manufacturer, instrumentIndex, filterIndex);
    }

    @Override
    public void setFilterModel(String model, int instrumentIndex, int filterIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setFilterModel(model, instrumentIndex, filterIndex);
    }

    @Override
    public void setFilterSerialNumber(String serialNumber, int instrumentIndex, int filterIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setFilterSerialNumber(serialNumber, instrumentIndex, filterIndex);
    }

    @Override
    public void setFilterType(FilterType type, int instrumentIndex, int filterIndex) {
        this.store.setFilterType(type, instrumentIndex, filterIndex);
    }

    @Override
    public void setFilterSetDichroicRef(String dichroic, int instrumentIndex, int filterSetIndex) {
        this.store.setFilterSetDichroicRef(dichroic, instrumentIndex, filterSetIndex);
    }

    @Override
    public void setFilterSetEmissionFilterRef(String emissionFilter, int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        this.store.setFilterSetEmissionFilterRef(emissionFilter, instrumentIndex, filterSetIndex, emissionFilterRefIndex);
    }

    @Override
    public void setFilterSetExcitationFilterRef(String excitationFilter, int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        this.store.setFilterSetExcitationFilterRef(excitationFilter, instrumentIndex, filterSetIndex, excitationFilterRefIndex);
    }

    @Override
    public void setFilterSetID(String id, int instrumentIndex, int filterSetIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setFilterSetID(id, instrumentIndex, filterSetIndex);
    }

    @Override
    public void setFilterSetLotNumber(String lotNumber, int instrumentIndex, int filterSetIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setFilterSetLotNumber(lotNumber, instrumentIndex, filterSetIndex);
    }

    @Override
    public void setFilterSetManufacturer(String manufacturer, int instrumentIndex, int filterSetIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setFilterSetManufacturer(manufacturer, instrumentIndex, filterSetIndex);
    }

    @Override
    public void setFilterSetModel(String model, int instrumentIndex, int filterSetIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setFilterSetModel(model, instrumentIndex, filterSetIndex);
    }

    @Override
    public void setFilterSetSerialNumber(String serialNumber, int instrumentIndex, int filterSetIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setFilterSetSerialNumber(serialNumber, instrumentIndex, filterSetIndex);
    }

    @Override
    public void setImageAcquisitionDate(Timestamp acquisitionDate, int imageIndex) {
        this.store.setImageAcquisitionDate(acquisitionDate, imageIndex);
    }

    @Override
    public void setImageAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        this.store.setImageAnnotationRef(annotation, imageIndex, annotationRefIndex);
    }

    @Override
    public void setImageDescription(String description, int imageIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setImageDescription(description, imageIndex);
    }

    @Override
    public void setImageExperimentRef(String experiment, int imageIndex) {
        this.store.setImageExperimentRef(experiment, imageIndex);
    }

    @Override
    public void setImageExperimenterGroupRef(String experimenterGroup, int imageIndex) {
        this.store.setImageExperimenterGroupRef(experimenterGroup, imageIndex);
    }

    @Override
    public void setImageExperimenterRef(String experimenter, int imageIndex) {
        this.store.setImageExperimenterRef(experimenter, imageIndex);
    }

    @Override
    public void setImageID(String id, int imageIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setImageID(id, imageIndex);
    }

    @Override
    public void setImageInstrumentRef(String instrument, int imageIndex) {
        this.store.setImageInstrumentRef(instrument, imageIndex);
    }

    @Override
    public void setImageMicrobeamManipulationRef(String microbeamManipulation, int imageIndex, int microbeamManipulationRefIndex) {
        this.store.setImageMicrobeamManipulationRef(microbeamManipulation, imageIndex, microbeamManipulationRefIndex);
    }

    @Override
    public void setImageName(String name, int imageIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setImageName(name, imageIndex);
    }

    @Override
    public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex) {
        this.store.setImageROIRef(roi, imageIndex, ROIRefIndex);
    }

    @Override
    public void setImagingEnvironmentAirPressure(Double airPressure, int imageIndex) {
        this.store.setImagingEnvironmentAirPressure(airPressure, imageIndex);
    }

    @Override
    public void setImagingEnvironmentCO2Percent(PercentFraction co2Percent, int imageIndex) {
        this.store.setImagingEnvironmentCO2Percent(co2Percent, imageIndex);
    }

    @Override
    public void setImagingEnvironmentHumidity(PercentFraction humidity, int imageIndex) {
        this.store.setImagingEnvironmentHumidity(humidity, imageIndex);
    }

    @Override
    public void setImagingEnvironmentTemperature(Double temperature, int imageIndex) {
        this.store.setImagingEnvironmentTemperature(temperature, imageIndex);
    }

    @Override
    public void setInstrumentID(String id, int instrumentIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setInstrumentID(id, instrumentIndex);
    }

    @Override
    public void setLabelFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        this.store.setLabelFillColor(fillColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        this.store.setLabelFillRule(fillRule, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        this.store.setLabelFontFamily(fontFamily, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setLabelFontSize(fontSize, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        this.store.setLabelFontStyle(fontStyle, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLabelID(id, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        this.store.setLabelLineCap(lineCap, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        this.store.setLabelLocked(locked, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        this.store.setLabelStrokeColor(strokeColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setLabelStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setLabelStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelText(String text, int ROIIndex, int shapeIndex) {
        text = this.filter ? DataTools.sanitize(text) : text;
        this.store.setLabelText(text, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setLabelTheC(theC, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setLabelTheT(theT, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setLabelTheZ(theZ, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        this.store.setLabelTransform(transform, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        this.store.setLabelVisible(visible, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setLabelX(x, ROIIndex, shapeIndex);
    }

    @Override
    public void setLabelY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setLabelY(y, ROIIndex, shapeIndex);
    }

    @Override
    public void setLaserID(String id, int instrumentIndex, int lightSourceIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLaserID(id, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setLaserLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setLaserManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserModel(String model, int instrumentIndex, int lightSourceIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setLaserModel(model, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserPower(Double power, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserPower(power, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setLaserSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserFrequencyMultiplication(PositiveInteger frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserFrequencyMultiplication(frequencyMultiplication, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserLaserMedium(LaserMedium laserMedium, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserLaserMedium(laserMedium, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserPockelCell(Boolean pockelCell, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserPockelCell(pockelCell, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserPulse(Pulse pulse, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserPulse(pulse, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserPump(String pump, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserPump(pump, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserRepetitionRate(Double repetitionRate, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserRepetitionRate(repetitionRate, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserTuneable(tuneable, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserType(LaserType type, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserType(type, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLaserWavelength(PositiveInteger wavelength, int instrumentIndex, int lightSourceIndex) {
        this.store.setLaserWavelength(wavelength, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLightEmittingDiodeID(String id, int instrumentIndex, int lightSourceIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLightEmittingDiodeID(id, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLightEmittingDiodeLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setLightEmittingDiodeLotNumber(lotNumber, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLightEmittingDiodeManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setLightEmittingDiodeManufacturer(manufacturer, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLightEmittingDiodeModel(String model, int instrumentIndex, int lightSourceIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setLightEmittingDiodeModel(model, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLightEmittingDiodePower(Double power, int instrumentIndex, int lightSourceIndex) {
        this.store.setLightEmittingDiodePower(power, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLightEmittingDiodeSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setLightEmittingDiodeSerialNumber(serialNumber, instrumentIndex, lightSourceIndex);
    }

    @Override
    public void setLightPathDichroicRef(String dichroic, int imageIndex, int channelIndex) {
        this.store.setLightPathDichroicRef(dichroic, imageIndex, channelIndex);
    }

    @Override
    public void setLightPathEmissionFilterRef(String emissionFilter, int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        this.store.setLightPathEmissionFilterRef(emissionFilter, imageIndex, channelIndex, emissionFilterRefIndex);
    }

    @Override
    public void setLightPathExcitationFilterRef(String excitationFilter, int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        this.store.setLightPathExcitationFilterRef(excitationFilter, imageIndex, channelIndex, excitationFilterRefIndex);
    }

    @Override
    public void setChannelLightSourceSettingsAttenuation(PercentFraction attenuation, int imageIndex, int channelIndex) {
        this.store.setChannelLightSourceSettingsAttenuation(attenuation, imageIndex, channelIndex);
    }

    @Override
    public void setMicrobeamManipulationLightSourceSettingsAttenuation(PercentFraction attenuation, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        this.store.setMicrobeamManipulationLightSourceSettingsAttenuation(attenuation, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
    }

    @Override
    public void setChannelLightSourceSettingsID(String id, int imageIndex, int channelIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setChannelLightSourceSettingsID(id, imageIndex, channelIndex);
    }

    @Override
    public void setMicrobeamManipulationLightSourceSettingsID(String id, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setMicrobeamManipulationLightSourceSettingsID(id, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
    }

    @Override
    public void setChannelLightSourceSettingsWavelength(PositiveInteger wavelength, int imageIndex, int channelIndex) {
        this.store.setChannelLightSourceSettingsWavelength(wavelength, imageIndex, channelIndex);
    }

    @Override
    public void setMicrobeamManipulationLightSourceSettingsWavelength(PositiveInteger wavelength, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        this.store.setMicrobeamManipulationLightSourceSettingsWavelength(wavelength, experimentIndex, microbeamManipulationIndex, lightSourceSettingsIndex);
    }

    @Override
    public void setLineFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        this.store.setLineFillColor(fillColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        this.store.setLineFillRule(fillRule, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        this.store.setLineFontFamily(fontFamily, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setLineFontSize(fontSize, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        this.store.setLineFontStyle(fontStyle, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLineID(id, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        this.store.setLineLineCap(lineCap, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        this.store.setLineLocked(locked, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        this.store.setLineStrokeColor(strokeColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setLineStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setLineStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineText(String text, int ROIIndex, int shapeIndex) {
        text = this.filter ? DataTools.sanitize(text) : text;
        this.store.setLineText(text, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setLineTheC(theC, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setLineTheT(theT, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setLineTheZ(theZ, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        this.store.setLineTransform(transform, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        this.store.setLineVisible(visible, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex) {
        this.store.setLineMarkerEnd(markerEnd, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex) {
        this.store.setLineMarkerStart(markerStart, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineX1(Double x1, int ROIIndex, int shapeIndex) {
        this.store.setLineX1(x1, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineX2(Double x2, int ROIIndex, int shapeIndex) {
        this.store.setLineX2(x2, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineY1(Double y1, int ROIIndex, int shapeIndex) {
        this.store.setLineY1(y1, ROIIndex, shapeIndex);
    }

    @Override
    public void setLineY2(Double y2, int ROIIndex, int shapeIndex) {
        this.store.setLineY2(y2, ROIIndex, shapeIndex);
    }

    @Override
    public void setListAnnotationAnnotationRef(String annotation, int listAnnotationIndex, int annotationRefIndex) {
        this.store.setListAnnotationAnnotationRef(annotation, listAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setListAnnotationAnnotator(String annotator, int listAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setListAnnotationAnnotator(annotator, listAnnotationIndex);
    }

    @Override
    public void setListAnnotationDescription(String description, int listAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setListAnnotationDescription(description, listAnnotationIndex);
    }

    @Override
    public void setListAnnotationID(String id, int listAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setListAnnotationID(id, listAnnotationIndex);
    }

    @Override
    public void setListAnnotationNamespace(String namespace, int listAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setListAnnotationNamespace(namespace, listAnnotationIndex);
    }

    @Override
    public void setLongAnnotationAnnotationRef(String annotation, int longAnnotationIndex, int annotationRefIndex) {
        this.store.setLongAnnotationAnnotationRef(annotation, longAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setLongAnnotationAnnotator(String annotator, int longAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setLongAnnotationAnnotator(annotator, longAnnotationIndex);
    }

    @Override
    public void setLongAnnotationDescription(String description, int longAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setLongAnnotationDescription(description, longAnnotationIndex);
    }

    @Override
    public void setLongAnnotationID(String id, int longAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setLongAnnotationID(id, longAnnotationIndex);
    }

    @Override
    public void setLongAnnotationNamespace(String namespace, int longAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setLongAnnotationNamespace(namespace, longAnnotationIndex);
    }

    @Override
    public void setLongAnnotationValue(Long value, int longAnnotationIndex) {
        this.store.setLongAnnotationValue(value, longAnnotationIndex);
    }

    @Override
    public void setMaskFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        this.store.setMaskFillColor(fillColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        this.store.setMaskFillRule(fillRule, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        this.store.setMaskFontFamily(fontFamily, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setMaskFontSize(fontSize, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        this.store.setMaskFontStyle(fontStyle, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setMaskID(id, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        this.store.setMaskLineCap(lineCap, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        this.store.setMaskLocked(locked, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        this.store.setMaskStrokeColor(strokeColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setMaskStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setMaskStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskText(String text, int ROIIndex, int shapeIndex) {
        text = this.filter ? DataTools.sanitize(text) : text;
        this.store.setMaskText(text, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setMaskTheC(theC, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setMaskTheT(theT, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setMaskTheZ(theZ, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        this.store.setMaskTransform(transform, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        this.store.setMaskVisible(visible, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskHeight(Double height, int ROIIndex, int shapeIndex) {
        this.store.setMaskHeight(height, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskWidth(Double width, int ROIIndex, int shapeIndex) {
        this.store.setMaskWidth(width, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setMaskX(x, ROIIndex, shapeIndex);
    }

    @Override
    public void setMaskY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setMaskY(y, ROIIndex, shapeIndex);
    }

    @Override
    public void setMicrobeamManipulationDescription(String description, int experimentIndex, int microbeamManipulationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setMicrobeamManipulationDescription(description, experimentIndex, microbeamManipulationIndex);
    }

    @Override
    public void setMicrobeamManipulationExperimenterRef(String experimenter, int experimentIndex, int microbeamManipulationIndex) {
        this.store.setMicrobeamManipulationExperimenterRef(experimenter, experimentIndex, microbeamManipulationIndex);
    }

    @Override
    public void setMicrobeamManipulationID(String id, int experimentIndex, int microbeamManipulationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setMicrobeamManipulationID(id, experimentIndex, microbeamManipulationIndex);
    }

    @Override
    public void setMicrobeamManipulationROIRef(String roi, int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        this.store.setMicrobeamManipulationROIRef(roi, experimentIndex, microbeamManipulationIndex, ROIRefIndex);
    }

    @Override
    public void setMicrobeamManipulationType(MicrobeamManipulationType type, int experimentIndex, int microbeamManipulationIndex) {
        this.store.setMicrobeamManipulationType(type, experimentIndex, microbeamManipulationIndex);
    }

    @Override
    public void setMicroscopeLotNumber(String lotNumber, int instrumentIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setMicroscopeLotNumber(lotNumber, instrumentIndex);
    }

    @Override
    public void setMicroscopeManufacturer(String manufacturer, int instrumentIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setMicroscopeManufacturer(manufacturer, instrumentIndex);
    }

    @Override
    public void setMicroscopeModel(String model, int instrumentIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setMicroscopeModel(model, instrumentIndex);
    }

    @Override
    public void setMicroscopeSerialNumber(String serialNumber, int instrumentIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setMicroscopeSerialNumber(serialNumber, instrumentIndex);
    }

    @Override
    public void setMicroscopeType(MicroscopeType type, int instrumentIndex) {
        this.store.setMicroscopeType(type, instrumentIndex);
    }

    @Override
    public void setObjectiveCalibratedMagnification(Double calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveCalibratedMagnification(calibratedMagnification, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveCorrection(Correction correction, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveCorrection(correction, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setObjectiveID(id, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveImmersion(Immersion immersion, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveImmersion(immersion, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveIris(iris, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveLensNA(Double lensNA, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveLensNA(lensNA, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveLotNumber(String lotNumber, int instrumentIndex, int objectiveIndex) {
        lotNumber = this.filter ? DataTools.sanitize(lotNumber) : lotNumber;
        this.store.setObjectiveLotNumber(lotNumber, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        manufacturer = this.filter ? DataTools.sanitize(manufacturer) : manufacturer;
        this.store.setObjectiveManufacturer(manufacturer, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        model = this.filter ? DataTools.sanitize(model) : model;
        this.store.setObjectiveModel(model, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveNominalMagnification(Double nominalMagnification, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveNominalMagnification(nominalMagnification, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        serialNumber = this.filter ? DataTools.sanitize(serialNumber) : serialNumber;
        this.store.setObjectiveSerialNumber(serialNumber, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveWorkingDistance(Double workingDistance, int instrumentIndex, int objectiveIndex) {
        this.store.setObjectiveWorkingDistance(workingDistance, instrumentIndex, objectiveIndex);
    }

    @Override
    public void setObjectiveSettingsCorrectionCollar(Double correctionCollar, int imageIndex) {
        this.store.setObjectiveSettingsCorrectionCollar(correctionCollar, imageIndex);
    }

    @Override
    public void setObjectiveSettingsID(String id, int imageIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setObjectiveSettingsID(id, imageIndex);
    }

    @Override
    public void setObjectiveSettingsMedium(Medium medium, int imageIndex) {
        this.store.setObjectiveSettingsMedium(medium, imageIndex);
    }

    @Override
    public void setObjectiveSettingsRefractiveIndex(Double refractiveIndex, int imageIndex) {
        this.store.setObjectiveSettingsRefractiveIndex(refractiveIndex, imageIndex);
    }

    @Override
    public void setPixelsAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        this.store.setPixelsAnnotationRef(annotation, imageIndex, annotationRefIndex);
    }

    @Override
    public void setPixelsBigEndian(Boolean bigEndian, int imageIndex) {
        this.store.setPixelsBigEndian(bigEndian, imageIndex);
    }

    @Override
    public void setPixelsDimensionOrder(DimensionOrder dimensionOrder, int imageIndex) {
        this.store.setPixelsDimensionOrder(dimensionOrder, imageIndex);
    }

    @Override
    public void setPixelsID(String id, int imageIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPixelsID(id, imageIndex);
    }

    @Override
    public void setPixelsInterleaved(Boolean interleaved, int imageIndex) {
        this.store.setPixelsInterleaved(interleaved, imageIndex);
    }

    @Override
    public void setPixelsPhysicalSizeX(PositiveFloat physicalSizeX, int imageIndex) {
        this.store.setPixelsPhysicalSizeX(physicalSizeX, imageIndex);
    }

    @Override
    public void setPixelsPhysicalSizeY(PositiveFloat physicalSizeY, int imageIndex) {
        this.store.setPixelsPhysicalSizeY(physicalSizeY, imageIndex);
    }

    @Override
    public void setPixelsPhysicalSizeZ(PositiveFloat physicalSizeZ, int imageIndex) {
        this.store.setPixelsPhysicalSizeZ(physicalSizeZ, imageIndex);
    }

    @Override
    public void setPixelsSignificantBits(PositiveInteger significantBits, int imageIndex) {
        this.store.setPixelsSignificantBits(significantBits, imageIndex);
    }

    @Override
    public void setPixelsSizeC(PositiveInteger sizeC, int imageIndex) {
        this.store.setPixelsSizeC(sizeC, imageIndex);
    }

    @Override
    public void setPixelsSizeT(PositiveInteger sizeT, int imageIndex) {
        this.store.setPixelsSizeT(sizeT, imageIndex);
    }

    @Override
    public void setPixelsSizeX(PositiveInteger sizeX, int imageIndex) {
        this.store.setPixelsSizeX(sizeX, imageIndex);
    }

    @Override
    public void setPixelsSizeY(PositiveInteger sizeY, int imageIndex) {
        this.store.setPixelsSizeY(sizeY, imageIndex);
    }

    @Override
    public void setPixelsSizeZ(PositiveInteger sizeZ, int imageIndex) {
        this.store.setPixelsSizeZ(sizeZ, imageIndex);
    }

    @Override
    public void setPixelsTimeIncrement(Double timeIncrement, int imageIndex) {
        this.store.setPixelsTimeIncrement(timeIncrement, imageIndex);
    }

    @Override
    public void setPixelsType(PixelType type, int imageIndex) {
        this.store.setPixelsType(type, imageIndex);
    }

    @Override
    public void setPlaneAnnotationRef(String annotation, int imageIndex, int planeIndex, int annotationRefIndex) {
        this.store.setPlaneAnnotationRef(annotation, imageIndex, planeIndex, annotationRefIndex);
    }

    @Override
    public void setPlaneDeltaT(Double deltaT, int imageIndex, int planeIndex) {
        this.store.setPlaneDeltaT(deltaT, imageIndex, planeIndex);
    }

    @Override
    public void setPlaneExposureTime(Double exposureTime, int imageIndex, int planeIndex) {
        this.store.setPlaneExposureTime(exposureTime, imageIndex, planeIndex);
    }

    @Override
    public void setPlaneHashSHA1(String hashSHA1, int imageIndex, int planeIndex) {
        hashSHA1 = this.filter ? DataTools.sanitize(hashSHA1) : hashSHA1;
        this.store.setPlaneHashSHA1(hashSHA1, imageIndex, planeIndex);
    }

    @Override
    public void setPlanePositionX(Double positionX, int imageIndex, int planeIndex) {
        this.store.setPlanePositionX(positionX, imageIndex, planeIndex);
    }

    @Override
    public void setPlanePositionY(Double positionY, int imageIndex, int planeIndex) {
        this.store.setPlanePositionY(positionY, imageIndex, planeIndex);
    }

    @Override
    public void setPlanePositionZ(Double positionZ, int imageIndex, int planeIndex) {
        this.store.setPlanePositionZ(positionZ, imageIndex, planeIndex);
    }

    @Override
    public void setPlaneTheC(NonNegativeInteger theC, int imageIndex, int planeIndex) {
        this.store.setPlaneTheC(theC, imageIndex, planeIndex);
    }

    @Override
    public void setPlaneTheT(NonNegativeInteger theT, int imageIndex, int planeIndex) {
        this.store.setPlaneTheT(theT, imageIndex, planeIndex);
    }

    @Override
    public void setPlaneTheZ(NonNegativeInteger theZ, int imageIndex, int planeIndex) {
        this.store.setPlaneTheZ(theZ, imageIndex, planeIndex);
    }

    @Override
    public void setPlateAnnotationRef(String annotation, int plateIndex, int annotationRefIndex) {
        this.store.setPlateAnnotationRef(annotation, plateIndex, annotationRefIndex);
    }

    @Override
    public void setPlateColumnNamingConvention(NamingConvention columnNamingConvention, int plateIndex) {
        this.store.setPlateColumnNamingConvention(columnNamingConvention, plateIndex);
    }

    @Override
    public void setPlateColumns(PositiveInteger columns, int plateIndex) {
        this.store.setPlateColumns(columns, plateIndex);
    }

    @Override
    public void setPlateDescription(String description, int plateIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setPlateDescription(description, plateIndex);
    }

    @Override
    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        externalIdentifier = this.filter ? DataTools.sanitize(externalIdentifier) : externalIdentifier;
        this.store.setPlateExternalIdentifier(externalIdentifier, plateIndex);
    }

    @Override
    public void setPlateFieldIndex(NonNegativeInteger fieldIndex, int plateIndex) {
        this.store.setPlateFieldIndex(fieldIndex, plateIndex);
    }

    @Override
    public void setPlateID(String id, int plateIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPlateID(id, plateIndex);
    }

    @Override
    public void setPlateName(String name, int plateIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setPlateName(name, plateIndex);
    }

    @Override
    public void setPlateRowNamingConvention(NamingConvention rowNamingConvention, int plateIndex) {
        this.store.setPlateRowNamingConvention(rowNamingConvention, plateIndex);
    }

    @Override
    public void setPlateRows(PositiveInteger rows, int plateIndex) {
        this.store.setPlateRows(rows, plateIndex);
    }

    @Override
    public void setPlateStatus(String status, int plateIndex) {
        status = this.filter ? DataTools.sanitize(status) : status;
        this.store.setPlateStatus(status, plateIndex);
    }

    @Override
    public void setPlateWellOriginX(Double wellOriginX, int plateIndex) {
        this.store.setPlateWellOriginX(wellOriginX, plateIndex);
    }

    @Override
    public void setPlateWellOriginY(Double wellOriginY, int plateIndex) {
        this.store.setPlateWellOriginY(wellOriginY, plateIndex);
    }

    @Override
    public void setPlateAcquisitionAnnotationRef(String annotation, int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        this.store.setPlateAcquisitionAnnotationRef(annotation, plateIndex, plateAcquisitionIndex, annotationRefIndex);
    }

    @Override
    public void setPlateAcquisitionDescription(String description, int plateIndex, int plateAcquisitionIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setPlateAcquisitionDescription(description, plateIndex, plateAcquisitionIndex);
    }

    @Override
    public void setPlateAcquisitionEndTime(Timestamp endTime, int plateIndex, int plateAcquisitionIndex) {
        this.store.setPlateAcquisitionEndTime(endTime, plateIndex, plateAcquisitionIndex);
    }

    @Override
    public void setPlateAcquisitionID(String id, int plateIndex, int plateAcquisitionIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPlateAcquisitionID(id, plateIndex, plateAcquisitionIndex);
    }

    @Override
    public void setPlateAcquisitionMaximumFieldCount(PositiveInteger maximumFieldCount, int plateIndex, int plateAcquisitionIndex) {
        this.store.setPlateAcquisitionMaximumFieldCount(maximumFieldCount, plateIndex, plateAcquisitionIndex);
    }

    @Override
    public void setPlateAcquisitionName(String name, int plateIndex, int plateAcquisitionIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setPlateAcquisitionName(name, plateIndex, plateAcquisitionIndex);
    }

    @Override
    public void setPlateAcquisitionStartTime(Timestamp startTime, int plateIndex, int plateAcquisitionIndex) {
        this.store.setPlateAcquisitionStartTime(startTime, plateIndex, plateAcquisitionIndex);
    }

    @Override
    public void setPlateAcquisitionWellSampleRef(String wellSample, int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        this.store.setPlateAcquisitionWellSampleRef(wellSample, plateIndex, plateAcquisitionIndex, wellSampleRefIndex);
    }

    @Override
    public void setPointFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        this.store.setPointFillColor(fillColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        this.store.setPointFillRule(fillRule, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        this.store.setPointFontFamily(fontFamily, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setPointFontSize(fontSize, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        this.store.setPointFontStyle(fontStyle, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPointID(id, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        this.store.setPointLineCap(lineCap, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        this.store.setPointLocked(locked, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        this.store.setPointStrokeColor(strokeColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setPointStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setPointStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointText(String text, int ROIIndex, int shapeIndex) {
        text = this.filter ? DataTools.sanitize(text) : text;
        this.store.setPointText(text, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setPointTheC(theC, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setPointTheT(theT, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setPointTheZ(theZ, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        this.store.setPointTransform(transform, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        this.store.setPointVisible(visible, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setPointX(x, ROIIndex, shapeIndex);
    }

    @Override
    public void setPointY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setPointY(y, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        this.store.setPolygonFillColor(fillColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        this.store.setPolygonFillRule(fillRule, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        this.store.setPolygonFontFamily(fontFamily, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setPolygonFontSize(fontSize, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        this.store.setPolygonFontStyle(fontStyle, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPolygonID(id, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        this.store.setPolygonLineCap(lineCap, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        this.store.setPolygonLocked(locked, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        this.store.setPolygonStrokeColor(strokeColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setPolygonStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setPolygonStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonText(String text, int ROIIndex, int shapeIndex) {
        text = this.filter ? DataTools.sanitize(text) : text;
        this.store.setPolygonText(text, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setPolygonTheC(theC, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setPolygonTheT(theT, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setPolygonTheZ(theZ, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        this.store.setPolygonTransform(transform, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        this.store.setPolygonVisible(visible, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolygonPoints(String points, int ROIIndex, int shapeIndex) {
        points = this.filter ? DataTools.sanitize(points) : points;
        this.store.setPolygonPoints(points, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        this.store.setPolylineFillColor(fillColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        this.store.setPolylineFillRule(fillRule, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        this.store.setPolylineFontFamily(fontFamily, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setPolylineFontSize(fontSize, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        this.store.setPolylineFontStyle(fontStyle, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setPolylineID(id, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        this.store.setPolylineLineCap(lineCap, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        this.store.setPolylineLocked(locked, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        this.store.setPolylineStrokeColor(strokeColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setPolylineStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setPolylineStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineText(String text, int ROIIndex, int shapeIndex) {
        text = this.filter ? DataTools.sanitize(text) : text;
        this.store.setPolylineText(text, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setPolylineTheC(theC, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setPolylineTheT(theT, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setPolylineTheZ(theZ, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        this.store.setPolylineTransform(transform, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        this.store.setPolylineVisible(visible, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex) {
        this.store.setPolylineMarkerEnd(markerEnd, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex) {
        this.store.setPolylineMarkerStart(markerStart, ROIIndex, shapeIndex);
    }

    @Override
    public void setPolylinePoints(String points, int ROIIndex, int shapeIndex) {
        points = this.filter ? DataTools.sanitize(points) : points;
        this.store.setPolylinePoints(points, ROIIndex, shapeIndex);
    }

    @Override
    public void setProjectAnnotationRef(String annotation, int projectIndex, int annotationRefIndex) {
        this.store.setProjectAnnotationRef(annotation, projectIndex, annotationRefIndex);
    }

    @Override
    public void setProjectDatasetRef(String dataset, int projectIndex, int datasetRefIndex) {
        this.store.setProjectDatasetRef(dataset, projectIndex, datasetRefIndex);
    }

    @Override
    public void setProjectDescription(String description, int projectIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setProjectDescription(description, projectIndex);
    }

    @Override
    public void setProjectExperimenterGroupRef(String experimenterGroup, int projectIndex) {
        this.store.setProjectExperimenterGroupRef(experimenterGroup, projectIndex);
    }

    @Override
    public void setProjectExperimenterRef(String experimenter, int projectIndex) {
        this.store.setProjectExperimenterRef(experimenter, projectIndex);
    }

    @Override
    public void setProjectID(String id, int projectIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setProjectID(id, projectIndex);
    }

    @Override
    public void setProjectName(String name, int projectIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setProjectName(name, projectIndex);
    }

    @Override
    public void setROIAnnotationRef(String annotation, int ROIIndex, int annotationRefIndex) {
        this.store.setROIAnnotationRef(annotation, ROIIndex, annotationRefIndex);
    }

    @Override
    public void setROIDescription(String description, int ROIIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setROIDescription(description, ROIIndex);
    }

    @Override
    public void setROIID(String id, int ROIIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setROIID(id, ROIIndex);
    }

    @Override
    public void setROIName(String name, int ROIIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setROIName(name, ROIIndex);
    }

    @Override
    public void setROINamespace(String namespace, int ROIIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setROINamespace(namespace, ROIIndex);
    }

    @Override
    public void setReagentAnnotationRef(String annotation, int screenIndex, int reagentIndex, int annotationRefIndex) {
        this.store.setReagentAnnotationRef(annotation, screenIndex, reagentIndex, annotationRefIndex);
    }

    @Override
    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setReagentDescription(description, screenIndex, reagentIndex);
    }

    @Override
    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setReagentID(id, screenIndex, reagentIndex);
    }

    @Override
    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setReagentName(name, screenIndex, reagentIndex);
    }

    @Override
    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        reagentIdentifier = this.filter ? DataTools.sanitize(reagentIdentifier) : reagentIdentifier;
        this.store.setReagentReagentIdentifier(reagentIdentifier, screenIndex, reagentIndex);
    }

    @Override
    public void setRectangleFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        this.store.setRectangleFillColor(fillColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        this.store.setRectangleFillRule(fillRule, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        this.store.setRectangleFontFamily(fontFamily, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        this.store.setRectangleFontSize(fontSize, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        this.store.setRectangleFontStyle(fontStyle, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleID(String id, int ROIIndex, int shapeIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setRectangleID(id, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        this.store.setRectangleLineCap(lineCap, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        this.store.setRectangleLocked(locked, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        this.store.setRectangleStrokeColor(strokeColor, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        strokeDashArray = this.filter ? DataTools.sanitize(strokeDashArray) : strokeDashArray;
        this.store.setRectangleStrokeDashArray(strokeDashArray, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        this.store.setRectangleStrokeWidth(strokeWidth, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleText(String text, int ROIIndex, int shapeIndex) {
        text = this.filter ? DataTools.sanitize(text) : text;
        this.store.setRectangleText(text, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        this.store.setRectangleTheC(theC, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        this.store.setRectangleTheT(theT, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        this.store.setRectangleTheZ(theZ, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        this.store.setRectangleTransform(transform, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        this.store.setRectangleVisible(visible, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleHeight(Double height, int ROIIndex, int shapeIndex) {
        this.store.setRectangleHeight(height, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleWidth(Double width, int ROIIndex, int shapeIndex) {
        this.store.setRectangleWidth(width, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleX(Double x, int ROIIndex, int shapeIndex) {
        this.store.setRectangleX(x, ROIIndex, shapeIndex);
    }

    @Override
    public void setRectangleY(Double y, int ROIIndex, int shapeIndex) {
        this.store.setRectangleY(y, ROIIndex, shapeIndex);
    }

    @Override
    public void setRightsRightsHeld(String rightsHeld) {
        rightsHeld = this.filter ? DataTools.sanitize(rightsHeld) : rightsHeld;
        this.store.setRightsRightsHeld(rightsHeld);
    }

    @Override
    public void setRightsRightsHolder(String rightsHolder) {
        rightsHolder = this.filter ? DataTools.sanitize(rightsHolder) : rightsHolder;
        this.store.setRightsRightsHolder(rightsHolder);
    }

    @Override
    public void setScreenAnnotationRef(String annotation, int screenIndex, int annotationRefIndex) {
        this.store.setScreenAnnotationRef(annotation, screenIndex, annotationRefIndex);
    }

    @Override
    public void setScreenDescription(String description, int screenIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setScreenDescription(description, screenIndex);
    }

    @Override
    public void setScreenID(String id, int screenIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setScreenID(id, screenIndex);
    }

    @Override
    public void setScreenName(String name, int screenIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setScreenName(name, screenIndex);
    }

    @Override
    public void setScreenPlateRef(String plate, int screenIndex, int plateRefIndex) {
        this.store.setScreenPlateRef(plate, screenIndex, plateRefIndex);
    }

    @Override
    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        protocolDescription = this.filter ? DataTools.sanitize(protocolDescription) : protocolDescription;
        this.store.setScreenProtocolDescription(protocolDescription, screenIndex);
    }

    @Override
    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        protocolIdentifier = this.filter ? DataTools.sanitize(protocolIdentifier) : protocolIdentifier;
        this.store.setScreenProtocolIdentifier(protocolIdentifier, screenIndex);
    }

    @Override
    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        reagentSetDescription = this.filter ? DataTools.sanitize(reagentSetDescription) : reagentSetDescription;
        this.store.setScreenReagentSetDescription(reagentSetDescription, screenIndex);
    }

    @Override
    public void setScreenReagentSetIdentifier(String reagentSetIdentifier, int screenIndex) {
        reagentSetIdentifier = this.filter ? DataTools.sanitize(reagentSetIdentifier) : reagentSetIdentifier;
        this.store.setScreenReagentSetIdentifier(reagentSetIdentifier, screenIndex);
    }

    @Override
    public void setScreenType(String type, int screenIndex) {
        type = this.filter ? DataTools.sanitize(type) : type;
        this.store.setScreenType(type, screenIndex);
    }

    @Override
    public void setStageLabelName(String name, int imageIndex) {
        name = this.filter ? DataTools.sanitize(name) : name;
        this.store.setStageLabelName(name, imageIndex);
    }

    @Override
    public void setStageLabelX(Double x, int imageIndex) {
        this.store.setStageLabelX(x, imageIndex);
    }

    @Override
    public void setStageLabelY(Double y, int imageIndex) {
        this.store.setStageLabelY(y, imageIndex);
    }

    @Override
    public void setStageLabelZ(Double z, int imageIndex) {
        this.store.setStageLabelZ(z, imageIndex);
    }

    @Override
    public void setTagAnnotationAnnotationRef(String annotation, int tagAnnotationIndex, int annotationRefIndex) {
        this.store.setTagAnnotationAnnotationRef(annotation, tagAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setTagAnnotationAnnotator(String annotator, int tagAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setTagAnnotationAnnotator(annotator, tagAnnotationIndex);
    }

    @Override
    public void setTagAnnotationDescription(String description, int tagAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setTagAnnotationDescription(description, tagAnnotationIndex);
    }

    @Override
    public void setTagAnnotationID(String id, int tagAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setTagAnnotationID(id, tagAnnotationIndex);
    }

    @Override
    public void setTagAnnotationNamespace(String namespace, int tagAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setTagAnnotationNamespace(namespace, tagAnnotationIndex);
    }

    @Override
    public void setTagAnnotationValue(String value, int tagAnnotationIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setTagAnnotationValue(value, tagAnnotationIndex);
    }

    @Override
    public void setTermAnnotationAnnotationRef(String annotation, int termAnnotationIndex, int annotationRefIndex) {
        this.store.setTermAnnotationAnnotationRef(annotation, termAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setTermAnnotationAnnotator(String annotator, int termAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setTermAnnotationAnnotator(annotator, termAnnotationIndex);
    }

    @Override
    public void setTermAnnotationDescription(String description, int termAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setTermAnnotationDescription(description, termAnnotationIndex);
    }

    @Override
    public void setTermAnnotationID(String id, int termAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setTermAnnotationID(id, termAnnotationIndex);
    }

    @Override
    public void setTermAnnotationNamespace(String namespace, int termAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setTermAnnotationNamespace(namespace, termAnnotationIndex);
    }

    @Override
    public void setTermAnnotationValue(String value, int termAnnotationIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setTermAnnotationValue(value, termAnnotationIndex);
    }

    @Override
    public void setTiffDataFirstC(NonNegativeInteger firstC, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataFirstC(firstC, imageIndex, tiffDataIndex);
    }

    @Override
    public void setTiffDataFirstT(NonNegativeInteger firstT, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataFirstT(firstT, imageIndex, tiffDataIndex);
    }

    @Override
    public void setTiffDataFirstZ(NonNegativeInteger firstZ, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataFirstZ(firstZ, imageIndex, tiffDataIndex);
    }

    @Override
    public void setTiffDataIFD(NonNegativeInteger ifd, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataIFD(ifd, imageIndex, tiffDataIndex);
    }

    @Override
    public void setTiffDataPlaneCount(NonNegativeInteger planeCount, int imageIndex, int tiffDataIndex) {
        this.store.setTiffDataPlaneCount(planeCount, imageIndex, tiffDataIndex);
    }

    @Override
    public void setTimestampAnnotationAnnotationRef(String annotation, int timestampAnnotationIndex, int annotationRefIndex) {
        this.store.setTimestampAnnotationAnnotationRef(annotation, timestampAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setTimestampAnnotationAnnotator(String annotator, int timestampAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setTimestampAnnotationAnnotator(annotator, timestampAnnotationIndex);
    }

    @Override
    public void setTimestampAnnotationDescription(String description, int timestampAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setTimestampAnnotationDescription(description, timestampAnnotationIndex);
    }

    @Override
    public void setTimestampAnnotationID(String id, int timestampAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setTimestampAnnotationID(id, timestampAnnotationIndex);
    }

    @Override
    public void setTimestampAnnotationNamespace(String namespace, int timestampAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setTimestampAnnotationNamespace(namespace, timestampAnnotationIndex);
    }

    @Override
    public void setTimestampAnnotationValue(Timestamp value, int timestampAnnotationIndex) {
        this.store.setTimestampAnnotationValue(value, timestampAnnotationIndex);
    }

    @Override
    public void setTransmittanceRangeCutIn(PositiveInteger cutIn, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeCutIn(cutIn, instrumentIndex, filterIndex);
    }

    @Override
    public void setTransmittanceRangeCutInTolerance(NonNegativeInteger cutInTolerance, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeCutInTolerance(cutInTolerance, instrumentIndex, filterIndex);
    }

    @Override
    public void setTransmittanceRangeCutOut(PositiveInteger cutOut, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeCutOut(cutOut, instrumentIndex, filterIndex);
    }

    @Override
    public void setTransmittanceRangeCutOutTolerance(NonNegativeInteger cutOutTolerance, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeCutOutTolerance(cutOutTolerance, instrumentIndex, filterIndex);
    }

    @Override
    public void setTransmittanceRangeTransmittance(PercentFraction transmittance, int instrumentIndex, int filterIndex) {
        this.store.setTransmittanceRangeTransmittance(transmittance, instrumentIndex, filterIndex);
    }

    @Override
    public void setUUIDValue(String value, int imageIndex, int tiffDataIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setUUIDValue(value, imageIndex, tiffDataIndex);
    }

    @Override
    public void setUUIDFileName(String fileName, int imageIndex, int tiffDataIndex) {
        fileName = this.filter ? DataTools.sanitize(fileName) : fileName;
        this.store.setUUIDFileName(fileName, imageIndex, tiffDataIndex);
    }

    @Override
    public void setWellAnnotationRef(String annotation, int plateIndex, int wellIndex, int annotationRefIndex) {
        this.store.setWellAnnotationRef(annotation, plateIndex, wellIndex, annotationRefIndex);
    }

    @Override
    public void setWellColor(Color color, int plateIndex, int wellIndex) {
        this.store.setWellColor(color, plateIndex, wellIndex);
    }

    @Override
    public void setWellColumn(NonNegativeInteger column, int plateIndex, int wellIndex) {
        this.store.setWellColumn(column, plateIndex, wellIndex);
    }

    @Override
    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        externalDescription = this.filter ? DataTools.sanitize(externalDescription) : externalDescription;
        this.store.setWellExternalDescription(externalDescription, plateIndex, wellIndex);
    }

    @Override
    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        externalIdentifier = this.filter ? DataTools.sanitize(externalIdentifier) : externalIdentifier;
        this.store.setWellExternalIdentifier(externalIdentifier, plateIndex, wellIndex);
    }

    @Override
    public void setWellID(String id, int plateIndex, int wellIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setWellID(id, plateIndex, wellIndex);
    }

    @Override
    public void setWellReagentRef(String reagent, int plateIndex, int wellIndex) {
        this.store.setWellReagentRef(reagent, plateIndex, wellIndex);
    }

    @Override
    public void setWellRow(NonNegativeInteger row, int plateIndex, int wellIndex) {
        this.store.setWellRow(row, plateIndex, wellIndex);
    }

    @Override
    public void setWellType(String type, int plateIndex, int wellIndex) {
        type = this.filter ? DataTools.sanitize(type) : type;
        this.store.setWellType(type, plateIndex, wellIndex);
    }

    @Override
    public void setWellSampleAnnotationRef(String annotation, int plateIndex, int wellIndex, int wellSampleIndex, int annotationRefIndex) {
        this.store.setWellSampleAnnotationRef(annotation, plateIndex, wellIndex, wellSampleIndex, annotationRefIndex);
    }

    @Override
    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setWellSampleID(id, plateIndex, wellIndex, wellSampleIndex);
    }

    @Override
    public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSampleImageRef(image, plateIndex, wellIndex, wellSampleIndex);
    }

    @Override
    public void setWellSampleIndex(NonNegativeInteger index, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSampleIndex(index, plateIndex, wellIndex, wellSampleIndex);
    }

    @Override
    public void setWellSamplePositionX(Double positionX, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSamplePositionX(positionX, plateIndex, wellIndex, wellSampleIndex);
    }

    @Override
    public void setWellSamplePositionY(Double positionY, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSamplePositionY(positionY, plateIndex, wellIndex, wellSampleIndex);
    }

    @Override
    public void setWellSampleTimepoint(Timestamp timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        this.store.setWellSampleTimepoint(timepoint, plateIndex, wellIndex, wellSampleIndex);
    }

    @Override
    public void setXMLAnnotationAnnotationRef(String annotation, int XMLAnnotationIndex, int annotationRefIndex) {
        this.store.setXMLAnnotationAnnotationRef(annotation, XMLAnnotationIndex, annotationRefIndex);
    }

    @Override
    public void setXMLAnnotationAnnotator(String annotator, int XMLAnnotationIndex) {
        annotator = this.filter ? DataTools.sanitize(annotator) : annotator;
        this.store.setXMLAnnotationAnnotator(annotator, XMLAnnotationIndex);
    }

    @Override
    public void setXMLAnnotationDescription(String description, int XMLAnnotationIndex) {
        description = this.filter ? DataTools.sanitize(description) : description;
        this.store.setXMLAnnotationDescription(description, XMLAnnotationIndex);
    }

    @Override
    public void setXMLAnnotationID(String id, int XMLAnnotationIndex) {
        id = this.filter ? DataTools.sanitize(id) : id;
        this.store.setXMLAnnotationID(id, XMLAnnotationIndex);
    }

    @Override
    public void setXMLAnnotationNamespace(String namespace, int XMLAnnotationIndex) {
        namespace = this.filter ? DataTools.sanitize(namespace) : namespace;
        this.store.setXMLAnnotationNamespace(namespace, XMLAnnotationIndex);
    }

    @Override
    public void setXMLAnnotationValue(String value, int XMLAnnotationIndex) {
        value = this.filter ? DataTools.sanitize(value) : value;
        this.store.setXMLAnnotationValue(value, XMLAnnotationIndex);
    }
}

