/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.PercentFraction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImagingEnvironment
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2013-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagingEnvironment.class);
    private PercentFraction co2Percent;
    private Double temperature;
    private Double airPressure;
    private PercentFraction humidity;

    public ImagingEnvironment() {
    }

    public ImagingEnvironment(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public ImagingEnvironment(ImagingEnvironment orig) {
        this.co2Percent = orig.co2Percent;
        this.temperature = orig.temperature;
        this.airPressure = orig.airPressure;
        this.humidity = orig.humidity;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"ImagingEnvironment".equals(tagName)) {
            LOGGER.debug("Expecting node name of ImagingEnvironment got {}", (Object)tagName);
        }
        if (element.hasAttribute("CO2Percent")) {
            this.setCO2Percent(PercentFraction.valueOf(element.getAttribute("CO2Percent")));
        }
        if (element.hasAttribute("Temperature")) {
            this.setTemperature(Double.valueOf(element.getAttribute("Temperature")));
        }
        if (element.hasAttribute("AirPressure")) {
            this.setAirPressure(Double.valueOf(element.getAttribute("AirPressure")));
        }
        if (element.hasAttribute("Humidity")) {
            this.setHumidity(PercentFraction.valueOf(element.getAttribute("Humidity")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public PercentFraction getCO2Percent() {
        return this.co2Percent;
    }

    public void setCO2Percent(PercentFraction co2Percent) {
        this.co2Percent = co2Percent;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Double getAirPressure() {
        return this.airPressure;
    }

    public void setAirPressure(Double airPressure) {
        this.airPressure = airPressure;
    }

    public PercentFraction getHumidity() {
        return this.humidity;
    }

    public void setHumidity(PercentFraction humidity) {
        this.humidity = humidity;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element ImagingEnvironment_element) {
        if (ImagingEnvironment_element == null) {
            ImagingEnvironment_element = document.createElementNS(NAMESPACE, "ImagingEnvironment");
        }
        if (this.co2Percent != null) {
            ImagingEnvironment_element.setAttribute("CO2Percent", this.co2Percent.toString());
        }
        if (this.temperature != null) {
            ImagingEnvironment_element.setAttribute("Temperature", this.temperature.toString());
        }
        if (this.airPressure != null) {
            ImagingEnvironment_element.setAttribute("AirPressure", this.airPressure.toString());
        }
        if (this.humidity != null) {
            ImagingEnvironment_element.setAttribute("Humidity", this.humidity.toString());
        }
        return super.asXMLElement(document, ImagingEnvironment_element);
    }
}

