/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Label
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2013-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Label.class);
    private Double y;
    private Double x;

    public Label() {
    }

    public Label(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Label(Label orig) {
        super(orig);
        this.y = orig.y;
        this.x = orig.x;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Label".equals(tagName)) {
            LOGGER.debug("Expecting node name of Label got {}", (Object)tagName);
        }
        if (element.hasAttribute("Y")) {
            this.setY(Double.valueOf(element.getAttribute("Y")));
        }
        if (element.hasAttribute("X")) {
            this.setX(Double.valueOf(element.getAttribute("X")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Label_element) {
        if (Label_element == null) {
            Label_element = document.createElementNS(NAMESPACE, "Label");
        }
        if (this.y != null) {
            Label_element.setAttribute("Y", this.y.toString());
        }
        if (this.x != null) {
            Label_element.setAttribute("X", this.x.toString());
        }
        return super.asXMLElement(document, Label_element);
    }
}

