/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.LightSource;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pump;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Laser
extends LightSource {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2013-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Laser.class);
    private Boolean pockelCell;
    private Pulse pulse;
    private LaserMedium laserMedium;
    private Boolean tuneable;
    private PositiveInteger wavelength;
    private PositiveInteger frequencyMultiplication;
    private LaserType type;
    private Double repetitionRate;
    private LightSource pump;

    public Laser() {
    }

    public Laser(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Laser(Laser orig) {
        super(orig);
        this.pockelCell = orig.pockelCell;
        this.pulse = orig.pulse;
        this.laserMedium = orig.laserMedium;
        this.tuneable = orig.tuneable;
        this.wavelength = orig.wavelength;
        this.frequencyMultiplication = orig.frequencyMultiplication;
        this.type = orig.type;
        this.repetitionRate = orig.repetitionRate;
        this.pump = orig.pump;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Laser".equals(tagName)) {
            LOGGER.debug("Expecting node name of Laser got {}", (Object)tagName);
        }
        if (element.hasAttribute("PockelCell")) {
            this.setPockelCell(Boolean.valueOf(element.getAttribute("PockelCell")));
        }
        if (element.hasAttribute("Pulse")) {
            this.setPulse(Pulse.fromString(element.getAttribute("Pulse")));
        }
        if (element.hasAttribute("LaserMedium")) {
            this.setLaserMedium(LaserMedium.fromString(element.getAttribute("LaserMedium")));
        }
        if (element.hasAttribute("Tuneable")) {
            this.setTuneable(Boolean.valueOf(element.getAttribute("Tuneable")));
        }
        if (element.hasAttribute("Wavelength")) {
            this.setWavelength(PositiveInteger.valueOf(element.getAttribute("Wavelength")));
        }
        if (element.hasAttribute("FrequencyMultiplication")) {
            this.setFrequencyMultiplication(PositiveInteger.valueOf(element.getAttribute("FrequencyMultiplication")));
        }
        if (element.hasAttribute("Type")) {
            this.setType(LaserType.fromString(element.getAttribute("Type")));
        }
        if (element.hasAttribute("RepetitionRate")) {
            this.setRepetitionRate(Double.valueOf(element.getAttribute("RepetitionRate")));
        }
        List<Element> Pump_nodeList = Laser.getChildrenByTagName(element, "Pump");
        for (Element Pump_element : Pump_nodeList) {
            Pump pump_reference = new Pump();
            pump_reference.setID(Pump_element.getAttribute("ID"));
            model.addReference(this, pump_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof Pump) {
            LightSource o_casted;
            this.pump = o_casted = (LightSource)o;
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public Boolean getPockelCell() {
        return this.pockelCell;
    }

    public void setPockelCell(Boolean pockelCell) {
        this.pockelCell = pockelCell;
    }

    public Pulse getPulse() {
        return this.pulse;
    }

    public void setPulse(Pulse pulse) {
        this.pulse = pulse;
    }

    public LaserMedium getLaserMedium() {
        return this.laserMedium;
    }

    public void setLaserMedium(LaserMedium laserMedium) {
        this.laserMedium = laserMedium;
    }

    public Boolean getTuneable() {
        return this.tuneable;
    }

    public void setTuneable(Boolean tuneable) {
        this.tuneable = tuneable;
    }

    public PositiveInteger getWavelength() {
        return this.wavelength;
    }

    public void setWavelength(PositiveInteger wavelength) {
        this.wavelength = wavelength;
    }

    public PositiveInteger getFrequencyMultiplication() {
        return this.frequencyMultiplication;
    }

    public void setFrequencyMultiplication(PositiveInteger frequencyMultiplication) {
        this.frequencyMultiplication = frequencyMultiplication;
    }

    public LaserType getType() {
        return this.type;
    }

    public void setType(LaserType type) {
        this.type = type;
    }

    public Double getRepetitionRate() {
        return this.repetitionRate;
    }

    public void setRepetitionRate(Double repetitionRate) {
        this.repetitionRate = repetitionRate;
    }

    public LightSource getLinkedPump() {
        return this.pump;
    }

    public void linkPump(LightSource o) {
        this.pump = o;
    }

    public void unlinkPump(LightSource o) {
        if (this.pump == o) {
            this.pump = null;
        }
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Laser_element) {
        if (Laser_element == null) {
            Laser_element = document.createElementNS(NAMESPACE, "Laser");
        }
        if (this.pockelCell != null) {
            Laser_element.setAttribute("PockelCell", this.pockelCell.toString());
        }
        if (this.pulse != null) {
            Laser_element.setAttribute("Pulse", this.pulse.toString());
        }
        if (this.laserMedium != null) {
            Laser_element.setAttribute("LaserMedium", this.laserMedium.toString());
        }
        if (this.tuneable != null) {
            Laser_element.setAttribute("Tuneable", this.tuneable.toString());
        }
        if (this.wavelength != null) {
            Laser_element.setAttribute("Wavelength", this.wavelength.toString());
        }
        if (this.frequencyMultiplication != null) {
            Laser_element.setAttribute("FrequencyMultiplication", this.frequencyMultiplication.toString());
        }
        if (this.type != null) {
            Laser_element.setAttribute("Type", this.type.toString());
        }
        if (this.repetitionRate != null) {
            Laser_element.setAttribute("RepetitionRate", this.repetitionRate.toString());
        }
        if (this.pump != null) {
            Pump o = new Pump();
            o.setID(this.pump.getID());
            Laser_element.appendChild(o.asXMLElement(document));
        }
        return super.asXMLElement(document, Laser_element);
    }
}

