/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.BinData;
import ome.xml.model.Channel;
import ome.xml.model.MetadataOnly;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Plane;
import ome.xml.model.Reference;
import ome.xml.model.TiffData;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Pixels
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2013-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Pixels.class);
    private PositiveInteger sizeT;
    private DimensionOrder dimensionOrder;
    private Double timeIncrement;
    private PositiveFloat physicalSizeY;
    private PositiveFloat physicalSizeX;
    private PositiveFloat physicalSizeZ;
    private PositiveInteger sizeX;
    private PositiveInteger sizeY;
    private PositiveInteger sizeZ;
    private Boolean bigEndian;
    private PositiveInteger significantBits;
    private PositiveInteger sizeC;
    private PixelType type;
    private String id;
    private Boolean interleaved;
    private List<Channel> channels = new ArrayList<Channel>();
    private List<BinData> binDataBlocks = new ArrayList<BinData>();
    private List<TiffData> tiffDataBlocks = new ArrayList<TiffData>();
    private MetadataOnly metadataOnly;
    private List<Plane> planes = new ArrayList<Plane>();
    private List<Annotation> annotationLinks = new ArrayList<Annotation>();

    public Pixels() {
    }

    public Pixels(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Pixels(Pixels orig) {
        this.sizeT = orig.sizeT;
        this.dimensionOrder = orig.dimensionOrder;
        this.timeIncrement = orig.timeIncrement;
        this.physicalSizeY = orig.physicalSizeY;
        this.physicalSizeX = orig.physicalSizeX;
        this.physicalSizeZ = orig.physicalSizeZ;
        this.sizeX = orig.sizeX;
        this.sizeY = orig.sizeY;
        this.sizeZ = orig.sizeZ;
        this.bigEndian = orig.bigEndian;
        this.significantBits = orig.significantBits;
        this.sizeC = orig.sizeC;
        this.type = orig.type;
        this.id = orig.id;
        this.interleaved = orig.interleaved;
        this.channels = orig.channels;
        this.binDataBlocks = orig.binDataBlocks;
        this.tiffDataBlocks = orig.tiffDataBlocks;
        this.metadataOnly = orig.metadataOnly;
        this.planes = orig.planes;
        this.annotationLinks = orig.annotationLinks;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Pixels".equals(tagName)) {
            LOGGER.debug("Expecting node name of Pixels got {}", (Object)tagName);
        }
        if (element.hasAttribute("SizeT")) {
            this.setSizeT(PositiveInteger.valueOf(element.getAttribute("SizeT")));
        }
        if (element.hasAttribute("DimensionOrder")) {
            this.setDimensionOrder(DimensionOrder.fromString(element.getAttribute("DimensionOrder")));
        }
        if (element.hasAttribute("TimeIncrement")) {
            this.setTimeIncrement(Double.valueOf(element.getAttribute("TimeIncrement")));
        }
        if (element.hasAttribute("PhysicalSizeY")) {
            this.setPhysicalSizeY(PositiveFloat.valueOf(element.getAttribute("PhysicalSizeY")));
        }
        if (element.hasAttribute("PhysicalSizeX")) {
            this.setPhysicalSizeX(PositiveFloat.valueOf(element.getAttribute("PhysicalSizeX")));
        }
        if (element.hasAttribute("PhysicalSizeZ")) {
            this.setPhysicalSizeZ(PositiveFloat.valueOf(element.getAttribute("PhysicalSizeZ")));
        }
        if (element.hasAttribute("SizeX")) {
            this.setSizeX(PositiveInteger.valueOf(element.getAttribute("SizeX")));
        }
        if (element.hasAttribute("SizeY")) {
            this.setSizeY(PositiveInteger.valueOf(element.getAttribute("SizeY")));
        }
        if (element.hasAttribute("SizeZ")) {
            this.setSizeZ(PositiveInteger.valueOf(element.getAttribute("SizeZ")));
        }
        if (element.hasAttribute("BigEndian")) {
            this.setBigEndian(Boolean.valueOf(element.getAttribute("BigEndian")));
        }
        if (element.hasAttribute("SignificantBits")) {
            this.setSignificantBits(PositiveInteger.valueOf(element.getAttribute("SignificantBits")));
        }
        if (element.hasAttribute("SizeC")) {
            this.setSizeC(PositiveInteger.valueOf(element.getAttribute("SizeC")));
        }
        if (element.hasAttribute("Type")) {
            this.setType(PixelType.fromString(element.getAttribute("Type")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Pixels missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Interleaved")) {
            this.setInterleaved(Boolean.valueOf(element.getAttribute("Interleaved")));
        }
        List<Element> Channel_nodeList = Pixels.getChildrenByTagName(element, "Channel");
        for (Element Channel_element : Channel_nodeList) {
            this.addChannel(new Channel(Channel_element, model));
        }
        List<Element> BinData_nodeList = Pixels.getChildrenByTagName(element, "BinData");
        for (Element BinData_element : BinData_nodeList) {
            this.addBinData(new BinData(BinData_element, model));
        }
        List<Element> TiffData_nodeList = Pixels.getChildrenByTagName(element, "TiffData");
        for (Element TiffData_element : TiffData_nodeList) {
            this.addTiffData(new TiffData(TiffData_element, model));
        }
        List<Element> MetadataOnly_nodeList = Pixels.getChildrenByTagName(element, "MetadataOnly");
        if (MetadataOnly_nodeList.size() > 1) {
            throw new RuntimeException(String.format("MetadataOnly node list size %d != 1", MetadataOnly_nodeList.size()));
        }
        if (MetadataOnly_nodeList.size() != 0) {
            this.setMetadataOnly(new MetadataOnly(MetadataOnly_nodeList.get(0), model));
        }
        List<Element> Plane_nodeList = Pixels.getChildrenByTagName(element, "Plane");
        for (Element Plane_element : Plane_nodeList) {
            this.addPlane(new Plane(Plane_element, model));
        }
        List<Element> AnnotationRef_nodeList = Pixels.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkPixels(this);
            if (!this.annotationLinks.contains(o_casted)) {
                this.annotationLinks.add(o_casted);
            }
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public PositiveInteger getSizeT() {
        return this.sizeT;
    }

    public void setSizeT(PositiveInteger sizeT) {
        this.sizeT = sizeT;
    }

    public DimensionOrder getDimensionOrder() {
        return this.dimensionOrder;
    }

    public void setDimensionOrder(DimensionOrder dimensionOrder) {
        this.dimensionOrder = dimensionOrder;
    }

    public Double getTimeIncrement() {
        return this.timeIncrement;
    }

    public void setTimeIncrement(Double timeIncrement) {
        this.timeIncrement = timeIncrement;
    }

    public PositiveFloat getPhysicalSizeY() {
        return this.physicalSizeY;
    }

    public void setPhysicalSizeY(PositiveFloat physicalSizeY) {
        this.physicalSizeY = physicalSizeY;
    }

    public PositiveFloat getPhysicalSizeX() {
        return this.physicalSizeX;
    }

    public void setPhysicalSizeX(PositiveFloat physicalSizeX) {
        this.physicalSizeX = physicalSizeX;
    }

    public PositiveFloat getPhysicalSizeZ() {
        return this.physicalSizeZ;
    }

    public void setPhysicalSizeZ(PositiveFloat physicalSizeZ) {
        this.physicalSizeZ = physicalSizeZ;
    }

    public PositiveInteger getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(PositiveInteger sizeX) {
        this.sizeX = sizeX;
    }

    public PositiveInteger getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(PositiveInteger sizeY) {
        this.sizeY = sizeY;
    }

    public PositiveInteger getSizeZ() {
        return this.sizeZ;
    }

    public void setSizeZ(PositiveInteger sizeZ) {
        this.sizeZ = sizeZ;
    }

    public Boolean getBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(Boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public PositiveInteger getSignificantBits() {
        return this.significantBits;
    }

    public void setSignificantBits(PositiveInteger significantBits) {
        this.significantBits = significantBits;
    }

    public PositiveInteger getSizeC() {
        return this.sizeC;
    }

    public void setSizeC(PositiveInteger sizeC) {
        this.sizeC = sizeC;
    }

    public PixelType getType() {
        return this.type;
    }

    public void setType(PixelType type) {
        this.type = type;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Boolean getInterleaved() {
        return this.interleaved;
    }

    public void setInterleaved(Boolean interleaved) {
        this.interleaved = interleaved;
    }

    public int sizeOfChannelList() {
        return this.channels.size();
    }

    public List<Channel> copyChannelList() {
        return new ArrayList<Channel>(this.channels);
    }

    public Channel getChannel(int index) {
        return this.channels.get(index);
    }

    public Channel setChannel(int index, Channel channel) {
        channel.setPixels(this);
        return this.channels.set(index, channel);
    }

    public void addChannel(Channel channel) {
        channel.setPixels(this);
        this.channels.add(channel);
    }

    public void removeChannel(Channel channel) {
        this.channels.remove(channel);
    }

    public int sizeOfBinDataList() {
        return this.binDataBlocks.size();
    }

    public List<BinData> copyBinDataList() {
        return new ArrayList<BinData>(this.binDataBlocks);
    }

    public BinData getBinData(int index) {
        return this.binDataBlocks.get(index);
    }

    public BinData setBinData(int index, BinData binData) {
        binData.setPixels(this);
        return this.binDataBlocks.set(index, binData);
    }

    public void addBinData(BinData binData) {
        binData.setPixels(this);
        this.binDataBlocks.add(binData);
    }

    public void removeBinData(BinData binData) {
        this.binDataBlocks.remove(binData);
    }

    public int sizeOfTiffDataList() {
        return this.tiffDataBlocks.size();
    }

    public List<TiffData> copyTiffDataList() {
        return new ArrayList<TiffData>(this.tiffDataBlocks);
    }

    public TiffData getTiffData(int index) {
        return this.tiffDataBlocks.get(index);
    }

    public TiffData setTiffData(int index, TiffData tiffData) {
        tiffData.setPixels(this);
        return this.tiffDataBlocks.set(index, tiffData);
    }

    public void addTiffData(TiffData tiffData) {
        tiffData.setPixels(this);
        this.tiffDataBlocks.add(tiffData);
    }

    public void removeTiffData(TiffData tiffData) {
        this.tiffDataBlocks.remove(tiffData);
    }

    public MetadataOnly getMetadataOnly() {
        return this.metadataOnly;
    }

    public void setMetadataOnly(MetadataOnly metadataOnly) {
        this.metadataOnly = metadataOnly;
    }

    public int sizeOfPlaneList() {
        return this.planes.size();
    }

    public List<Plane> copyPlaneList() {
        return new ArrayList<Plane>(this.planes);
    }

    public Plane getPlane(int index) {
        return this.planes.get(index);
    }

    public Plane setPlane(int index, Plane plane) {
        plane.setPixels(this);
        return this.planes.set(index, plane);
    }

    public void addPlane(Plane plane) {
        plane.setPixels(this);
        this.planes.add(plane);
    }

    public void removePlane(Plane plane) {
        this.planes.remove(plane);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkPixels(this);
        if (!this.annotationLinks.contains(o)) {
            return this.annotationLinks.add(o);
        }
        return false;
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkPixels(this);
        return this.annotationLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Pixels_element) {
        if (Pixels_element == null) {
            Pixels_element = document.createElementNS(NAMESPACE, "Pixels");
        }
        if (this.sizeT != null) {
            Pixels_element.setAttribute("SizeT", this.sizeT.toString());
        }
        if (this.dimensionOrder != null) {
            Pixels_element.setAttribute("DimensionOrder", this.dimensionOrder.toString());
        }
        if (this.timeIncrement != null) {
            Pixels_element.setAttribute("TimeIncrement", this.timeIncrement.toString());
        }
        if (this.physicalSizeY != null) {
            Pixels_element.setAttribute("PhysicalSizeY", this.physicalSizeY.toString());
        }
        if (this.physicalSizeX != null) {
            Pixels_element.setAttribute("PhysicalSizeX", this.physicalSizeX.toString());
        }
        if (this.physicalSizeZ != null) {
            Pixels_element.setAttribute("PhysicalSizeZ", this.physicalSizeZ.toString());
        }
        if (this.sizeX != null) {
            Pixels_element.setAttribute("SizeX", this.sizeX.toString());
        }
        if (this.sizeY != null) {
            Pixels_element.setAttribute("SizeY", this.sizeY.toString());
        }
        if (this.sizeZ != null) {
            Pixels_element.setAttribute("SizeZ", this.sizeZ.toString());
        }
        if (this.bigEndian != null) {
            Pixels_element.setAttribute("BigEndian", this.bigEndian.toString());
        }
        if (this.significantBits != null) {
            Pixels_element.setAttribute("SignificantBits", this.significantBits.toString());
        }
        if (this.sizeC != null) {
            Pixels_element.setAttribute("SizeC", this.sizeC.toString());
        }
        if (this.type != null) {
            Pixels_element.setAttribute("Type", this.type.toString());
        }
        if (this.id != null) {
            Pixels_element.setAttribute("ID", this.id.toString());
        }
        if (this.interleaved != null) {
            Pixels_element.setAttribute("Interleaved", this.interleaved.toString());
        }
        if (this.channels != null) {
            for (Channel channels_value : this.channels) {
                Pixels_element.appendChild(channels_value.asXMLElement(document));
            }
        }
        if (this.binDataBlocks != null) {
            for (BinData binDataBlocks_value : this.binDataBlocks) {
                Pixels_element.appendChild(binDataBlocks_value.asXMLElement(document));
            }
        }
        if (this.tiffDataBlocks != null) {
            for (TiffData tiffDataBlocks_value : this.tiffDataBlocks) {
                Pixels_element.appendChild(tiffDataBlocks_value.asXMLElement(document));
            }
        }
        if (this.metadataOnly != null) {
            Pixels_element.appendChild(this.metadataOnly.asXMLElement(document));
        }
        if (this.planes != null) {
            for (Plane planes_value : this.planes) {
                Pixels_element.appendChild(planes_value.asXMLElement(document));
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Pixels_element.appendChild(o.asXMLElement(document));
            }
        }
        return super.asXMLElement(document, Pixels_element);
    }
}

