/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.Reference;
import ome.xml.model.Screen;
import ome.xml.model.Well;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Plate
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SPW/2013-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Plate.class);
    private String status;
    private PositiveInteger rows;
    private String externalIdentifier;
    private NamingConvention rowNamingConvention;
    private NamingConvention columnNamingConvention;
    private NonNegativeInteger fieldIndex;
    private Double wellOriginY;
    private Double wellOriginX;
    private String id;
    private PositiveInteger columns;
    private String name;
    private String description;
    private List<Well> wells = new ArrayList<Well>();
    private List<Annotation> annotationLinks = new ArrayList<Annotation>();
    private List<PlateAcquisition> plateAcquisitions = new ArrayList<PlateAcquisition>();
    private List<Screen> screenLinks = new ArrayList<Screen>();

    public Plate() {
    }

    public Plate(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Plate(Plate orig) {
        this.status = orig.status;
        this.rows = orig.rows;
        this.externalIdentifier = orig.externalIdentifier;
        this.rowNamingConvention = orig.rowNamingConvention;
        this.columnNamingConvention = orig.columnNamingConvention;
        this.fieldIndex = orig.fieldIndex;
        this.wellOriginY = orig.wellOriginY;
        this.wellOriginX = orig.wellOriginX;
        this.id = orig.id;
        this.columns = orig.columns;
        this.name = orig.name;
        this.description = orig.description;
        this.wells = orig.wells;
        this.annotationLinks = orig.annotationLinks;
        this.plateAcquisitions = orig.plateAcquisitions;
        this.screenLinks = orig.screenLinks;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Plate".equals(tagName)) {
            LOGGER.debug("Expecting node name of Plate got {}", (Object)tagName);
        }
        if (element.hasAttribute("Status")) {
            this.setStatus(String.valueOf(element.getAttribute("Status")));
        }
        if (element.hasAttribute("Rows")) {
            this.setRows(PositiveInteger.valueOf(element.getAttribute("Rows")));
        }
        if (element.hasAttribute("ExternalIdentifier")) {
            this.setExternalIdentifier(String.valueOf(element.getAttribute("ExternalIdentifier")));
        }
        if (element.hasAttribute("RowNamingConvention")) {
            this.setRowNamingConvention(NamingConvention.fromString(element.getAttribute("RowNamingConvention")));
        }
        if (element.hasAttribute("ColumnNamingConvention")) {
            this.setColumnNamingConvention(NamingConvention.fromString(element.getAttribute("ColumnNamingConvention")));
        }
        if (element.hasAttribute("FieldIndex")) {
            this.setFieldIndex(NonNegativeInteger.valueOf(element.getAttribute("FieldIndex")));
        }
        if (element.hasAttribute("WellOriginY")) {
            this.setWellOriginY(Double.valueOf(element.getAttribute("WellOriginY")));
        }
        if (element.hasAttribute("WellOriginX")) {
            this.setWellOriginX(Double.valueOf(element.getAttribute("WellOriginX")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Plate missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Columns")) {
            this.setColumns(PositiveInteger.valueOf(element.getAttribute("Columns")));
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if ((Description_nodeList = Plate.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> Well_nodeList = Plate.getChildrenByTagName(element, "Well");
        for (Element Well_element : Well_nodeList) {
            this.addWell(new Well(Well_element, model));
        }
        List<Element> AnnotationRef_nodeList = Plate.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
        List<Element> PlateAcquisition_nodeList = Plate.getChildrenByTagName(element, "PlateAcquisition");
        for (Element PlateAcquisition_element : PlateAcquisition_nodeList) {
            this.addPlateAcquisition(new PlateAcquisition(PlateAcquisition_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkPlate(this);
            if (!this.annotationLinks.contains(o_casted)) {
                this.annotationLinks.add(o_casted);
            }
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public PositiveInteger getRows() {
        return this.rows;
    }

    public void setRows(PositiveInteger rows) {
        this.rows = rows;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public NamingConvention getRowNamingConvention() {
        return this.rowNamingConvention;
    }

    public void setRowNamingConvention(NamingConvention rowNamingConvention) {
        this.rowNamingConvention = rowNamingConvention;
    }

    public NamingConvention getColumnNamingConvention() {
        return this.columnNamingConvention;
    }

    public void setColumnNamingConvention(NamingConvention columnNamingConvention) {
        this.columnNamingConvention = columnNamingConvention;
    }

    public NonNegativeInteger getFieldIndex() {
        return this.fieldIndex;
    }

    public void setFieldIndex(NonNegativeInteger fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public Double getWellOriginY() {
        return this.wellOriginY;
    }

    public void setWellOriginY(Double wellOriginY) {
        this.wellOriginY = wellOriginY;
    }

    public Double getWellOriginX() {
        return this.wellOriginX;
    }

    public void setWellOriginX(Double wellOriginX) {
        this.wellOriginX = wellOriginX;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public PositiveInteger getColumns() {
        return this.columns;
    }

    public void setColumns(PositiveInteger columns) {
        this.columns = columns;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfWellList() {
        return this.wells.size();
    }

    public List<Well> copyWellList() {
        return new ArrayList<Well>(this.wells);
    }

    public Well getWell(int index) {
        return this.wells.get(index);
    }

    public Well setWell(int index, Well well) {
        well.setPlate(this);
        return this.wells.set(index, well);
    }

    public void addWell(Well well) {
        well.setPlate(this);
        this.wells.add(well);
    }

    public void removeWell(Well well) {
        this.wells.remove(well);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkPlate(this);
        if (!this.annotationLinks.contains(o)) {
            return this.annotationLinks.add(o);
        }
        return false;
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkPlate(this);
        return this.annotationLinks.remove(o);
    }

    public int sizeOfPlateAcquisitionList() {
        return this.plateAcquisitions.size();
    }

    public List<PlateAcquisition> copyPlateAcquisitionList() {
        return new ArrayList<PlateAcquisition>(this.plateAcquisitions);
    }

    public PlateAcquisition getPlateAcquisition(int index) {
        return this.plateAcquisitions.get(index);
    }

    public PlateAcquisition setPlateAcquisition(int index, PlateAcquisition plateAcquisition) {
        plateAcquisition.setPlate(this);
        return this.plateAcquisitions.set(index, plateAcquisition);
    }

    public void addPlateAcquisition(PlateAcquisition plateAcquisition) {
        plateAcquisition.setPlate(this);
        this.plateAcquisitions.add(plateAcquisition);
    }

    public void removePlateAcquisition(PlateAcquisition plateAcquisition) {
        this.plateAcquisitions.remove(plateAcquisition);
    }

    public int sizeOfLinkedScreenList() {
        return this.screenLinks.size();
    }

    public List<Screen> copyLinkedScreenList() {
        return new ArrayList<Screen>(this.screenLinks);
    }

    public Screen getLinkedScreen(int index) {
        return this.screenLinks.get(index);
    }

    public Screen setLinkedScreen(int index, Screen o) {
        return this.screenLinks.set(index, o);
    }

    public boolean linkScreen(Screen o) {
        if (!this.screenLinks.contains(o)) {
            return this.screenLinks.add(o);
        }
        return false;
    }

    public boolean unlinkScreen(Screen o) {
        return this.screenLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Plate_element) {
        if (Plate_element == null) {
            Plate_element = document.createElementNS(NAMESPACE, "Plate");
        }
        if (this.status != null) {
            Plate_element.setAttribute("Status", this.status.toString());
        }
        if (this.rows != null) {
            Plate_element.setAttribute("Rows", this.rows.toString());
        }
        if (this.externalIdentifier != null) {
            Plate_element.setAttribute("ExternalIdentifier", this.externalIdentifier.toString());
        }
        if (this.rowNamingConvention != null) {
            Plate_element.setAttribute("RowNamingConvention", this.rowNamingConvention.toString());
        }
        if (this.columnNamingConvention != null) {
            Plate_element.setAttribute("ColumnNamingConvention", this.columnNamingConvention.toString());
        }
        if (this.fieldIndex != null) {
            Plate_element.setAttribute("FieldIndex", this.fieldIndex.toString());
        }
        if (this.wellOriginY != null) {
            Plate_element.setAttribute("WellOriginY", this.wellOriginY.toString());
        }
        if (this.wellOriginX != null) {
            Plate_element.setAttribute("WellOriginX", this.wellOriginX.toString());
        }
        if (this.id != null) {
            Plate_element.setAttribute("ID", this.id.toString());
        }
        if (this.columns != null) {
            Plate_element.setAttribute("Columns", this.columns.toString());
        }
        if (this.name != null) {
            Plate_element.setAttribute("Name", this.name.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description.toString());
            Plate_element.appendChild(description_element);
        }
        if (this.wells != null) {
            for (Well wells_value : this.wells) {
                Plate_element.appendChild(wells_value.asXMLElement(document));
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Plate_element.appendChild(o.asXMLElement(document));
            }
        }
        if (this.plateAcquisitions != null) {
            for (PlateAcquisition plateAcquisitions_value : this.plateAcquisitions) {
                Plate_element.appendChild(plateAcquisitions_value.asXMLElement(document));
            }
        }
        if (this.screenLinks != null) {
            // empty if block
        }
        return super.asXMLElement(document, Plate_element);
    }
}

