/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.Annotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TextAnnotation
extends Annotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2013-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(TextAnnotation.class);

    public TextAnnotation() {
    }

    public TextAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public TextAnnotation(TextAnnotation orig) {
        super(orig);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"TextAnnotation".equals(tagName)) {
            LOGGER.debug("Expecting node name of TextAnnotation got {}", (Object)tagName);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element TextAnnotation_element) {
        if (TextAnnotation_element == null) {
            TextAnnotation_element = document.createElementNS(NAMESPACE, "TextAnnotation");
        }
        TextAnnotation_element = super.asXMLElement(document, TextAnnotation_element);
        return TextAnnotation_element;
    }
}

