/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.codec.CompressionType;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.meta.MetadataRetrieve;

public class JPEG2000Writer
extends FormatWriter {
    public JPEG2000Writer() {
        super("JPEG-2000", "jp2");
        this.compressionTypes = new String[]{CompressionType.J2K_LOSSY.getCompression(), CompressionType.J2K.getCompression()};
        this.options = JPEG2000CodecOptions.getDefaultOptions();
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h);
        this.out.write(this.compressBuffer(no, buf, x, y, w, h));
    }

    public byte[] compressBuffer(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h);
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        boolean littleEndian = retrieve.getPixelsBinDataBigEndian(this.series, 0) == false;
        int bytesPerPixel = FormatTools.getBytesPerPixel(FormatTools.pixelTypeFromString(retrieve.getPixelsType(this.series).toString()));
        int nChannels = this.getSamplesPerPixel();
        if (this.options == null) {
            this.options = JPEG2000CodecOptions.getDefaultOptions();
        }
        this.options = new JPEG2000CodecOptions(this.options);
        this.options.width = w;
        this.options.height = h;
        this.options.channels = nChannels;
        this.options.bitsPerSample = bytesPerPixel * 8;
        this.options.littleEndian = littleEndian;
        this.options.interleaved = this.interleaved;
        this.options.lossless = this.compression == null || this.compression.equals(CompressionType.J2K.getCompression());
        this.options.colorModel = this.getColorModel();
        return new JPEG2000Codec().compress(buf, this.options);
    }

    @Override
    public boolean canDoStacks() {
        return false;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return new int[]{0, 1, 2, 3, 4, 5};
    }
}

