/*
 * Decompiled with CFR 0.152.
 */
package ome.units;

import java.math.BigInteger;
import ome.units.quantity.Angle;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Quantity;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.units.unit.Unit;

public final class UNITS {
    public static final Unit<Angle> RADIAN = Unit.CreateBaseUnit("SI.RADIAN", "rad");
    public static final Unit<ElectricPotential> VOLT = Unit.CreateBaseUnit("SI.VOLT", "V");
    public static final Unit<Frequency> HERTZ = Unit.CreateBaseUnit("SI.HERTZ", "Hz");
    public static final Unit<Length> METRE = Unit.CreateBaseUnit("SI.METRE", "m");
    public static final Unit<Length> INCH = METRE.multiply(0.0254).setSymbol("in");
    public static final Unit<Power> WATT = Unit.CreateBaseUnit("SI.WATT", "W");
    public static final Unit<Pressure> PASCAL = Unit.CreateBaseUnit("SI.PASCAL", "Pa");
    public static final Unit<Temperature> KELVIN = Unit.CreateBaseUnit("SI.KELVIN", "K");
    public static final Unit<Time> SECOND = Unit.CreateBaseUnit("SI.SECOND", "s");
    public static final Unit<Frequency> YOTTAHZ = UNITS.YOTTA(HERTZ);
    public static final Unit<Frequency> ZETTAHZ = UNITS.ZETTA(HERTZ);
    public static final Unit<Frequency> EXAHZ = UNITS.EXA(HERTZ);
    public static final Unit<Frequency> PETAHZ = UNITS.PETA(HERTZ);
    public static final Unit<Frequency> TERAHZ = UNITS.TERA(HERTZ);
    public static final Unit<Frequency> GIGAHZ = UNITS.GIGA(HERTZ);
    public static final Unit<Frequency> MEGAHZ = UNITS.MEGA(HERTZ);
    public static final Unit<Frequency> KHZ = UNITS.KILO(HERTZ);
    public static final Unit<Frequency> HHZ = UNITS.HECTO(HERTZ);
    public static final Unit<Frequency> DAHZ = UNITS.DEKA(HERTZ);
    public static final Unit<Frequency> HZ = HERTZ;
    public static final Unit<Frequency> DHZ = UNITS.DECI(HERTZ);
    public static final Unit<Frequency> CHZ = UNITS.CENTI(HERTZ);
    public static final Unit<Frequency> MHZ = UNITS.MILLI(HERTZ);
    public static final Unit<Frequency> MICROHZ = UNITS.MICRO(HERTZ);
    public static final Unit<Frequency> NHZ = UNITS.NANO(HERTZ);
    public static final Unit<Frequency> PHZ = UNITS.PICO(HERTZ);
    public static final Unit<Frequency> FHZ = UNITS.FEMTO(HERTZ);
    public static final Unit<Frequency> AHZ = UNITS.ATTO(HERTZ);
    public static final Unit<Frequency> ZHZ = UNITS.ZEPTO(HERTZ);
    public static final Unit<Frequency> YHZ = UNITS.YOCTO(HERTZ);
    public static final Unit<Length> YOTTAM = UNITS.YOTTA(METRE);
    public static final Unit<Length> ZETTAM = UNITS.ZETTA(METRE);
    public static final Unit<Length> EXAM = UNITS.EXA(METRE);
    public static final Unit<Length> PETAM = UNITS.PETA(METRE);
    public static final Unit<Length> TERAM = UNITS.TERA(METRE);
    public static final Unit<Length> GIGAM = UNITS.GIGA(METRE);
    public static final Unit<Length> MEGAM = UNITS.MEGA(METRE);
    public static final Unit<Length> KM = UNITS.KILO(METRE);
    public static final Unit<Length> HM = UNITS.HECTO(METRE);
    public static final Unit<Length> DAM = UNITS.DEKA(METRE);
    public static final Unit<Length> M = METRE;
    public static final Unit<Length> DM = UNITS.DECI(METRE);
    public static final Unit<Length> CM = UNITS.CENTI(METRE);
    public static final Unit<Length> MM = UNITS.MILLI(METRE);
    public static final Unit<Length> MICROM = UNITS.MICRO(METRE);
    public static final Unit<Length> NM = UNITS.NANO(METRE);
    public static final Unit<Length> PM = UNITS.PICO(METRE);
    public static final Unit<Length> FM = UNITS.FEMTO(METRE);
    public static final Unit<Length> AM = UNITS.ATTO(METRE);
    public static final Unit<Length> ZM = UNITS.ZEPTO(METRE);
    public static final Unit<Length> YM = UNITS.YOCTO(METRE);
    public static final Unit<Length> ANGSTROM = NM.divide(10).setSymbol("\u00c5");
    public static final Unit<Length> THOU = UNITS.MILLI(INCH).setSymbol("thou");
    public static final Unit<Length> LI = INCH.divide(12).setSymbol("li");
    public static final Unit<Length> IN = INCH;
    public static final Unit<Length> FT = INCH.multiply(12).setSymbol("ft");
    public static final Unit<Length> YD = FT.multiply(3).setSymbol("yd");
    public static final Unit<Length> MI = YD.multiply(1760).setSymbol("mi");
    public static final Unit<Length> UA = UNITS.GIGA(METRE.multiply(149.5978707)).setSymbol("ua");
    public static final Unit<Length> LY = UNITS.PETA(METRE.multiply(9.4607304725808)).setSymbol("ly");
    public static final Unit<Length> PC = UNITS.GIGA(METRE.multiply(30856776)).setSymbol("pc");
    public static final Unit<Length> PT = INCH.divide(72).setSymbol("pt");
    public static final Unit<Length> PIXEL = Unit.CreateBaseUnit("Pixel", "pixel");
    public static final Unit<Length> REFERENCEFRAME = Unit.CreateBaseUnit("ReferenceFrame", "reference frame");
    public static final Unit<Power> YOTTAW = UNITS.YOTTA(WATT);
    public static final Unit<Power> ZETTAW = UNITS.ZETTA(WATT);
    public static final Unit<Power> EXAW = UNITS.EXA(WATT);
    public static final Unit<Power> PETAW = UNITS.PETA(WATT);
    public static final Unit<Power> TERAW = UNITS.TERA(WATT);
    public static final Unit<Power> GIGAW = UNITS.GIGA(WATT);
    public static final Unit<Power> MEGAW = UNITS.MEGA(WATT);
    public static final Unit<Power> KW = UNITS.KILO(WATT);
    public static final Unit<Power> HW = UNITS.HECTO(WATT);
    public static final Unit<Power> DAW = UNITS.DEKA(WATT);
    public static final Unit<Power> W = WATT;
    public static final Unit<Power> DW = UNITS.DECI(WATT);
    public static final Unit<Power> CW = UNITS.CENTI(WATT);
    public static final Unit<Power> MW = UNITS.MILLI(WATT);
    public static final Unit<Power> MICROW = UNITS.MICRO(WATT);
    public static final Unit<Power> NW = UNITS.NANO(WATT);
    public static final Unit<Power> PW = UNITS.PICO(WATT);
    public static final Unit<Power> FW = UNITS.FEMTO(WATT);
    public static final Unit<Power> AW = UNITS.ATTO(WATT);
    public static final Unit<Power> ZW = UNITS.ZEPTO(WATT);
    public static final Unit<Power> YW = UNITS.YOCTO(WATT);
    public static final Unit<Pressure> YOTTAPA = UNITS.YOTTA(PASCAL);
    public static final Unit<Pressure> ZETTAPA = UNITS.ZETTA(PASCAL);
    public static final Unit<Pressure> EXAPA = UNITS.EXA(PASCAL);
    public static final Unit<Pressure> PETAPA = UNITS.PETA(PASCAL);
    public static final Unit<Pressure> TERAPA = UNITS.TERA(PASCAL);
    public static final Unit<Pressure> GIGAPA = UNITS.GIGA(PASCAL);
    public static final Unit<Pressure> MEGAPA = UNITS.MEGA(PASCAL);
    public static final Unit<Pressure> KPA = UNITS.KILO(PASCAL);
    public static final Unit<Pressure> HPA = UNITS.HECTO(PASCAL);
    public static final Unit<Pressure> DAPA = UNITS.DEKA(PASCAL);
    public static final Unit<Pressure> PA = PASCAL;
    public static final Unit<Pressure> DPA = UNITS.DECI(PASCAL);
    public static final Unit<Pressure> CPA = UNITS.CENTI(PASCAL);
    public static final Unit<Pressure> MPA = UNITS.MILLI(PASCAL);
    public static final Unit<Pressure> MICROPA = UNITS.MICRO(PASCAL);
    public static final Unit<Pressure> NPA = UNITS.NANO(PASCAL);
    public static final Unit<Pressure> PPA = UNITS.PICO(PASCAL);
    public static final Unit<Pressure> FPA = UNITS.FEMTO(PASCAL);
    public static final Unit<Pressure> APA = UNITS.ATTO(PASCAL);
    public static final Unit<Pressure> ZPA = UNITS.ZEPTO(PASCAL);
    public static final Unit<Pressure> YPA = UNITS.YOCTO(PASCAL);
    public static final Unit<Pressure> BAR = PASCAL.multiply(100000).setSymbol("bar");
    public static final Unit<Pressure> MEGABAR = UNITS.MEGA(BAR);
    public static final Unit<Pressure> KBAR = UNITS.KILO(BAR);
    public static final Unit<Pressure> DBAR = UNITS.DECI(BAR);
    public static final Unit<Pressure> CBAR = UNITS.CENTI(BAR);
    public static final Unit<Pressure> MBAR = UNITS.MILLI(BAR);
    public static final Unit<Pressure> ATM = PASCAL.multiply(101325).setSymbol("atm");
    public static final Unit<Pressure> PSI = PASCAL.multiply(6894.757293168362).setSymbol("psi");
    public static final Unit<Pressure> TORR = ATM.divide(760).setSymbol("Torr");
    public static final Unit<Pressure> MTORR = UNITS.MILLI(TORR);
    public static final Unit<Pressure> MMHG = PASCAL.multiply(133.322387415).setSymbol("mm Hg");
    public static final Unit<Temperature> DEGREEC = KELVIN.add(273.15).setSymbol("\u00b0C");
    public static final Unit<Temperature> K = KELVIN;
    public static final Unit<Temperature> DEGREER = KELVIN.multiply(5).divide(9).setSymbol("\u00b0R");
    public static final Unit<Temperature> DEGREEF = DEGREER.add(459.67).setSymbol("\u00b0F");
    public static final Unit<Time> YOTTAS = UNITS.YOTTA(SECOND);
    public static final Unit<Time> ZETTAS = UNITS.ZETTA(SECOND);
    public static final Unit<Time> EXAS = UNITS.EXA(SECOND);
    public static final Unit<Time> PETAS = UNITS.PETA(SECOND);
    public static final Unit<Time> TERAS = UNITS.TERA(SECOND);
    public static final Unit<Time> GIGAS = UNITS.GIGA(SECOND);
    public static final Unit<Time> MEGAS = UNITS.MEGA(SECOND);
    public static final Unit<Time> KS = UNITS.KILO(SECOND);
    public static final Unit<Time> HS = UNITS.HECTO(SECOND);
    public static final Unit<Time> DAS = UNITS.DEKA(SECOND);
    public static final Unit<Time> S = SECOND;
    public static final Unit<Time> DS = UNITS.DECI(SECOND);
    public static final Unit<Time> CS = UNITS.CENTI(SECOND);
    public static final Unit<Time> MS = UNITS.MILLI(SECOND);
    public static final Unit<Time> MICROS = UNITS.MICRO(SECOND);
    public static final Unit<Time> NS = UNITS.NANO(SECOND);
    public static final Unit<Time> PS = UNITS.PICO(SECOND);
    public static final Unit<Time> FS = UNITS.FEMTO(SECOND);
    public static final Unit<Time> AS = UNITS.ATTO(SECOND);
    public static final Unit<Time> ZS = UNITS.ZEPTO(SECOND);
    public static final Unit<Time> YS = UNITS.YOCTO(SECOND);
    public static final Unit<Time> MIN = SECOND.multiply(60).setSymbol("min");
    public static final Unit<Time> H = MIN.multiply(60).setSymbol("h");
    public static final Unit<Time> D = H.multiply(24).setSymbol("d");
    public static final Unit<ElectricPotential> YOTTAV = UNITS.YOTTA(VOLT);
    public static final Unit<ElectricPotential> ZETTAV = UNITS.ZETTA(VOLT);
    public static final Unit<ElectricPotential> EXAV = UNITS.EXA(VOLT);
    public static final Unit<ElectricPotential> PETAV = UNITS.PETA(VOLT);
    public static final Unit<ElectricPotential> TERAV = UNITS.TERA(VOLT);
    public static final Unit<ElectricPotential> GIGAV = UNITS.GIGA(VOLT);
    public static final Unit<ElectricPotential> MEGAV = UNITS.MEGA(VOLT);
    public static final Unit<ElectricPotential> KV = UNITS.KILO(VOLT);
    public static final Unit<ElectricPotential> HV = UNITS.HECTO(VOLT);
    public static final Unit<ElectricPotential> DAV = UNITS.DEKA(VOLT);
    public static final Unit<ElectricPotential> V = VOLT;
    public static final Unit<ElectricPotential> DV = UNITS.DECI(VOLT);
    public static final Unit<ElectricPotential> CV = UNITS.CENTI(VOLT);
    public static final Unit<ElectricPotential> MV = UNITS.MILLI(VOLT);
    public static final Unit<ElectricPotential> MICROV = UNITS.MICRO(VOLT);
    public static final Unit<ElectricPotential> NV = UNITS.NANO(VOLT);
    public static final Unit<ElectricPotential> PV = UNITS.PICO(VOLT);
    public static final Unit<ElectricPotential> FV = UNITS.FEMTO(VOLT);
    public static final Unit<ElectricPotential> AV = UNITS.ATTO(VOLT);
    public static final Unit<ElectricPotential> ZV = UNITS.ZEPTO(VOLT);
    public static final Unit<ElectricPotential> YV = UNITS.YOCTO(VOLT);
    public static final Unit<Angle> DEG = RADIAN.multiply(Math.PI).divide(180).setSymbol("deg");
    public static final Unit<Angle> RAD = RADIAN;
    public static final Unit<Angle> GON = RADIAN.multiply(Math.PI).divide(200).setSymbol("gon");

    public String getName() {
        return "OME-combined";
    }

    public static <T extends Quantity> Unit<T> YOTTA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("Y").multiply(BigInteger.TEN.pow(24).doubleValue());
    }

    public static <T extends Quantity> Unit<T> ZETTA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("Z").multiply(BigInteger.TEN.pow(21).doubleValue());
    }

    public static <T extends Quantity> Unit<T> EXA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("E").multiply(BigInteger.TEN.pow(18).doubleValue());
    }

    public static <T extends Quantity> Unit<T> PETA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("P").multiply(BigInteger.TEN.pow(15).doubleValue());
    }

    public static <T extends Quantity> Unit<T> TERA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("T").multiply(BigInteger.TEN.pow(12).doubleValue());
    }

    public static <T extends Quantity> Unit<T> GIGA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("G").multiply(BigInteger.TEN.pow(9).doubleValue());
    }

    public static <T extends Quantity> Unit<T> MEGA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("M").multiply(BigInteger.TEN.pow(6).doubleValue());
    }

    public static <T extends Quantity> Unit<T> KILO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("k").multiply(BigInteger.TEN.pow(3).doubleValue());
    }

    public static <T extends Quantity> Unit<T> HECTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("h").multiply(BigInteger.TEN.pow(2).doubleValue());
    }

    public static <T extends Quantity> Unit<T> DEKA(Unit<T> inUnit) {
        return inUnit.prefixSymbol("da").multiply(BigInteger.TEN.pow(1).doubleValue());
    }

    public static <T extends Quantity> Unit<T> DECI(Unit<T> inUnit) {
        return inUnit.prefixSymbol("d").divide(BigInteger.TEN.pow(1).doubleValue());
    }

    public static <T extends Quantity> Unit<T> CENTI(Unit<T> inUnit) {
        return inUnit.prefixSymbol("c").divide(BigInteger.TEN.pow(2).doubleValue());
    }

    public static <T extends Quantity> Unit<T> MILLI(Unit<T> inUnit) {
        return inUnit.prefixSymbol("m").divide(BigInteger.TEN.pow(3).doubleValue());
    }

    public static <T extends Quantity> Unit<T> MICRO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("\u00b5").divide(BigInteger.TEN.pow(6).doubleValue());
    }

    public static <T extends Quantity> Unit<T> NANO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("n").divide(BigInteger.TEN.pow(9).doubleValue());
    }

    public static <T extends Quantity> Unit<T> PICO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("p").divide(BigInteger.TEN.pow(12).doubleValue());
    }

    public static <T extends Quantity> Unit<T> FEMTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("f").divide(BigInteger.TEN.pow(15).doubleValue());
    }

    public static <T extends Quantity> Unit<T> ATTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("a").divide(BigInteger.TEN.pow(18).doubleValue());
    }

    public static <T extends Quantity> Unit<T> ZEPTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("z").divide(BigInteger.TEN.pow(21).doubleValue());
    }

    public static <T extends Quantity> Unit<T> YOCTO(Unit<T> inUnit) {
        return inUnit.prefixSymbol("y").divide(BigInteger.TEN.pow(24).doubleValue());
    }
}

