/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.Annotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BasicAnnotation
extends Annotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicAnnotation.class);

    public BasicAnnotation() {
    }

    public BasicAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public BasicAnnotation(BasicAnnotation orig) {
        super(orig);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"BasicAnnotation".equals(tagName)) {
            LOGGER.debug("Expecting node name of BasicAnnotation got {}", (Object)tagName);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element BasicAnnotation_element) {
        if (BasicAnnotation_element == null) {
            BasicAnnotation_element = document.createElementNS(NAMESPACE, "BasicAnnotation");
        }
        BasicAnnotation_element = super.asXMLElement(document, BasicAnnotation_element);
        return BasicAnnotation_element;
    }
}

