/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.BooleanAnnotation;
import ome.xml.model.CommentAnnotation;
import ome.xml.model.DoubleAnnotation;
import ome.xml.model.FileAnnotation;
import ome.xml.model.ListAnnotation;
import ome.xml.model.LongAnnotation;
import ome.xml.model.MapAnnotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.TagAnnotation;
import ome.xml.model.TermAnnotation;
import ome.xml.model.TimestampAnnotation;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StructuredAnnotations
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(StructuredAnnotations.class);
    private List<XMLAnnotation> xmlAnnotations = new ArrayList<XMLAnnotation>();
    private List<FileAnnotation> fileAnnotations = new ArrayList<FileAnnotation>();
    private List<ListAnnotation> listAnnotations = new ArrayList<ListAnnotation>();
    private List<LongAnnotation> longAnnotations = new ArrayList<LongAnnotation>();
    private List<DoubleAnnotation> doubleAnnotations = new ArrayList<DoubleAnnotation>();
    private List<CommentAnnotation> commentAnnotations = new ArrayList<CommentAnnotation>();
    private List<BooleanAnnotation> booleanAnnotations = new ArrayList<BooleanAnnotation>();
    private List<TimestampAnnotation> timestampAnnotations = new ArrayList<TimestampAnnotation>();
    private List<TagAnnotation> tagAnnotations = new ArrayList<TagAnnotation>();
    private List<TermAnnotation> termAnnotations = new ArrayList<TermAnnotation>();
    private List<MapAnnotation> mapAnnotations = new ArrayList<MapAnnotation>();

    public StructuredAnnotations() {
    }

    public StructuredAnnotations(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public StructuredAnnotations(StructuredAnnotations orig) {
        this.xmlAnnotations = orig.xmlAnnotations;
        this.fileAnnotations = orig.fileAnnotations;
        this.listAnnotations = orig.listAnnotations;
        this.longAnnotations = orig.longAnnotations;
        this.doubleAnnotations = orig.doubleAnnotations;
        this.commentAnnotations = orig.commentAnnotations;
        this.booleanAnnotations = orig.booleanAnnotations;
        this.timestampAnnotations = orig.timestampAnnotations;
        this.tagAnnotations = orig.tagAnnotations;
        this.termAnnotations = orig.termAnnotations;
        this.mapAnnotations = orig.mapAnnotations;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"StructuredAnnotations".equals(tagName)) {
            LOGGER.debug("Expecting node name of StructuredAnnotations got {}", (Object)tagName);
        }
        List<Element> XMLAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "XMLAnnotation");
        for (Element XMLAnnotation_element : XMLAnnotation_nodeList) {
            this.addXMLAnnotation(new XMLAnnotation(XMLAnnotation_element, model));
        }
        List<Element> FileAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "FileAnnotation");
        for (Element FileAnnotation_element : FileAnnotation_nodeList) {
            this.addFileAnnotation(new FileAnnotation(FileAnnotation_element, model));
        }
        List<Element> ListAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "ListAnnotation");
        for (Element ListAnnotation_element : ListAnnotation_nodeList) {
            this.addListAnnotation(new ListAnnotation(ListAnnotation_element, model));
        }
        List<Element> LongAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "LongAnnotation");
        for (Element LongAnnotation_element : LongAnnotation_nodeList) {
            this.addLongAnnotation(new LongAnnotation(LongAnnotation_element, model));
        }
        List<Element> DoubleAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "DoubleAnnotation");
        for (Element DoubleAnnotation_element : DoubleAnnotation_nodeList) {
            this.addDoubleAnnotation(new DoubleAnnotation(DoubleAnnotation_element, model));
        }
        List<Element> CommentAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "CommentAnnotation");
        for (Element CommentAnnotation_element : CommentAnnotation_nodeList) {
            this.addCommentAnnotation(new CommentAnnotation(CommentAnnotation_element, model));
        }
        List<Element> BooleanAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "BooleanAnnotation");
        for (Element BooleanAnnotation_element : BooleanAnnotation_nodeList) {
            this.addBooleanAnnotation(new BooleanAnnotation(BooleanAnnotation_element, model));
        }
        List<Element> TimestampAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "TimestampAnnotation");
        for (Element TimestampAnnotation_element : TimestampAnnotation_nodeList) {
            this.addTimestampAnnotation(new TimestampAnnotation(TimestampAnnotation_element, model));
        }
        List<Element> TagAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "TagAnnotation");
        for (Element TagAnnotation_element : TagAnnotation_nodeList) {
            this.addTagAnnotation(new TagAnnotation(TagAnnotation_element, model));
        }
        List<Element> TermAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "TermAnnotation");
        for (Element TermAnnotation_element : TermAnnotation_nodeList) {
            this.addTermAnnotation(new TermAnnotation(TermAnnotation_element, model));
        }
        List<Element> MapAnnotation_nodeList = StructuredAnnotations.getChildrenByTagName(element, "MapAnnotation");
        for (Element MapAnnotation_element : MapAnnotation_nodeList) {
            this.addMapAnnotation(new MapAnnotation(MapAnnotation_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public int sizeOfXMLAnnotationList() {
        return this.xmlAnnotations.size();
    }

    public List<XMLAnnotation> copyXMLAnnotationList() {
        return new ArrayList<XMLAnnotation>(this.xmlAnnotations);
    }

    public XMLAnnotation getXMLAnnotation(int index) {
        return this.xmlAnnotations.get(index);
    }

    public XMLAnnotation setXMLAnnotation(int index, XMLAnnotation xmlAnnotation) {
        xmlAnnotation.setStructuredAnnotations(this);
        return this.xmlAnnotations.set(index, xmlAnnotation);
    }

    public void addXMLAnnotation(XMLAnnotation xmlAnnotation) {
        xmlAnnotation.setStructuredAnnotations(this);
        this.xmlAnnotations.add(xmlAnnotation);
    }

    public void removeXMLAnnotation(XMLAnnotation xmlAnnotation) {
        this.xmlAnnotations.remove(xmlAnnotation);
    }

    public int sizeOfFileAnnotationList() {
        return this.fileAnnotations.size();
    }

    public List<FileAnnotation> copyFileAnnotationList() {
        return new ArrayList<FileAnnotation>(this.fileAnnotations);
    }

    public FileAnnotation getFileAnnotation(int index) {
        return this.fileAnnotations.get(index);
    }

    public FileAnnotation setFileAnnotation(int index, FileAnnotation fileAnnotation) {
        fileAnnotation.setStructuredAnnotations(this);
        return this.fileAnnotations.set(index, fileAnnotation);
    }

    public void addFileAnnotation(FileAnnotation fileAnnotation) {
        fileAnnotation.setStructuredAnnotations(this);
        this.fileAnnotations.add(fileAnnotation);
    }

    public void removeFileAnnotation(FileAnnotation fileAnnotation) {
        this.fileAnnotations.remove(fileAnnotation);
    }

    public int sizeOfListAnnotationList() {
        return this.listAnnotations.size();
    }

    public List<ListAnnotation> copyListAnnotationList() {
        return new ArrayList<ListAnnotation>(this.listAnnotations);
    }

    public ListAnnotation getListAnnotation(int index) {
        return this.listAnnotations.get(index);
    }

    public ListAnnotation setListAnnotation(int index, ListAnnotation listAnnotation) {
        listAnnotation.setStructuredAnnotations(this);
        return this.listAnnotations.set(index, listAnnotation);
    }

    public void addListAnnotation(ListAnnotation listAnnotation) {
        listAnnotation.setStructuredAnnotations(this);
        this.listAnnotations.add(listAnnotation);
    }

    public void removeListAnnotation(ListAnnotation listAnnotation) {
        this.listAnnotations.remove(listAnnotation);
    }

    public int sizeOfLongAnnotationList() {
        return this.longAnnotations.size();
    }

    public List<LongAnnotation> copyLongAnnotationList() {
        return new ArrayList<LongAnnotation>(this.longAnnotations);
    }

    public LongAnnotation getLongAnnotation(int index) {
        return this.longAnnotations.get(index);
    }

    public LongAnnotation setLongAnnotation(int index, LongAnnotation longAnnotation) {
        longAnnotation.setStructuredAnnotations(this);
        return this.longAnnotations.set(index, longAnnotation);
    }

    public void addLongAnnotation(LongAnnotation longAnnotation) {
        longAnnotation.setStructuredAnnotations(this);
        this.longAnnotations.add(longAnnotation);
    }

    public void removeLongAnnotation(LongAnnotation longAnnotation) {
        this.longAnnotations.remove(longAnnotation);
    }

    public int sizeOfDoubleAnnotationList() {
        return this.doubleAnnotations.size();
    }

    public List<DoubleAnnotation> copyDoubleAnnotationList() {
        return new ArrayList<DoubleAnnotation>(this.doubleAnnotations);
    }

    public DoubleAnnotation getDoubleAnnotation(int index) {
        return this.doubleAnnotations.get(index);
    }

    public DoubleAnnotation setDoubleAnnotation(int index, DoubleAnnotation doubleAnnotation) {
        doubleAnnotation.setStructuredAnnotations(this);
        return this.doubleAnnotations.set(index, doubleAnnotation);
    }

    public void addDoubleAnnotation(DoubleAnnotation doubleAnnotation) {
        doubleAnnotation.setStructuredAnnotations(this);
        this.doubleAnnotations.add(doubleAnnotation);
    }

    public void removeDoubleAnnotation(DoubleAnnotation doubleAnnotation) {
        this.doubleAnnotations.remove(doubleAnnotation);
    }

    public int sizeOfCommentAnnotationList() {
        return this.commentAnnotations.size();
    }

    public List<CommentAnnotation> copyCommentAnnotationList() {
        return new ArrayList<CommentAnnotation>(this.commentAnnotations);
    }

    public CommentAnnotation getCommentAnnotation(int index) {
        return this.commentAnnotations.get(index);
    }

    public CommentAnnotation setCommentAnnotation(int index, CommentAnnotation commentAnnotation) {
        commentAnnotation.setStructuredAnnotations(this);
        return this.commentAnnotations.set(index, commentAnnotation);
    }

    public void addCommentAnnotation(CommentAnnotation commentAnnotation) {
        commentAnnotation.setStructuredAnnotations(this);
        this.commentAnnotations.add(commentAnnotation);
    }

    public void removeCommentAnnotation(CommentAnnotation commentAnnotation) {
        this.commentAnnotations.remove(commentAnnotation);
    }

    public int sizeOfBooleanAnnotationList() {
        return this.booleanAnnotations.size();
    }

    public List<BooleanAnnotation> copyBooleanAnnotationList() {
        return new ArrayList<BooleanAnnotation>(this.booleanAnnotations);
    }

    public BooleanAnnotation getBooleanAnnotation(int index) {
        return this.booleanAnnotations.get(index);
    }

    public BooleanAnnotation setBooleanAnnotation(int index, BooleanAnnotation booleanAnnotation) {
        booleanAnnotation.setStructuredAnnotations(this);
        return this.booleanAnnotations.set(index, booleanAnnotation);
    }

    public void addBooleanAnnotation(BooleanAnnotation booleanAnnotation) {
        booleanAnnotation.setStructuredAnnotations(this);
        this.booleanAnnotations.add(booleanAnnotation);
    }

    public void removeBooleanAnnotation(BooleanAnnotation booleanAnnotation) {
        this.booleanAnnotations.remove(booleanAnnotation);
    }

    public int sizeOfTimestampAnnotationList() {
        return this.timestampAnnotations.size();
    }

    public List<TimestampAnnotation> copyTimestampAnnotationList() {
        return new ArrayList<TimestampAnnotation>(this.timestampAnnotations);
    }

    public TimestampAnnotation getTimestampAnnotation(int index) {
        return this.timestampAnnotations.get(index);
    }

    public TimestampAnnotation setTimestampAnnotation(int index, TimestampAnnotation timestampAnnotation) {
        timestampAnnotation.setStructuredAnnotations(this);
        return this.timestampAnnotations.set(index, timestampAnnotation);
    }

    public void addTimestampAnnotation(TimestampAnnotation timestampAnnotation) {
        timestampAnnotation.setStructuredAnnotations(this);
        this.timestampAnnotations.add(timestampAnnotation);
    }

    public void removeTimestampAnnotation(TimestampAnnotation timestampAnnotation) {
        this.timestampAnnotations.remove(timestampAnnotation);
    }

    public int sizeOfTagAnnotationList() {
        return this.tagAnnotations.size();
    }

    public List<TagAnnotation> copyTagAnnotationList() {
        return new ArrayList<TagAnnotation>(this.tagAnnotations);
    }

    public TagAnnotation getTagAnnotation(int index) {
        return this.tagAnnotations.get(index);
    }

    public TagAnnotation setTagAnnotation(int index, TagAnnotation tagAnnotation) {
        tagAnnotation.setStructuredAnnotations(this);
        return this.tagAnnotations.set(index, tagAnnotation);
    }

    public void addTagAnnotation(TagAnnotation tagAnnotation) {
        tagAnnotation.setStructuredAnnotations(this);
        this.tagAnnotations.add(tagAnnotation);
    }

    public void removeTagAnnotation(TagAnnotation tagAnnotation) {
        this.tagAnnotations.remove(tagAnnotation);
    }

    public int sizeOfTermAnnotationList() {
        return this.termAnnotations.size();
    }

    public List<TermAnnotation> copyTermAnnotationList() {
        return new ArrayList<TermAnnotation>(this.termAnnotations);
    }

    public TermAnnotation getTermAnnotation(int index) {
        return this.termAnnotations.get(index);
    }

    public TermAnnotation setTermAnnotation(int index, TermAnnotation termAnnotation) {
        termAnnotation.setStructuredAnnotations(this);
        return this.termAnnotations.set(index, termAnnotation);
    }

    public void addTermAnnotation(TermAnnotation termAnnotation) {
        termAnnotation.setStructuredAnnotations(this);
        this.termAnnotations.add(termAnnotation);
    }

    public void removeTermAnnotation(TermAnnotation termAnnotation) {
        this.termAnnotations.remove(termAnnotation);
    }

    public int sizeOfMapAnnotationList() {
        return this.mapAnnotations.size();
    }

    public List<MapAnnotation> copyMapAnnotationList() {
        return new ArrayList<MapAnnotation>(this.mapAnnotations);
    }

    public MapAnnotation getMapAnnotation(int index) {
        return this.mapAnnotations.get(index);
    }

    public MapAnnotation setMapAnnotation(int index, MapAnnotation mapAnnotation) {
        mapAnnotation.setStructuredAnnotations(this);
        return this.mapAnnotations.set(index, mapAnnotation);
    }

    public void addMapAnnotation(MapAnnotation mapAnnotation) {
        mapAnnotation.setStructuredAnnotations(this);
        this.mapAnnotations.add(mapAnnotation);
    }

    public void removeMapAnnotation(MapAnnotation mapAnnotation) {
        this.mapAnnotations.remove(mapAnnotation);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element StructuredAnnotations_element) {
        if (StructuredAnnotations_element == null) {
            StructuredAnnotations_element = document.createElementNS(NAMESPACE, "StructuredAnnotations");
        }
        if (this.xmlAnnotations != null) {
            for (XMLAnnotation xmlAnnotations_value : this.xmlAnnotations) {
                StructuredAnnotations_element.appendChild(xmlAnnotations_value.asXMLElement(document));
            }
        }
        if (this.fileAnnotations != null) {
            for (FileAnnotation fileAnnotations_value : this.fileAnnotations) {
                StructuredAnnotations_element.appendChild(fileAnnotations_value.asXMLElement(document));
            }
        }
        if (this.listAnnotations != null) {
            for (ListAnnotation listAnnotations_value : this.listAnnotations) {
                StructuredAnnotations_element.appendChild(listAnnotations_value.asXMLElement(document));
            }
        }
        if (this.longAnnotations != null) {
            for (LongAnnotation longAnnotations_value : this.longAnnotations) {
                StructuredAnnotations_element.appendChild(longAnnotations_value.asXMLElement(document));
            }
        }
        if (this.doubleAnnotations != null) {
            for (DoubleAnnotation doubleAnnotations_value : this.doubleAnnotations) {
                StructuredAnnotations_element.appendChild(doubleAnnotations_value.asXMLElement(document));
            }
        }
        if (this.commentAnnotations != null) {
            for (CommentAnnotation commentAnnotations_value : this.commentAnnotations) {
                StructuredAnnotations_element.appendChild(commentAnnotations_value.asXMLElement(document));
            }
        }
        if (this.booleanAnnotations != null) {
            for (BooleanAnnotation booleanAnnotations_value : this.booleanAnnotations) {
                StructuredAnnotations_element.appendChild(booleanAnnotations_value.asXMLElement(document));
            }
        }
        if (this.timestampAnnotations != null) {
            for (TimestampAnnotation timestampAnnotations_value : this.timestampAnnotations) {
                StructuredAnnotations_element.appendChild(timestampAnnotations_value.asXMLElement(document));
            }
        }
        if (this.tagAnnotations != null) {
            for (TagAnnotation tagAnnotations_value : this.tagAnnotations) {
                StructuredAnnotations_element.appendChild(tagAnnotations_value.asXMLElement(document));
            }
        }
        if (this.termAnnotations != null) {
            for (TermAnnotation termAnnotations_value : this.termAnnotations) {
                StructuredAnnotations_element.appendChild(termAnnotations_value.asXMLElement(document));
            }
        }
        if (this.mapAnnotations != null) {
            for (MapAnnotation mapAnnotations_value : this.mapAnnotations) {
                StructuredAnnotations_element.appendChild(mapAnnotations_value.asXMLElement(document));
            }
        }
        return super.asXMLElement(document, StructuredAnnotations_element);
    }
}

