/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FlowSightReader
extends FormatReader {
    private static final int CHANNEL_COUNT_TAG = 33000;
    private static final int ACQUISITION_TIME_TAG = 33004;
    private static final int CHANNEL_NAMES_TAG = 33007;
    private static final int CHANNEL_DESCS_TAG = 33008;
    private static final int METADATA_XML_TAG = 33027;
    private static final int GREYSCALE_COMPRESSION = 30817;
    private static final int BITMASK_COMPRESSION = 30818;
    private static final int[] MINIMAL_TAGS = new int[]{33027};
    private transient TiffParser tiffParser;
    private long[] ifdOffsets;
    private String[] channelNames;
    private String[] channelDescs;

    public FlowSightReader() {
        super("FlowSight", "cif");
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tiffParser = new TiffParser(stream);
        if (!tiffParser.isValidHeader()) {
            return false;
        }
        IFD ifd = tiffParser.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        tiffParser.fillInIFD(ifd);
        for (int tag : MINIMAL_TAGS) {
            try {
                if (ifd.getIFDStringValue(tag) != null) continue;
                return false;
            }
            catch (FormatException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        String channelDescsString;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.tiffParser = new TiffParser(this.in);
        this.tiffParser.setDoCaching(false);
        this.tiffParser.setUse64BitOffsets(false);
        Boolean littleEndian = this.tiffParser.checkHeader();
        if (littleEndian == null) {
            throw new FormatException("Invalid FlowSight file");
        }
        boolean little = littleEndian;
        this.in.order(little);
        LOGGER.info("Reading IFDs");
        this.ifdOffsets = this.tiffParser.getIFDOffsets();
        if (this.ifdOffsets.length < 2) {
            throw new FormatException("No IFDs found");
        }
        LOGGER.info("Populating metadata");
        IFD ifd0 = this.tiffParser.getFirstIFD();
        this.tiffParser.fillInIFD(ifd0);
        int channelCount = ifd0.getIFDIntValue(33000, 1);
        String channelNamesString = ifd0.getIFDStringValue(33007);
        if (channelNamesString != null) {
            this.channelNames = channelNamesString.split("\\|");
            if (this.channelNames.length != channelCount) {
                throw new FormatException(String.format("Channel count (%d) does not match number of channel names (%d) in string \"%s\"", channelCount, this.channelNames.length, channelNamesString));
            }
            LOGGER.debug("Found {} channels: {}", (Object)channelCount, (Object)channelNamesString.replace('|', ','));
        }
        if ((channelDescsString = ifd0.getIFDStringValue(33008)) != null) {
            this.channelDescs = channelDescsString.split("\\|");
            if (this.channelDescs.length != channelCount) {
                throw new FormatException(String.format("Channel count (%d) does not match number of channel descriptions (%d) in string \"%s\"", channelCount, this.channelDescs.length, channelDescsString));
            }
        }
        String xml = ifd0.getIFDTextValue(33027);
        xml = XMLTools.sanitizeXML(xml);
        try {
            Element xmlRoot = XMLTools.parseDOM(xml).getDocumentElement();
            NodeList imagingNodes = xmlRoot.getElementsByTagName("Imaging");
            if (imagingNodes.getLength() > 0) {
                Element imagingNode = (Element)imagingNodes.item(0);
                NodeList children = imagingNode.getChildNodes();
                for (int child = 0; child < children.getLength(); ++child) {
                    String[] tokens;
                    Node childNode = children.item(child);
                    String name = childNode.getNodeName();
                    if (!name.startsWith("ChannelInUseIndicators")) continue;
                    channelCount = 0;
                    String text = childNode.getTextContent();
                    for (String token : tokens = text.split(" ")) {
                        if (!token.equals("1")) continue;
                        ++channelCount;
                    }
                }
            }
        }
        catch (ParserConfigurationException e) {
            LOGGER.debug("Could not parse XML", e);
        }
        catch (SAXException e) {
            LOGGER.debug("Could not parse XML", e);
        }
        for (int idxOff = 1; idxOff < this.ifdOffsets.length; ++idxOff) {
            long offset = this.ifdOffsets[idxOff];
            boolean first = idxOff == 1;
            IFD ifd = this.tiffParser.getIFD(offset);
            this.tiffParser.fillInIFD(ifd);
            CoreMetadata ms = first ? (CoreMetadata)this.core.get(0) : new CoreMetadata();
            ms.rgb = false;
            ms.interleaved = false;
            ms.littleEndian = ifd0.isLittleEndian();
            ms.sizeX = (int)ifd.getImageWidth() / channelCount;
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = 1;
            ms.sizeC = channelCount;
            ms.sizeT = 1;
            ms.indexed = false;
            ms.dimensionOrder = "XYCZT";
            ms.bitsPerPixel = ifd.getIFDIntValue(258);
            ms.pixelType = ms.bitsPerPixel == 8 ? 1 : 3;
            ms.imageCount = channelCount;
            ms.resolutionCount = 1;
            ms.thumbnail = false;
            ms.metadataComplete = true;
            if (first) continue;
            this.core.add(ms);
        }
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels(store, this);
        if (this.channelNames != null && this.channelDescs != null) {
            String[] maskDescs = new String[channelCount];
            for (int i = 0; i < channelCount; ++i) {
                maskDescs[i] = this.channelDescs[i] + " Mask";
            }
            for (int series = 0; series < this.ifdOffsets.length - 1; ++series) {
                boolean isMask = ((CoreMetadata)this.core.get((int)series)).pixelType == 1;
                String[] descs = isMask ? maskDescs : this.channelDescs;
                for (int channel = 0; channel < channelCount; ++channel) {
                    store.setChannelName(descs[channel], series, channel);
                    String cid = MetadataTools.createLSID("Channel", series, channel) + ":";
                    store.setChannelID(cid + this.channelNames[channel], series, channel);
                }
            }
        }
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.tiffParser = null;
        this.ifdOffsets = null;
        this.channelNames = null;
        this.channelDescs = null;
    }

    @Override
    public void reopenFile() throws IOException {
        super.reopenFile();
        this.tiffParser = new TiffParser(this.in);
        this.tiffParser.setDoCaching(false);
        this.tiffParser.setUse64BitOffsets(false);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] tempBuffer;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int idx = this.getSeries() + 1;
        IFD ifd = this.tiffParser.getIFD(this.ifdOffsets[idx]);
        int imageWidth = (int)ifd.getImageWidth();
        int imageHeight = (int)ifd.getImageLength();
        int wOff = x + no * imageWidth / this.getSizeC();
        if (x + w > imageWidth / this.getSizeC()) {
            throw new FormatException("Requested tile dimensions extend beyond those of the image.");
        }
        int compression = ifd.getIFDIntValue(259);
        switch (compression) {
            case 30817: {
                tempBuffer = this.openGreyscaleBytes(ifd, imageWidth, imageHeight);
                break;
            }
            case 30818: {
                tempBuffer = this.openBitmaskBytes(ifd, imageWidth, imageHeight);
                break;
            }
            default: {
                throw new FormatException(String.format("Unknown compression code: %d", compression));
            }
        }
        int bytesPerSample = ifd.getIFDIntValue(258) / 8;
        for (int yy = y; yy < y + h; ++yy) {
            int srcOff = bytesPerSample * (wOff + yy * imageWidth);
            int destOff = bytesPerSample * (yy - y) * w;
            System.arraycopy(tempBuffer, srcOff, buf, destOff, w * bytesPerSample);
        }
        return buf;
    }

    private byte[] openBitmaskBytes(IFD ifd, int imageWidth, int imageHeight) throws FormatException {
        byte[] uncompressed = new byte[imageWidth * imageHeight];
        long[] stripByteCounts = ifd.getIFDLongArray(279);
        long[] stripOffsets = ifd.getIFDLongArray(273);
        int off = 0;
        for (int i = 0; i < stripByteCounts.length; ++i) {
            try {
                this.in.seek(stripOffsets[i]);
                int j = 0;
                while ((long)j < stripByteCounts[i]) {
                    byte value = this.in.readByte();
                    int runLength = (this.in.readByte() & 0xFF) + 1;
                    if (off + runLength > uncompressed.length) {
                        throw new FormatException("Unexpected buffer overrun encountered when decompressing bitmask data");
                    }
                    Arrays.fill(uncompressed, off, off + runLength, value);
                    off += runLength;
                    j += 2;
                }
                continue;
            }
            catch (IOException e) {
                LOGGER.error("Caught exception while reading bitmask IFD data", e);
                throw new FormatException(String.format("Error in FlowSight file format: %s", e.getMessage()));
            }
        }
        if (off != uncompressed.length) {
            throw new FormatException("Buffer shortfall encountered when decompressing bitmask data");
        }
        return uncompressed;
    }

    private byte[] openGreyscaleBytes(IFD ifd, int imageWidth, int imageHeight) throws FormatException {
        final FormatException[] formatException = new FormatException[1];
        final long[] stripByteCounts = ifd.getIFDLongArray(279);
        final long[] stripOffsets = ifd.getIFDLongArray(273);
        Iterator<Short> diffs = new Iterator<Short>(){
            int index = -1;
            int offset = 0;
            int count = 0;
            byte currentByte;
            int nibbleIdx = 2;
            short value = 0;
            short shift = 0;
            boolean bHasNext;
            boolean loaded = this.bHasNext = formatException[0] != null;

            @Override
            public boolean hasNext() {
                if (this.loaded) {
                    return this.bHasNext;
                }
                this.shift = 0;
                this.value = 0;
                while (!this.loaded) {
                    try {
                        byte nibble = this.getNextNibble();
                        this.value = (short)(this.value + ((short)(nibble & 7) << this.shift));
                        this.shift = (short)(this.shift + 3);
                        if ((nibble & 8) != 0) continue;
                        this.loaded = true;
                        this.bHasNext = true;
                        if ((nibble & 4) == 0) continue;
                        this.value = (short)(this.value | -(1 << this.shift));
                    }
                    catch (IOException e) {
                        LOGGER.error("IOException during read of greyscale image", e);
                        formatException[0] = new FormatException(String.format("Error in FlowSight format: %s", e.getMessage()));
                        this.loaded = true;
                        this.bHasNext = false;
                    }
                    catch (FormatException e) {
                        LOGGER.error("Format exception during read of greyscale image", e);
                        formatException[0] = e;
                        this.loaded = true;
                        this.bHasNext = false;
                    }
                }
                return this.bHasNext;
            }

            private byte getNextNibble() throws IOException, FormatException {
                if (this.nibbleIdx >= 2) {
                    if (!this.getNextByte()) {
                        return -1;
                    }
                    this.nibbleIdx = 0;
                }
                if (this.nibbleIdx++ == 0) {
                    return (byte)(this.currentByte & 0xF);
                }
                return (byte)(this.currentByte >> 4);
            }

            private boolean getNextByte() throws IOException, FormatException {
                while (this.offset == this.count) {
                    ++this.index;
                    if (this.index == stripByteCounts.length) {
                        this.loaded = true;
                        this.bHasNext = false;
                        return false;
                    }
                    FlowSightReader.this.in.seek(stripOffsets[this.index]);
                    this.offset = 0;
                    this.count = (int)stripByteCounts[this.index];
                }
                this.currentByte = FlowSightReader.this.in.readByte();
                ++this.offset;
                return true;
            }

            @Override
            public Short next() {
                if (!this.hasNext()) {
                    throw new IndexOutOfBoundsException("Tried to read past end of IFD data");
                }
                this.loaded = false;
                return this.value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        byte[] buffer = new byte[imageWidth * imageHeight * 2];
        short[] lastRow = new short[imageWidth];
        short[] thisRow = new short[imageWidth];
        int index = 0;
        for (int y = 0; y < imageHeight; ++y) {
            for (int x = 0; x < imageWidth; ++x) {
                thisRow[x] = x != 0 ? (short)((Short)diffs.next() + lastRow[x] + thisRow[x - 1] - lastRow[x - 1]) : (short)((Short)diffs.next() + lastRow[x]);
                DataTools.unpackBytes(thisRow[x], buffer, index, 2, this.in.isLittleEndian());
                index += 2;
            }
            short[] temp = lastRow;
            lastRow = thisRow;
            thisRow = temp;
        }
        return buffer;
    }
}

