/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.IJ;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import java.io.IOException;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.ReaderWrapper;
import loci.plugins.BF;
import loci.plugins.util.LociPrefs;

public class ImageProcessorReader
extends ReaderWrapper {
    public static ImageProcessorReader makeImageProcessorReader(IFormatReader r) {
        if (r instanceof ImageProcessorReader) {
            return (ImageProcessorReader)r;
        }
        return new ImageProcessorReader(r);
    }

    public ImageProcessorReader() {
        super(LociPrefs.makeImageReader());
    }

    public ImageProcessorReader(IFormatReader r) {
        super(r);
    }

    public ImageProcessor[] openProcessors(int no) throws FormatException, IOException {
        return this.openProcessors(no, 0, 0, this.getSizeX(), this.getSizeY());
    }

    public ImageProcessor[] openThumbProcessors(int no) throws FormatException, IOException {
        int h;
        byte[] b = this.openThumbBytes(no);
        int c = this.getRGBChannelCount();
        int type = this.getPixelType();
        int bpp = FormatTools.getBytesPerPixel(type);
        boolean interleave = this.isInterleaved();
        int w = this.getThumbSizeX();
        if (b.length != w * (h = this.getThumbSizeY()) * c * bpp && b.length != w * h * bpp) {
            throw new FormatException("Invalid byte array length: " + b.length + " (expected w=" + w + ", h=" + h + ", c=" + c + ", bpp=" + bpp + ")");
        }
        LUT cm = this.createColorModel();
        boolean isFloat = FormatTools.isFloatingPoint(type);
        boolean isLittle = this.isLittleEndian();
        boolean isSigned = FormatTools.isSigned(type);
        ImageProcessor[] ip = new ImageProcessor[c];
        for (int i = 0; i < c; ++i) {
            Object[] tmp;
            Object[] q;
            byte[] channel = ImageTools.splitChannels(b, i, c, bpp, false, interleave);
            Object pixels = DataTools.makeDataArray(channel, bpp, isFloat, isLittle);
            if (pixels instanceof byte[]) {
                q = (byte[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new byte[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                if (isSigned) {
                    q = DataTools.makeSigned(q);
                }
                ip[i] = new ByteProcessor(w, h, q, null);
                if (cm == null) continue;
                ip[i].setColorModel((ColorModel)cm);
                continue;
            }
            if (pixels instanceof short[]) {
                q = (short[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new short[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                if (isSigned) {
                    q = DataTools.makeSigned((short[])q);
                }
                ip[i] = new ShortProcessor(w, h, (short[])q, (ColorModel)cm);
                continue;
            }
            if (pixels instanceof int[]) {
                q = (int[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new int[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                ip[i] = new FloatProcessor(w, h, (int[])q);
                continue;
            }
            if (pixels instanceof float[]) {
                q = (float[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new float[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                ip[i] = new FloatProcessor(w, h, (float[])q, null);
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            q = (double[])pixels;
            if (q.length != w * h) {
                tmp = q;
                q = new double[w * h];
                System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
            }
            ip[i] = new FloatProcessor(w, h, (double[])q);
        }
        return ip;
    }

    public ImageProcessor[] openProcessors(int no, int x, int y, int w, int h) throws FormatException, IOException {
        byte[] b = this.openBytes(no, x, y, w, h);
        int c = this.getRGBChannelCount();
        int type = this.getPixelType();
        int bpp = FormatTools.getBytesPerPixel(type);
        boolean interleave = this.isInterleaved();
        if (b.length != w * h * c * bpp && b.length != w * h * bpp) {
            throw new FormatException("Invalid byte array length: " + b.length + " (expected w=" + w + ", h=" + h + ", c=" + c + ", bpp=" + bpp + ")");
        }
        LUT cm = this.createColorModel();
        boolean isFloat = FormatTools.isFloatingPoint(type);
        boolean isLittle = this.isLittleEndian();
        boolean isSigned = FormatTools.isSigned(type);
        ImageProcessor[] ip = new ImageProcessor[c];
        for (int i = 0; i < c; ++i) {
            Object[] tmp;
            Object[] q;
            byte[] channel = ImageTools.splitChannels(b, i, c, bpp, false, interleave);
            Object pixels = DataTools.makeDataArray(channel, bpp, isFloat, isLittle);
            if (pixels instanceof byte[]) {
                q = (byte[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new byte[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                if (isSigned) {
                    q = DataTools.makeSigned(q);
                }
                ip[i] = new ByteProcessor(w, h, q, null);
                if (cm == null) continue;
                ip[i].setColorModel((ColorModel)cm);
                continue;
            }
            if (pixels instanceof short[]) {
                q = (short[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new short[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                if (isSigned) {
                    q = DataTools.makeSigned((short[])q);
                }
                ip[i] = new ShortProcessor(w, h, (short[])q, (ColorModel)cm);
                continue;
            }
            if (pixels instanceof int[]) {
                q = (int[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new int[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                ip[i] = new FloatProcessor(w, h, (int[])q);
                continue;
            }
            if (pixels instanceof float[]) {
                q = (float[])pixels;
                if (q.length != w * h) {
                    tmp = q;
                    q = new float[w * h];
                    System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
                }
                ip[i] = new FloatProcessor(w, h, (float[])q, null);
                continue;
            }
            if (!(pixels instanceof double[])) continue;
            q = (double[])pixels;
            if (q.length != w * h) {
                tmp = q;
                q = new double[w * h];
                System.arraycopy(tmp, 0, q, 0, Math.min(q.length, tmp.length));
            }
            ip[i] = new FloatProcessor(w, h, (double[])q);
        }
        return ip;
    }

    @Override
    public Class<?> getNativeDataType() {
        return ImageProcessor[].class;
    }

    @Override
    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.openProcessors(no, x, y, w, h);
    }

    private LUT createColorModel() throws FormatException, IOException {
        byte[][] byteTable = this.get8BitLookupTable();
        if (byteTable == null) {
            byteTable = this.convertTo8Bit(this.get16BitLookupTable());
        }
        if (byteTable == null || byteTable.length == 0) {
            return null;
        }
        int colors = byteTable.length;
        int samples = byteTable[0].length;
        byte[] r = colors >= 1 ? byteTable[0] : new byte[samples];
        byte[] g = colors >= 2 ? byteTable[1] : new byte[samples];
        byte[] b = colors >= 3 ? byteTable[2] : new byte[samples];
        return new LUT(8, samples, r, g, b);
    }

    private byte[][] convertTo8Bit(short[][] shortTable) {
        if (shortTable == null) {
            return null;
        }
        byte[][] byteTable = new byte[shortTable.length][256];
        double max = Math.pow(2.0, this.getBitsPerPixel()) - 1.0;
        for (int c = 0; c < byteTable.length; ++c) {
            int len = Math.min(byteTable[c].length, shortTable[c].length);
            int valuesPerBin = shortTable[c].length / byteTable[c].length;
            int adjustPerBin = (int)((max + 1.0) / (double)byteTable[c].length);
            for (int i = 0; i < len; ++i) {
                double average = 0.0;
                for (int p = 0; p < valuesPerBin; ++p) {
                    int index = i * valuesPerBin + p;
                    int value = 0xFFFF & shortTable[c][index];
                    average += (double)value;
                }
                if ((average /= (double)adjustPerBin) > max) {
                    average = (int)Math.min(max, average / (double)valuesPerBin);
                }
                byteTable[c][i] = (byte)(255.0 * (average / max));
            }
        }
        if (IJ.debugMode) {
            int j;
            int i;
            StringBuilder sb = new StringBuilder();
            BF.debug("Downsampled 16-bit LUT to 8-bit:");
            BF.debug("shortTable = {");
            for (i = 0; i < shortTable.length; ++i) {
                sb.setLength(0);
                sb.append("\t{");
                for (j = 0; j < shortTable[i].length; ++j) {
                    sb.append(" ");
                    sb.append(shortTable[i][j]);
                }
                sb.append(" }");
                BF.debug(sb.toString());
            }
            BF.debug("}");
            BF.debug("byteTable = {");
            for (i = 0; i < byteTable.length; ++i) {
                sb.setLength(0);
                sb.append("\t{");
                for (j = 0; j < byteTable[i].length; ++j) {
                    sb.append(" ");
                    sb.append(byteTable[i][j]);
                }
                sb.append(" }");
                BF.debug(sb.toString());
            }
            BF.debug("}");
        }
        return byteTable;
    }
}

