/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinaryOnly
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryOnly.class);
    private String metadataFile;
    private String uuid;

    public BinaryOnly() {
    }

    public BinaryOnly(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public BinaryOnly(BinaryOnly orig) {
        this.metadataFile = orig.metadataFile;
        this.uuid = orig.uuid;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"BinaryOnly".equals(tagName)) {
            LOGGER.debug("Expecting node name of BinaryOnly got {}", (Object)tagName);
        }
        if (element.hasAttribute("MetadataFile")) {
            this.setMetadataFile(String.valueOf(element.getAttribute("MetadataFile")));
        }
        if (element.hasAttribute("UUID")) {
            this.setUUID(String.valueOf(element.getAttribute("UUID")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getMetadataFile() {
        return this.metadataFile;
    }

    public void setMetadataFile(String metadataFile) {
        this.metadataFile = metadataFile;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element BinaryOnly_element) {
        if (BinaryOnly_element == null) {
            BinaryOnly_element = document.createElementNS(NAMESPACE, "BinaryOnly");
        }
        if (this.metadataFile != null) {
            BinaryOnly_element.setAttribute("MetadataFile", this.metadataFile.toString());
        }
        if (this.uuid != null) {
            BinaryOnly_element.setAttribute("UUID", this.uuid.toString());
        }
        return super.asXMLElement(document, BinaryOnly_element);
    }
}

