/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.MapPair;
import ome.xml.model.MapPairs;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TextAnnotation;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapAnnotation
extends TextAnnotation {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/SA/2015-01";
    private static final Logger LOGGER = LoggerFactory.getLogger(MapAnnotation.class);
    private MapPairs value;
    private StructuredAnnotations structuredAnnotations;

    public MapAnnotation() {
    }

    public MapAnnotation(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public MapAnnotation(MapAnnotation orig) {
        super(orig);
        this.value = orig.value;
        this.structuredAnnotations = orig.structuredAnnotations;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Value_nodeList;
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"MapAnnotation".equals(tagName)) {
            LOGGER.debug("Expecting node name of MapAnnotation got {}", (Object)tagName);
        }
        if ((Value_nodeList = MapAnnotation.getChildrenByTagName(element, "Value")).size() > 1) {
            throw new RuntimeException(String.format("Value node list size %d != 1", Value_nodeList.size()));
        }
        if (Value_nodeList.size() != 0) {
            try {
                ArrayList<MapPair> pairs = new ArrayList<MapPair>();
                NodeList children = Value_nodeList.get(0).getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() != 1) continue;
                    pairs.add(new MapPair(((Element)child).getAttribute("K"), child.getTextContent()));
                }
                MapPairs mapPairs = new MapPairs(pairs);
                this.setValue(mapPairs);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public MapPairs getValue() {
        return this.value;
    }

    public void setValue(MapPairs value) {
        this.value = value;
    }

    public StructuredAnnotations getStructuredAnnotations() {
        return this.structuredAnnotations;
    }

    public void setStructuredAnnotations(StructuredAnnotations structuredAnnotations_BackReference) {
        this.structuredAnnotations = structuredAnnotations_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element MapAnnotation_element) {
        if (MapAnnotation_element == null) {
            MapAnnotation_element = document.createElementNS(NAMESPACE, "MapAnnotation");
        }
        MapAnnotation_element = super.asXMLElement(document, MapAnnotation_element);
        if (this.value != null) {
            MapAnnotation_element.appendChild(this.value.asXMLElement(document));
        }
        if (this.structuredAnnotations != null) {
            // empty if block
        }
        return MapAnnotation_element;
    }
}

