/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PixelTypeEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PixelTypeEnumHandler.class);
    private static final Hashtable<String, String> patterns = PixelTypeEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*int8\\s*", "int8");
        p.put("^\\s*int16\\s*", "int16");
        p.put("^\\s*int32\\s*", "int32");
        p.put("^\\s*uint8\\s*", "uint8");
        p.put("^\\s*uint16\\s*", "uint16");
        p.put("^\\s*uint32\\s*", "uint32");
        p.put("^\\s*float\\s*", "float");
        p.put("^\\s*bit\\s*", "bit");
        p.put("^\\s*double\\s*", "double");
        p.put("^\\s*complex\\s*", "complex");
        p.put("^\\s*double-complex\\s*", "double-complex");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return PixelType.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"PixelType", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return PixelType.class;
    }
}

