/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import thredds.inventory.MFile;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.TimeDuration;

public interface CollectionManager {
    public String getCollectionName();

    public String getRoot();

    public boolean isStatic();

    public long getLastScanned();

    public long getLastChanged();

    public TimeDuration getRecheck();

    public boolean isScanNeeded();

    public boolean scanIfNeeded() throws IOException;

    public boolean scan(boolean var1) throws IOException;

    public void updateNocheck() throws IOException;

    public Iterable<MFile> getFiles();

    public void setFiles(Iterable<MFile> var1);

    public CalendarDate extractRunDate(MFile var1);

    public boolean hasDateExtractor();

    public CalendarDate getStartCollection();

    public void close();

    public int getProtoIndex(int var1);

    public long getOlderThanFilterInMSecs();

    public List<String> getFilenames();

    public MFile getLatestFile();

    public void setChangeChecker(ChangeChecker var1);

    public Object getAuxInfo(String var1);

    public void putAuxInfo(String var1, Object var2);

    public void resetProto();

    public void addEventListener(TriggerListener var1);

    public void removeEventListener(TriggerListener var1);

    public static class TriggerEvent
    extends EventObject {
        private final TriggerType type;

        TriggerEvent(Object source, TriggerType type) {
            super(source);
            this.type = type;
        }

        public TriggerType getType() {
            return this.type;
        }

        @Override
        public String toString() {
            return "TriggerEvent{type='" + (Object)((Object)this.type) + '\'' + '}';
        }
    }

    public static enum TriggerType {
        update,
        proto,
        updateNocheck;

    }

    public static interface TriggerListener {
        public void handleCollectionEvent(TriggerEvent var1);
    }

    public static interface ChangeChecker {
        public boolean hasChangedSince(MFile var1, long var2);

        public boolean hasntChangedSince(MFile var1, long var2);
    }

    public static enum Force {
        always,
        test,
        nocheck;

    }
}

