/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import loci.common.DataTools;
import loci.common.HandleException;
import loci.common.StreamHandle;

public class GZipHandle
extends StreamHandle {
    public GZipHandle(String file2) throws IOException {
        int skip;
        this.file = file2;
        if (!GZipHandle.isGZipFile(file2)) {
            throw new HandleException(file2 + " is not a gzip file.");
        }
        this.resetStream();
        this.length = 0L;
        while ((skip = this.stream.skipBytes(1024)) > 0) {
            this.length += (long)skip;
        }
        this.resetStream();
    }

    public static boolean isGZipFile(String file2) throws IOException {
        if (!file2.toLowerCase().endsWith(".gz")) {
            return false;
        }
        FileInputStream s = new FileInputStream(file2);
        byte[] b = new byte[2];
        s.read(b);
        s.close();
        return DataTools.bytesToInt(b, true) == 35615;
    }

    @Override
    protected void resetStream() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.file), 0x100000);
        this.stream = new DataInputStream(new GZIPInputStream(bis));
    }
}

