/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.primitives;

import ome.xml.model.primitives.PrimitiveType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timestamp
extends PrimitiveType<String> {
    public static final String ISO8601_FORMAT_MS = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String ISO8601_FORMAT_S = "yyyy-MM-dd'T'HH:mm:ss";
    public static final DateTimeFormatter ISO8601_PARSER = ISODateTimeFormat.dateTimeParser().withZone(DateTimeZone.UTC);
    public static final DateTimeFormatter ISO8601_FORMATTER_MS = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS");
    public static final DateTimeFormatter ISO8601_FORMATTER_S = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static final Logger LOGGER = LoggerFactory.getLogger(Timestamp.class);
    final Instant timestamp;

    public Timestamp(String value) throws IllegalArgumentException, UnsupportedOperationException {
        this.timestamp = Instant.parse(value, ISO8601_PARSER);
        this.value = this.toString();
    }

    public Timestamp(Instant instant) {
        this.timestamp = new Instant(instant);
        this.value = this.toString();
    }

    public Timestamp(DateTime datetime) {
        this.timestamp = datetime.toInstant();
        this.value = this.toString();
    }

    public static Timestamp valueOf(String value) {
        if (value == null) {
            return null;
        }
        Timestamp t = null;
        try {
            t = new Timestamp(value);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Invalid timestamp '{}'", (Object)value);
        }
        catch (UnsupportedOperationException e) {
            LOGGER.debug("Error parsing timestamp '{}'", (Object)value, (Object)e);
        }
        return t;
    }

    public Instant asInstant() {
        return this.timestamp;
    }

    public DateTime asDateTime(DateTimeZone zone) {
        return new DateTime((Object)this.timestamp, zone);
    }

    @Override
    public String toString() {
        if (this.timestamp == null) {
            return "";
        }
        if (this.timestamp.getMillis() % 1000L != 0L) {
            return ISO8601_FORMATTER_MS.print(this.timestamp);
        }
        return ISO8601_FORMATTER_S.print(this.timestamp);
    }
}

