/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5ReferenceReader;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

public class HDF5ReferenceReader
implements IHDF5ReferenceReader {
    private final HDF5BaseReader baseReader;

    HDF5ReferenceReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public String resolvePath(String reference) {
        assert (reference != null);
        this.baseReader.checkOpen();
        if (reference.charAt(0) != '\u0000') {
            throw new HDF5JavaException(String.format("'%s' is not a reference.", reference));
        }
        return this.baseReader.h5.getReferencedObjectName(this.baseReader.fileId, Long.parseLong(reference.substring(1)));
    }

    private String refToStr(long reference) {
        return String.valueOf('\u0000') + Long.toString(reference);
    }

    private String[] refToStr(long[] references) {
        String[] result = new String[references.length];
        int i = 0;
        while (i < references.length) {
            result[i] = String.valueOf('\u0000') + Long.toString(references[i]);
            ++i;
        }
        return result;
    }

    private void checkReference(int dataTypeId, String objectPath) throws HDF5JavaException {
        boolean isReference;
        boolean bl = isReference = this.baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_REFERENCE;
        if (!isReference) {
            throw new HDF5JavaException("Dataset " + objectPath + " is not a reference.");
        }
    }

    private void checkRank1(int[] arrayDimensions, String objectPath) {
        if (arrayDimensions.length != 1) {
            throw new HDF5JavaException("Dataset " + objectPath + ": array needs to be of rank 1, but is of rank " + arrayDimensions.length);
        }
    }

    private void checkRank1(long[] arrayDimensions, String objectPath) {
        if (arrayDimensions.length != 1) {
            throw new HDF5JavaException("Dataset " + objectPath + ": array needs to be of rank 1, but is of rank " + arrayDimensions.length);
        }
    }

    @Override
    public String getAttr(String objectPath, String attributeName) {
        return this.getAttr(objectPath, attributeName, true);
    }

    @Override
    public String getAttr(final String objectPath, final String attributeName, final boolean resolveName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> readRunnable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                int objectId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openObject(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                int dataTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                HDF5ReferenceReader.this.checkReference(dataTypeId, objectPath);
                long[] reference = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, dataTypeId, 1);
                return resolveName ? ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getReferencedObjectName(attributeId, reference[0]) : HDF5ReferenceReader.this.refToStr(reference[0]);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public String[] getArrayAttr(String objectPath, String attributeName) {
        return this.getArrayAttr(objectPath, attributeName, true);
    }

    @Override
    public String[] getArrayAttr(final String objectPath, final String attributeName, final boolean resolveName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String[]> getAttributeRunnable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                int memoryTypeId;
                int len;
                int objectId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openObject(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                int attributeTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                if (((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                    int baseDataTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getBaseDataType(attributeTypeId, registry);
                    HDF5ReferenceReader.this.checkReference(baseDataTypeId, objectPath);
                    int[] arrayDimensions = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getArrayDimensions(attributeTypeId);
                    HDF5ReferenceReader.this.checkRank1(arrayDimensions, objectPath);
                    len = arrayDimensions[0];
                    memoryTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_STD_REF_OBJ, len, registry);
                } else {
                    HDF5ReferenceReader.this.checkReference(attributeTypeId, objectPath);
                    long[] arrayDimensions = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry);
                    HDF5ReferenceReader.this.checkRank1(arrayDimensions, objectPath);
                    memoryTypeId = HDF5Constants.H5T_STD_REF_OBJ;
                    len = HDF5Utils.getOneDimensionalArraySize(arrayDimensions);
                }
                long[] references = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, memoryTypeId, len);
                return resolveName ? ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getReferencedObjectNames(attributeId, references) : HDF5ReferenceReader.this.refToStr(references);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public MDArray<String> getMDArrayAttr(String objectPath, String attributeName) {
        return this.getMDArrayAttr(objectPath, attributeName, true);
    }

    @Override
    public MDArray<String> getMDArrayAttr(final String objectPath, final String attributeName, final boolean resolveName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDArray<String>> getAttributeRunnable = new ICallableWithCleanUp<MDArray<String>>(){

            @Override
            public MDArray<String> call(ICleanUpRegistry registry) {
                try {
                    int memoryTypeId;
                    int[] arrayDimensions;
                    int objectId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openObject(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, objectPath, registry);
                    int attributeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                    int attributeTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                    if (((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                        int baseDataTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getBaseDataType(attributeTypeId, registry);
                        HDF5ReferenceReader.this.checkReference(baseDataTypeId, objectPath);
                        arrayDimensions = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getArrayDimensions(attributeTypeId);
                        memoryTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_STD_REF_OBJ, arrayDimensions, registry);
                    } else {
                        HDF5ReferenceReader.this.checkReference(attributeTypeId, objectPath);
                        arrayDimensions = MDAbstractArray.toInt(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getDataDimensionsForAttribute(attributeId, registry));
                        memoryTypeId = HDF5Constants.H5T_STD_REF_OBJ;
                    }
                    int len = MDAbstractArray.getLength(arrayDimensions);
                    long[] references = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, memoryTypeId, len);
                    return new MDArray<String>((T[])(resolveName ? ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getReferencedObjectNames(attributeId, references) : HDF5ReferenceReader.this.refToStr(references)), arrayDimensions);
                }
                catch (IllegalArgumentException ex) {
                    throw new HDF5JavaException(ex.getMessage());
                }
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public String read(String objectPath) {
        return this.read(objectPath, true);
    }

    @Override
    public String read(final String objectPath, final boolean resolveName) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> readRunnable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openObject(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, objectPath, registry);
                int objectReferenceDataTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                HDF5ReferenceReader.this.checkReference(objectReferenceDataTypeId, objectPath);
                long[] reference = new long[1];
                ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readDataSet(dataSetId, objectReferenceDataTypeId, reference);
                return resolveName ? ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getReferencedObjectName(dataSetId, reference[0]) : HDF5ReferenceReader.this.refToStr(reference[0]);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public String[] readArray(String objectPath) {
        return this.readArray(objectPath, true);
    }

    @Override
    public String[] readArray(final String objectPath, final boolean resolveName) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String[]> readCallable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                long[] references;
                int dataSetId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openDataSet(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, objectPath, registry);
                int dataTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                if (((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_REFERENCE) {
                    HDF5BaseReader.DataSpaceParameters spaceParams = HDF5ReferenceReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                    HDF5ReferenceReader.this.checkRank1(spaceParams.dimensions, objectPath);
                    references = new long[spaceParams.blockSize];
                    ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readDataSet(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, references);
                } else if (((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_ARRAY && ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getClassType(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getBaseDataType(dataTypeId, registry)) == HDF5Constants.H5T_REFERENCE) {
                    int spaceId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.createScalarDataSpace();
                    int[] dimensions = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getArrayDimensions(dataTypeId);
                    HDF5ReferenceReader.this.checkRank1(dimensions, objectPath);
                    int len = dimensions[0];
                    references = new long[len];
                    int memoryTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_STD_REF_OBJ, len, registry);
                    ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readDataSet(dataSetId, memoryTypeId, spaceId, spaceId, references);
                } else {
                    throw new HDF5JavaException("Dataset " + objectPath + " is not a reference.");
                }
                return resolveName ? ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getReferencedObjectNames(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, references) : HDF5ReferenceReader.this.refToStr(references);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public String[] readArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, blockNumber * (long)blockSize, true);
    }

    @Override
    public String[] readArrayBlock(String objectPath, int blockSize, long blockNumber, boolean resolveName) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, blockNumber * (long)blockSize, resolveName);
    }

    @Override
    public String[] readArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, offset, true);
    }

    @Override
    public String[] readArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset, final boolean resolveName) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String[]> readCallable = new ICallableWithCleanUp<String[]>(){

            @Override
            public String[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openDataSet(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5ReferenceReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                long[] references = new long[spaceParams.blockSize];
                ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_STD_REF_OBJ, spaceParams.memorySpaceId, spaceParams.dataSpaceId, references);
                return resolveName ? ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getReferencedObjectNames(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, references) : HDF5ReferenceReader.this.refToStr(references);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public MDArray<String> readMDArray(String objectPath) {
        return this.readMDArray(objectPath, true);
    }

    @Override
    public MDArray<String> readMDArray(final String objectPath, final boolean resolveName) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDArray<String>> readCallable = new ICallableWithCleanUp<MDArray<String>>(){

            @Override
            public MDArray<String> call(ICleanUpRegistry registry) {
                long[] references;
                int[] dimensions;
                int dataSetId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openDataSet(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, objectPath, registry);
                int dataTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                if (((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_REFERENCE) {
                    HDF5BaseReader.DataSpaceParameters spaceParams = HDF5ReferenceReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                    dimensions = MDAbstractArray.toInt(spaceParams.dimensions);
                    references = new long[spaceParams.blockSize];
                    ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readDataSet(dataSetId, dataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, references);
                } else if (((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getClassType(dataTypeId) == HDF5Constants.H5T_ARRAY && ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getClassType(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getBaseDataType(dataTypeId, registry)) == HDF5Constants.H5T_REFERENCE) {
                    int spaceId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.createScalarDataSpace();
                    dimensions = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getArrayDimensions(dataTypeId);
                    int len = MDAbstractArray.getLength(dimensions);
                    references = new long[len];
                    int memoryTypeId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.createArrayType(HDF5Constants.H5T_STD_REF_OBJ, len, registry);
                    ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readDataSet(dataSetId, memoryTypeId, spaceId, spaceId, references);
                } else {
                    throw new HDF5JavaException("Dataset " + objectPath + " is not a reference.");
                }
                String[] referencedObjectNames = resolveName ? ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getReferencedObjectNames(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, references) : HDF5ReferenceReader.this.refToStr(references);
                return new MDArray<String>((T[])referencedObjectNames, dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public MDArray<String> readMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        return this.readMDArrayBlock(objectPath, blockDimensions, blockNumber, true);
    }

    @Override
    public MDArray<String> readMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber, boolean resolveName) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset, resolveName);
    }

    @Override
    public MDArray<String> readMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) {
        return this.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset, true);
    }

    @Override
    public MDArray<String> readMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset, final boolean resolveName) {
        assert (objectPath != null);
        assert (blockDimensions != null);
        assert (offset != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDArray<String>> readCallable = new ICallableWithCleanUp<MDArray<String>>(){

            @Override
            public MDArray<String> call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.openDataSet(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5ReferenceReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                long[] referencesBlock = new long[spaceParams.blockSize];
                ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_STD_REF_OBJ, spaceParams.memorySpaceId, spaceParams.dataSpaceId, referencesBlock);
                String[] referencedObjectNamesBlock = resolveName ? ((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.h5.getReferencedObjectNames(((HDF5ReferenceReader)HDF5ReferenceReader.this).baseReader.fileId, referencesBlock) : HDF5ReferenceReader.this.refToStr(referencesBlock);
                return new MDArray<String>((T[])referencedObjectNamesBlock, blockDimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getArrayNaturalBlocks(String dataSetPath) throws HDF5JavaException {
        return this.getArrayNaturalBlocks(dataSetPath, true);
    }

    @Override
    public Iterable<HDF5DataBlock<String[]>> getArrayNaturalBlocks(final String dataSetPath, final boolean resolveName) throws HDF5JavaException {
        this.baseReader.checkOpen();
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<String[]>>(){

            @Override
            public Iterator<HDF5DataBlock<String[]>> iterator() {
                return new Iterator<HDF5DataBlock<String[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<String[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        String[] referencesBlock = HDF5ReferenceReader.this.readArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset, resolveName);
                        return new HDF5DataBlock<String[]>(referencesBlock, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getMDArrayNaturalBlocks(String dataSetPath) {
        return this.getMDArrayNaturalBlocks(dataSetPath, true);
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDArray<String>>> getMDArrayNaturalBlocks(final String dataSetPath, final boolean resolveName) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5MDDataBlock<MDArray<String>>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDArray<String>>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDArray<String>>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDArray<String>> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDArray<String> data = HDF5ReferenceReader.this.readMDArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset, resolveName);
                        return new HDF5MDDataBlock<MDArray<String>>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

