/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.ChannelSeparator;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.SVSReader;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class AFIReader
extends FormatReader {
    private static final int EXTRA_IMAGES = 3;
    private ArrayList<String> pixels = new ArrayList();
    private ChannelSeparator[] reader;

    public AFIReader() {
        super("Aperio AFI", "afi");
        this.domains = new String[]{"Histology"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .afi file and several similarly-named .svs files";
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        return FormatTools.validStream(stream, 4, false);
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public int getOptimalTileWidth() {
        return this.reader[0].getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        return this.reader[0].getOptimalTileHeight();
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCoreIndex() >= this.core.size() - 3) {
            this.reader[0].setCoreIndex(this.getCoreIndex());
            return this.reader[0].openThumbBytes(no);
        }
        int coreIndex = this.getCoreIndex();
        this.setCoreIndex(this.core.size() - 3 - 1);
        byte[] thumb = FormatTools.openThumbBytes(this, no);
        this.setCoreIndex(coreIndex);
        return thumb;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.getCoreIndex() >= this.core.size() - 3) {
            this.reader[0].setCoreIndex(this.getCoreIndex());
            return this.reader[0].openBytes(no, buf, x, y, w, h);
        }
        int[] coords = this.getZCTCoords(no);
        int channel = coords[1];
        int index = this.getIndex(coords[0], 0, coords[2]);
        this.reader[channel].setCoreIndex(this.getCoreIndex());
        return this.reader[channel].openBytes(index, buf, x, y, w, h);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] files = new String[this.pixels.size() + 1];
        files[0] = this.currentId;
        for (int i = 0; i < this.pixels.size(); ++i) {
            files[i + 1] = this.pixels.get(i);
        }
        return files;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                for (ChannelSeparator r : this.reader) {
                    if (r == null) continue;
                    r.close();
                }
            }
            this.reader = null;
            this.pixels.clear();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        String xml = DataTools.readFile(id);
        XMLTools.parseXML(xml, (DefaultHandler)new AFIHandler());
        String parent = new Location(id).getAbsoluteFile().getParent();
        String[] channelNames = new String[this.pixels.size()];
        this.reader = new ChannelSeparator[this.pixels.size()];
        for (i = 0; i < this.pixels.size(); ++i) {
            String file2 = this.pixels.get(i);
            int underscore = file2.indexOf(95);
            int fullStop = file2.indexOf(46);
            if (underscore >= 0 && fullStop > underscore) {
                channelNames[i] = file2.substring(underscore + 1, fullStop);
            }
            this.pixels.set(i, new Location(parent, file2).getAbsolutePath());
            this.reader[i] = new ChannelSeparator(new SVSReader());
            this.reader[i].setFlattenedResolutions(this.hasFlattenedResolutions());
            this.reader[i].setId(this.pixels.get(i));
        }
        this.core = this.reader[0].getCoreMetadataList();
        for (i = 0; i < this.core.size() - 3; ++i) {
            CoreMetadata c = (CoreMetadata)this.core.get(i);
            c.sizeC = this.pixels.size();
            c.imageCount = c.sizeC * c.sizeZ * c.sizeT;
            c.rgb = false;
            if (i != 0) continue;
            c.resolutionCount = this.core.size() - 3;
        }
        MetadataStore store = this.makeFilterMetadata();
        boolean minimalMetadata = this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM;
        MetadataTools.populatePixels(store, this, !minimalMetadata);
        String fileID = this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1, this.currentId.lastIndexOf("."));
        for (int i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            store.setImageName(fileID + " - image #" + (i2 + 1), i2);
        }
        if (!minimalMetadata) {
            Length[] emission = new Length[this.pixels.size()];
            Length[] excitation = new Length[this.pixels.size()];
            Double[] exposure = new Double[this.pixels.size()];
            Timestamp[] datestamp = new Timestamp[this.pixels.size()];
            Length[] physicalSizes = null;
            double magnification = Double.NaN;
            for (int c = 0; c < this.pixels.size(); ++c) {
                SVSReader baseReader = (SVSReader)this.reader[c].getReader();
                emission[c] = baseReader.getEmission();
                excitation[c] = baseReader.getExcitation();
                exposure[c] = baseReader.getExposureTime();
                datestamp[c] = baseReader.getDatestamp();
                physicalSizes = baseReader.getPhysicalSizes();
                if (c != 0) continue;
                magnification = baseReader.getMagnification();
            }
            String instrument = MetadataTools.createLSID("Instrument", 0);
            String objective = MetadataTools.createLSID("Objective", 0, 0);
            store.setInstrumentID(instrument, 0);
            store.setObjectiveID(objective, 0, 0);
            store.setObjectiveNominalMagnification(magnification, 0, 0);
            for (int i3 = 0; i3 < this.getSeriesCount() - 3; ++i3) {
                if (datestamp[0] != null) {
                    store.setImageAcquisitionDate(datestamp[0], i3);
                }
                store.setImageInstrumentRef(instrument, i3);
                store.setObjectiveSettingsID(objective, i3);
                if (i3 < physicalSizes.length && physicalSizes[i3] != null && physicalSizes[i3].value(UNITS.MICROMETER).doubleValue() - 1.0E-6 > 0.0) {
                    Length size = physicalSizes[i3];
                    store.setPixelsPhysicalSizeX(size, i3);
                    store.setPixelsPhysicalSizeY(size, i3);
                }
                for (int c = 0; c < channelNames.length; ++c) {
                    store.setChannelName(channelNames[c], i3, c);
                    if (emission[c] != null) {
                        store.setChannelEmissionWavelength(emission[c], i3, c);
                    }
                    if (excitation[c] != null) {
                        store.setChannelExcitationWavelength(excitation[c], i3, c);
                    }
                    store.setPlaneExposureTime(FormatTools.createTime(exposure[c], UNITS.SECOND), i3, c);
                }
            }
        }
    }

    class AFIHandler
    extends BaseHandler {
        private String currentElement;

        AFIHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            if (this.currentElement.equals("Path") && value.trim().length() > 0) {
                AFIReader.this.pixels.add(value);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentElement = qName;
        }
    }
}

