/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffSaver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditTiffG
extends JFrame
implements ActionListener {
    private static final String TITLE = "EditTiffG";
    private static final Logger LOGGER = LoggerFactory.getLogger(EditTiffG.class);
    private JTextArea textArea;
    private JFileChooser fileBox;
    private File file;

    public EditTiffG() {
        this.setTitle(TITLE);
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea(25, 80);
        this.add((Component)new JScrollPane(this.textArea), "Center");
        this.textArea.setLineWrap(true);
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu file2 = new JMenu("File");
        menubar.add(file2);
        JMenuItem fileOpen = new JMenuItem("Open");
        file2.add(fileOpen);
        fileOpen.addActionListener(this);
        fileOpen.setActionCommand("open");
        JMenuItem fileSave = new JMenuItem("Save");
        file2.add(fileSave);
        fileSave.addActionListener(this);
        fileSave.setActionCommand("save");
        JMenuItem fileExit = new JMenuItem("Exit");
        file2.add(fileExit);
        fileExit.addActionListener(this);
        fileExit.setActionCommand("exit");
        this.fileBox = new JFileChooser(System.getProperty("user.dir"));
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setVisible(true);
    }

    public String getXML() {
        return this.textArea.getText();
    }

    public void setXML(String xml) {
        this.textArea.setText(xml);
    }

    public void open() {
        int rval = this.fileBox.showOpenDialog(this);
        if (rval != 0) {
            return;
        }
        File f = this.fileBox.getSelectedFile();
        this.openFile(f);
    }

    public void save() {
        this.saveFile(this.file);
    }

    public void exit() {
        System.exit(0);
    }

    public void openFile(File f) {
        try {
            String id = f.getAbsolutePath();
            String xml = new TiffParser(id).getComment();
            this.setXML(xml);
            this.file = f;
            this.setTitle("EditTiffG - " + id);
        }
        catch (IOException exc) {
            this.showError(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File f) {
        RandomAccessInputStream in = null;
        RandomAccessOutputStream out = null;
        try {
            String xml = this.getXML();
            String path = f.getAbsolutePath();
            in = new RandomAccessInputStream(path);
            out = new RandomAccessOutputStream(path);
            TiffSaver saver = new TiffSaver(out, path);
            saver.overwriteComment(in, xml);
        }
        catch (FormatException exc) {
            this.showError(exc);
        }
        catch (IOException exc) {
            this.showError(exc);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exc) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exc) {}
        }
    }

    public void showError(Throwable t) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String error = "";
        try {
            t.printStackTrace(new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8")));
            error = new String(out.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Failed to show error", e);
        }
        JOptionPane.showMessageDialog(this, "Sorry, there was an error: " + error, TITLE, 0);
    }

    public static void openFile(String filename) {
        EditTiffG etg = new EditTiffG();
        File f = new File(filename);
        if (f.exists()) {
            etg.openFile(f);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("open".equals(cmd)) {
            this.open();
        } else if ("save".equals(cmd)) {
            this.save();
        } else if ("exit".equals(cmd)) {
            this.exit();
        }
    }

    public static void main(String[] args) throws Exception {
        EditTiffG.openFile(args[0]);
    }
}

