/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.util.DodsURLExtractor;

public class CrawlableDatasetDods
implements CrawlableDataset {
    private static Logger log = LoggerFactory.getLogger(CrawlableDatasetDods.class);
    private static DodsURLExtractor urlExtractor = null;
    private static Map listDatasetsMap = null;
    private String path;
    private URLConnection pathUrlConnection = null;
    private String name;
    private Object configObj = null;
    private static String[] knownFileExtensions = new String[]{".hdf", ".xml", ".nc", ".bz2", ".cdp", ".jpg"};
    private static String[] dodsExtensions = new String[]{".html", ".htm", ".das", ".dds", ".info"};

    protected CrawlableDatasetDods() {
    }

    protected CrawlableDatasetDods(String path, Object configObj) {
        if (urlExtractor == null) {
            urlExtractor = new DodsURLExtractor();
        }
        if (listDatasetsMap == null) {
            listDatasetsMap = new HashMap();
        }
        if (configObj != null) {
            log.debug("CrawlableDatasetDods(): config object not null, it will be ignored <" + configObj.toString() + ">.");
            this.configObj = configObj;
        }
        if (path.startsWith("http:")) {
            this.path = path;
            try {
                new URI(path);
                this.name = this.getName(path);
            }
            catch (URISyntaxException e) {
                String tmpMsg = "Bad URI syntax for path <" + path + ">: " + e.getMessage();
                log.debug("CrawlableDatasetDods(): " + tmpMsg);
                throw new IllegalArgumentException(tmpMsg);
            }
        } else {
            String tmpMsg = "Invalid url <" + path + ">.";
            log.debug("CrawlableDatasetDods(): " + tmpMsg);
            throw new IllegalArgumentException(tmpMsg);
        }
    }

    private CrawlableDatasetDods(CrawlableDatasetDods parent, String childPath) {
        String normalChildPath = childPath.startsWith("/") ? childPath.substring(1) : childPath;
        this.path = parent.getPath();
        this.path = this.path + (this.path.endsWith("/") ? normalChildPath : "/" + normalChildPath);
        this.name = this.getName(this.path);
        this.configObj = null;
    }

    private String getName(String path) {
        if (!path.equals("/")) {
            String tmpName = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            int index = tmpName.lastIndexOf("/");
            if (index != -1) {
                tmpName = tmpName.substring(index + 1);
            }
            return tmpName;
        }
        return path;
    }

    public URI getUri() {
        try {
            return new URI(this.path);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public Object getConfigObject() {
        return this.configObj;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCollection() {
        return CrawlableDatasetDods.isCollection(this.path);
    }

    @Override
    public CrawlableDataset getDescendant(String relativePath) {
        if (relativePath.startsWith("/")) {
            throw new IllegalArgumentException("Path must be relative <" + relativePath + ">.");
        }
        return new CrawlableDatasetDods(this, relativePath);
    }

    private static boolean isCollection(String path) {
        int i;
        String testPath = path.toLowerCase();
        if (CrawlableDatasetDods.isDodsDataset(testPath)) {
            return false;
        }
        for (i = 0; i < knownFileExtensions.length && !testPath.endsWith(knownFileExtensions[i]); ++i) {
        }
        return i >= knownFileExtensions.length;
    }

    private static String getDodsExtension(String path) {
        int i;
        String extension = "";
        String testPath = path.toLowerCase();
        for (i = 0; i < dodsExtensions.length && !testPath.endsWith(dodsExtensions[i]); ++i) {
        }
        if (i < dodsExtensions.length) {
            extension = dodsExtensions[i];
        }
        return extension;
    }

    private static boolean isDodsDataset(String path) {
        return CrawlableDatasetDods.getDodsExtension(path).length() > 0;
    }

    private static String removeDodsExtension(String path) {
        String dodsExtension = CrawlableDatasetDods.getDodsExtension(path);
        if (dodsExtension.length() > 0) {
            path = path.substring(0, path.length() - dodsExtension.length());
        }
        return path;
    }

    private String forceChild(String url) {
        int j;
        String prefix = this.path;
        if (prefix.endsWith("/")) {
            prefix = this.path.substring(0, this.path.length() - 1);
        }
        if ((j = url.substring(0, url.length() - 1).lastIndexOf(47)) >= 0) {
            String ret = prefix + url.substring(j);
            return ret;
        }
        return url;
    }

    public List listDatasets() throws IOException {
        if (!this.isCollection()) {
            String tmpMsg = "This dataset <" + this.getPath() + "> is not a collection dataset.";
            log.error("listDatasets(): " + tmpMsg);
            throw new IllegalStateException(tmpMsg);
        }
        if (listDatasetsMap.containsKey(this.path)) {
            return (List)listDatasetsMap.get(this.path);
        }
        ArrayList<CrawlableDataset> list = new ArrayList<CrawlableDataset>();
        ArrayList<String> pathList = new ArrayList<String>();
        ArrayList possibleDsList = null;
        try {
            String openPath = this.path;
            if (!openPath.endsWith("/")) {
                openPath = openPath + "/";
            }
            possibleDsList = urlExtractor.extract(openPath);
        }
        catch (IOException e) {
            log.warn("listDatasets(): IOException while extracting dataset info from given OPeNDAP directory <" + this.path + ">, return empty list: " + e.getMessage());
            return list;
        }
        String curDsUrlString2 = null;
        for (String curDsUrlString2 : possibleDsList) {
            if (!CrawlableDatasetDods.isDodsDataset(curDsUrlString2) && !CrawlableDatasetDods.isCollection(curDsUrlString2)) {
                log.warn("expandThisLevel(): Dataset isn't an OPeNDAP dataset or collection dataset, skip <" + this.path + ">.");
                continue;
            }
            if (!(curDsUrlString2 = CrawlableDatasetDods.removeDodsExtension(curDsUrlString2)).startsWith(this.path)) {
                log.debug("listDatasets(): skipping URL <" + curDsUrlString2 + ">, not child of this CrDs <" + this.path + ">.");
                continue;
            }
            if (pathList.contains(curDsUrlString2)) continue;
            pathList.add(curDsUrlString2);
            if (!curDsUrlString2.startsWith(this.path)) {
                log.debug("listDatasets(): current path <" + curDsUrlString2 + "> not child of given" + " location <" + this.path + ">, skip.");
                continue;
            }
            try {
                new URI(curDsUrlString2);
            }
            catch (URISyntaxException e) {
                log.error("listDatasets(): Skipping dataset  <" + curDsUrlString2 + "> due to URISyntaxException: " + e.getMessage());
                continue;
            }
            log.debug("listDatasets(): handle dataset (" + curDsUrlString2 + ")");
            try {
                list.add(CrawlableDatasetFactory.createCrawlableDataset(curDsUrlString2, this.getClass().getName(), null));
            }
            catch (ClassNotFoundException e) {
                log.warn("listDatasets(): Can't make CrawlableDataset for child url <" + curDsUrlString2 + ">: " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.warn("listDatasets(): Can't make CrawlableDataset for child url <" + curDsUrlString2 + ">: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.warn("listDatasets(): Can't make CrawlableDataset for child url <" + curDsUrlString2 + ">: " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.warn("listDatasets(): Can't make CrawlableDataset for child url <" + curDsUrlString2 + ">: " + e.getMessage());
            }
            catch (InstantiationException e) {
                log.warn("listDatasets(): Can't make CrawlableDataset for child url <" + curDsUrlString2 + ">: " + e.getMessage());
            }
        }
        listDatasetsMap.put(this.path, list);
        return list;
    }

    public List listDatasets(CrawlableDatasetFilter filter) throws IOException {
        List list = this.listDatasets();
        if (filter == null) {
            return list;
        }
        ArrayList<CrawlableDataset> retList = new ArrayList<CrawlableDataset>();
        for (CrawlableDataset curDs : list) {
            if (!filter.accept(curDs)) continue;
            retList.add(curDs);
        }
        return retList;
    }

    @Override
    public CrawlableDataset getParentDataset() {
        if (!this.path.equals("/")) {
            String parentPath;
            int index = parentPath.lastIndexOf("/", (parentPath = this.path).endsWith("/") ? parentPath.length() - 2 : parentPath.length() - 1);
            if (index != -1) {
                parentPath = parentPath.substring(0, index + 1);
            }
            return new CrawlableDatasetDods(parentPath, null);
        }
        return null;
    }

    @Override
    public boolean exists() {
        if (this.pathUrlConnection == null) {
            try {
                URL u = new URL(this.path);
                this.pathUrlConnection = u.openConnection();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.pathUrlConnection != null) {
            try {
                int responseCode = ((HttpURLConnection)this.pathUrlConnection).getResponseCode();
                if (responseCode >= 200 && responseCode < 300) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public long length() {
        if (this.isCollection()) {
            return 0L;
        }
        if (this.pathUrlConnection == null) {
            try {
                URL u = new URL(this.path);
                this.pathUrlConnection = u.openConnection();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.pathUrlConnection != null) {
            return this.pathUrlConnection.getContentLength();
        }
        return -1L;
    }

    @Override
    public Date lastModified() {
        if (this.pathUrlConnection == null) {
            try {
                URL u = new URL(this.path);
                this.pathUrlConnection = u.openConnection();
            }
            catch (MalformedURLException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.pathUrlConnection != null) {
            long lastModified = this.pathUrlConnection.getLastModified();
            if (lastModified != 0L) {
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.setTimeInMillis(lastModified);
                return cal.getTime();
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return this.path;
    }
}

