/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.libmdb;

import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import mdbtools.libmdb.Holder;
import mdbtools.libmdb.MdbCatalogEntry;
import mdbtools.libmdb.MdbColumn;
import mdbtools.libmdb.MdbFormatConstants;
import mdbtools.libmdb.MdbHandle;
import mdbtools.libmdb.MdbTableDef;
import mdbtools.libmdb.Money;
import mdbtools.libmdb.Sargs;
import mdbtools.libmdb.Util;
import mdbtools.libmdb.file;
import mdbtools.libmdb.macros;

public class Data {
    public static int mdb_find_end_of_row(MdbHandle mdb, int row) {
        int row_end;
        MdbFormatConstants fmt = mdb.fmt;
        if (row == 0) {
            row_end = fmt.pg_size - 1;
        } else {
            int offset = fmt.row_count_offset + 2 + (row - 1) * 2;
            int ij = file.mdb_get_int16(mdb, offset);
            row_end = (ij & 0xFFF) - 1;
        }
        return row_end;
    }

    public static void mdb_bind_column(MdbTableDef table, int col_num, Holder bind_ptr) {
        MdbColumn col = (MdbColumn)table.columns.get(col_num - 1);
        col.bind_ptr = bind_ptr;
    }

    public static int mdb_rewind_table(MdbTableDef table) {
        table.cur_pg_num = 0;
        table.cur_phys_pg = 0;
        table.cur_row = 0;
        return 0;
    }

    public static boolean mdb_fetch_row(MdbTableDef table) throws IOException {
        int rc;
        MdbHandle mdb = table.entry.mdb;
        MdbFormatConstants fmt = mdb.fmt;
        if (table.num_rows == 0) {
            return false;
        }
        if (table.cur_pg_num == 0) {
            table.cur_pg_num = 1;
            table.cur_row = 0;
            Data.mdb_read_next_dpg(table);
        }
        do {
            int rows;
            if (table.cur_row >= (rows = file.mdb_get_int16(mdb, fmt.row_count_offset))) {
                table.cur_row = 0;
                if (Data.mdb_read_next_dpg(table) == 0) {
                    return false;
                }
            }
            rc = Data.mdb_read_row(table, table.cur_row);
            ++table.cur_row;
        } while (rc == 0);
        return true;
    }

    public static int mdb_read_next_dpg_by_map0(MdbTableDef table) throws IOException {
        MdbCatalogEntry entry = table.entry;
        MdbHandle mdb = entry.mdb;
        int pgnum = file._mdb_get_int32(table.usage_map, 1);
        for (int i = 5; i < table.map_sz; ++i) {
            for (int bitn = 0; bitn < 8; ++bitn) {
                if ((table.usage_map[i] & 1 << bitn) != 0 && pgnum > table.cur_phys_pg) {
                    table.cur_phys_pg = pgnum;
                    if (file.mdb_read_pg(mdb, pgnum) == 0L) {
                        return 0;
                    }
                    return pgnum;
                }
                ++pgnum;
            }
        }
        return 0;
    }

    public static int mdb_read_next_dpg(MdbTableDef table) throws IOException {
        MdbCatalogEntry entry = table.entry;
        MdbHandle mdb = entry.mdb;
        byte map_type = table.usage_map[0];
        if (map_type == 0) {
            return Data.mdb_read_next_dpg_by_map0(table);
        }
        if (map_type == 1) {
            return Data.mdb_read_next_dpg_by_map1(table);
        }
        throw new RuntimeException("Warning: unrecognized usage map type: " + table.usage_map[0] + ", defaulting to brute force read\n");
    }

    public static int mdb_read_row(MdbTableDef table, int row) throws IOException {
        int col_ptr;
        int rc;
        boolean isnull;
        MdbColumn col;
        int j;
        MdbHandle mdb = table.entry.mdb;
        MdbFormatConstants fmt = mdb.fmt;
        int num_of_jumps = 0;
        int jumps_used = 0;
        int deleted_columns = 0;
        byte[] null_mask = new byte[33];
        int row_start = file.mdb_get_int16(mdb, fmt.row_count_offset + 2 + row * 2);
        int row_end = Data.mdb_find_end_of_row(mdb, row);
        int lookupflag = 0;
        int delflag = 0;
        if ((row_start & 0x8000) != 0) {
            ++lookupflag;
        }
        if ((row_start & 0x4000) != 0) {
            ++delflag;
        }
        row_start &= 0xFFF;
        if (table.noskip_del == 0 && delflag != 0) {
            row_end = row_start - 1;
            return 0;
        }
        int num_cols = macros.IS_JET4(mdb) ? file.mdb_get_int16(mdb, row_start) : mdb.pg_buf[row_start];
        int var_cols = 0;
        int fixed_cols = 0;
        for (j = 0; j < table.num_cols; ++j) {
            col = (MdbColumn)table.columns.get(j);
            if (Data.mdb_is_fixed_col(col)) {
                ++fixed_cols;
                continue;
            }
            ++var_cols;
        }
        int bitmask_sz = (num_cols - 1) / 8 + 1;
        int eod = macros.IS_JET4(mdb) ? file.mdb_get_int16(mdb, row_end - 3 - var_cols * 2 - bitmask_sz) : mdb.pg_buf[row_end - 1 - var_cols - bitmask_sz] & 0xFF;
        for (int i = 0; i < bitmask_sz; ++i) {
            null_mask[i] = mdb.pg_buf[row_end - bitmask_sz + i + 1];
        }
        int col_start = macros.IS_JET4(mdb) ? 2 : 1;
        int fixed_cols_found = 0;
        int var_cols_found = 0;
        for (j = 0; j < table.num_cols; ++j) {
            col = (MdbColumn)table.columns.get(j);
            if (!Data.mdb_is_fixed_col(col) || ++fixed_cols_found > fixed_cols) continue;
            isnull = Data.mdb_is_null(null_mask, j + 1);
            rc = Data._mdb_attempt_bind(mdb, col, isnull, row_start + col_start, col.col_size);
            if (rc == 0) {
                return 0;
            }
            if (col.col_type == 1) continue;
            col_start += col.col_size;
        }
        int old_col_start = col_start;
        if (col_start >= 256) {
            ++num_of_jumps;
            ++jumps_used;
            row_start = row_start + col_start - col_start % 256;
        }
        col_start = row_start;
        while (col_start + 256 < row_end - bitmask_sz - 1 - var_cols - num_of_jumps) {
            col_start += 256;
            ++num_of_jumps;
        }
        if (macros.IS_JET4(mdb)) {
            col_ptr = row_end - 2 - bitmask_sz - 1;
            eod = file.mdb_get_int16(mdb, col_ptr - var_cols * 2);
            col_start = file.mdb_get_int16(mdb, col_ptr);
        } else {
            col_ptr = row_end - bitmask_sz - num_of_jumps - 1;
            if (mdb.pg_buf[col_ptr] == 255) {
                --col_ptr;
                ++deleted_columns;
            }
            eod = mdb.pg_buf[col_ptr - var_cols];
            col_start = mdb.pg_buf[col_ptr];
        }
        if (col_start < old_col_start) {
            col_start = old_col_start;
        }
        for (j = 0; j < table.num_cols; ++j) {
            int len;
            col = (MdbColumn)table.columns.get(j);
            if (Data.mdb_is_fixed_col(col) || ++var_cols_found > var_cols) continue;
            if (var_cols_found == var_cols) {
                len = eod - col_start;
            } else {
                if (macros.IS_JET4(mdb)) {
                    int next_col = mdb.pg_buf[row_end - bitmask_sz - var_cols_found * 2 - 2] * 256 + mdb.pg_buf[row_end - bitmask_sz - var_cols_found * 2 - 2 - 1];
                    len = next_col - col_start;
                } else {
                    len = mdb.pg_buf[col_ptr - var_cols_found] - col_start;
                }
                if (len < 0) {
                    len += 256;
                }
            }
            isnull = Data.mdb_is_null(null_mask, j + 1);
            rc = Data._mdb_attempt_bind(mdb, col, isnull, row_start + col_start, len);
            if (rc == 0) {
                return 0;
            }
            col_start += len;
        }
        return 1;
    }

    private static boolean mdb_is_fixed_col(MdbColumn col) {
        return col.is_fixed;
    }

    private static boolean mdb_is_null(byte[] null_mask, int col_num) {
        int bit_num = (col_num - 1) % 8;
        int byte_num = (col_num - 1) / 8;
        return (1 << bit_num & null_mask[byte_num]) == 0;
    }

    private static int _mdb_attempt_bind(MdbHandle mdb, MdbColumn col, boolean isnull, int offset, int len) throws IOException {
        if (col.col_type == 1) {
            Data.mdb_xfer_bound_bool(mdb, col, isnull);
        } else if (col.col_type == 11) {
            Data.mdb_xfer_bound_ole(mdb, offset, col, len);
        } else if (isnull) {
            Data.mdb_xfer_bound_data(mdb, 0, col, 0);
        } else {
            if (!Sargs.mdb_test_sargs(mdb, col, offset, len)) {
                return 0;
            }
            Data.mdb_xfer_bound_data(mdb, offset, col, len);
        }
        return 1;
    }

    public static int mdb_xfer_bound_bool(MdbHandle mdb, MdbColumn col, boolean value) {
        int n = col.cur_value_len = value ? 1 : 0;
        if (col.bind_ptr != null) {
            col.bind_ptr.s = value ? "0" : "1";
        }
        return 0;
    }

    public static int mdb_xfer_bound_ole(MdbHandle mdb, int start, MdbColumn col, int len) throws IOException {
        int ret = 0;
        if (len != 0) {
            col.cur_value_start = start;
            col.cur_value_len = len;
        } else {
            col.cur_value_start = 0;
            col.cur_value_len = 0;
        }
        if (col.bind_ptr != null) {
            ret = Data.mdb_copy_ole(mdb, col.bind_ptr, start, len);
        }
        return ret;
    }

    public static int mdb_xfer_bound_data(MdbHandle mdb, int start, MdbColumn col, int len) throws IOException {
        if (len != 0) {
            col.cur_value_start = start;
            col.cur_value_len = len;
        } else {
            col.cur_value_start = 0;
            col.cur_value_len = 0;
        }
        if (col.bind_ptr != null) {
            col.bind_ptr.s = len != 0 ? (col.col_type == 16 ? Data.mdb_num_to_string(mdb, start, col.col_type, col.col_prec, col.col_scale) : Data.mdb_col_to_string(mdb, start, col.col_type, len)) : "";
            int ret = col.bind_ptr.s.length();
            return ret;
        }
        return 0;
    }

    public static String mdb_col_to_string(MdbHandle mdb, int start, int datatype, int size) throws IOException {
        switch (datatype) {
            case 1: {
                throw new RuntimeException("Should not get here - boolean");
            }
            case 2: {
                return Integer.toString(file.mdb_get_byte(mdb, start));
            }
            case 3: {
                return Integer.toString(file.mdb_get_int16(mdb, start));
            }
            case 4: {
                return Integer.toString(file.mdb_get_int32(mdb, start));
            }
            case 6: {
                return Float.toString(file.mdb_get_single(mdb, start));
            }
            case 7: {
                return Double.toString(file.mdb_get_double(mdb, start));
            }
            case 10: {
                String text;
                if (size < 0) {
                    return "";
                }
                if (macros.IS_JET4(mdb)) {
                    if (mdb.pg_buf[start] == 255 && mdb.pg_buf[start + 1] == 254) {
                        text = new String(mdb.pg_buf, start + 2, size - 2);
                    } else {
                        int index = 0;
                        byte[] ba = new byte[size];
                        for (int i = 0; i < size; ++i) {
                            ba[index++] = mdb.pg_buf[start + i];
                        }
                        text = Util.extractText(ba);
                    }
                } else {
                    text = new String(mdb.pg_buf, start, size);
                }
                return text;
            }
            case 8: {
                long t = (int)((file.mdb_get_double(mdb, start) - 25569.0) * 86400.0);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                cal.setTimeInMillis(t *= 1000L);
                String text = "" + (cal.get(2) + 1) + '/' + cal.get(5) + '/' + cal.get(1) + ' ' + cal.get(11) + ':' + cal.get(12) + ':' + cal.get(13);
                return text;
            }
            case 12: {
                return Data.mdb_memo_to_string(mdb, start, size);
            }
            case 5: {
                return Money.mdb_money_to_string(mdb, start);
            }
            case 16: {
                throw new RuntimeException("Should not get here - numeric");
            }
        }
        throw new RuntimeException("Should not get here - default");
    }

    public static int mdb_read_next_dpg_by_map1(MdbTableDef table) throws IOException {
        MdbCatalogEntry entry = table.entry;
        MdbHandle mdb = entry.mdb;
        int pgnum = 0;
        for (int i = 1; i < table.map_sz - 1; i += 4) {
            int map_pg = file._mdb_get_int32(table.usage_map, i);
            if (map_pg == 0) continue;
            if (file.mdb_read_alt_pg(mdb, map_pg) != (long)mdb.fmt.pg_size) {
                throw new RuntimeException("Oops! didn't get a full page at " + map_pg);
            }
            for (int j = 4; j < mdb.fmt.pg_size; ++j) {
                for (int bitn = 0; bitn < 8; ++bitn) {
                    if ((mdb.alt_pg_buf[j] & 1 << bitn) != 0 && pgnum > table.cur_phys_pg) {
                        table.cur_phys_pg = pgnum;
                        if (file.mdb_read_pg(mdb, pgnum) == 0L) {
                            return 0;
                        }
                        return pgnum;
                    }
                    ++pgnum;
                }
            }
        }
        return 0;
    }

    public static String mdb_memo_to_string(MdbHandle mdb, int start, int size) throws IOException {
        int row_start;
        MdbFormatConstants fmt = mdb.fmt;
        String text = "";
        if (size < 12) {
            return "";
        }
        int memo_len = file.mdb_get_int16(mdb, start);
        int memo_flags = file.mdb_get_int16(mdb, start + 2);
        if ((memo_flags & 0x8000) != 0) {
            int begin = start + 12 + 2;
            int end = size - 12 - 2;
            if (begin >= 0 && begin < mdb.pg_buf.length && end > 0 && begin + end <= mdb.pg_buf.length) {
                text = new String(mdb.pg_buf, begin, end);
            }
            return text;
        }
        if ((memo_flags & 0x4000) != 0) {
            byte memo_row = mdb.pg_buf[start + 4];
            int lval_pg = file.mdb_get_int24(mdb, start + 5);
            if (file.mdb_read_alt_pg(mdb, lval_pg) != (long)fmt.pg_size) {
                throw new IOException("failed to read");
            }
            file.mdb_swap_pgbuf(mdb);
            int row_stop = memo_row != 0 ? file.mdb_get_int16(mdb, fmt.row_count_offset + 2 + (memo_row - 1) * 2) & 0xFFF : fmt.pg_size - 1;
            int row_start2 = file.mdb_get_int16(mdb, fmt.row_count_offset + 2 + memo_row * 2);
            int len = row_stop - row_start2;
            if (macros.IS_JET3(mdb)) {
                text = new String(mdb.pg_buf, row_start2, len);
            } else if (mdb.pg_buf[row_start2] == -1 && mdb.pg_buf[row_start2 + 1] == -2) {
                text = new String(mdb.pg_buf, row_start2 + 2, len - 2);
            } else {
                char[] ca = new char[len];
                int j = 0;
                for (int i = 0; i < len; i += 2) {
                    ca[j++] = (char)file.unsign(mdb.pg_buf[row_start2 + i]);
                }
                text = new String(ca, 0, j++);
            }
            file.mdb_swap_pgbuf(mdb);
            return text;
        }
        int lval_pg = file.mdb_get_int32(mdb, start + 4);
        byte memo_row = mdb.pg_buf[start + 4];
        file.mdb_swap_pgbuf(mdb);
        do {
            int strlen;
            if (file.mdb_read_pg(mdb, lval_pg) != (long)fmt.pg_size) {
                if (memo_len < fmt.pg_size) {
                    file.mdb_swap_pgbuf(mdb);
                }
                return text;
            }
            int row_stop = memo_row != 0 ? file.mdb_get_int16(mdb, 10 + (memo_row - 1) * 2) & 0xFFF : fmt.pg_size - 1;
            row_start = file.mdb_get_int16(mdb, 10 + memo_row * 2);
            int len = row_stop - row_start;
            int n = strlen = text.length() + len - 4 > 16384 ? 16384 - text.length() : len - 4;
            if (strlen < 0) {
                strlen = 0;
            }
            if (row_start + 4 >= mdb.pg_buf.length) {
                row_start = mdb.pg_buf.length - strlen - 4;
            }
            text = text + new String(mdb.pg_buf, row_start + 4, strlen);
            memo_row = mdb.pg_buf[row_start];
        } while ((lval_pg = file.mdb_get_int32(mdb, row_start)) != 0);
        file.mdb_swap_pgbuf(mdb);
        return text;
    }

    private static int mdb_copy_ole(MdbHandle mdb, Holder dest, int start, int size) throws IOException {
        if (size < 12) {
            return 0;
        }
        int ole_len = file.mdb_get_int16(mdb, start);
        int ole_flags = file.mdb_get_int16(mdb, start + 2);
        if (ole_flags == 32768) {
            int len = size - 12;
            if (dest != null) {
                dest.ba = new byte[len];
                System.arraycopy(mdb.pg_buf, start + 12, dest.ba, 0, len);
            }
            return len;
        }
        if (ole_flags == 16384) {
            byte ole_row = mdb.pg_buf[start + 4];
            int lval_pg = file.mdb_get_int24(mdb, start + 5);
            if (file.mdb_read_alt_pg(mdb, lval_pg) != (long)mdb.fmt.pg_size) {
                return 0;
            }
            file.mdb_swap_pgbuf(mdb);
            int row_stop = ole_row != 0 ? file.mdb_get_int16(mdb, 10 + (ole_row - 1) * 2) & 0xFFF : mdb.fmt.pg_size - 1;
            int row_start = file.mdb_get_int16(mdb, 10 + ole_row * 2);
            int len = row_stop - row_start;
            if (dest != null) {
                dest.ba = new byte[len];
                System.arraycopy(mdb.pg_buf, row_start, dest.ba, 0, len);
            }
            file.mdb_swap_pgbuf(mdb);
            return len;
        }
        if (ole_flags == 0) {
            int row_start;
            byte ole_row = mdb.pg_buf[start + 4];
            int lval_pg = file.mdb_get_int24(mdb, start + 5);
            file.mdb_swap_pgbuf(mdb);
            int cur = 0;
            do {
                if (file.mdb_read_pg(mdb, lval_pg) != (long)mdb.fmt.pg_size) {
                    return 0;
                }
                int row_stop = ole_row != 0 ? file.mdb_get_int16(mdb, 10 + (ole_row - 1) * 2) & 0xFFF : mdb.fmt.pg_size - 1;
                row_start = file.mdb_get_int16(mdb, 10 + ole_row * 2);
                if (row_start > row_stop) {
                    row_start = 0;
                }
                int len = row_stop - row_start;
                if (dest != null) {
                    dest.ba = new byte[len];
                    try {
                        System.arraycopy(mdb.pg_buf, row_start + 4, dest.ba, cur, len - 4);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break;
                    }
                }
                cur += len - 4;
                ole_row = mdb.pg_buf[row_start];
            } while ((lval_pg = file.mdb_get_int24(mdb, row_start + 1)) != 0);
            file.mdb_swap_pgbuf(mdb);
            return cur;
        }
        return 0;
    }

    private static String mdb_num_to_string(MdbHandle mdb, int start, int datatype, int prec, int scale) {
        int l = file.unsign(mdb.pg_buf[start + 16]) * 256 * 256 * 256 + file.unsign(mdb.pg_buf[start + 15]) * 256 * 256 + file.unsign(mdb.pg_buf[start + 14]) * 256 + file.unsign(mdb.pg_buf[start + 13]);
        if (scale == 0) {
            return Integer.toString(l);
        }
        throw new RuntimeException("not ported yet");
    }
}

