/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import javax.xml.bind.DatatypeConverter;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Pixels;
import ome.xml.model.Reference;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.NonNegativeLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BinData
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(BinData.class);
    private byte[] base64Binary;
    private Boolean bigEndian;
    private NonNegativeLong length;
    private Compression compression;
    private Pixels pixels;

    public BinData() {
    }

    public BinData(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public BinData(BinData orig) {
        this.base64Binary = orig.base64Binary;
        this.bigEndian = orig.bigEndian;
        this.length = orig.length;
        this.compression = orig.compression;
        this.pixels = orig.pixels;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        String value_textContent = element.getTextContent();
        if (value_textContent.trim().length() > 0) {
            byte[] rawBytes = DatatypeConverter.parseBase64Binary((String)value_textContent);
            this.setBase64Binary(rawBytes);
        }
        if (element.hasAttribute("BigEndian")) {
            this.setBigEndian(Boolean.valueOf(element.getAttribute("BigEndian")));
        }
        if (element.hasAttribute("Length")) {
            this.setLength(NonNegativeLong.valueOf(element.getAttribute("Length")));
        }
        if (element.hasAttribute("Compression")) {
            this.setCompression(Compression.fromString(element.getAttribute("Compression")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public byte[] getBase64Binary() {
        return this.base64Binary;
    }

    public void setBase64Binary(byte[] base64Binary) {
        this.base64Binary = base64Binary;
    }

    public Boolean getBigEndian() {
        return this.bigEndian;
    }

    public void setBigEndian(Boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public NonNegativeLong getLength() {
        return this.length;
    }

    public void setLength(NonNegativeLong length) {
        this.length = length;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public Pixels getPixels() {
        return this.pixels;
    }

    public void setPixels(Pixels pixels_BackReference) {
        this.pixels = pixels_BackReference;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element BinData_element) {
        if (BinData_element == null) {
            BinData_element = document.createElementNS(NAMESPACE, "BinData");
        }
        super.asXMLElement(document, BinData_element);
        if (this.base64Binary != null) {
            String encodedString = DatatypeConverter.printBase64Binary((byte[])this.base64Binary);
            BinData_element.setTextContent(encodedString);
        }
        if (this.bigEndian != null) {
            BinData_element.setAttribute("BigEndian", this.bigEndian.toString());
        }
        if (this.length != null) {
            BinData_element.setAttribute("Length", this.length.toString());
        }
        if (this.compression != null) {
            BinData_element.setAttribute("Compression", this.compression.toString());
        }
        if (this.pixels != null) {
            // empty if block
        }
        return BinData_element;
    }
}

