/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.mp4;

import com.drew.imaging.mp4.Mp4Handler;
import com.drew.lang.StreamReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.mp4.boxes.Box;
import java.io.IOException;
import java.io.InputStream;

public class Mp4Reader {
    private Mp4Reader() {
    }

    public static void extract(@NotNull InputStream inputStream, @NotNull Mp4Handler handler) {
        StreamReader reader = new StreamReader(inputStream);
        reader.setMotorolaByteOrder(true);
        Mp4Reader.processBoxes(reader, -1L, handler);
    }

    private static void processBoxes(StreamReader reader, long atomEnd, Mp4Handler handler) {
        try {
            while (atomEnd == -1L || reader.getPosition() < atomEnd) {
                Box box = new Box(reader);
                if (handler.shouldAcceptContainer(box)) {
                    Mp4Reader.processBoxes(reader, box.size + reader.getPosition() - 8L, handler.processContainer(box));
                    continue;
                }
                if (handler.shouldAcceptBox(box)) {
                    handler = handler.processBox(box, reader.getBytes((int)box.size - 8));
                    continue;
                }
                if (box.usertype != null) {
                    reader.skip(box.size - 24L);
                    continue;
                }
                if (box.size > 1L) {
                    reader.skip(box.size - 8L);
                    continue;
                }
                if (box.size != -1L) continue;
                break;
            }
        }
        catch (IOException e) {
            handler.addError(e.getMessage());
        }
    }
}

