/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.MissingLibraryException;
import loci.formats.ReaderWrapper;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import ome.units.UNITS;
import ome.units.quantity.Angle;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.UnitsTime;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PrimitiveNumber;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormatTools {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FormatTools.class);
    public static final int INT8 = 0;
    public static final int UINT8 = 1;
    public static final int INT16 = 2;
    public static final int UINT16 = 3;
    public static final int INT32 = 4;
    public static final int UINT32 = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BIT = 8;
    private static final String[] pixelTypes = FormatTools.makePixelTypes();
    public static final String CHANNEL = "Channel";
    public static final String SPECTRA = "Spectra";
    public static final String LIFETIME = "Lifetime";
    public static final String POLARIZATION = "Polarization";
    public static final String PHASE = "Phase";
    public static final String FREQUENCY = "Frequency";
    public static final String ROTATION = "Rotation";
    public static final String ILLUMINATION = "Illumination";
    public static final int MUST_GROUP = 0;
    public static final int CAN_GROUP = 1;
    public static final int CANNOT_GROUP = 2;
    public static final String SERIES_NUM = "%s";
    public static final String SERIES_NAME = "%n";
    public static final String CHANNEL_NUM = "%c";
    public static final String CHANNEL_NAME = "%w";
    public static final String Z_NUM = "%z";
    public static final String T_NUM = "%t";
    public static final String TIMESTAMP = "%A";
    public static final String TILE_X = "%x";
    public static final String TILE_Y = "%y";
    public static final String TILE_NUM = "%m";
    public static final Properties VERSION_PROPERTIES = null;
    public static final String VCS_REVISION;
    @Deprecated
    public static final String VCS_SHORT_REVISION;
    public static final String DATE;
    public static final String YEAR;
    public static final String VERSION;
    public static final String CREATOR;
    @Deprecated
    public static final String PROPERTY_FILE;
    public static final String HCS_DOMAIN = "High-Content Screening (HCS)";
    public static final String LM_DOMAIN = "Light Microscopy";
    public static final String EM_DOMAIN = "Electron Microscopy (EM)";
    public static final String SPM_DOMAIN = "Scanning Probe Microscopy (SPM)";
    public static final String SEM_DOMAIN = "Scanning Electron Microscopy (SEM)";
    public static final String FLIM_DOMAIN = "Fluorescence-Lifetime Imaging";
    public static final String MEDICAL_DOMAIN = "Medical Imaging";
    public static final String HISTOLOGY_DOMAIN = "Histology";
    public static final String GEL_DOMAIN = "Gel/Blot Imaging";
    public static final String ASTRONOMY_DOMAIN = "Astronomy";
    public static final String GRAPHICS_DOMAIN = "Graphics";
    public static final String UNKNOWN_DOMAIN = "Unknown";
    public static final String[] NON_GRAPHICS_DOMAINS;
    public static final String[] NON_HCS_DOMAINS;
    public static final String[] NON_SPECIAL_DOMAINS;
    public static final String[] ALL_DOMAINS;
    public static final String URL_BIO_FORMATS = "https://www.openmicroscopy.org/bio-formats";
    public static final String URL_BIO_FORMATS_LIBRARIES;
    public static final String URL_OME_TIFF = "https://docs.openmicroscopy.org/latest/ome-model/ome-tiff/";

    static String[] makePixelTypes() {
        String[] pixelTypes = new String[]{"int8", "uint8", "int16", "uint16", "int32", "uint32", "float", "double", "bit"};
        return pixelTypes;
    }

    @Deprecated
    static Properties loadProperties() {
        Properties properties = new Properties();
        LOGGER.debug("loadProperties() is deprecated");
        return properties;
    }

    private static Manifest loadManifest() {
        String className = FormatTools.class.getSimpleName() + ".class";
        String classPath = FormatTools.class.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return null;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            return manifest;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private FormatTools() {
    }

    public static int getIndex(IFormatReader reader, int z, int c, int t) {
        String order = reader.getDimensionOrder();
        int zSize = reader.getSizeZ();
        int cSize = reader.getEffectiveSizeC();
        int tSize = reader.getSizeT();
        int num = reader.getImageCount();
        return FormatTools.getIndex(order, zSize, cSize, tSize, num, z, c, t);
    }

    public static int getIndex(IFormatReader reader, int z, int c, int t, int moduloZ, int moduloC, int moduloT) {
        String order = reader.getDimensionOrder();
        int zSize = reader.getSizeZ();
        int cSize = reader.getEffectiveSizeC();
        int tSize = reader.getSizeT();
        int moduloZSize = reader.getModuloZ().length();
        int moduloCSize = reader.getModuloC().length();
        int moduloTSize = reader.getModuloT().length();
        int num = reader.getImageCount();
        return FormatTools.getIndex(order, zSize, cSize, tSize, moduloZSize, moduloCSize, moduloTSize, num, z, c, t, moduloZ, moduloC, moduloT);
    }

    public static int getIndex(String order, int zSize, int cSize, int tSize, int num, int z, int c, int t) {
        int len0;
        int v2;
        int v1;
        int v0;
        if (order == null) {
            throw new IllegalArgumentException("Dimension order is null");
        }
        if (!order.startsWith("XY") && !order.startsWith("YX")) {
            throw new IllegalArgumentException("Invalid dimension order: " + order);
        }
        int iz = order.indexOf(90) - 2;
        int ic = order.indexOf(67) - 2;
        int it = order.indexOf(84) - 2;
        if (iz < 0 || iz > 2 || ic < 0 || ic > 2 || it < 0 || it > 2) {
            throw new IllegalArgumentException("Invalid dimension order: " + order);
        }
        if (zSize <= 0) {
            throw new IllegalArgumentException("Invalid Z size: " + zSize);
        }
        if (z < 0 || z >= zSize) {
            throw new IllegalArgumentException("Invalid Z index: " + z + "/" + zSize);
        }
        if (cSize <= 0) {
            throw new IllegalArgumentException("Invalid C size: " + cSize);
        }
        if (c < 0 || c >= cSize) {
            throw new IllegalArgumentException("Invalid C index: " + c + "/" + cSize);
        }
        if (tSize <= 0) {
            throw new IllegalArgumentException("Invalid T size: " + tSize);
        }
        if (t < 0 || t >= tSize) {
            throw new IllegalArgumentException("Invalid T index: " + t + "/" + tSize);
        }
        if (num <= 0) {
            throw new IllegalArgumentException("Invalid image count: " + num);
        }
        if (num != zSize * cSize * tSize) {
            throw new IllegalArgumentException("ZCT size vs image count mismatch (sizeZ=" + zSize + ", sizeC=" + cSize + ", sizeT=" + tSize + ", total=" + num + ")");
        }
        int n = iz == 0 ? z : (v0 = ic == 0 ? c : t);
        int n2 = iz == 1 ? z : (v1 = ic == 1 ? c : t);
        int n3 = iz == 2 ? z : (v2 = ic == 2 ? c : t);
        int n4 = iz == 0 ? zSize : (len0 = ic == 0 ? cSize : tSize);
        int len1 = iz == 1 ? zSize : (ic == 1 ? cSize : tSize);
        return v0 + v1 * len0 + v2 * len0 * len1;
    }

    public static int getIndex(String order, int zSize, int cSize, int tSize, int moduloZSize, int moduloCSize, int moduloTSize, int num, int z, int c, int t, int moduloZ, int moduloC, int moduloT) {
        return FormatTools.getIndex(order, zSize, cSize, tSize, num, z * moduloZSize + moduloZ, c * moduloCSize + moduloC, t * moduloTSize + moduloT);
    }

    public static int[] getZCTCoords(IFormatReader reader, int index) {
        String order = reader.getDimensionOrder();
        int zSize = reader.getSizeZ();
        int cSize = reader.getEffectiveSizeC();
        int tSize = reader.getSizeT();
        int num = reader.getImageCount();
        return FormatTools.getZCTCoords(order, zSize, cSize, tSize, num, index);
    }

    public static int[] getZCTModuloCoords(IFormatReader reader, int index) {
        String order = reader.getDimensionOrder();
        int zSize = reader.getSizeZ();
        int cSize = reader.getEffectiveSizeC();
        int tSize = reader.getSizeT();
        int moduloZSize = reader.getModuloZ().length();
        int moduloCSize = reader.getModuloC().length();
        int moduloTSize = reader.getModuloT().length();
        int num = reader.getImageCount();
        return FormatTools.getZCTCoords(order, zSize, cSize, tSize, moduloZSize, moduloCSize, moduloTSize, num, index);
    }

    public static int[] getZCTCoords(String order, int zSize, int cSize, int tSize, int num, int index) {
        int c;
        int z;
        int len0;
        if (order == null) {
            throw new IllegalArgumentException("Dimension order is null");
        }
        if (!order.startsWith("XY") && !order.startsWith("YX")) {
            throw new IllegalArgumentException("Invalid dimension order: " + order);
        }
        int iz = order.indexOf(90) - 2;
        int ic = order.indexOf(67) - 2;
        int it = order.indexOf(84) - 2;
        if (iz < 0 || iz > 2 || ic < 0 || ic > 2 || it < 0 || it > 2) {
            throw new IllegalArgumentException("Invalid dimension order: " + order);
        }
        if (zSize <= 0) {
            throw new IllegalArgumentException("Invalid Z size: " + zSize);
        }
        if (cSize <= 0) {
            throw new IllegalArgumentException("Invalid C size: " + cSize);
        }
        if (tSize <= 0) {
            throw new IllegalArgumentException("Invalid T size: " + tSize);
        }
        if (num <= 0) {
            throw new IllegalArgumentException("Invalid plane count: " + num);
        }
        if (num != zSize * cSize * tSize) {
            throw new IllegalArgumentException("ZCT size vs image count mismatch (sizeZ=" + zSize + ", sizeC=" + cSize + ", sizeT=" + tSize + ", total=" + num + ")");
        }
        if (index < 0 || index >= num) {
            throw new IllegalArgumentException("Invalid plane index: " + index + "/" + num);
        }
        int n = iz == 0 ? zSize : (len0 = ic == 0 ? cSize : tSize);
        int len1 = iz == 1 ? zSize : (ic == 1 ? cSize : tSize);
        int v0 = index % len0;
        int v1 = index / len0 % len1;
        int v2 = index / len0 / len1;
        int n2 = iz == 0 ? v0 : (z = iz == 1 ? v1 : v2);
        int n3 = ic == 0 ? v0 : (c = ic == 1 ? v1 : v2);
        int t = it == 0 ? v0 : (it == 1 ? v1 : v2);
        return new int[]{z, c, t};
    }

    public static int[] getZCTCoords(String order, int zSize, int cSize, int tSize, int moduloZSize, int moduloCSize, int moduloTSize, int num, int index) {
        int[] coords = FormatTools.getZCTCoords(order, zSize, cSize, tSize, num, index);
        return new int[]{coords[0] / moduloZSize, coords[1] / moduloCSize, coords[2] / moduloTSize, coords[0] % moduloZSize, coords[1] % moduloCSize, coords[2] % moduloTSize};
    }

    public static int getReorderedIndex(IFormatReader reader, String newOrder, int newIndex) throws FormatException {
        String origOrder = reader.getDimensionOrder();
        int zSize = reader.getSizeZ();
        int cSize = reader.getEffectiveSizeC();
        int tSize = reader.getSizeT();
        int num = reader.getImageCount();
        return FormatTools.getReorderedIndex(origOrder, newOrder, zSize, cSize, tSize, num, newIndex);
    }

    public static int getReorderedIndex(String origOrder, String newOrder, int zSize, int cSize, int tSize, int num, int newIndex) {
        int[] zct = FormatTools.getZCTCoords(newOrder, zSize, cSize, tSize, num, newIndex);
        return FormatTools.getIndex(origOrder, zSize, cSize, tSize, num, zct[0], zct[1], zct[2]);
    }

    public static int positionToRaster(int[] lengths, int[] pos) {
        int offset = 1;
        int raster = 0;
        for (int i = 0; i < pos.length; ++i) {
            raster += offset * pos[i];
            offset *= lengths[i];
        }
        return raster;
    }

    public static int[] rasterToPosition(int[] lengths, int raster) {
        return FormatTools.rasterToPosition(lengths, raster, new int[lengths.length]);
    }

    public static int[] rasterToPosition(int[] lengths, int raster, int[] pos) {
        int offset = 1;
        for (int i = 0; i < pos.length; ++i) {
            int offset1 = offset * lengths[i];
            int q = i < pos.length - 1 ? raster % offset1 : raster;
            pos[i] = q / offset;
            raster -= q;
            offset = offset1;
        }
        return pos;
    }

    public static int getRasterLength(int[] lengths) {
        int len = 1;
        for (int i = 0; i < lengths.length; ++i) {
            len *= lengths[i];
        }
        return len;
    }

    public static int pixelTypeFromString(String pixelTypeAsString) {
        String lowercaseTypeAsString = pixelTypeAsString.toLowerCase();
        for (int i = 0; i < pixelTypes.length; ++i) {
            if (!pixelTypes[i].equals(lowercaseTypeAsString)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown type: '" + pixelTypeAsString + "'");
    }

    public static String getPixelTypeString(int pixelType) {
        if (pixelType < 0 || pixelType >= pixelTypes.length) {
            throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
        }
        return pixelTypes[pixelType];
    }

    public static int getBytesPerPixel(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 1: 
            case 8: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public static int getBytesPerPixel(String pixelType) {
        return FormatTools.getBytesPerPixel(FormatTools.pixelTypeFromString(pixelType));
    }

    public static boolean isFloatingPoint(IFormatReader reader) {
        int originalSeries = reader.getSeries();
        for (int s2 = 0; s2 < reader.getSeriesCount(); ++s2) {
            reader.setSeries(s2);
            if (!FormatTools.isFloatingPoint(reader.getPixelType())) continue;
            reader.setSeries(originalSeries);
            return true;
        }
        reader.setSeries(originalSeries);
        return false;
    }

    public static boolean isFloatingPoint(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                return false;
            }
            case 6: 
            case 7: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public static boolean isSigned(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public static int pixelTypeFromBytes(int bytes, boolean signed, boolean fp) throws FormatException {
        switch (bytes) {
            case 1: {
                return signed ? 0 : 1;
            }
            case 2: {
                return signed ? 2 : 3;
            }
            case 4: {
                return fp ? 6 : (signed ? 4 : 5);
            }
            case 8: {
                return 7;
            }
        }
        throw new FormatException("Unsupported byte depth: " + bytes);
    }

    public static void assertId(String currentId, boolean notNull, int depth) {
        String header;
        String msg = null;
        if (currentId == null && notNull) {
            msg = "Current file should not be null; call setId(String) first";
        } else if (currentId != null && !notNull) {
            msg = "Current file should be null, but is '" + currentId + "'; call close() first";
        }
        if (msg == null) {
            return;
        }
        StackTraceElement[] ste = new Exception().getStackTrace();
        if (depth > 0 && ste.length > depth) {
            String c = ste[depth].getClassName();
            if (c.startsWith("loci.formats.")) {
                c = c.substring(c.lastIndexOf(".") + 1);
            }
            header = c + "." + ste[depth].getMethodName() + ": ";
        } else {
            header = "";
        }
        throw new IllegalStateException(header + msg);
    }

    public static void checkPlaneParameters(IFormatReader r, int no, int bufLength, int x, int y, int w, int h2) throws FormatException {
        FormatTools.assertId(r.getCurrentFile(), true, 2);
        FormatTools.checkPlaneNumber(r, no);
        FormatTools.checkTileSize(r, x, y, w, h2);
        if (bufLength >= 0) {
            FormatTools.checkBufferSize(r, bufLength, w, h2);
        }
    }

    public static void checkPlaneNumber(IFormatReader r, int no) throws FormatException {
        int imageCount = r.getImageCount();
        if (no < 0 || no >= imageCount) {
            throw new FormatException("Invalid image number: " + no + " (series=" + r.getSeries() + ", imageCount=" + imageCount + ")");
        }
    }

    public static void checkTileSize(IFormatReader r, int x, int y, int w, int h2) throws FormatException {
        int width = r.getSizeX();
        int height = r.getSizeY();
        if (x < 0 || y < 0 || w < 0 || h2 < 0 || x + w > width || y + h2 > height) {
            throw new FormatException("Invalid tile size: x=" + x + ", y=" + y + ", w=" + w + ", h=" + h2);
        }
    }

    public static void checkBufferSize(IFormatReader r, int len) throws FormatException {
        FormatTools.checkBufferSize(r, len, r.getSizeX(), r.getSizeY());
    }

    public static void checkBufferSize(IFormatReader r, int len, int w, int h2) throws FormatException {
        int size = FormatTools.getPlaneSize(r, w, h2);
        if (size > len) {
            throw new FormatException("Buffer too small (got " + len + ", expected " + size + ").");
        }
    }

    public static boolean validStream(RandomAccessInputStream stream, int len, boolean littleEndian) throws IOException {
        stream.seek(0L);
        stream.order(littleEndian);
        return stream.length() >= (long)len;
    }

    public static int getPlaneSize(IFormatReader r) {
        return FormatTools.getPlaneSize(r, r.getSizeX(), r.getSizeY());
    }

    public static int getPlaneSize(IFormatReader r, int w, int h2) {
        return w * h2 * r.getRGBChannelCount() * FormatTools.getBytesPerPixel(r.getPixelType());
    }

    public static String getTileFilename(int tileX, int tileY, int tileIndex, String pattern) {
        String filename = pattern;
        filename = filename.replaceAll(TILE_X, String.valueOf(tileX));
        filename = filename.replaceAll(TILE_Y, String.valueOf(tileY));
        filename = filename.replaceAll(TILE_NUM, String.valueOf(tileIndex));
        return filename;
    }

    public static String getFilename(int series, int image, IFormatReader r, String pattern) throws FormatException, IOException {
        return FormatTools.getFilename(series, image, r, pattern, false);
    }

    public static String getFilename(int series, int image, IFormatReader r, String pattern, boolean padded) throws FormatException, IOException {
        MetadataStore store = r.getMetadataStore();
        MetadataRetrieve retrieve = store instanceof MetadataRetrieve ? (MetadataRetrieve)((Object)store) : new DummyMetadata();
        return FormatTools.getFilename(series, image, retrieve, pattern, padded);
    }

    public static String getFilename(int series, int image, MetadataRetrieve retrieve, String pattern, boolean padded) throws FormatException, IOException {
        String sPlaces = "%d";
        if (padded) {
            sPlaces = "%0" + String.valueOf(retrieve.getImageCount()).length() + "d";
        }
        String filename = pattern.replaceAll(SERIES_NUM, String.format(sPlaces, series));
        String imageName = retrieve.getImageName(series);
        if (imageName == null) {
            imageName = "Series" + series;
        }
        imageName = imageName.replaceAll("/", "_");
        imageName = imageName.replaceAll("\\\\", "_");
        filename = filename.replaceAll(SERIES_NAME, imageName);
        DimensionOrder order = retrieve.getPixelsDimensionOrder(series);
        int sizeC = retrieve.getChannelCount(series);
        int sizeT = (Integer)retrieve.getPixelsSizeT(series).getValue();
        int sizeZ = (Integer)retrieve.getPixelsSizeZ(series).getValue();
        int[] coordinates = FormatTools.getZCTCoords(order.getValue(), sizeZ, sizeC, sizeT, sizeZ * sizeC * sizeT, image);
        String zPlaces = "%d";
        String tPlaces = "%d";
        String cPlaces = "%d";
        if (padded) {
            zPlaces = "%0" + String.valueOf(sizeZ).length() + "d";
            tPlaces = "%0" + String.valueOf(sizeT).length() + "d";
            cPlaces = "%0" + String.valueOf(sizeC).length() + "d";
        }
        filename = filename.replaceAll(Z_NUM, String.format(zPlaces, coordinates[0]));
        filename = filename.replaceAll(T_NUM, String.format(tPlaces, coordinates[2]));
        filename = filename.replaceAll(CHANNEL_NUM, String.format(cPlaces, coordinates[1]));
        String channelName = retrieve.getChannelName(series, coordinates[1]);
        if (channelName == null) {
            channelName = String.valueOf(coordinates[1]);
        }
        channelName = channelName.replaceAll("/", "_");
        channelName = channelName.replaceAll("\\\\", "_");
        filename = filename.replaceAll(CHANNEL_NAME, channelName);
        Timestamp timestamp = retrieve.getImageAcquisitionDate(series);
        long stamp = 0L;
        String date = null;
        if (timestamp != null) {
            Time deltaT;
            date = (String)timestamp.getValue();
            if (retrieve.getPlaneCount(series) > image && (deltaT = retrieve.getPlaneDeltaT(series, image)) != null) {
                stamp = (long)(deltaT.value(UNITS.SECOND).doubleValue() * 1000.0);
            }
            stamp += DateTools.getTime(date, "yyyy-MM-dd'T'HH:mm:ss");
        } else {
            stamp = System.currentTimeMillis();
        }
        date = DateTools.convertDate(stamp, 0);
        filename = filename.replaceAll(TIMESTAMP, date);
        return filename;
    }

    public static String[] getFilenames(String pattern, IFormatReader r) throws FormatException, IOException {
        Vector<String> filenames = new Vector<String>();
        String filename = null;
        for (int series = 0; series < r.getSeriesCount(); ++series) {
            r.setSeries(series);
            for (int image = 0; image < r.getImageCount(); ++image) {
                filename = FormatTools.getFilename(series, image, r, pattern);
                if (filenames.contains(filename)) continue;
                filenames.add(filename);
            }
        }
        return filenames.toArray(new String[0]);
    }

    public static int getImagesPerFile(String pattern, IFormatReader r) throws FormatException, IOException {
        String[] filenames = FormatTools.getFilenames(pattern, r);
        int totalPlanes = 0;
        for (int series = 0; series < r.getSeriesCount(); ++series) {
            r.setSeries(series);
            totalPlanes += r.getImageCount();
        }
        return totalPlanes / filenames.length;
    }

    public static IFormatReader getReader(IFormatReader r, Class<? extends IFormatReader> c) {
        IFormatReader[] underlying = r.getUnderlyingReaders();
        if (underlying != null) {
            int i;
            for (i = 0; i < underlying.length; ++i) {
                if (!underlying[i].getClass().isInstance(c)) continue;
                return underlying[i];
            }
            for (i = 0; i < underlying.length; ++i) {
                IFormatReader t = FormatTools.getReader(underlying[i], c);
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }

    public static boolean equalReaders(IFormatReader a, IFormatReader b) {
        IFormatReader copyWrapper = a;
        IFormatReader realWrapper = b;
        while (copyWrapper != null) {
            if (!copyWrapper.getClass().equals(realWrapper.getClass())) {
                return false;
            }
            if (copyWrapper instanceof ReaderWrapper) {
                copyWrapper = ((ReaderWrapper)copyWrapper).getReader();
                realWrapper = ((ReaderWrapper)realWrapper).getReader();
                continue;
            }
            copyWrapper = null;
            realWrapper = null;
        }
        if (a.isNormalized() != b.isNormalized()) {
            return false;
        }
        if (a.isOriginalMetadataPopulated() != b.isOriginalMetadataPopulated()) {
            return false;
        }
        if (a.isGroupFiles() != b.isGroupFiles()) {
            return false;
        }
        if (a.isMetadataFiltered() != b.isMetadataFiltered()) {
            return false;
        }
        if (a.hasFlattenedResolutions() != b.hasFlattenedResolutions()) {
            return false;
        }
        return a.getMetadataOptions().getMetadataLevel().equals((Object)b.getMetadataOptions().getMetadataLevel());
    }

    public static byte[] openThumbBytes(IFormatReader reader, int no) throws FormatException, IOException {
        ReflectedUniverse r = new ReflectedUniverse();
        byte[][] bytes = null;
        try {
            r.exec("import loci.formats.gui.AWTImageTools");
            int planeSize = FormatTools.getPlaneSize(reader);
            byte[] plane = null;
            if (planeSize < 0) {
                int width = reader.getThumbSizeX() * 4;
                int height = reader.getThumbSizeY() * 4;
                int x = (reader.getSizeX() - width) / 2;
                int y = (reader.getSizeY() - height) / 2;
                plane = reader.openBytes(no, x, y, width, height);
            } else {
                plane = reader.openBytes(no);
            }
            r.setVar("plane", plane);
            r.setVar("reader", reader);
            r.setVar("sizeX", reader.getSizeX());
            r.setVar("sizeY", reader.getSizeY());
            r.setVar("thumbSizeX", reader.getThumbSizeX());
            r.setVar("thumbSizeY", reader.getThumbSizeY());
            r.setVar("little", reader.isLittleEndian());
            r.setVar("normal", true);
            r.exec("img = AWTImageTools.openImage(plane, reader, sizeX, sizeY, normal)");
            r.exec("img = AWTImageTools.makeUnsigned(img)");
            r.exec("thumb = AWTImageTools.scale(img, thumbSizeX, thumbSizeY, false)");
            bytes = (byte[][])r.exec("AWTImageTools.getPixelBytes(thumb, little)");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        int rgbChannelCount = reader.getRGBChannelCount();
        byte[] rtn = new byte[rgbChannelCount * bytes[0].length];
        if (!reader.isInterleaved()) {
            for (int i = 0; i < rgbChannelCount; ++i) {
                System.arraycopy(bytes[i], 0, rtn, bytes[0].length * i, bytes[i].length);
            }
        } else {
            int bpp = FormatTools.getBytesPerPixel(reader.getPixelType());
            for (int i = 0; i < bytes[0].length; i += bpp) {
                for (int j = 0; j < rgbChannelCount; ++j) {
                    System.arraycopy(bytes[j], i, rtn, i * rgbChannelCount + j * bpp, bpp);
                }
            }
        }
        return rtn;
    }

    public static void convert(String input, String output) throws FormatException, IOException {
        ImageReader reader = new ImageReader();
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = factory.getInstance(OMEXMLService.class);
            reader.setMetadataStore(service.createOMEXMLMetadata());
        }
        catch (DependencyException de) {
            throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, de);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        reader.setId(input);
        ImageWriter writer = new ImageWriter();
        FormatTools.convert(reader, writer, output);
    }

    public static void convert(IFormatReader input, IFormatWriter output, String outputFile) throws FormatException, IOException {
        MetadataStore store = input.getMetadataStore();
        MetadataRetrieve meta = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = factory.getInstance(OMEXMLService.class);
            meta = service.asRetrieve(store);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, de);
        }
        output.setMetadataRetrieve(meta);
        output.setId(outputFile);
        for (int series = 0; series < input.getSeriesCount(); ++series) {
            input.setSeries(series);
            output.setSeries(series);
            byte[] buf = new byte[FormatTools.getPlaneSize(input)];
            for (int image = 0; image < input.getImageCount(); ++image) {
                input.openBytes(image, buf);
                output.saveBytes(image, buf);
            }
        }
        input.close();
        output.close();
    }

    public static long[] defaultMinMax(int pixelType) {
        long min2 = 0L;
        long max = 0L;
        switch (pixelType) {
            case 0: {
                min2 = -128L;
                max = 127L;
                break;
            }
            case 2: {
                min2 = -32768L;
                max = 32767L;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                min2 = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
                break;
            }
            case 1: {
                max = (long)Math.pow(2.0, 8.0) - 1L;
                break;
            }
            case 3: {
                max = (long)Math.pow(2.0, 16.0) - 1L;
                break;
            }
            case 5: {
                max = (long)Math.pow(2.0, 32.0) - 1L;
                break;
            }
            case 8: {
                max = 1L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid pixel type");
            }
        }
        long[] values = new long[]{min2, max};
        return values;
    }

    public static boolean isPositiveValue(Double value) {
        return value != null && value - 1.0E-6 > 0.0 && value < Double.POSITIVE_INFINITY;
    }

    public static Length getWavelength(Double value, String unit) {
        if (unit != null) {
            try {
                UnitsLength ul = UnitsLength.fromString(unit);
                return UnitsLength.create(value, ul);
            }
            catch (EnumerationException enumerationException) {
                // empty catch block
            }
        }
        return new Length(value, UNITS.NANOMETER);
    }

    public static Time getTime(Double value, String unit) {
        if (unit != null) {
            try {
                UnitsTime ut = UnitsTime.fromString(unit);
                return UnitsTime.create(value, ut);
            }
            catch (EnumerationException enumerationException) {
                // empty catch block
            }
        }
        return new Time(value, UNITS.SECOND);
    }

    public static Length getStagePosition(Double value, Unit<Length> unit) {
        if (value == null || value.isNaN() || value.isInfinite()) {
            LOGGER.debug("Expected float value for stage position; got {}", (Object)value);
            return null;
        }
        if (unit == null) {
            LOGGER.debug("Expected valid unit for stage position; got {}", (Object)unit);
            return null;
        }
        return new Length(value, unit);
    }

    public static Length getStagePosition(Double value, String unit) {
        Unit<Length> baseunit = null;
        try {
            baseunit = UnitsLengthEnumHandler.getBaseUnit(UnitsLength.fromString(unit));
        }
        catch (EnumerationException e) {
            LOGGER.warn("Invalid base unit: using default reference frame unit");
            LOGGER.debug(e.getMessage());
            baseunit = UNITS.REFERENCEFRAME;
        }
        return FormatTools.getStagePosition(value, baseunit);
    }

    public static Length getPhysicalSize(Double value, String unit) {
        if (value != null && value != 0.0 && value < Double.POSITIVE_INFINITY) {
            if (unit != null) {
                try {
                    UnitsLength ul = UnitsLength.fromString(unit);
                    int ordinal = ul.ordinal();
                    Length returnLength = UnitsLength.create(value, ul);
                    if (returnLength.value().doubleValue() > 1.0E-6 && returnLength.value().doubleValue() < Double.POSITIVE_INFINITY) {
                        return returnLength;
                    }
                    while (returnLength.value().doubleValue() < 1.0E-6 && ordinal < UnitsLength.values().length - 3) {
                        ul = UnitsLength.values()[++ordinal];
                        Length tempLength = UnitsLength.create(0, ul);
                        returnLength = UnitsLength.create(returnLength.value(tempLength.unit()), ul);
                    }
                    if (returnLength.value().doubleValue() > 1.0E-6 && returnLength.value().doubleValue() < Double.POSITIVE_INFINITY) {
                        return returnLength;
                    }
                    LOGGER.debug("Expected positive value for PhysicalSize; got {}", (Object)value);
                    return null;
                }
                catch (EnumerationException enumerationException) {
                    // empty catch block
                }
            }
            return new Length(value, UNITS.MICROMETER);
        }
        LOGGER.debug("Expected positive value for PhysicalSize; got {}", (Object)value);
        return null;
    }

    public static Length getPhysicalSizeX(Double value) {
        return FormatTools.getPhysicalSizeX(value, UNITS.MICROMETER);
    }

    public static Length getPhysicalSizeX(Double value, String unit) {
        return FormatTools.getPhysicalSize(value, unit);
    }

    public static Length getPhysicalSizeX(Double value, Unit<Length> unit) {
        return FormatTools.getPhysicalSize(value, unit.getSymbol());
    }

    public static Length getPhysicalSizeY(Double value) {
        return FormatTools.getPhysicalSizeY(value, UNITS.MICROMETER);
    }

    public static Length getPhysicalSizeY(Double value, String unit) {
        return FormatTools.getPhysicalSize(value, unit);
    }

    public static Length getPhysicalSizeY(Double value, Unit<Length> unit) {
        return FormatTools.getPhysicalSize(value, unit.getSymbol());
    }

    public static Length getPhysicalSizeZ(Double value) {
        return FormatTools.getPhysicalSizeZ(value, UNITS.MICROMETER);
    }

    public static Length getPhysicalSizeZ(Double value, String unit) {
        return FormatTools.getPhysicalSize(value, unit);
    }

    public static Length getPhysicalSizeZ(Double value, Unit<Length> unit) {
        return FormatTools.getPhysicalSize(value, unit.getSymbol());
    }

    public static Length getEmissionWavelength(Double value) {
        if (value != null && value - 1.0E-6 > 0.0 && value < Double.POSITIVE_INFINITY) {
            return FormatTools.createLength(new PositiveFloat(value), UNITS.NANOMETER);
        }
        LOGGER.debug("Expected positive value for EmissionWavelength; got {}", (Object)value);
        return null;
    }

    public static Length getExcitationWavelength(Double value) {
        if (value != null && value - 1.0E-6 > 0.0 && value < Double.POSITIVE_INFINITY) {
            return FormatTools.createLength(new PositiveFloat(value), UNITS.NANOMETER);
        }
        LOGGER.debug("Expected positive value for ExcitationWavelength; got {}", (Object)value);
        return null;
    }

    public static Length getWavelength(Double value) {
        if (value != null && value > 0.0) {
            return new Length(value, UNITS.NANOMETER);
        }
        LOGGER.debug("Expected positive value for Wavelength; got {}", (Object)value);
        return null;
    }

    public static PositiveInteger getMaxFieldCount(Integer value) {
        if (value != null && value > 0) {
            return new PositiveInteger(value);
        }
        LOGGER.debug("Expected positive value for MaximumFieldCount; got {}", (Object)value);
        return null;
    }

    public static Length getCutIn(Double value) {
        if (value != null && value > 0.0) {
            return new Length(value, UNITS.NANOMETER);
        }
        LOGGER.debug("Expected positive value for CutIn; got {}", (Object)value);
        return null;
    }

    public static Length getCutOut(Double value) {
        if (value != null && value > 0.0) {
            return new Length(value, UNITS.NANOMETER);
        }
        LOGGER.debug("Expected positive value for CutOut; got {}", (Object)value);
        return null;
    }

    public static Length getFontSize(Integer value) {
        if (value != null && value >= 0) {
            return new Length(value, UNITS.POINT);
        }
        LOGGER.debug("Expected non-negative value for FontSize; got {}", (Object)value);
        return null;
    }

    public static Angle createAngle(Double value, Unit<Angle> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Angle(value, valueUnit);
    }

    public static Angle createAngle(Integer value, Unit<Angle> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Angle(value, valueUnit);
    }

    public static <T extends PrimitiveNumber> Angle createAngle(T value, Unit<Angle> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Angle(value.getNumberValue(), valueUnit);
    }

    public static ElectricPotential createElectricPotential(Double value, Unit<ElectricPotential> valueUnit) {
        if (value == null) {
            return null;
        }
        return new ElectricPotential(value, valueUnit);
    }

    public static ElectricPotential createElectricPotential(Integer value, Unit<ElectricPotential> valueUnit) {
        if (value == null) {
            return null;
        }
        return new ElectricPotential(value, valueUnit);
    }

    public static <T extends PrimitiveNumber> ElectricPotential createElectricPotential(T value, Unit<ElectricPotential> valueUnit) {
        if (value == null) {
            return null;
        }
        return new ElectricPotential(value.getNumberValue(), valueUnit);
    }

    public static Frequency createFrequency(Double value, Unit<Frequency> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Frequency(value, valueUnit);
    }

    public static Frequency createFrequency(Integer value, Unit<Frequency> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Frequency(value, valueUnit);
    }

    public static <T extends PrimitiveNumber> Frequency createFrequency(T value, Unit<Frequency> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Frequency(value.getNumberValue(), valueUnit);
    }

    public static Power createPower(Double value, Unit<Power> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Power(value, valueUnit);
    }

    public static Power createPower(Integer value, Unit<Power> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Power(value, valueUnit);
    }

    public static <T extends PrimitiveNumber> Power createPower(T value, Unit<Power> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Power(value.getNumberValue(), valueUnit);
    }

    public static Length createLength(Double value, Unit<Length> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Length(value, valueUnit);
    }

    public static Length createLength(Integer value, Unit<Length> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Length(value, valueUnit);
    }

    public static <T extends PrimitiveNumber> Length createLength(T value, Unit<Length> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Length(value.getNumberValue(), valueUnit);
    }

    public static Pressure createPressure(Double value, Unit<Pressure> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Pressure(value, valueUnit);
    }

    public static Pressure createPressure(Integer value, Unit<Pressure> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Pressure(value, valueUnit);
    }

    public static <T extends PrimitiveNumber> Pressure createPressure(T value, Unit<Pressure> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Pressure(value.getNumberValue(), valueUnit);
    }

    public static Temperature createTemperature(Double value, Unit<Temperature> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Temperature(value, valueUnit);
    }

    public static Temperature createTemperature(Integer value, Unit<Temperature> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Temperature(value, valueUnit);
    }

    public static <T extends PrimitiveNumber> Temperature createTemperature(T value, Unit<Temperature> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Temperature(value.getNumberValue(), valueUnit);
    }

    public static Time createTime(Double value, Unit<Time> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Time(value, valueUnit);
    }

    public static Time createTime(Integer value, Unit<Time> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Time(value, valueUnit);
    }

    public static <T extends PrimitiveNumber> Time createTime(T value, Unit<Time> valueUnit) {
        if (value == null) {
            return null;
        }
        return new Time(value.getNumberValue(), valueUnit);
    }

    public static Length parseLength(String s2) {
        return FormatTools.parseLength(s2, null);
    }

    public static Length parseLength(String s2, String defaultUnit) {
        Matcher m3 = Pattern.compile("\\s*([-e\\d.]+)\\s*([^\\d\\s].*?)?\\s*").matcher(s2);
        if (!m3.matches()) {
            LOGGER.warn("{} does not match a length", (Object)s2);
            return null;
        }
        Double value = DataTools.parseDouble(m3.group(1));
        if (value == null || value == Double.POSITIVE_INFINITY || value == Double.NEGATIVE_INFINITY) {
            LOGGER.warn("{} is not a valid length value", (Object)m3.group(1));
            return null;
        }
        String unit = m3.group(2);
        if (unit == null || unit.trim().length() == 0) {
            unit = defaultUnit;
        }
        Unit<Length> l = null;
        try {
            l = UnitsLengthEnumHandler.getBaseUnit(UnitsLength.fromString(unit));
        }
        catch (EnumerationException e) {
            LOGGER.warn("{} does not match a length unit!", (Object)unit);
            return null;
        }
        return FormatTools.createLength(value, l);
    }

    public static int getRequiredDirectories(String[] files) {
        String[] dirs;
        if (files == null || files.length == 0) {
            return 0;
        }
        StringBuilder commonParent = new StringBuilder();
        int dirCount = 0;
        for (String dir : dirs = files[0].split(File.separatorChar == '/' ? "/" : "\\\\")) {
            boolean canAppend = true;
            for (String f : files) {
                if (f.startsWith(commonParent.toString() + dir)) continue;
                canAppend = false;
                break;
            }
            if (!canAppend) continue;
            commonParent.append(dir);
            commonParent.append(File.separator);
            ++dirCount;
        }
        int maxDirCount = 0;
        for (String f : files) {
            int parentDirCount = f.split(File.separatorChar == '/' ? "/" : "\\\\").length - 1;
            if (parentDirCount <= maxDirCount) continue;
            maxDirCount = parentDirCount;
        }
        return Math.max(maxDirCount - dirCount, 0);
    }

    static {
        PROPERTY_FILE = null;
        Manifest manifest = FormatTools.loadManifest();
        Attributes attr = manifest != null ? manifest.getMainAttributes() : new Attributes();
        VERSION = attr.getValue("Implementation-Version") != null ? attr.getValue("Implementation-Version") : "(unknown version)";
        CREATOR = "OME Bio-Formats " + VERSION;
        VCS_REVISION = attr.getValue("Implementation-Build") != null ? attr.getValue("Implementation-Build") : "(unknown revision)";
        VCS_SHORT_REVISION = VCS_REVISION;
        if (attr.getValue("Implementation-Date") != null) {
            DATE = attr.getValue("Implementation-Date");
            YEAR = DATE.substring(DATE.lastIndexOf(32) + 1);
        } else {
            DATE = "(unknown date)";
            YEAR = "(unknown year)";
        }
        NON_GRAPHICS_DOMAINS = new String[]{LM_DOMAIN, EM_DOMAIN, SPM_DOMAIN, SEM_DOMAIN, FLIM_DOMAIN, MEDICAL_DOMAIN, HISTOLOGY_DOMAIN, GEL_DOMAIN, ASTRONOMY_DOMAIN, HCS_DOMAIN, UNKNOWN_DOMAIN};
        NON_HCS_DOMAINS = new String[]{LM_DOMAIN, EM_DOMAIN, SPM_DOMAIN, SEM_DOMAIN, FLIM_DOMAIN, MEDICAL_DOMAIN, HISTOLOGY_DOMAIN, GEL_DOMAIN, ASTRONOMY_DOMAIN, UNKNOWN_DOMAIN};
        NON_SPECIAL_DOMAINS = new String[]{LM_DOMAIN, EM_DOMAIN, SPM_DOMAIN, SEM_DOMAIN, FLIM_DOMAIN, MEDICAL_DOMAIN, HISTOLOGY_DOMAIN, GEL_DOMAIN, ASTRONOMY_DOMAIN, UNKNOWN_DOMAIN};
        ALL_DOMAINS = new String[]{HCS_DOMAIN, LM_DOMAIN, EM_DOMAIN, SPM_DOMAIN, SEM_DOMAIN, FLIM_DOMAIN, MEDICAL_DOMAIN, HISTOLOGY_DOMAIN, GEL_DOMAIN, ASTRONOMY_DOMAIN, GRAPHICS_DOMAIN, UNKNOWN_DOMAIN};
        URL_BIO_FORMATS_LIBRARIES = "https://docs.openmicroscopy.org/bio-formats/" + VERSION + "/developers/java-library.html";
    }
}

