/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatWriter;
import loci.formats.MetadataTools;
import loci.formats.codec.CompressionType;
import loci.formats.gui.LegacyQTTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.LegacyQTWriter;

public class QTWriter
extends FormatWriter {
    public static final int CODEC_MOTION_JPEG_B = 1835692130;
    public static final int CODEC_CINEPAK = 1668704612;
    public static final int CODEC_ANIMATION = 1919706400;
    public static final int CODEC_H_263 = 1748121139;
    public static final int CODEC_SORENSON = 1398165809;
    public static final int CODEC_SORENSON_3 = 1398165811;
    public static final int CODEC_MPEG_4 = 1836070006;
    public static final int CODEC_RAW = 0;
    public static final int QUALITY_LOW = 256;
    public static final int QUALITY_NORMAL = 512;
    public static final int QUALITY_HIGH = 768;
    public static final int QUALITY_MAXIMUM = 1023;
    private static final long BYTE_COUNT_OFFSET = 8L;
    protected int codec = 0;
    protected int quality = 512;
    protected int numBytes;
    protected List<Integer> offsets;
    protected int created;
    protected int pad;
    protected boolean needLegacy = false;
    protected LegacyQTWriter legacy;
    private int numWritten = 0;

    public QTWriter() {
        super("QuickTime", "mov");
        LegacyQTTools tools = new LegacyQTTools();
        this.compressionTypes = tools.canDoQT() ? new String[]{CompressionType.UNCOMPRESSED.getCompression(), CompressionType.CINEPAK.getCompression(), CompressionType.ANIMATION.getCompression(), CompressionType.H_263.getCompression(), CompressionType.SORENSON.getCompression(), CompressionType.SORENSON_3.getCompression(), CompressionType.MPEG_4.getCompression()} : new String[]{CompressionType.UNCOMPRESSED.getCompression()};
    }

    public void setCodec(int codec) {
        this.codec = codec;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h2);
        if (this.needLegacy) {
            this.legacy.saveBytes(no, buf, x, y, w, h2);
            return;
        }
        MetadataRetrieve r = this.getMetadataRetrieve();
        int width = (Integer)r.getPixelsSizeX(this.series).getValue();
        int height = (Integer)r.getPixelsSizeY(this.series).getValue();
        int nChannels = this.getSamplesPerPixel();
        int planeSize = width * height * nChannels;
        if (!this.initialized[this.series][no]) {
            this.initialized[this.series][no] = true;
            this.setCodec();
            if (this.codec != 0) {
                this.needLegacy = true;
                this.legacy.setId(this.currentId);
                this.legacy.saveBytes(no, buf, x, y, w, h2);
                return;
            }
            this.numBytes += planeSize + this.pad * height;
            this.out.seek(8L);
            this.out.writeInt(this.numBytes + 8);
            this.out.seek(this.offsets.get(no).intValue());
            if (!this.isFullPlane(x, y, w, h2)) {
                this.out.skipBytes(planeSize + this.pad * height);
            }
        }
        this.out.seek(this.offsets.get(no) + y * (nChannels * width + this.pad));
        byte[] tmp = new byte[buf.length];
        if (nChannels == 1 && !this.needLegacy) {
            for (int i = 0; i < buf.length; ++i) {
                tmp[i] = (byte)(255 - buf[i]);
            }
        } else {
            System.arraycopy(buf, 0, tmp, 0, buf.length);
        }
        if (!this.interleaved) {
            byte[] tmp2 = new byte[tmp.length];
            System.arraycopy(tmp, 0, tmp2, 0, tmp.length);
            for (int i = 0; i < tmp.length; ++i) {
                int c = i / (w * h2);
                int index = i % (w * h2);
                tmp[index * nChannels + c] = tmp2[i];
            }
        }
        int rowLen = tmp.length / h2;
        for (int row = 0; row < h2; ++row) {
            this.out.skipBytes(nChannels * x);
            this.out.write(tmp, row * rowLen, rowLen);
            for (int i = 0; i < this.pad; ++i) {
                this.out.writeByte(0);
            }
            if (row >= h2 - 1) continue;
            this.out.skipBytes(nChannels * (width - w - x));
        }
        ++this.numWritten;
        this.writeFooter();
    }

    @Override
    public boolean canDoStacks() {
        return true;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return new int[]{1};
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
        MetadataRetrieve r = this.getMetadataRetrieve();
        MetadataTools.verifyMinimumPopulated(r, this.series);
        int width = (Integer)r.getPixelsSizeX(this.series).getValue();
        int height = (Integer)r.getPixelsSizeY(this.series).getValue();
        int nChannels = this.getSamplesPerPixel();
        int planeSize = width * height * nChannels;
        int n = this.pad = nChannels > 1 ? 0 : (4 - width % 4) % 4;
        if (this.legacy == null) {
            this.legacy = new LegacyQTWriter();
            this.legacy.setCodec(this.codec);
            this.legacy.setMetadataRetrieve(r);
        }
        this.offsets = new ArrayList<Integer>();
        this.created = (int)System.currentTimeMillis();
        this.numBytes = 0;
        if (this.out.length() == 0L) {
            this.writeAtom(8, "wide");
            this.writeAtom(this.numBytes + 8, "mdat");
            this.numWritten = 0;
        } else {
            this.out.seek(8L);
            try (RandomAccessInputStream in = new RandomAccessInputStream(this.currentId);){
                in.seek(8L);
                this.numBytes = in.readInt() - 8;
                this.numWritten = this.numBytes / (planeSize + this.pad * height);
            }
        }
        for (int i = 0; i < this.getPlaneCount(); ++i) {
            this.offsets.add(16 + i * (planeSize + this.pad * height));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.writeFooter();
        }
        super.close();
        this.numBytes = 0;
        this.created = 0;
        this.offsets = null;
        this.pad = 0;
        this.numWritten = 0;
    }

    private void setCodec() {
        if (this.compression == null) {
            return;
        }
        if (this.compression.equals("Uncompressed")) {
            this.codec = 0;
        } else if (this.compression.equals("Motion JPEG-B")) {
            this.codec = 1835692130;
        } else if (this.compression.equals("Cinepak")) {
            this.codec = 1668704612;
        } else if (this.compression.equals("Animation")) {
            this.codec = 1919706400;
        } else if (this.compression.equals("H.263")) {
            this.codec = 1748121139;
        } else if (this.compression.equals("Sorenson")) {
            this.codec = 1398165809;
        } else if (this.compression.equals("Sorenson 3")) {
            this.codec = 1398165811;
        } else if (this.compression.equals("MPEG 4")) {
            this.codec = 1836070006;
        }
    }

    private void writeFooter() throws IOException {
        int i;
        this.out.seek(this.out.length());
        MetadataRetrieve r = this.getMetadataRetrieve();
        int width = (Integer)r.getPixelsSizeX(this.series).getValue();
        int height = (Integer)r.getPixelsSizeY(this.series).getValue();
        int nChannels = this.getSamplesPerPixel();
        int timeScale = 1000;
        int duration = (int)((double)this.numWritten * ((double)timeScale / (double)this.fps));
        int bitsPerPixel = nChannels > 1 ? 24 : 40;
        int channels = bitsPerPixel >= 40 ? 1 : 3;
        int atomLength = 685 + 8 * this.numWritten;
        this.writeAtom(atomLength, "moov");
        this.writeAtom(108, "mvhd");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeInt(this.created);
        this.out.writeInt((int)System.currentTimeMillis());
        this.out.writeInt(timeScale);
        this.out.writeInt(duration);
        this.out.write(new byte[]{0, 1, 0, 0});
        this.out.write(new byte[]{0, -1, 0, 0, 0, 0, 0, 0, 0, 0});
        this.writeRotationMatrix();
        this.out.writeShort(0);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeInt(2);
        this.writeAtom(atomLength -= 116, "trak");
        this.writeAtom(92, "tkhd");
        this.out.writeShort(0);
        this.out.writeShort(15);
        this.out.writeInt(this.created);
        this.out.writeInt((int)System.currentTimeMillis());
        this.out.writeInt(1);
        this.out.writeInt(0);
        this.out.writeInt(duration);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeShort(0);
        this.out.writeInt(0);
        this.writeRotationMatrix();
        this.out.writeInt(width);
        this.out.writeInt(height);
        this.out.writeShort(0);
        this.writeAtom(36, "edts");
        this.writeAtom(28, "elst");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeInt(1);
        this.out.writeInt(duration);
        this.out.writeShort(0);
        this.out.writeInt(1);
        this.out.writeShort(0);
        this.writeAtom(atomLength -= 136, "mdia");
        this.writeAtom(32, "mdhd");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeInt(this.created);
        this.out.writeInt((int)System.currentTimeMillis());
        this.out.writeInt(timeScale);
        this.out.writeInt(duration);
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.writeAtom(58, "hdlr");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeBytes("mhlr");
        this.out.writeBytes("vide");
        this.out.writeBytes("appl");
        this.out.write(new byte[]{16, 0, 0, 0, 0, 1, 1, 11, 25});
        this.out.writeBytes("Apple Video Media Handler");
        this.writeAtom(atomLength -= 98, "minf");
        this.writeAtom(20, "vmhd");
        this.out.writeShort(0);
        this.out.writeShort(1);
        this.out.writeShort(64);
        this.out.writeShort(32768);
        this.out.writeShort(32768);
        this.out.writeShort(32768);
        this.writeAtom(57, "hdlr");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeBytes("dhlr");
        this.out.writeBytes("alis");
        this.out.writeBytes("appl");
        this.out.write(new byte[]{16, 0, 0, 1, 0, 1, 1, 31, 24});
        this.out.writeBytes("Apple Alias Data Handler");
        this.writeAtom(36, "dinf");
        this.writeAtom(28, "dref");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeShort(1);
        this.out.write(new byte[]{0, 0, 0, 12});
        this.out.writeBytes("alis");
        this.out.writeShort(0);
        this.out.writeShort(1);
        this.writeAtom(atomLength -= 121, "stbl");
        this.writeAtom(118, "stsd");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeInt(1);
        this.out.write(new byte[]{0, 0, 0, 102});
        this.out.writeBytes("raw ");
        this.out.write(new byte[]{0, 0, 0, 0, 0, 0});
        this.out.writeShort(1);
        this.out.writeShort(1);
        this.out.writeShort(1);
        this.out.writeBytes("appl");
        this.out.writeInt(0);
        this.out.writeInt(768);
        this.out.writeShort(width);
        this.out.writeShort(height);
        byte[] dpi = new byte[]{0, 72, 0, 0};
        this.out.write(dpi);
        this.out.write(dpi);
        this.out.writeInt(0);
        this.out.writeShort(1);
        this.out.writeShort(12);
        this.out.writeBytes("Uncompressed");
        this.out.writeInt(bitsPerPixel);
        this.out.writeInt(bitsPerPixel);
        this.out.writeInt(bitsPerPixel);
        this.out.writeInt(bitsPerPixel);
        this.out.writeInt(bitsPerPixel);
        this.out.writeShort(bitsPerPixel);
        this.out.writeInt(65535);
        this.out.write(new byte[]{12, 103, 97, 108});
        this.out.write(new byte[]{97, 1, -52, -52, 0, 0, 0, 0});
        this.writeAtom(24, "stts");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeInt(1);
        this.out.writeInt(this.numWritten);
        this.out.writeInt((int)((double)timeScale / (double)this.fps));
        this.writeAtom(28, "stsc");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeInt(1);
        this.out.writeInt(1);
        this.out.writeInt(1);
        this.out.writeInt(1);
        this.writeAtom(20 + 4 * this.numWritten, "stsz");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeInt(0);
        this.out.writeInt(this.numWritten);
        for (i = 0; i < this.numWritten; ++i) {
            this.out.writeInt(channels * height * (width + this.pad));
        }
        this.writeAtom(16 + 4 * this.numWritten, "stco");
        this.out.writeShort(0);
        this.out.writeShort(0);
        this.out.writeInt(this.numWritten);
        for (i = 0; i < this.numWritten; ++i) {
            this.out.writeInt(this.offsets.get(i));
        }
    }

    private void writeRotationMatrix() throws IOException {
        this.out.writeInt(1);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeInt(1);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeInt(0);
        this.out.writeInt(16384);
    }

    private void writeAtom(int length, String type) throws IOException {
        this.out.writeInt(length);
        this.out.writeBytes(type);
    }
}

