/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.ncml;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.jdom2.Element;
import thredds.filesystem.MFileOS;
import thredds.inventory.MFile;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.ncml.NcMLReaderNew;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.cache.FileFactory;

@Immutable
class AggDataset
implements Comparable<AggDataset> {
    private static final boolean debugOpenFile = false;
    private static final boolean debugRead = false;
    private final MFile mfile;
    private final Set<NetcdfDataset.Enhance> enhance;
    @Nullable
    protected final String cacheLocation;
    @Nullable
    private final String id;
    @Nullable
    private final Element ncmlElem;
    @Nullable
    protected final FileFactory reader;
    @Nullable
    protected final Object spiObject;
    protected DatasetUrl durl;

    protected AggDataset(MFile mfile, @Nullable Object spiObject, @Nullable Element ncmlElem) {
        this.mfile = mfile;
        this.cacheLocation = mfile.getPath();
        Set wantEnhance = (Set)mfile.getAuxInfo();
        this.enhance = wantEnhance == null ? NetcdfDataset.getEnhanceNone() : wantEnhance;
        this.id = null;
        this.reader = null;
        this.spiObject = spiObject;
        this.ncmlElem = ncmlElem;
    }

    protected AggDataset(String cacheLocation, String location, @Nullable String id, @Nullable EnumSet<NetcdfDataset.Enhance> wantEnhance, @Nullable FileFactory reader, @Nullable Object spiObject, @Nullable Element ncmlElem) {
        this.mfile = MFileOS.getExistingFile(location);
        this.cacheLocation = cacheLocation;
        this.id = id;
        this.enhance = wantEnhance == null ? NetcdfDataset.getEnhanceNone() : wantEnhance;
        this.reader = reader;
        this.spiObject = spiObject;
        this.ncmlElem = ncmlElem;
    }

    public String getLocation() {
        return this.mfile == null ? this.cacheLocation : this.mfile.getPath();
    }

    public MFile getMFile() {
        return this.mfile;
    }

    public String getCacheLocation() {
        return this.cacheLocation;
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.mfile != null) {
            return this.mfile.getPath();
        }
        return Integer.toString(this.hashCode());
    }

    public NetcdfFile acquireFile(CancelTask cancelTask) throws IOException {
        long start = System.currentTimeMillis();
        if (this.durl == null) {
            this.durl = DatasetUrl.findDatasetUrl(this.cacheLocation);
        }
        NetcdfFile ncfile = NetcdfDatasets.acquireFile(this.reader, null, this.durl, -1, cancelTask, this.spiObject);
        if (this.ncmlElem == null && this.enhance.isEmpty()) {
            return ncfile;
        }
        NetcdfDataset.Builder builder = NcMLReaderNew.mergeNcML(ncfile, this.ncmlElem);
        builder.setEnhanceMode(this.enhance);
        return builder.build();
    }

    protected void close(NetcdfFile ncfile) throws IOException {
        if (ncfile == null) {
            return;
        }
        this.cacheVariables(ncfile);
        ncfile.close();
    }

    protected void cacheVariables(NetcdfFile ncfile) throws IOException {
    }

    public void show(Formatter f) {
        f.format("   %s%n", this.mfile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Array read(Variable mainv, CancelTask cancelTask) throws IOException {
        NetcdfFile ncd = null;
        try {
            ncd = this.acquireFile(cancelTask);
            if (cancelTask != null && cancelTask.isCancel()) {
                Array array = null;
                return array;
            }
            Variable v = this.findVariable(ncd, mainv);
            Array array = v.read();
            return array;
        }
        finally {
            this.close(ncd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Array read(Variable mainv, CancelTask cancelTask, List<Range> section) throws IOException, InvalidRangeException {
        NetcdfFile ncd = null;
        try {
            ncd = this.acquireFile(cancelTask);
            if (cancelTask != null && cancelTask.isCancel()) {
                Array array = null;
                return array;
            }
            Variable v = this.findVariable(ncd, mainv);
            Array array = v.read(section);
            return array;
        }
        finally {
            this.close(ncd);
        }
    }

    protected Variable findVariable(NetcdfFile ncfile, Variable mainV) {
        Variable v = ncfile.findVariable(mainV.getFullNameEscaped());
        if (v == null && mainV instanceof VariableDS) {
            VariableDS ve = (VariableDS)mainV;
            v = ncfile.findVariable(ve.getOriginalName());
        }
        return v;
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof AggDataset)) {
            return false;
        }
        AggDataset other = (AggDataset)oo;
        return this.getLocation().equals(other.getLocation());
    }

    public int hashCode() {
        return this.getLocation().hashCode();
    }

    @Override
    public int compareTo(AggDataset o) {
        return this.getLocation().compareTo(o.getLocation());
    }
}

