/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.ByteArrayReader;
import com.drew.lang.Charsets;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.photoshop.Knot;
import com.drew.metadata.photoshop.PhotoshopDirectory;
import com.drew.metadata.photoshop.Subpath;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class PhotoshopDescriptor
extends TagDescriptor<PhotoshopDirectory> {
    public PhotoshopDescriptor(@NotNull PhotoshopDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1033: 
            case 1036: {
                return this.getThumbnailDescription(tagType);
            }
            case 1002: 
            case 1035: {
                return this.getSimpleString(tagType);
            }
            case 1028: {
                return this.getBinaryDataString(tagType);
            }
            case 1050: {
                return this.getSlicesDescription();
            }
            case 1057: {
                return this.getVersionDescription();
            }
            case 1034: {
                return this.getBooleanString(tagType);
            }
            case 1005: {
                return this.getResolutionInfoDescription();
            }
            case 1037: 
            case 1044: 
            case 1049: 
            case 1054: {
                return this.get32BitNumberString(tagType);
            }
            case 1030: {
                return this.getJpegQualityString();
            }
            case 1062: {
                return this.getPrintScaleDescription();
            }
            case 1064: {
                return this.getPixelAspectRatioString();
            }
            case 2999: {
                return this.getClippingPathNameString(tagType);
            }
        }
        if (tagType >= 2000 && tagType <= 2998) {
            return this.getPathString(tagType);
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getJpegQualityString() {
        try {
            String format;
            String quality;
            byte[] b = ((PhotoshopDirectory)this._directory).getByteArray(1030);
            if (b == null) {
                return ((PhotoshopDirectory)this._directory).getString(1030);
            }
            ByteArrayReader reader = new ByteArrayReader(b);
            int q = reader.getUInt16(0);
            int f = reader.getUInt16(2);
            int s2 = reader.getUInt16(4);
            int q1 = q <= 65535 && q >= 65533 ? q - 65532 : (q <= 8 ? q + 4 : q);
            switch (q) {
                case 0: 
                case 65533: 
                case 65534: 
                case 65535: {
                    quality = "Low";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    quality = "Medium";
                    break;
                }
                case 4: 
                case 5: {
                    quality = "High";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    quality = "Maximum";
                    break;
                }
                default: {
                    quality = "Unknown";
                }
            }
            switch (f) {
                case 0: {
                    format = "Standard";
                    break;
                }
                case 1: {
                    format = "Optimised";
                    break;
                }
                case 257: {
                    format = "Progressive";
                    break;
                }
                default: {
                    format = String.format("Unknown 0x%04X", f);
                }
            }
            String scans = s2 >= 1 && s2 <= 3 ? String.format("%d", s2 + 2) : String.format("Unknown 0x%04X", s2);
            return String.format("%d (%s), %s format, %s scans", q1, quality, format, scans);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public String getPixelAspectRatioString() {
        try {
            byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(1064);
            if (bytes == null) {
                return null;
            }
            ByteArrayReader reader = new ByteArrayReader(bytes);
            double d = reader.getDouble64(4);
            return Double.toString(d);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public String getPrintScaleDescription() {
        try {
            byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(1062);
            if (bytes == null) {
                return null;
            }
            ByteArrayReader reader = new ByteArrayReader(bytes);
            int style = reader.getInt32(0);
            float locX = reader.getFloat32(2);
            float locY = reader.getFloat32(6);
            float scale = reader.getFloat32(10);
            switch (style) {
                case 0: {
                    return "Centered, Scale " + scale;
                }
                case 1: {
                    return "Size to fit";
                }
                case 2: {
                    return String.format("User defined, X:%s Y:%s, Scale:%s", Float.valueOf(locX), Float.valueOf(locY), Float.valueOf(scale));
                }
            }
            return String.format("Unknown %04X, X:%s Y:%s, Scale:%s", style, Float.valueOf(locX), Float.valueOf(locY), Float.valueOf(scale));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public String getResolutionInfoDescription() {
        try {
            byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(1005);
            if (bytes == null) {
                return null;
            }
            ByteArrayReader reader = new ByteArrayReader(bytes);
            float resX = reader.getS15Fixed16(0);
            float resY = reader.getS15Fixed16(8);
            DecimalFormat format = new DecimalFormat("0.##");
            return format.format(resX) + "x" + format.format(resY) + " DPI";
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public String getVersionDescription() {
        try {
            byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(1057);
            if (bytes == null) {
                return null;
            }
            ByteArrayReader reader = new ByteArrayReader(bytes);
            int pos = 0;
            int ver = reader.getInt32(0);
            pos += 4;
            ++pos;
            int readerLength = reader.getInt32(5);
            pos += 4;
            String readerStr = reader.getString(9, readerLength * 2, "UTF-16");
            int writerLength = reader.getInt32(pos += readerLength * 2);
            String writerStr = reader.getString(pos += 4, writerLength * 2, "UTF-16");
            int fileVersion = reader.getInt32(pos += writerLength * 2);
            return String.format("%d (%s, %s) %d", ver, readerStr, writerStr, fileVersion);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public String getSlicesDescription() {
        try {
            byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(1050);
            if (bytes == null) {
                return null;
            }
            ByteArrayReader reader = new ByteArrayReader(bytes);
            int nameLength = reader.getInt32(20);
            String name = reader.getString(24, nameLength * 2, "UTF-16");
            int pos = 24 + nameLength * 2;
            int sliceCount = reader.getInt32(pos);
            return String.format("%s (%d,%d,%d,%d) %d Slices", name, reader.getInt32(4), reader.getInt32(8), reader.getInt32(12), reader.getInt32(16), sliceCount);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public String getThumbnailDescription(int tagType) {
        try {
            byte[] v = ((PhotoshopDirectory)this._directory).getByteArray(tagType);
            if (v == null) {
                return null;
            }
            ByteArrayReader reader = new ByteArrayReader(v);
            int format = reader.getInt32(0);
            int width = reader.getInt32(4);
            int height = reader.getInt32(8);
            int totalSize = reader.getInt32(16);
            int compSize = reader.getInt32(20);
            int bpp = reader.getInt32(24);
            return String.format("%s, %dx%d, Decomp %d bytes, %d bpp, %d bytes", format == 1 ? "JpegRGB" : "RawRGB", width, height, totalSize, bpp, compSize);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    private String getBooleanString(int tag) {
        byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(tag);
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        return bytes[0] == 0 ? "No" : "Yes";
    }

    @Nullable
    private String get32BitNumberString(int tag) {
        byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(tag);
        if (bytes == null) {
            return null;
        }
        ByteArrayReader reader = new ByteArrayReader(bytes);
        try {
            return String.format("%d", reader.getInt32(0));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    private String getSimpleString(int tagType) {
        byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(tagType);
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }

    @Nullable
    private String getBinaryDataString(int tagType) {
        byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(tagType);
        if (bytes == null) {
            return null;
        }
        return String.format("%d bytes binary data", bytes.length);
    }

    @Nullable
    public String getClippingPathNameString(int tagType) {
        try {
            byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(tagType);
            if (bytes == null) {
                return null;
            }
            ByteArrayReader reader = new ByteArrayReader(bytes);
            byte length = ((RandomAccessReader)reader).getByte(0);
            return new String(((RandomAccessReader)reader).getBytes(1, length), "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public String getPathString(int tagType) {
        try {
            byte[] bytes = ((PhotoshopDirectory)this._directory).getByteArray(tagType);
            if (bytes == null) {
                return null;
            }
            ByteArrayReader reader = new ByteArrayReader(bytes);
            int length = (int)(((RandomAccessReader)reader).getLength() - (long)((RandomAccessReader)reader).getByte((int)((RandomAccessReader)reader).getLength() - 1) - 1L) / 26;
            String fillRecord = null;
            Subpath cSubpath = new Subpath();
            Subpath oSubpath = new Subpath();
            ArrayList<Subpath> paths = new ArrayList<Subpath>();
            block11: for (int i = 0; i < length; ++i) {
                int recordSpacer = 26 * i;
                short selector = reader.getInt16(recordSpacer);
                switch (selector) {
                    case 0: {
                        if (cSubpath.size() != 0) {
                            paths.add(cSubpath);
                        }
                        cSubpath = new Subpath("Closed Subpath");
                        continue block11;
                    }
                    case 1: 
                    case 2: {
                        int j;
                        Knot knot = selector == 1 ? new Knot("Linked") : new Knot("Unlinked");
                        for (j = 0; j < 6; ++j) {
                            knot.setPoint(j, (double)reader.getInt8(j * 4 + 2 + recordSpacer) + (double)reader.getInt24(j * 4 + 3 + recordSpacer) / Math.pow(2.0, 24.0));
                        }
                        cSubpath.add(knot);
                        continue block11;
                    }
                    case 3: {
                        if (oSubpath.size() != 0) {
                            paths.add(oSubpath);
                        }
                        oSubpath = new Subpath("Open Subpath");
                        continue block11;
                    }
                    case 4: 
                    case 5: {
                        int j;
                        Knot knot = selector == 4 ? new Knot("Linked") : new Knot("Unlinked");
                        for (j = 0; j < 6; ++j) {
                            knot.setPoint(j, (double)reader.getInt8(j * 4 + 2 + recordSpacer) + (double)reader.getInt24(j * 4 + 3 + recordSpacer) / Math.pow(2.0, 24.0));
                        }
                        oSubpath.add(knot);
                        continue block11;
                    }
                    case 6: {
                        continue block11;
                    }
                    case 7: {
                        continue block11;
                    }
                    case 8: {
                        fillRecord = reader.getInt16(2 + recordSpacer) == 1 ? "with all pixels" : "without all pixels";
                    }
                }
            }
            if (cSubpath.size() != 0) {
                paths.add(cSubpath);
            }
            if (oSubpath.size() != 0) {
                paths.add(oSubpath);
            }
            byte nameLength = ((RandomAccessReader)reader).getByte((int)((RandomAccessReader)reader).getLength() - 1);
            String name = reader.getString((int)((RandomAccessReader)reader).getLength() - nameLength - 1, (int)nameLength, Charsets.ASCII);
            StringBuilder str = new StringBuilder();
            str.append('\"').append(name).append('\"').append(" having ");
            if (fillRecord != null) {
                str.append("initial fill rule \"").append(fillRecord).append("\" and ");
            }
            str.append(paths.size()).append(paths.size() == 1 ? " subpath:" : " subpaths:");
            for (Subpath path : paths) {
                str.append("\n- ").append(path.getType()).append(" with ").append(paths.size()).append(paths.size() == 1 ? " knot:" : " knots:");
                for (Knot knot : path.getKnots()) {
                    str.append("\n  - ").append(knot.getType());
                    str.append(" (").append(knot.getPoint(0)).append(",").append(knot.getPoint(1)).append(")");
                    str.append(" (").append(knot.getPoint(2)).append(",").append(knot.getPoint(3)).append(")");
                    str.append(" (").append(knot.getPoint(4)).append(",").append(knot.getPoint(5)).append(")");
                }
            }
            return str.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

