/*
 * Decompiled with CFR 0.152.
 */
package io.minio.messages;

import com.google.api.client.util.Key;
import com.google.api.client.xml.XmlNamespaceDictionary;
import io.minio.ErrorCode;
import io.minio.messages.XmlEntity;
import java.io.IOException;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParserException;

public class ErrorResponse
extends XmlEntity {
    @Key(value="Code")
    protected String code;
    @Key(value="Message")
    protected String message;
    @Key(value="BucketName")
    protected String bucketName;
    @Key(value="Key")
    protected String objectName;
    @Key(value="Resource")
    protected String resource;
    @Key(value="RequestId")
    protected String requestId;
    @Key(value="HostId")
    protected String hostId;
    protected ErrorCode errorCode;

    public ErrorResponse() throws XmlPullParserException {
        this.name = "ErrorResponse";
    }

    public ErrorResponse(Reader reader) throws IOException, XmlPullParserException {
        this();
        this.parseXml(reader);
    }

    public ErrorResponse(ErrorCode errorCode, String bucketName, String objectName, String resource, String requestId, String hostId) throws XmlPullParserException {
        this();
        this.errorCode = errorCode;
        this.code = errorCode.code();
        this.message = errorCode.message();
        this.bucketName = bucketName;
        this.objectName = objectName;
        this.resource = resource;
        this.requestId = requestId;
        this.hostId = hostId;
    }

    public ErrorCode errorCode() {
        if (this.errorCode == null) {
            this.errorCode = ErrorCode.fromString(this.code);
        }
        return this.errorCode;
    }

    public String code() {
        return this.code;
    }

    public String message() {
        return this.message;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String objectName() {
        return this.objectName;
    }

    public String hostId() {
        return this.hostId;
    }

    public String requestId() {
        return this.requestId;
    }

    public String resource() {
        return this.resource;
    }

    @Override
    public void parseXml(Reader reader) throws IOException, XmlPullParserException {
        XmlNamespaceDictionary namespaceDictionary = new XmlNamespaceDictionary();
        namespaceDictionary.set("", "");
        super.parseXml(reader, namespaceDictionary);
    }

    public String getString() {
        return "ErrorResponse(code=" + this.code + ", message=" + this.message + ", bucketName=" + this.bucketName + ", objectName=" + this.objectName + ", resource=" + this.resource + ", requestId=" + this.requestId + ", hostId=" + this.hostId + ")";
    }
}

