/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VentanaReader
extends BaseTiffReader {
    public static final String SPLIT_TILES_KEY = "ventana.split_tiles";
    public static final boolean SPLIT_TILES_DEFAULT = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(VentanaReader.class);
    private static final int XML_TAG = 700;
    private static final int EXTRA_TAG_1 = 34377;
    private static final int EXTRA_TAG_2 = 34677;
    private Double magnification = null;
    private List<AreaOfInterest> areas = new ArrayList<AreaOfInterest>();
    private int tileWidth;
    private int tileHeight;
    private TIFFTile[] tiles;
    private int resolutions = 0;
    private Double physicalPixelSize = null;

    public VentanaReader() {
        super("Ventana .bif", new String[]{"bif"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = true;
        this.noSubresolutions = true;
        this.canSeparateSeries = false;
    }

    public boolean splitTiles() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(SPLIT_TILES_KEY, false);
        }
        return false;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (!isThisType && open) {
            RandomAccessInputStream stream = null;
            try {
                stream = new RandomAccessInputStream(name);
                TiffParser tiffParser = new TiffParser(stream);
                tiffParser.setDoCaching(false);
                if (!tiffParser.isValidHeader()) {
                    boolean bl = false;
                    return bl;
                }
                IFD ifd = tiffParser.getFirstIFD();
                if (ifd == null) {
                    boolean e = false;
                    return e;
                }
                tiffParser.fillInIFD(ifd);
                String xml = ifd.getIFDTextValue(700);
                boolean bl = xml != null && xml.indexOf("iScan") >= 0;
                return bl;
            }
            catch (IOException e) {
                LOGGER.debug("I/O exception during isThisType() evaluation.", e);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("I/O exception during stream closure.", e);
                }
            }
        }
        return isThisType;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        this.lastPlane = this.getIFDIndex(this.getCoreIndex(), 0);
        return super.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        this.lastPlane = this.getIFDIndex(this.getCoreIndex(), 0);
        return super.get16BitLookupTable();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        Arrays.fill(buf, (byte)0);
        IFD ifd = (IFD)this.ifds.get(this.getIFDIndex(this.getCoreIndex(), no));
        if (this.splitTiles()) {
            TIFFTile tile = this.tiles[this.getCoreIndex()];
            this.tiffParser.getSamples(ifd, buf, tile.baseX + x, tile.baseY + y, w, h2);
            return buf;
        }
        if (this.getCoreIndex() >= this.core.size(0) || this.areas.size() == 0) {
            this.tiffParser.getSamples(ifd, buf, x, y, w, h2);
            return buf;
        }
        Region imageBox = new Region(x, y, w, h2);
        boolean interleaved = this.isInterleaved();
        int count = interleaved ? 1 : this.getRGBChannelCount();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bpp * this.getRGBChannelCount();
        int tilePixel = bpp * (this.getRGBChannelCount() / count);
        int outputRowLen = w * tilePixel;
        int scale = this.getScale(this.getCoreIndex());
        int thisTileWidth = this.tileWidth / scale;
        int thisTileHeight = this.tileHeight / scale;
        byte[] subResTile = null;
        int subResX = -1;
        int subResY = -1;
        HashMap<Region, byte[]> cachedTiles = new HashMap<Region, byte[]>();
        byte[] tilePixels = new byte[thisTileWidth * thisTileHeight * pixel];
        for (TIFFTile tile : this.tiles) {
            Region tileBox = new Region(tile.realX, tile.realY, this.tileWidth, this.tileHeight);
            for (AreaOfInterest area : this.areas) {
                if (!tileBox.intersects(area.boundingBox)) continue;
                tileBox = tileBox.intersection(area.boundingBox);
                break;
            }
            tileBox.x = this.scaleCoordinate(tileBox.x, this.getCoreIndex());
            tileBox.y = this.scaleCoordinate(tileBox.y, this.getCoreIndex());
            tileBox.width /= scale;
            tileBox.height /= scale;
            if (!tileBox.intersects(imageBox)) continue;
            if (scale == 1) {
                this.tiffParser.getSamples(ifd, tilePixels, tile.baseX, tile.baseY, thisTileWidth, thisTileHeight);
            } else {
                int resX = this.scaleCoordinate(tile.baseX, this.getCoreIndex());
                int offsetX = resX % this.tileWidth;
                int resY = this.scaleCoordinate(tile.baseY, this.getCoreIndex());
                int offsetY = resY % this.tileHeight;
                if ((resX -= offsetX) != subResX || (resY -= offsetY) != subResY || subResTile == null) {
                    Region key;
                    if (subResTile == null) {
                        subResTile = new byte[this.tileWidth * this.tileHeight * pixel];
                    }
                    if (!cachedTiles.containsKey(key = new Region(resX, resY, this.tileWidth, this.tileHeight))) {
                        byte[] b = new byte[subResTile.length];
                        this.tiffParser.getSamples(ifd, b, resX, resY, this.tileWidth, this.tileHeight);
                        cachedTiles.put(key, b);
                    }
                    System.arraycopy(cachedTiles.get(key), 0, subResTile, 0, subResTile.length);
                    subResX = resX;
                    subResY = resY;
                }
                int inRow = this.tileWidth * tilePixel;
                int outRow = thisTileWidth * tilePixel;
                int input = 0;
                int output = 0;
                for (int c = 0; c < count; ++c) {
                    input = inRow * (c * this.tileHeight + offsetY) + offsetX * tilePixel;
                    output = c * thisTileHeight * outRow;
                    for (int row = 0; row < thisTileHeight; ++row) {
                        System.arraycopy(subResTile, input, tilePixels, output, outRow);
                        input += inRow;
                        output += outRow;
                    }
                }
            }
            Region intersection = tileBox.intersection(imageBox);
            int intersectionX = 0;
            if (tileBox.x < imageBox.x) {
                intersectionX = imageBox.x - tileBox.x;
            }
            int rowLen = Math.min(intersection.width, thisTileWidth) * tilePixel;
            for (int c = 0; c < count; ++c) {
                for (int row = 0; row < intersection.height; ++row) {
                    int realRow = row + intersection.y - tileBox.y;
                    int inputOffset = tilePixel * (realRow * thisTileWidth + intersection.x - tileBox.x);
                    if (!interleaved) {
                        inputOffset += c * thisTileWidth * thisTileHeight * tilePixel;
                    }
                    int outputOffset = tilePixel * (intersection.x - x) + outputRowLen * (row + intersection.y - y);
                    if (!interleaved) {
                        outputOffset += c * w * h2 * tilePixel;
                    }
                    int copy = Math.min(rowLen, buf.length - outputOffset);
                    System.arraycopy(tilePixels, inputOffset, buf, outputOffset, copy);
                }
            }
        }
        return buf;
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        if (this.getCoreIndex() < this.core.size(0)) {
            int currentCore = this.getCoreIndex();
            this.setCoreIndex(this.core.size(0) - 1);
            byte[] thumb = super.openThumbBytes(no);
            this.setCoreIndex(currentCore);
            return thumb;
        }
        return super.openThumbBytes(no);
    }

    @Override
    public int getThumbSizeX() {
        if (this.getCoreIndex() < this.core.size(0)) {
            int currentCore = this.getCoreIndex();
            this.setCoreIndex(this.core.size(0) - 1);
            int x = super.getThumbSizeX();
            this.setCoreIndex(currentCore);
            return x;
        }
        return super.getThumbSizeX();
    }

    @Override
    public int getThumbSizeY() {
        if (this.getCoreIndex() < this.core.size(0)) {
            int currentCore = this.getCoreIndex();
            this.setCoreIndex(this.core.size(0) - 1);
            int y = super.getThumbSizeY();
            this.setCoreIndex(currentCore);
            return y;
        }
        return super.getThumbSizeY();
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.magnification = null;
            this.areas.clear();
            this.tileWidth = 0;
            this.tileHeight = 0;
            this.tiles = null;
            this.resolutions = 0;
            this.physicalPixelSize = null;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = this.getIFDIndex(this.getCoreIndex(), 0);
            return (int)((IFD)this.ifds.get(ifd)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = this.getIFDIndex(this.getCoreIndex(), 0);
            return (int)((IFD)this.ifds.get(ifd)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    protected ArrayList<String> getAvailableOptions() {
        ArrayList<String> optionsList = super.getAvailableOptions();
        optionsList.add(SPLIT_TILES_KEY);
        return optionsList;
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        int s2;
        int i;
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getMainIFDs();
        int seriesCount = this.ifds.size();
        this.core.clear();
        for (int i2 = 0; i2 < seriesCount; ++i2) {
            this.core.add(new CoreMetadata());
        }
        int resolutionCount = 0;
        for (i = 0; i < seriesCount; ++i) {
            String[] tokens;
            this.setSeries(i);
            int index = this.getIFDIndex(i, 0);
            this.tiffParser.fillInIFD((IFD)this.ifds.get(index));
            String comment = ((IFD)this.ifds.get(index)).getComment();
            if (comment == null) continue;
            for (String token : tokens = comment.split(" ")) {
                String[] v = token.split("=");
                if (v.length != 2) continue;
                this.addSeriesMeta(v[0], v[1]);
                if (v[0].equals("level")) {
                    ++resolutionCount;
                    continue;
                }
                if (this.magnification != null || !v[0].equals("mag")) continue;
                this.magnification = DataTools.parseDouble(v[1]);
            }
            String xml = ((IFD)this.ifds.get(index)).getIFDTextValue(700);
            LOGGER.debug("XMP tag for series #{} = {}", (Object)i, (Object)xml);
            if (xml == null || resolutionCount > 1) continue;
            this.parseXML(xml);
        }
        this.setSeries(0);
        this.resolutions = resolutionCount;
        this.core.clear();
        this.core.add(new CoreMetadata());
        for (i = 1; i < this.resolutions; ++i) {
            this.core.add(0, new CoreMetadata());
        }
        for (s2 = 0; s2 < seriesCount - this.resolutions; ++s2) {
            this.core.add(new CoreMetadata());
        }
        for (s2 = 0; s2 < this.core.size(); ++s2) {
            for (int r = 0; r < this.core.size(s2); ++r) {
                CoreMetadata ms = (CoreMetadata)this.core.get(s2, r);
                ms.resolutionCount = this.core.size(s2);
                ms.sizeZ = 1;
                ms.sizeT = 1;
                ms.imageCount = ms.sizeZ * ms.sizeT;
                int ifdIndex = this.getIFDIndex(this.core.flattenedIndex(s2, r), 0);
                IFD ifd = (IFD)this.ifds.get(ifdIndex);
                PhotoInterp p = ifd.getPhotometricInterpretation();
                int samples = ifd.getSamplesPerPixel();
                ms.rgb = samples > 1 || p == PhotoInterp.RGB;
                ms.sizeX = (int)ifd.getImageWidth();
                ms.sizeY = (int)ifd.getImageLength();
                ms.sizeC = ms.rgb ? samples : 1;
                ms.littleEndian = ifd.isLittleEndian();
                ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
                ms.pixelType = ifd.getPixelType();
                ms.metadataComplete = true;
                ms.interleaved = false;
                ms.falseColor = false;
                ms.dimensionOrder = "XYCZT";
                boolean bl = ms.thumbnail = s2 != 0 || r != 0;
                if (s2 != 0 || r != 0) continue;
                this.tileWidth = (int)ifd.getTileWidth();
                this.tileHeight = (int)ifd.getTileLength();
                long[] offsets = ifd.getStripOffsets();
                int x = 0;
                int y = 0;
                this.tiles = new TIFFTile[offsets.length];
                for (int i3 = 0; i3 < offsets.length; ++i3) {
                    this.tiles[i3] = new TIFFTile();
                    this.tiles[i3].offset = offsets[i3];
                    this.tiles[i3].ifd = ifdIndex;
                    this.tiles[i3].realX = -1 * this.tileWidth;
                    this.tiles[i3].realY = -1 * this.tileHeight;
                    this.tiles[i3].baseX = this.tileWidth * x++;
                    this.tiles[i3].baseY = this.tileHeight * y;
                    if (x * this.tileWidth < ms.sizeX) continue;
                    ++y;
                    x = 0;
                }
            }
        }
        if (this.splitTiles()) {
            CoreMetadata first = (CoreMetadata)this.core.get(0, 0);
            this.core.clear();
            for (TIFFTile tile : this.tiles) {
                CoreMetadata m3 = new CoreMetadata(first);
                m3.sizeX = this.tileWidth;
                m3.sizeY = this.tileHeight;
                m3.thumbnail = false;
                this.core.add(m3);
            }
            return;
        }
        int tileCols = ((CoreMetadata)this.core.get((int)0, (int)0)).sizeX / this.tileWidth;
        LOGGER.debug("number of valid areas of interest = {}", (Object)this.areas.size());
        int maxYAdjust = Integer.MIN_VALUE;
        for (AreaOfInterest area : this.areas) {
            int tileRow = area.yOrigin / this.tileHeight;
            int tileCol = area.xOrigin / this.tileWidth;
            for (int row = 0; row < area.tileRows; ++row) {
                for (int col = 0; col < area.tileColumns; ++col) {
                    int index = (tileRow + row) * tileCols + (tileCol + col);
                    this.tiles[index].realX = this.tiles[index].baseX;
                    this.tiles[index].realY = this.tiles[index].baseY;
                }
            }
            HashMap<Integer, Integer> columnYAdjust = new HashMap<Integer, Integer>();
            double rightSum = 0.0;
            double upSum = 0.0;
            int rightCount = 0;
            int upCount = 0;
            for (Overlap overlap : area.overlaps) {
                if (overlap.confidence < 98) continue;
                if (overlap.direction.equals("RIGHT")) {
                    rightSum += (double)overlap.x;
                    ++rightCount;
                    if (overlap.y <= 0) continue;
                    columnYAdjust.put(this.getTileColumn(overlap.a, area.tileRows, area.tileColumns), overlap.y);
                    continue;
                }
                if (overlap.direction.equals("UP")) {
                    upSum += (double)overlap.y;
                    ++upCount;
                    continue;
                }
                if (overlap.direction.equals("LEFT")) {
                    rightSum += (double)overlap.x;
                    ++rightCount;
                    if (overlap.y > 0) continue;
                    columnYAdjust.put(this.getTileColumn(overlap.a, area.tileRows, area.tileColumns), overlap.y);
                    continue;
                }
                throw new FormatException("Unsupported overlap direction: " + overlap.direction);
            }
            if (rightCount > 0) {
                rightSum /= (double)rightCount;
            }
            if (upCount > 0) {
                upSum /= (double)upCount;
            }
            boolean allEven = true;
            boolean allOdd = true;
            Integer firstValue = null;
            for (Integer column : columnYAdjust.keySet()) {
                firstValue = (Integer)columnYAdjust.get(column);
                if (column % 2 == 0) {
                    allOdd = false;
                    continue;
                }
                allEven = false;
            }
            if (allOdd || allEven) {
                for (int i4 = 0; i4 < area.tileColumns; ++i4) {
                    if (i4 % 2 == 0 && allOdd || i4 % 2 == 1 && allEven || columnYAdjust.get(i4) != null) continue;
                    columnYAdjust.put(i4, firstValue);
                }
            }
            for (Integer adjust : columnYAdjust.values()) {
                if (adjust <= maxYAdjust) continue;
                maxYAdjust = adjust;
            }
            for (int row = 0; row < area.tileRows; ++row) {
                for (int col = 0; col < area.tileColumns; ++col) {
                    int index = (tileRow + row) * tileCols + (tileCol + col);
                    this.tiles[index].realX = (int)((double)this.tiles[index].realX - rightSum * (double)col);
                    this.tiles[index].realY = (int)((double)this.tiles[index].realY - upSum * (double)row);
                    if (!columnYAdjust.containsKey(col)) continue;
                    this.tiles[index].realY += ((Integer)columnYAdjust.get(col)).intValue();
                }
            }
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        for (AreaOfInterest area : this.areas) {
            int tileRow = area.yOrigin / this.tileHeight;
            int tileCol = area.xOrigin / this.tileWidth;
            int areaMinX = Integer.MAX_VALUE;
            int areaMinY = Integer.MAX_VALUE;
            int areaMaxX = 0;
            int areaMaxY = 0;
            for (int row = 0; row < area.tileRows; ++row) {
                for (int col = 0; col < area.tileColumns; ++col) {
                    int index = (tileRow + row) * tileCols + (tileCol + col);
                    if (this.tiles[index].realX < 0 || this.tiles[index].realY < 0) continue;
                    areaMinX = Math.min(areaMinX, this.tiles[index].realX);
                    areaMaxX = Math.max(areaMaxX, this.tiles[index].realX + this.tileWidth);
                    areaMinY = Math.min(areaMinY, this.tiles[index].realY);
                    areaMaxY = Math.max(areaMaxY, this.tiles[index].realY + this.tileHeight);
                }
            }
            area.boundingBox = new Region(areaMinX, areaMinY + maxYAdjust, areaMaxX - areaMinX, areaMaxY - areaMinY - 3 * maxYAdjust);
            minX = Math.min(areaMinX, minX);
            maxX = Math.max(areaMaxX, maxX);
            minY = Math.min(area.boundingBox.y, minY);
            maxY = Math.max(area.boundingBox.y + area.boundingBox.height, maxY);
        }
        for (AreaOfInterest area : this.areas) {
            int tileRow = area.yOrigin / this.tileHeight;
            int tileCol = area.xOrigin / this.tileWidth;
            for (int row = 0; row < area.tileRows; ++row) {
                for (int col = 0; col < area.tileColumns; ++col) {
                    int index = (tileRow + row) * tileCols + (tileCol + col);
                    this.tiles[index].realX -= minX;
                    this.tiles[index].realY -= minY;
                }
            }
            area.boundingBox.x -= minX;
            area.boundingBox.y -= minY;
        }
        int newX = maxX - minX;
        int newY = maxY - minY;
        if (this.areas.size() > 0) {
            for (int s3 = 1; s3 < this.core.size(0); ++s3) {
                int scale = this.getScale(s3);
                ((CoreMetadata)this.core.get((int)0, (int)s3)).sizeX = newX / scale;
                ((CoreMetadata)this.core.get((int)0, (int)s3)).sizeY = newY / scale;
            }
            ((CoreMetadata)this.core.get((int)0, (int)0)).sizeX = newX;
            ((CoreMetadata)this.core.get((int)0, (int)0)).sizeY = newY;
        }
    }

    private int getScale(int resolution) {
        return (int)Math.round((double)((CoreMetadata)this.core.get((int)0, (int)0)).sizeX / (double)((CoreMetadata)this.core.get((int)0, (int)resolution)).sizeX);
    }

    private int scaleCoordinate(int v, int resolution) {
        return (int)Math.ceil((double)v / (double)this.getScale(resolution));
    }

    private int getTileColumn(int index, int rows, int cols) {
        int row = (int)Math.floor((double)index / (double)cols);
        int col = index - row * cols;
        if (row % 2 == 1) {
            return cols - col - 1;
        }
        return col;
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, this.splitTiles() || this.getImageCount() > 1);
        String instrument = MetadataTools.createLSID("Instrument", 0);
        String objective = MetadataTools.createLSID("Objective", 0, 0);
        store.setInstrumentID(instrument, 0);
        store.setObjectiveID(objective, 0, 0);
        store.setObjectiveNominalMagnification(this.magnification, 0, 0);
        Length pixelSize = null;
        if (this.physicalPixelSize != null) {
            pixelSize = new Length(this.physicalPixelSize, UNITS.MICROMETER);
        }
        block5: for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            store.setImageInstrumentRef(instrument, i);
            store.setObjectiveSettingsID(objective, i);
            if (pixelSize != null) {
                store.setPixelsPhysicalSizeX(pixelSize, i);
                store.setPixelsPhysicalSizeY(pixelSize, i);
            }
            if (this.splitTiles()) {
                for (int p = 0; p < this.getImageCount(); ++p) {
                    double x = this.tiles[i].baseX;
                    double y = this.tiles[i].baseY;
                    if (this.physicalPixelSize != null) {
                        x *= this.physicalPixelSize.doubleValue();
                        y *= this.physicalPixelSize.doubleValue();
                    }
                    store.setPlanePositionX(new Length(x, UNITS.MICROMETER), i, p);
                    store.setPlanePositionY(new Length(y, UNITS.MICROMETER), i, p);
                }
            }
            if (this.hasFlattenedResolutions() || this.splitTiles()) continue;
            switch (i) {
                case 0: {
                    store.setImageName("", i);
                    continue block5;
                }
                case 1: {
                    store.setImageName("overview image", i);
                    continue block5;
                }
                case 2: {
                    store.setImageName("mask image", i);
                }
            }
        }
        this.setSeries(0);
    }

    private int getIFDIndex(int coreIndex, int no) {
        if (this.splitTiles() && coreIndex > 0 && this.resolutions > 0) {
            return this.getIFDIndex(0, no);
        }
        int extra = this.ifds.size() - this.resolutions * ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount;
        if (coreIndex < this.ifds.size() - extra) {
            return extra + coreIndex * ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount + no;
        }
        return coreIndex - (this.ifds.size() - extra);
    }

    private void parseXML(String xml) throws IOException {
        String physicalSize;
        Element root = null;
        try {
            root = XMLTools.parseDOM(xml).getDocumentElement();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
        Element iScan = (Element)root.getElementsByTagName("iScan").item(0);
        if (iScan != null && (physicalSize = iScan.getAttribute("ScanRes")) != null) {
            this.physicalPixelSize = DataTools.parseDouble(physicalSize);
        }
        Element slideStitchInfo = (Element)root.getElementsByTagName("SlideStitchInfo").item(0);
        Element aoiOrigins = (Element)root.getElementsByTagName("AoiOrigin").item(0);
        if (slideStitchInfo == null || aoiOrigins == null) {
            return;
        }
        NodeList imageInfos = slideStitchInfo.getElementsByTagName("ImageInfo");
        for (int i = 0; i < imageInfos.getLength(); ++i) {
            Element imageInfo = (Element)imageInfos.item(i);
            if (imageInfo.getAttribute("AOIScanned").equals("0")) continue;
            AreaOfInterest aoi = new AreaOfInterest();
            String aoiIndex = imageInfo.getAttribute("AOIIndex");
            aoi.index = i;
            if (aoiIndex != null && !aoiIndex.isEmpty()) {
                aoi.index = Integer.parseInt(aoiIndex);
            }
            aoi.tileRows = Integer.parseInt(imageInfo.getAttribute("NumRows"));
            aoi.tileColumns = Integer.parseInt(imageInfo.getAttribute("NumCols"));
            NodeList joints = imageInfo.getElementsByTagName("TileJointInfo");
            for (int j = 0; j < joints.getLength(); ++j) {
                Element joint = (Element)joints.item(j);
                if (!joint.getAttribute("FlagJoined").equals("1")) continue;
                Overlap overlap = new Overlap();
                overlap.a = Integer.parseInt(joint.getAttribute("Tile1")) - 1;
                overlap.b = Integer.parseInt(joint.getAttribute("Tile2")) - 1;
                overlap.x = DataTools.parseDouble(joint.getAttribute("OverlapX")).intValue();
                overlap.y = DataTools.parseDouble(joint.getAttribute("OverlapY")).intValue();
                overlap.direction = joint.getAttribute("Direction");
                overlap.confidence = Integer.parseInt(joint.getAttribute("Confidence"));
                aoi.overlaps.add(overlap);
            }
            this.areas.add(aoi);
        }
        NodeList aois = aoiOrigins.getChildNodes();
        for (int i = 0; i < aois.getLength(); ++i) {
            String name = aois.item(i).getNodeName();
            if (!name.startsWith("AOI")) continue;
            Element aoi = (Element)aois.item(i);
            int thisIndex = Integer.parseInt(name.replace("AOI", ""));
            for (AreaOfInterest a : this.areas) {
                if (a.index != thisIndex) continue;
                a.xOrigin = Integer.parseInt(aoi.getAttribute("OriginX"));
                a.yOrigin = Integer.parseInt(aoi.getAttribute("OriginY"));
            }
        }
    }

    class TIFFTile {
        public int ifd;
        public long offset;
        public int baseX;
        public int baseY;
        public int realX;
        public int realY;

        TIFFTile() {
        }
    }

    class Overlap
    implements Comparable<Overlap> {
        public int a;
        public int b;
        public int x;
        public int y;
        public int confidence;
        public String direction;

        Overlap() {
        }

        @Override
        public int compareTo(Overlap o) {
            if (this.a != o.a) {
                return this.a - o.a;
            }
            return this.b - o.b;
        }

        public String toString() {
            return this.a + " => " + this.b + ", overlap = {" + this.x + ", " + this.y + "}, direction = " + this.direction;
        }
    }

    class AreaOfInterest {
        public int xOrigin;
        public int yOrigin;
        public int index;
        public int tileRows;
        public int tileColumns;
        public List<Overlap> overlaps = new ArrayList<Overlap>();
        public Region boundingBox;

        AreaOfInterest() {
        }

        public String toString() {
            return "AOI #" + this.index + ", X=" + this.xOrigin + ", Y=" + this.yOrigin + ", rows=" + this.tileRows + ", cols=" + this.tileColumns + ", overlaps=" + this.overlaps.size();
        }
    }
}

