/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.common.services.AbstractService;
import loci.formats.FormatException;
import loci.formats.services.JPEGXRService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.jxrlib.Decode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPEGXRServiceImpl
extends AbstractService
implements JPEGXRService {
    private static final int PIXEL_FORMAT_TAG = 48129;
    private static final short BGR_24 = 12;
    private static final short BGR_32 = 14;
    private static final short BGRA_32 = 15;
    private static final short PBGRA_32 = 16;
    private static final Logger LOGGER = LoggerFactory.getLogger(JPEGXRServiceImpl.class);

    public JPEGXRServiceImpl() {
        this.checkClassDependency(Decode.class);
    }

    @Override
    public byte[] decompress(byte[] compressed) throws FormatException {
        LOGGER.trace("begin tile decode; compressed size = {}", (Object)compressed.length);
        try {
            byte[] raw = Decode.decodeFirstFrame(compressed, 0, compressed.length);
            short[] format = this.getPixelFormat(compressed);
            if (this.isBGR(format)) {
                int bpp = this.getBGRComponents(format);
                for (int p = 0; p < raw.length; p += bpp) {
                    byte tmp = raw[p];
                    raw[p] = raw[p + 2];
                    raw[p + 2] = tmp;
                }
            }
            return raw;
        }
        catch (Exception e) {
            throw new FormatException(e);
        }
    }

    private short[] getPixelFormat(byte[] stream) throws FormatException, IOException {
        try (RandomAccessInputStream s2 = new RandomAccessInputStream(stream);){
            s2.order(true);
            s2.seek(4L);
            long ifdPointer = s2.readInt();
            TiffParser p = new TiffParser(s2);
            IFD ifd = p.getIFD(ifdPointer);
            short[] sArray = ifd.getIFDShortArray(48129);
            return sArray;
        }
    }

    private boolean isBGR(short[] format) {
        short lastByte = format[format.length - 1];
        return lastByte == 12 || lastByte == 14 || lastByte == 15 || lastByte == 16;
    }

    private int getBGRComponents(short[] format) {
        short lastByte = format[format.length - 1];
        return lastByte == 12 || lastByte == 14 ? 3 : 4;
    }
}

