/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataScalar;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationPointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.ft.point.writer.CFPointWriterUtils;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.Station;

public class WriterCFStationCollection
extends CFPointWriter {
    private List<StationFeature> stnList;
    protected Structure stationStruct;
    private HashMap<String, Integer> stationIndexMap;
    private boolean useDesc;
    private boolean useAlt;
    private boolean useWmoId;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private Map<String, Variable> featureVarMap = new HashMap<String, Variable>();
    private int stnRecno;
    private int obsRecno;

    public WriterCFStationCollection(String fileOut, List<Attribute> atts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, atts, dataVars, timeUnit, altUnits, config);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.timeSeries.name()));
        this.writer.addGroupAttribute(null, new Attribute("DSG_representation", "Timeseries of station data in the indexed ragged array representation, H.2.5"));
    }

    public void writeHeader(List<StationFeature> stns, StationPointFeature spf) throws IOException {
        this.stnList = stns;
        for (Station station : this.stnList) {
            if (!Double.isNaN(station.getAltitude())) {
                this.useAlt = true;
            }
            if (station.getWmoId() != null && !station.getWmoId().trim().isEmpty()) {
                this.useWmoId = true;
            }
            if (station.getDescription() != null && !station.getDescription().trim().isEmpty()) {
                this.useDesc = true;
            }
            this.id_strlen = Math.max(this.id_strlen, station.getName().length());
            if (station.getDescription() != null) {
                this.desc_strlen = Math.max(this.desc_strlen, station.getDescription().length());
            }
            if (station.getWmoId() == null) continue;
            this.wmo_strlen = Math.max(this.wmo_strlen, station.getWmoId().length());
        }
        this.llbb = CFPointWriterUtils.getBoundingBox(this.stnList);
        StationFeature sf = spf.getStation();
        StructureData structureData = sf.getFeatureData();
        StructureData obsData = spf.getFeatureData();
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        coords.add(VariableSimpleBuilder.makeScalar("time", "time of measurement", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        coords.add(VariableSimpleBuilder.makeScalar("stationIndex", "station index for this observation record", null, DataType.INT).addAttribute("instance_dimension", "station").build());
        Formatter coordNames = new Formatter().format("%s %s %s", "time", "latitude", "longitude");
        if (this.useAlt) {
            coordNames.format(" %s", "stationAltitude");
        }
        super.writeHeader(coords, structureData, obsData, coordNames.toString());
        int count = 0;
        this.stationIndexMap = new HashMap(2 * stns.size());
        for (StationFeature stn : this.stnList) {
            this.writeStationData(stn);
            this.stationIndexMap.put(stn.getName(), count);
            ++count;
        }
    }

    @Override
    protected void makeFeatureVariables(StructureData featureData, boolean isExtended) {
        Dimension stationDim = this.writer.addDimension(null, "station", this.stnList.size());
        ArrayList<VariableSimpleIF> stnVars = new ArrayList<VariableSimpleIF>();
        stnVars.add(VariableSimpleBuilder.makeScalar("latitude", "station latitude", "degrees_north", DataType.DOUBLE).build());
        stnVars.add(VariableSimpleBuilder.makeScalar("longitude", "station longitude", "degrees_east", DataType.DOUBLE).build());
        if (this.useAlt) {
            stnVars.add(VariableSimpleBuilder.makeScalar("stationAltitude", "station altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "surface_altitude").addAttribute("positive", CF1Convention.getZisPositive("altitude", this.altUnits)).build());
        }
        stnVars.add(VariableSimpleBuilder.makeString("station_id", "station identifier", null, this.id_strlen).addAttribute("cf_role", "timeseries_id").build());
        if (this.useDesc) {
            stnVars.add(VariableSimpleBuilder.makeString("station_description", "station description", null, this.desc_strlen).addAttribute("standard_name", "platform_name").build());
        }
        if (this.useWmoId) {
            stnVars.add(VariableSimpleBuilder.makeString("wmo_id", "station WMO id", null, this.wmo_strlen).addAttribute("standard_name", "platform_id").build());
        }
        for (StructureMembers.Member m3 : featureData.getMembers()) {
            if (this.getDataVar(m3.getName()) == null) continue;
            stnVars.add(VariableSimpleBuilder.fromMember(m3).build());
        }
        if (isExtended) {
            this.stationStruct = (Structure)this.writer.addVariable(null, "station", DataType.STRUCTURE, "station");
            this.addCoordinatesExtended(this.stationStruct, stnVars);
        } else {
            this.addCoordinatesClassic(stationDim, stnVars, this.featureVarMap);
        }
    }

    private void writeStationData(StationFeature stn) throws IOException {
        StructureDataScalar stnCoords = new StructureDataScalar("Coords");
        stnCoords.addMember("latitude", null, null, DataType.DOUBLE, stn.getLatLon().getLatitude());
        stnCoords.addMember("longitude", null, null, DataType.DOUBLE, stn.getLatLon().getLongitude());
        stnCoords.addMember("stationAltitude", null, null, DataType.DOUBLE, stn.getAltitude());
        stnCoords.addMemberString("station_id", null, null, stn.getName().trim(), this.id_strlen);
        if (this.useDesc) {
            stnCoords.addMemberString("station_description", null, null, stn.getDescription().trim(), this.desc_strlen);
        }
        if (this.useWmoId) {
            stnCoords.addMemberString("wmo_id", null, null, stn.getWmoId().trim(), this.wmo_strlen);
        }
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(stnCoords);
        sdall.add(stn.getFeatureData());
        this.stnRecno = super.writeStructureData(this.stnRecno, this.stationStruct, sdall, this.featureVarMap);
    }

    public void writeRecord(Station s2, PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(s2.getName(), sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sdata);
    }

    public void writeRecord(String stnName, double timeCoordValue, CalendarDate obsDate, StructureData sdata) throws IOException {
        this.trackBB(null, obsDate);
        Integer parentIndex = this.stationIndexMap.get(stnName);
        if (parentIndex == null) {
            throw new RuntimeException("Cant find station " + stnName);
        }
        StructureDataScalar coords = new StructureDataScalar("Coords");
        coords.addMember("time", null, null, DataType.DOUBLE, timeCoordValue);
        coords.addMember("stationIndex", null, null, DataType.INT, parentIndex);
        StructureDataComposite sdall = new StructureDataComposite();
        sdall.add(coords);
        sdall.add(sdata);
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

