/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLCellRenderer
extends DefaultTreeCellRenderer {
    private static final String ELEMENT_STYLE_START = "<font color=\"#7f007f\"><b>";
    private static final String ELEMENT_STYLE_END = "</b></font>";
    private static final String ATTR_NAME_STYLE_START = "<b>";
    private static final String ATTR_NAME_STYLE_END = "</b>";
    private static final String ATTR_VALUE_STYLE_START = "<font color=\"blue\">";
    private static final String ATTR_VALUE_STYLE_END = "</font>";
    private static final String COMMENT_STYLE_START = "<font color=\"green\"><i>";
    private static final String COMMENT_STYLE_END = "</i></font>";

    public static JTree makeJTree(Document doc) {
        Element rootNode = doc.getDocumentElement();
        DefaultMutableTreeNode rootTreeNode = XMLCellRenderer.makeTreeNode(rootNode);
        JTree tree = new JTree(rootTreeNode);
        tree.setCellRenderer(new XMLCellRenderer());
        tree.setRowHeight(0);
        return tree;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        XMLItem item = (XMLItem)treeNode.getUserObject();
        JLabel l = (JLabel)c;
        l.setText(item.toString(true));
        return c;
    }

    private static DefaultMutableTreeNode makeTreeNode(Node node) {
        DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(new XMLItem(node));
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (n instanceof Text) continue;
            treeNode.add(XMLCellRenderer.makeTreeNode(n));
        }
        return treeNode;
    }

    private static class XMLItem {
        private Node node;

        public XMLItem(Node node) {
            this.node = node;
        }

        public String toString(boolean html) {
            StringBuilder sb = new StringBuilder();
            if (this.node instanceof Element) {
                Node n;
                if (html) {
                    sb.append("<html>");
                }
                sb.append(html ? "&lt;" : "<");
                if (html) {
                    sb.append(XMLCellRenderer.ELEMENT_STYLE_START);
                }
                sb.append(this.node.getNodeName());
                if (html) {
                    sb.append(XMLCellRenderer.ELEMENT_STYLE_END);
                }
                NamedNodeMap attr = this.node.getAttributes();
                for (int i = 0; i < attr.getLength(); ++i) {
                    Node attrNode = attr.item(i);
                    sb.append(" ");
                    if (html) {
                        sb.append(XMLCellRenderer.ATTR_NAME_STYLE_START);
                    }
                    sb.append(attrNode.getNodeName());
                    sb.append("=");
                    if (html) {
                        sb.append(XMLCellRenderer.ATTR_NAME_STYLE_END);
                    }
                    if (html) {
                        sb.append(XMLCellRenderer.ATTR_VALUE_STYLE_START);
                    }
                    sb.append(html ? "&quot;" : "\"");
                    sb.append(attrNode.getNodeValue());
                    sb.append(html ? "&quot;" : "\"");
                    if (!html) continue;
                    sb.append(XMLCellRenderer.ATTR_VALUE_STYLE_END);
                }
                int numChildren = this.node.getChildNodes().getLength();
                if (numChildren == 0) {
                    sb.append("/");
                }
                sb.append(html ? "&gt;" : ">");
                if (numChildren == 1 && (n = this.node.getFirstChild()) instanceof Text) {
                    sb.append(this.sanitize(n.getNodeValue(), html));
                    sb.append(html ? "&lt;" : "<");
                    sb.append("/");
                    if (html) {
                        sb.append(XMLCellRenderer.ELEMENT_STYLE_START);
                    }
                    sb.append(this.node.getNodeName());
                    if (html) {
                        sb.append(XMLCellRenderer.ELEMENT_STYLE_END);
                    }
                    sb.append(html ? "&gt;" : ">");
                }
            } else if (this.node instanceof Comment) {
                if (html) {
                    sb.append("<html>");
                }
                if (html) {
                    sb.append(XMLCellRenderer.COMMENT_STYLE_START);
                }
                sb.append(html ? "&lt;" : "<");
                sb.append("!--");
                sb.append(html ? "<br>" : "\n");
                sb.append(this.sanitize(this.node.getNodeValue(), html));
                sb.append(html ? "<br>" : "\n");
                sb.append("--");
                sb.append(html ? "&gt;" : ">");
                if (html) {
                    sb.append(XMLCellRenderer.COMMENT_STYLE_END);
                }
            } else {
                sb.append(this.node.getNodeValue());
            }
            return sb.toString();
        }

        public String toString() {
            return this.toString(false);
        }

        private String sanitize(String s2, boolean html) {
            if (!html) {
                return s2;
            }
            s2 = s2.replaceAll("&", "&amp;");
            s2 = s2.replaceAll("\"", "&quot;");
            s2 = s2.replaceAll("<", "&lt;");
            s2 = s2.replaceAll(">", "&gt;");
            s2 = s2.replaceAll("[\n\r]", "<br>");
            return s2;
        }
    }
}

