/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.model.enums.Binning;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class InCellReader
extends FormatReader {
    public static final String INCELL_MAGIC_STRING = "IN Cell Analyzer";
    public static final String CYTELL_MAGIC_STRING = "Cytell";
    private static final String[] PIXELS_SUFFIXES = new String[]{"tif", "tiff", "im"};
    private static final String[] METADATA_SUFFIXES = new String[]{"xml", "xlog"};
    private boolean[][] plateMap;
    private Image[][][][] imageFiles;
    private MinimalTiffReader tiffReader;
    private List<Double> emWaves;
    private List<Double> exWaves;
    private List<String> channelNames;
    private int totalImages;
    private transient int imagesNumber;
    private int imageWidth;
    private int imageHeight;
    private String creationDate;
    private String rowName = "A";
    private String colName = "1";
    private int fieldCount;
    private int wellRows;
    private int wellCols;
    private Map<Integer, int[]> wellCoordinates;
    private Map<Integer, Length> posX;
    private Map<Integer, Length> posY;
    private int offsetPointCounter;
    private boolean[][] exclude;
    private List<Integer> channelsPerTimepoint;
    private boolean oneTimepointPerSeries;
    private int totalChannels;
    private List<String> metadataFiles;
    private Binning bin;
    private Length x;
    private Length y;
    private Double gain;
    private Double temperature;
    private Double refractive;
    private List<String> exFilters = new ArrayList<String>();
    private List<String> emFilters = new ArrayList<String>();

    public InCellReader() {
        super("InCell 1000/2000", new String[]{"xdce", "xml", "tiff", "tif", "xlog"});
        this.suffixSufficient = false;
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .xdce file with at least one .tif/.tiff or .im file";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (InCellReader.checkSuffix(name, "xdce") || InCellReader.checkSuffix(name, "xml")) {
            return super.isThisType(name, open);
        }
        return false;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2048;
        if (!FormatTools.validStream(stream, 2048, false)) {
            return false;
        }
        String check = stream.readString(2048);
        return check.indexOf(INCELL_MAGIC_STRING) >= 0 || check.indexOf(CYTELL_MAGIC_STRING) >= 0;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader == null ? (byte[][])null : this.tiffReader.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReader == null ? (short[][])null : this.tiffReader.get16BitLookupTable();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int[] coordinates = this.getZCTCoords(no);
        int well = this.getWellFromSeries(this.getSeries());
        int field = this.getFieldFromSeries(this.getSeries());
        int timepoint = this.oneTimepointPerSeries ? this.getSeries() % this.channelsPerTimepoint.size() : coordinates[2];
        int image = this.getIndex(coordinates[0], coordinates[1], 0);
        if (this.imageFiles[well][field][timepoint][image] == null) {
            return buf;
        }
        String filename = this.imageFiles[well][field][timepoint][image].filename;
        if (filename == null || !new Location(filename).exists()) {
            return buf;
        }
        if (this.imageFiles[well][field][timepoint][image].isTiff) {
            try {
                this.tiffReader.setId(filename);
                return this.tiffReader.openBytes(0, buf, x, y, w, h2);
            }
            catch (FormatException e) {
                LOGGER.debug("", e);
            }
            catch (IOException e) {
                LOGGER.debug("", e);
            }
            return buf;
        }
        RandomAccessInputStream s2 = new RandomAccessInputStream(filename);
        if (s2.length() > (long)FormatTools.getPlaneSize(this)) {
            s2.seek(128L);
            this.readPlane(s2, x, y, w, h2, buf);
        }
        s2.close();
        return buf;
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.currentId);
        files.addAll(this.metadataFiles);
        if (!noPixels && this.imageFiles != null) {
            int well = this.getWellFromSeries(this.getSeries());
            int field = this.getFieldFromSeries(this.getSeries());
            Image[][] imageArray = this.imageFiles[well][field];
            int n = imageArray.length;
            for (int i = 0; i < n; ++i) {
                Image[] timepoints;
                for (Image plane : timepoints = imageArray[i]) {
                    if (plane == null || plane.filename == null) continue;
                    if (new Location(plane.filename).exists()) {
                        files.add(plane.filename);
                    }
                    if (plane.thumbnailFile == null || !new Location(plane.thumbnailFile).exists()) continue;
                    files.add(plane.thumbnailFile);
                }
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiffReader != null) {
            this.tiffReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.imageFiles = null;
            this.tiffReader = null;
            this.totalImages = 0;
            this.imagesNumber = 0;
            this.exWaves = null;
            this.emWaves = null;
            this.channelNames = null;
            this.wellCoordinates = null;
            this.posX = null;
            this.posY = null;
            this.offsetPointCounter = 0;
            this.creationDate = null;
            this.wellCols = 0;
            this.wellRows = 0;
            this.fieldCount = 0;
            this.exclude = null;
            this.metadataFiles = null;
            this.imageHeight = 0;
            this.imageWidth = 0;
            this.rowName = "A";
            this.colName = "1";
            this.channelsPerTimepoint = null;
            this.oneTimepointPerSeries = false;
            this.totalChannels = 0;
            this.plateMap = null;
            this.bin = null;
            this.x = null;
            this.y = null;
            this.gain = null;
            this.temperature = null;
            this.refractive = null;
            this.emFilters.clear();
            this.exFilters.clear();
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        Image[][][][] imageArray = this.imageFiles;
        int n = imageArray.length;
        for (int i = 0; i < n; ++i) {
            Image[][][] well;
            Image[][][] imageArray2 = well = imageArray[i];
            int n2 = imageArray2.length;
            for (int j = 0; j < n2; ++j) {
                Image[][] field;
                Image[][] imageArray3 = field = imageArray2[j];
                int n3 = imageArray3.length;
                block2: for (int k = 0; k < n3; ++k) {
                    Image[] timepoint;
                    for (Image img : timepoint = imageArray3[k]) {
                        if (img == null) continue;
                        if (!img.isTiff || this.tiffReader == null) continue block2;
                        return this.tiffReader.getOptimalTileWidth();
                    }
                }
            }
        }
        return super.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        Image[][][][] imageArray = this.imageFiles;
        int n = imageArray.length;
        for (int i = 0; i < n; ++i) {
            Image[][][] well;
            Image[][][] imageArray2 = well = imageArray[i];
            int n2 = imageArray2.length;
            for (int j = 0; j < n2; ++j) {
                Image[][] field;
                Image[][] imageArray3 = field = imageArray2[j];
                int n3 = imageArray3.length;
                block2: for (int k = 0; k < n3; ++k) {
                    Image[] timepoint;
                    for (Image img : timepoint = imageArray3[k]) {
                        if (img == null) continue;
                        if (!img.isTiff || this.tiffReader == null) continue block2;
                        return this.tiffReader.getOptimalTileHeight();
                    }
                }
            }
        }
        return super.getOptimalTileHeight();
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int field;
        int well;
        int i;
        CoreMetadata ms;
        int i2;
        int row;
        if (InCellReader.checkSuffix(id, PIXELS_SUFFIXES) || InCellReader.checkSuffix(id, "xlog")) {
            String[] list;
            Location currentFile = new Location(id).getAbsoluteFile();
            Location parent = currentFile.getParentFile();
            for (String f : list = parent.list(true)) {
                String data;
                String path;
                if (!InCellReader.checkSuffix(f, new String[]{"xdce", "xml"}) || !this.isThisType(path = new Location(parent, f).getAbsolutePath()) || (data = DataTools.readFile(path)).indexOf(currentFile.getName()) < 0) continue;
                id = path;
                break;
            }
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.channelNames = new ArrayList<String>();
        this.emWaves = new ArrayList<Double>();
        this.exWaves = new ArrayList<Double>();
        this.channelsPerTimepoint = new ArrayList<Integer>();
        this.metadataFiles = new ArrayList<String>();
        this.wellCoordinates = new HashMap<Integer, int[]>();
        this.posX = new HashMap<Integer, Length>();
        this.posY = new HashMap<Integer, Length>();
        this.offsetPointCounter = 0;
        byte[] b = new byte[(int)this.in.length()];
        this.in.read(b);
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        ms0.dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        BaseHandler handler = new MinimalInCellHandler();
        XMLTools.parseXML(b, (DefaultHandler)handler);
        if (this.getSizeZ() == 0) {
            ms0.sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            ms0.sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            ms0.sizeT = 1;
        }
        if (this.totalImages == 0) {
            ms0.imageCount = this.getSizeC() * this.getSizeZ() * this.getSizeT();
            this.totalImages = this.getImageCount() * this.wellRows * this.wellCols * this.fieldCount;
            Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
            for (row = 0; row < this.wellRows; ++row) {
                for (int col = 0; col < this.wellCols; ++col) {
                    this.plateMap[row][col] = true;
                    for (int field2 = 0; field2 < this.fieldCount; ++field2) {
                        for (int t2 = 0; t2 < this.getSizeT(); ++t2) {
                            for (int image = 0; image < this.getSizeC() * this.getSizeZ(); ++image) {
                                int channel = this.getZCTCoords(image)[1];
                                Image plane = new Image();
                                String filename = FormatTools.getWellRowName(row) + " - " + (col + 1) + "(fld " + (field2 + 1) + " wv " + this.exFilters.get(channel) + " - " + this.emFilters.get(channel) + ").tif";
                                Location path = new Location(parent, filename);
                                if (path.exists()) {
                                    plane.filename = path.getAbsolutePath();
                                } else {
                                    LOGGER.debug("Missing file {}", (Object)filename);
                                }
                                this.imageFiles[row * this.wellCols + col][field2][t2][image] = plane;
                            }
                        }
                    }
                }
            }
        } else if (this.totalImages != this.imagesNumber) {
            LOGGER.warn("Inconsistent number of Images {}: expected {} but found {}", id, this.imagesNumber, this.totalImages);
        }
        for (int t3 = this.imageFiles[0][0].length - 1; t3 >= 0; --t3) {
            boolean allNull = true;
            for (int well2 = 0; well2 < this.imageFiles.length; ++well2) {
                block8: for (int field3 = 0; field3 < this.imageFiles[well2].length; ++field3) {
                    for (int p = 0; p < this.imageFiles[well2][field3][t3].length; ++p) {
                        if (this.imageFiles[well2][field3][t3][p] == null) continue;
                        allNull = false;
                        continue block8;
                    }
                }
            }
            if (!allNull) continue;
            --ms0.sizeT;
        }
        int seriesCount = 0;
        if (this.exclude != null) {
            for (row = 0; row < this.wellRows; ++row) {
                for (int col = 0; col < this.wellCols; ++col) {
                    if (this.exclude[row][col]) continue;
                    int well3 = row * this.wellCols + col;
                    boolean hasNonNullImage = false;
                    for (int field4 = 0; field4 < this.imageFiles[well3].length; ++field4) {
                        block13: for (int t4 = 0; t4 < this.imageFiles[well3][field4].length; ++t4) {
                            for (int p = 0; p < this.imageFiles[well3][field4][t4].length; ++p) {
                                if (this.imageFiles[well3][field4][t4][p] == null) continue;
                                hasNonNullImage = true;
                                continue block13;
                            }
                        }
                    }
                    if (!hasNonNullImage) continue;
                    seriesCount += this.imageFiles[well3].length;
                }
            }
            int expectedSeries = this.totalImages / (this.getSizeZ() * this.getSizeC() * this.getSizeT());
            if (expectedSeries > 0) {
                seriesCount = Math.min(seriesCount, expectedSeries);
            }
        } else {
            seriesCount = this.totalImages / (this.getSizeZ() * this.getSizeC() * this.getSizeT());
        }
        this.totalChannels = this.getSizeC();
        this.oneTimepointPerSeries = false;
        for (int i3 = 1; i3 < this.channelsPerTimepoint.size(); ++i3) {
            if (this.channelsPerTimepoint.get(i3).equals(this.channelsPerTimepoint.get(i3 - 1))) continue;
            this.oneTimepointPerSeries = true;
            break;
        }
        if (this.oneTimepointPerSeries) {
            int imageCount = 0;
            for (Integer timepoint : this.channelsPerTimepoint) {
                imageCount += timepoint * this.getSizeZ();
            }
            seriesCount = this.totalImages / imageCount * this.getSizeT();
        }
        int sizeT = this.getSizeT();
        int sizeC = this.getSizeC();
        int z = this.getSizeZ();
        int t5 = this.oneTimepointPerSeries ? 1 : this.getSizeT();
        this.core.clear();
        for (int i4 = 0; i4 < seriesCount; ++i4) {
            int c = this.oneTimepointPerSeries ? this.channelsPerTimepoint.get(i4 % sizeT) : sizeC;
            CoreMetadata ms2 = new CoreMetadata();
            this.core.add(ms2);
            ms2.sizeZ = z;
            ms2.sizeC = c;
            ms2.sizeT = t5;
            ms2.imageCount = z * c * t5;
            ms2.dimensionOrder = "XYZCT";
        }
        int wellIndex = this.getWellFromSeries(0);
        int fieldIndex = this.getFieldFromSeries(0);
        String filename = this.imageFiles[wellIndex][fieldIndex][0][0].filename;
        boolean isTiff = this.imageFiles[wellIndex][fieldIndex][0][0].isTiff;
        if (isTiff && filename != null) {
            this.tiffReader = new MinimalTiffReader();
            this.tiffReader.setId(filename);
            for (i2 = 0; i2 < seriesCount; ++i2) {
                ms = (CoreMetadata)this.core.get(i2);
                ms.sizeX = this.tiffReader.getSizeX();
                ms.sizeY = this.tiffReader.getSizeY();
                ms.interleaved = this.tiffReader.isInterleaved();
                ms.indexed = this.tiffReader.isIndexed();
                ms.rgb = this.tiffReader.isRGB();
                ms.pixelType = this.tiffReader.getPixelType();
                ms.littleEndian = this.tiffReader.isLittleEndian();
            }
        } else {
            for (i2 = 0; i2 < seriesCount; ++i2) {
                ms = (CoreMetadata)this.core.get(i2);
                ms.sizeX = this.imageWidth;
                ms.sizeY = this.imageHeight;
                ms.interleaved = false;
                ms.indexed = false;
                ms.rgb = false;
                ms.pixelType = 3;
                ms.littleEndian = true;
            }
        }
        MetadataTools.populatePixels(store, this, true);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            handler = new InCellHandler(store);
            XMLTools.parseXML(b, (DefaultHandler)handler);
        }
        String rowNaming = Character.isDigit(this.rowName.charAt(0)) ? "Number" : "Letter";
        String colNaming = Character.isDigit(this.colName.charAt(0)) ? "Number" : "Letter";
        String plateName = this.currentId;
        int begin = plateName.lastIndexOf(File.separator) + 1;
        int end = plateName.lastIndexOf(".");
        plateName = plateName.substring(begin, end);
        store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
        store.setPlateName(plateName, 0);
        store.setPlateRowNamingConvention(MetadataTools.getNamingConvention(rowNaming), 0);
        store.setPlateColumnNamingConvention(MetadataTools.getNamingConvention(colNaming), 0);
        store.setPlateRows(new PositiveInteger(this.wellRows), 0);
        store.setPlateColumns(new PositiveInteger(this.wellCols), 0);
        String plateAcqID = MetadataTools.createLSID("PlateAcquisition", 0, 0);
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        PositiveInteger maxFieldCount = FormatTools.getMaxFieldCount(this.fieldCount);
        if (maxFieldCount != null) {
            store.setPlateAcquisitionMaximumFieldCount(maxFieldCount, 0, 0);
        }
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        String experimentID = MetadataTools.createLSID("Experiment", 0);
        store.setInstrumentID(instrumentID, 0);
        store.setExperimentID(experimentID, 0);
        String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
        store.setObjectiveID(objectiveID, 0, 0);
        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
        store.setDetectorID(detectorID, 0, 0);
        int prevWell = -1;
        for (i = 0; i < seriesCount; ++i) {
            store.setObjectiveSettingsID(objectiveID, i);
            if (this.refractive != null) {
                store.setObjectiveSettingsRefractiveIndex(this.refractive, i);
            }
            if (this.x != null) {
                store.setPixelsPhysicalSizeX(this.x, i);
            }
            if (this.y != null) {
                store.setPixelsPhysicalSizeY(this.y, i);
            }
            well = this.getWellFromSeries(i);
            field = this.getFieldFromSeries(i);
            int totalTimepoints = this.oneTimepointPerSeries ? this.channelsPerTimepoint.size() : 1;
            int timepoint = this.oneTimepointPerSeries ? i % totalTimepoints + 1 : -1;
            String imageID = MetadataTools.createLSID("Image", i);
            store.setImageID(imageID, i);
            store.setImageInstrumentRef(instrumentID, i);
            store.setImageExperimentRef(experimentID, i);
            int wellRow = well / this.wellCols;
            int wellCol = well % this.wellCols;
            wellIndex = i / (this.fieldCount * totalTimepoints);
            if (well != prevWell) {
                String wellID = MetadataTools.createLSID("Well", 0, wellIndex);
                store.setWellID(wellID, 0, wellIndex);
                store.setWellRow(new NonNegativeInteger(wellRow), 0, wellIndex);
                store.setWellColumn(new NonNegativeInteger(wellCol), 0, wellIndex);
                prevWell = well;
            }
            char rowChar = this.rowName.charAt(this.rowName.length() - 1);
            char colChar = this.colName.charAt(this.colName.length() - 1);
            String row2 = this.rowName.substring(0, this.rowName.length() - 1);
            String col = this.colName.substring(0, this.colName.length() - 1);
            row2 = Character.isDigit(rowChar) ? row2 + (wellRow + Integer.parseInt(String.valueOf(rowChar))) : row2 + (char)(rowChar + wellRow);
            col = Character.isDigit(colChar) ? col + (wellCol + Integer.parseInt(String.valueOf(colChar))) : col + (char)(colChar + wellCol);
            String imageName = "Well " + row2 + "-" + col + ", Field #" + (field + 1);
            if (timepoint >= 0) {
                imageName = imageName + ", Timepoint #" + timepoint;
            }
            store.setImageName(imageName, i);
            if (this.creationDate != null) {
                store.setImageAcquisitionDate(new Timestamp(this.creationDate), i);
            }
            if (--timepoint < 0) {
                timepoint = 0;
            }
            int sampleIndex = field * totalTimepoints + timepoint;
            String wellSampleID = MetadataTools.createLSID("WellSample", 0, wellIndex, sampleIndex);
            store.setWellSampleID(wellSampleID, 0, wellIndex, sampleIndex);
            store.setWellSampleIndex(new NonNegativeInteger(i), 0, wellIndex, sampleIndex);
            store.setWellSampleImageRef(imageID, 0, wellIndex, sampleIndex);
            if (this.posX.containsKey(field)) {
                store.setWellSamplePositionX(this.posX.get(field), 0, wellIndex, sampleIndex);
            }
            if (this.posY.containsKey(field)) {
                store.setWellSamplePositionY(this.posY.get(field), 0, wellIndex, sampleIndex);
            }
            store.setPlateAcquisitionWellSampleRef(wellSampleID, 0, 0, i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (i = 0; i < seriesCount; ++i) {
                this.setSeries(i);
                well = this.getWellFromSeries(i);
                field = this.getFieldFromSeries(i);
                int timepoint = this.oneTimepointPerSeries ? i % this.channelsPerTimepoint.size() : 0;
                Double[][] minMax = new Double[this.getEffectiveSizeC()][2];
                for (int time = 0; time < this.getSizeT(); ++time) {
                    if (!this.oneTimepointPerSeries) {
                        timepoint = time;
                    }
                    int c = this.channelsPerTimepoint.get(timepoint);
                    for (int q = 0; q < this.getSizeZ() * c; ++q) {
                        Image img = this.imageFiles[well][field][timepoint][q];
                        if (img == null) continue;
                        int plane = time * this.getSizeZ() * c + q;
                        if (img.deltaT != null) {
                            store.setPlaneDeltaT(new Time(img.deltaT, UNITS.SECOND), i, plane);
                        }
                        if (img.exposure != null) {
                            store.setPlaneExposureTime(new Time(img.exposure, UNITS.SECOND), i, plane);
                        }
                        store.setPlanePositionX(this.posX.get(field), i, plane);
                        store.setPlanePositionY(this.posY.get(field), i, plane);
                        store.setPlanePositionZ(img.zPosition, i, plane);
                        int channel = this.getZCTCoords(plane)[1];
                        if (img.min != null && (minMax[channel][0] == null || img.min < minMax[channel][0])) {
                            minMax[channel][0] = img.min;
                        }
                        if (img.max == null || minMax[channel][1] != null && !(img.max > minMax[channel][1])) continue;
                        minMax[channel][1] = img.max;
                    }
                }
                for (int q = 0; q < this.getEffectiveSizeC(); ++q) {
                    Length excitation;
                    Double wave;
                    Length emission;
                    if (q < this.channelNames.size()) {
                        store.setChannelName(this.channelNames.get(q), i, q);
                    }
                    if (q < this.emWaves.size() && (emission = FormatTools.getEmissionWavelength(wave = this.emWaves.get(q))) != null) {
                        store.setChannelEmissionWavelength(emission, i, q);
                    }
                    if (q < this.exWaves.size() && (excitation = FormatTools.getExcitationWavelength(wave = this.exWaves.get(q))) != null) {
                        store.setChannelExcitationWavelength(excitation, i, q);
                    }
                    if (detectorID != null) {
                        store.setDetectorSettingsID(detectorID, i, q);
                        if (this.bin != null) {
                            store.setDetectorSettingsBinning(this.bin, i, q);
                        }
                        if (this.gain != null) {
                            store.setDetectorSettingsGain(this.gain, i, q);
                        }
                    }
                    LOGGER.trace("series {} channel {}: min = {}, max = {}", i, q, minMax[q][0], minMax[q][1]);
                    if (!(store instanceof IMinMaxStore)) continue;
                    IMinMaxStore minMaxStore = (IMinMaxStore)((Object)store);
                    minMaxStore.setChannelGlobalMinMax(q, minMax[q][0], minMax[q][1], i);
                }
                if (this.temperature == null) continue;
                store.setImagingEnvironmentTemperature(new Temperature(this.temperature, UNITS.CELSIUS), i);
            }
            this.setSeries(0);
            store.setPlateWellOriginX(new Length(0.5, UNITS.MICROMETER), 0);
            store.setPlateWellOriginY(new Length(0.5, UNITS.MICROMETER), 0);
        }
    }

    private int getFieldFromSeries(int series) {
        if (this.oneTimepointPerSeries) {
            series /= this.channelsPerTimepoint.size();
        }
        return series % this.fieldCount;
    }

    private int getWellFromSeries(int series) {
        if (this.oneTimepointPerSeries) {
            series /= this.channelsPerTimepoint.size();
        }
        int well = series / this.fieldCount;
        int counter = -1;
        for (int row = 0; row < this.plateMap.length; ++row) {
            for (int col = 0; col < this.plateMap[row].length; ++col) {
                if (this.plateMap[row][col]) {
                    ++counter;
                }
                if (counter != well) continue;
                return row * this.wellCols + col;
            }
        }
        return -1;
    }

    static /* synthetic */ Image[][][][] access$202(InCellReader x0, Image[][][][] x1) {
        x0.imageFiles = x1;
        return x1;
    }

    static /* synthetic */ boolean[][] access$702(InCellReader x0, boolean[][] x1) {
        x0.plateMap = x1;
        return x1;
    }

    static /* synthetic */ boolean[][] access$802(InCellReader x0, boolean[][] x1) {
        x0.exclude = x1;
        return x1;
    }

    class Image {
        public String filename;
        public String thumbnailFile;
        public boolean isTiff;
        public Double deltaT;
        public Double exposure;
        public Length zPosition;
        public Double min;
        public Double max;

        Image() {
        }
    }

    class InCellHandler
    extends BaseHandler {
        private String currentQName;
        private boolean openImage;
        private MetadataStore store;
        private int nextPlate = 0;
        private int currentRow = -1;
        private int currentCol = -1;
        private int currentField = 0;
        private int currentImage;
        private int currentPlane;
        private Double timestamp;
        private Double exposure;
        private Length zPosition;

        public InCellHandler(MetadataStore store) {
            this.store = store;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.currentQName.equals("UserComment")) {
                String value = new String(ch, start, length);
                this.store.setImageDescription(value, 0);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals("Image")) {
                InCellReader.this.wellCoordinates.put(this.currentField, new int[]{this.currentRow, this.currentCol});
                this.openImage = false;
                int well = this.currentRow * InCellReader.this.wellCols + this.currentCol;
                Image img = InCellReader.this.imageFiles[well][this.currentField][this.currentImage][this.currentPlane];
                if (img != null) {
                    img.deltaT = this.timestamp;
                    img.exposure = this.exposure;
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String key;
            this.currentQName = qName;
            for (int i = 0; i < attributes.getLength() && InCellReader.this.getMetadataValue(key = qName + " - " + attributes.getQName(i)) == null; ++i) {
                InCellReader.this.addGlobalMeta(key, attributes.getValue(i));
            }
            if (qName.equals("Microscopy")) {
                String experimentID = MetadataTools.createLSID("Experiment", 0);
                this.store.setExperimentID(experimentID, 0);
                try {
                    this.store.setExperimentType(MetadataTools.getExperimentType(attributes.getValue("type")), 0);
                }
                catch (FormatException e) {
                    LOGGER.warn("", e);
                }
            } else if (qName.equals("Image")) {
                this.openImage = true;
                double time = Double.parseDouble(attributes.getValue("acquisition_time_ms"));
                this.timestamp = time / 1000.0;
            } else if (qName.equals("Identifier")) {
                int t2;
                this.currentField = Integer.parseInt(attributes.getValue("field_index"));
                int z = Integer.parseInt(attributes.getValue("z_index"));
                int c = Integer.parseInt(attributes.getValue("wave_index"));
                this.currentImage = t2 = Integer.parseInt(attributes.getValue("time_index"));
                this.currentPlane = z * InCellReader.this.getSizeC() + c;
                int well = this.currentRow * InCellReader.this.wellCols + this.currentCol;
                Image img = InCellReader.this.imageFiles[well][this.currentField][this.currentImage][this.currentPlane];
                if (img != null) {
                    img.zPosition = this.zPosition;
                }
            } else if (qName.equals("FocusPosition")) {
                Double z = Double.valueOf(attributes.getValue("z"));
                this.zPosition = new Length(z, UNITS.REFERENCEFRAME);
            } else if (qName.equals("Creation")) {
                String date = attributes.getValue("date");
                String time = attributes.getValue("time");
                InCellReader.this.creationDate = date + "T" + time;
            } else if (qName.equals("ObjectiveCalibration")) {
                Double mag = Double.parseDouble(attributes.getValue("magnification"));
                this.store.setObjectiveNominalMagnification(mag, 0, 0);
                this.store.setObjectiveLensNA(DataTools.parseDouble(attributes.getValue("numerical_aperture")), 0, 0);
                try {
                    this.store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
                }
                catch (FormatException e) {
                    LOGGER.warn("", e);
                }
                String objective = attributes.getValue("objective_name");
                String[] tokens = objective.split("_");
                this.store.setObjectiveManufacturer(tokens[0], 0, 0);
                String correction = tokens.length > 2 ? tokens[2] : "Other";
                try {
                    this.store.setObjectiveCorrection(MetadataTools.getCorrection(correction), 0, 0);
                }
                catch (FormatException e) {
                    LOGGER.warn("", e);
                }
                Double pixelSizeX = DataTools.parseDouble(attributes.getValue("pixel_width"));
                Double pixelSizeY = DataTools.parseDouble(attributes.getValue("pixel_height"));
                InCellReader.this.refractive = DataTools.parseDouble(attributes.getValue("refractive_index"));
                InCellReader.this.x = FormatTools.getPhysicalSizeX(pixelSizeX);
                InCellReader.this.y = FormatTools.getPhysicalSizeY(pixelSizeY);
            } else if (qName.equals("ExcitationFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.exWaves.add(DataTools.parseDouble(wave));
                }
            } else if (qName.equals("EmissionFilter")) {
                String wave = attributes.getValue("wavelength");
                if (wave != null) {
                    InCellReader.this.emWaves.add(DataTools.parseDouble(wave));
                }
                InCellReader.this.channelNames.add(attributes.getValue("name"));
            } else if (qName.equals("Camera")) {
                this.store.setDetectorModel(attributes.getValue("name"), 0, 0);
                try {
                    this.store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, 0);
                }
                catch (FormatException e) {
                    LOGGER.warn("", e);
                }
            } else if (qName.equals("Binning")) {
                String binning = attributes.getValue("value");
                try {
                    InCellReader.this.bin = MetadataTools.getBinning(binning);
                }
                catch (FormatException objective) {}
            } else if (qName.equals("Gain")) {
                String value = attributes.getValue("value");
                if (value == null) {
                    return;
                }
                try {
                    InCellReader.this.gain = DataTools.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Could not parse gain '" + value + "'", e);
                }
            } else if (qName.equals("PlateTemperature")) {
                InCellReader.this.temperature = DataTools.parseDouble(attributes.getValue("value"));
            } else if (qName.equals("Plate")) {
                ++this.nextPlate;
            } else if (qName.equals("Row")) {
                this.currentRow = Integer.parseInt(attributes.getValue("number")) - 1;
            } else if (qName.equals("Column")) {
                this.currentCol = Integer.parseInt(attributes.getValue("number")) - 1;
            } else if (qName.equals("Exposure") && this.openImage) {
                double exp = Double.parseDouble(attributes.getValue("time"));
                this.exposure = exp / 1000.0;
            } else if (qName.equals("offset_point")) {
                String x = attributes.getValue("x");
                String y = attributes.getValue("y");
                Integer index = DataTools.parseInteger(attributes.getValue("index"));
                if (null == index) {
                    index = InCellReader.this.offsetPointCounter++;
                }
                InCellReader.this.posX.put(index, new Length(Double.valueOf(x), UNITS.REFERENCEFRAME));
                InCellReader.this.posY.put(index, new Length(-1.0 * Double.valueOf(y), UNITS.REFERENCEFRAME));
                InCellReader.this.addGlobalMetaList("X position for position", x);
                InCellReader.this.addGlobalMetaList("Y position for position", y);
            }
        }
    }

    class MinimalInCellHandler
    extends BaseHandler {
        private String currentImageFile;
        private String currentThumbnail;
        private int wellRow;
        private int wellCol;
        private int nChannels = 0;
        private boolean doT = true;
        private boolean doZ = true;
        private Image lastImage = null;

        MinimalInCellHandler() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            block8: {
                block9: {
                    block7: {
                        if (!qName.equals("PlateMap")) break block7;
                        int sizeT = InCellReader.this.getSizeT();
                        if (sizeT == 0) {
                            sizeT = 1;
                        }
                        if (InCellReader.this.channelsPerTimepoint.size() == 0) {
                            CoreMetadata ms0 = (CoreMetadata)InCellReader.this.core.get(0);
                            InCellReader.this.channelsPerTimepoint.add(ms0.sizeC);
                        }
                        InCellReader.access$202(InCellReader.this, new Image[InCellReader.this.wellRows * InCellReader.this.wellCols][InCellReader.this.fieldCount][sizeT][]);
                        for (int well = 0; well < InCellReader.this.wellRows * InCellReader.this.wellCols; ++well) {
                            for (int field = 0; field < InCellReader.this.fieldCount; ++field) {
                                for (int t2 = 0; t2 < sizeT; ++t2) {
                                    int channels = (Integer)InCellReader.this.channelsPerTimepoint.get(t2);
                                    ((InCellReader)InCellReader.this).imageFiles[well][field][t2] = new Image[channels * InCellReader.this.getSizeZ()];
                                }
                            }
                        }
                        break block8;
                    }
                    if (!qName.equals("TimePoint")) break block9;
                    InCellReader.this.channelsPerTimepoint.add(this.nChannels);
                    this.nChannels = 0;
                    break block8;
                }
                if (!qName.equals("Times")) break block8;
                if (InCellReader.this.channelsPerTimepoint.size() == 0) {
                    InCellReader.this.channelsPerTimepoint.add(InCellReader.this.getSizeC());
                }
                for (int i = 0; i < InCellReader.this.channelsPerTimepoint.size(); ++i) {
                    int c = (Integer)InCellReader.this.channelsPerTimepoint.get(i);
                    if (c != 0) continue;
                    InCellReader.this.channelsPerTimepoint.set(i, InCellReader.this.getSizeC());
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            CoreMetadata ms0 = (CoreMetadata)InCellReader.this.core.get(0);
            if (qName.equals("Plate")) {
                InCellReader.this.wellRows = Integer.parseInt(attributes.getValue("rows"));
                InCellReader.this.wellCols = Integer.parseInt(attributes.getValue("columns"));
                InCellReader.access$702(InCellReader.this, new boolean[InCellReader.this.wellRows][InCellReader.this.wellCols]);
            } else if (qName.equals("Exclude")) {
                if (InCellReader.this.exclude == null) {
                    InCellReader.access$802(InCellReader.this, new boolean[InCellReader.this.wellRows][InCellReader.this.wellCols]);
                }
                int row = Integer.parseInt(attributes.getValue("row")) - 1;
                int col = Integer.parseInt(attributes.getValue("col")) - 1;
                ((InCellReader)InCellReader.this).exclude[row][col] = true;
            } else if (qName.equals("Images")) {
                InCellReader.this.imagesNumber = Integer.parseInt(attributes.getValue("number"));
            } else if (qName.equals("Image")) {
                InCellReader.this.totalImages++;
                String file2 = attributes.getValue("filename");
                String thumb = attributes.getValue("thumbnail");
                Location current = new Location(InCellReader.this.currentId).getAbsoluteFile();
                Location imageFile = new Location(current.getParentFile(), file2);
                this.currentImageFile = imageFile.getAbsolutePath();
                this.currentThumbnail = new Location(current.getParentFile(), thumb).getAbsolutePath();
            } else if (qName.equals("Identifier")) {
                int field = Integer.parseInt(attributes.getValue("field_index"));
                int z = Integer.parseInt(attributes.getValue("z_index"));
                int c = Integer.parseInt(attributes.getValue("wave_index"));
                int t2 = Integer.parseInt(attributes.getValue("time_index"));
                int channels = (Integer)InCellReader.this.channelsPerTimepoint.get(t2);
                int index = FormatTools.getIndex("XYZCT", InCellReader.this.getSizeZ(), channels, 1, InCellReader.this.getSizeZ() * channels, z, c, 0);
                Image img = new Image();
                img.thumbnailFile = this.currentThumbnail;
                Location file3 = new Location(this.currentImageFile);
                String string = img.filename = file3.exists() ? this.currentImageFile : null;
                if (img.filename == null) {
                    LOGGER.debug("{} does not exist.", (Object)this.currentImageFile);
                }
                this.currentImageFile = this.currentImageFile.toLowerCase();
                img.isTiff = this.currentImageFile.endsWith(".tif") || this.currentImageFile.endsWith(".tiff");
                ((InCellReader)InCellReader.this).imageFiles[this.wellRow * ((InCellReader)InCellReader.this).wellCols + this.wellCol][field][t2][index] = img;
                this.lastImage = img;
            } else if (qName.equals("MinMaxMean")) {
                if (this.lastImage != null) {
                    this.lastImage.min = DataTools.parseDouble(attributes.getValue("min"));
                    this.lastImage.max = DataTools.parseDouble(attributes.getValue("max"));
                }
            } else if (qName.equals("offset_point")) {
                InCellReader.this.fieldCount++;
            } else if (qName.equals("TimePoint") && this.doT) {
                ++ms0.sizeT;
            } else if (qName.equals("Wavelength")) {
                String mode;
                String fusion = attributes.getValue("fusion_wave");
                if (fusion.equals("false")) {
                    ++ms0.sizeC;
                }
                if ((mode = attributes.getValue("imaging_mode")) != null) {
                    this.doZ = mode.equals("3-D");
                }
            } else if (qName.equals("AcqWave")) {
                ++this.nChannels;
            } else if (qName.equals("ZDimensionParameters")) {
                String nz = attributes.getValue("number_of_slices");
                ms0.sizeZ = nz != null && this.doZ ? Integer.parseInt(nz) : 1;
            } else if (qName.equals("Row")) {
                this.wellRow = Integer.parseInt(attributes.getValue("number")) - 1;
            } else if (qName.equals("Column")) {
                this.wellCol = Integer.parseInt(attributes.getValue("number")) - 1;
                ((InCellReader)InCellReader.this).plateMap[this.wellRow][this.wellCol] = true;
            } else if (qName.equals("Size")) {
                InCellReader.this.imageWidth = Integer.parseInt(attributes.getValue("width"));
                InCellReader.this.imageHeight = Integer.parseInt(attributes.getValue("height"));
            } else if (qName.equals("NamingRows")) {
                InCellReader.this.rowName = attributes.getValue("begin");
            } else if (qName.equals("NamingColumns")) {
                InCellReader.this.colName = attributes.getValue("begin");
            } else if (qName.equals("TimeSchedule")) {
                this.doT = Boolean.parseBoolean(attributes.getValue("enabled"));
            } else if (qName.equals("ExcitationFilter")) {
                InCellReader.this.exFilters.add(attributes.getValue("name"));
            } else if (qName.equals("EmissionFilter")) {
                InCellReader.this.emFilters.add(attributes.getValue("name"));
            }
        }
    }
}

