/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import loci.formats.in.LeicaMicrosystemsMetadata.Channel;
import loci.formats.in.LeicaMicrosystemsMetadata.Dimension;
import loci.formats.in.LeicaMicrosystemsMetadata.ROI;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Color;

public class MetadataTempBuffer {
    public List<ArrayList<Color>> channelColors = new ArrayList<ArrayList<Color>>();
    public int[][] channelPrios;
    public List<Double> physicalSizeXs = new ArrayList<Double>();
    public List<Double> physicalSizeYs = new ArrayList<Double>();
    public List<Length> fieldPosX = new ArrayList<Length>();
    public List<Length> fieldPosY = new ArrayList<Length>();
    public String[] descriptions;
    public String[] microscopeModels;
    public String[] serialNumber;
    public Double[] pinholes;
    public Double[] zooms;
    public Double[] zSteps;
    public Double[] tSteps;
    public Double[] lensNA;
    public boolean[] flipX;
    public boolean[] flipY;
    public boolean[] swapXY;
    public Double[][] expTimes;
    public Double[][] gains;
    public Double[][] detectorOffsets;
    public String[][] channelNames;
    public ArrayList<ArrayList<String>> detectorModels;
    public Double[][] exWaves;
    public ArrayList<ArrayList<Boolean>> activeDetector;
    public ArrayList<HashMap<Integer, String>> detectorIndexes;
    public String[] immersions;
    public String[] corrections;
    public String[] objectiveModels;
    public Double[] magnification;
    public Length[] posX;
    public Length[] posY;
    public Length[] posZ;
    public Double[] refractiveIndex;
    public ArrayList<ArrayList<Length>> cutIns;
    public ArrayList<ArrayList<Length>> cutOuts;
    public ArrayList<ArrayList<String>> filterModels;
    public Double[][] timestamps;
    public ArrayList<ArrayList<Double>> laserIntensity;
    public ArrayList<ArrayList<Double>> laserWavelength;
    public ArrayList<ArrayList<Boolean>> laserActive;
    public ArrayList<ArrayList<Boolean>> laserFrap;
    public ROI[][] imageROIs;
    public boolean alternateCenter = false;
    public String[] imageNames;
    public double[] acquiredDate;
    public int[] tileCount;
    public long[] tileBytesInc;
    public boolean[] inverseRgb;
    private ArrayList<ArrayList<Dimension>> dimensions;
    public ArrayList<ArrayList<Channel>> channels;

    public MetadataTempBuffer(int len) {
        this.tileCount = new int[len];
        Arrays.fill(this.tileCount, 1);
        this.tileBytesInc = new long[len];
        this.acquiredDate = new double[len];
        this.descriptions = new String[len];
        this.timestamps = new Double[len][];
        this.serialNumber = new String[len];
        this.lensNA = new Double[len];
        this.magnification = new Double[len];
        this.immersions = new String[len];
        this.corrections = new String[len];
        this.objectiveModels = new String[len];
        this.posX = new Length[len];
        this.posY = new Length[len];
        this.posZ = new Length[len];
        this.refractiveIndex = new Double[len];
        this.microscopeModels = new String[len];
        this.zSteps = new Double[len];
        this.tSteps = new Double[len];
        this.pinholes = new Double[len];
        this.zooms = new Double[len];
        this.flipX = new boolean[len];
        this.flipY = new boolean[len];
        this.swapXY = new boolean[len];
        this.expTimes = new Double[len][];
        this.gains = new Double[len][];
        this.detectorOffsets = new Double[len][];
        this.channelNames = new String[len][];
        this.exWaves = new Double[len][];
        this.imageROIs = new ROI[len][];
        this.imageNames = new String[len];
        this.inverseRgb = new boolean[len];
        this.laserWavelength = this.ArrayListOfArrayLists(len, Double.class);
        this.activeDetector = this.ArrayListOfArrayLists(len, Boolean.class);
        this.cutIns = this.ArrayListOfArrayLists(len, Length.class);
        this.cutOuts = this.ArrayListOfArrayLists(len, Length.class);
        this.filterModels = this.ArrayListOfArrayLists(len, String.class);
        this.detectorModels = this.ArrayListOfArrayLists(len, String.class);
        this.detectorIndexes = this.ArrayListOfHashMaps(len, Integer.class, String.class);
        this.laserIntensity = this.ArrayListOfArrayLists(len, Double.class);
        this.laserActive = this.ArrayListOfArrayLists(len, Boolean.class);
        this.laserFrap = this.ArrayListOfArrayLists(len, Boolean.class);
        this.dimensions = this.ArrayListOfArrayLists(len, Dimension.class);
        this.channels = this.ArrayListOfArrayLists(len, Channel.class);
    }

    public Dimension getDimension(int imageIndex, Dimension.DimensionKey key) {
        for (Dimension dimension : this.dimensions.get(imageIndex)) {
            if (dimension.key != key) continue;
            return dimension;
        }
        return null;
    }

    public void addDimension(int imageIndex, Dimension dimension) {
        this.dimensions.get(imageIndex).add(dimension);
        if (dimension.key == Dimension.DimensionKey.X) {
            this.physicalSizeXs.add(dimension.getLength());
        } else if (dimension.key == Dimension.DimensionKey.Y) {
            this.physicalSizeYs.add(dimension.getLength());
        } else if (dimension.key == Dimension.DimensionKey.Z) {
            if (this.zSteps[imageIndex] == null && dimension.getLength() != null) {
                this.zSteps[imageIndex] = Math.abs(dimension.getLength());
            }
        } else if (dimension.key == Dimension.DimensionKey.S) {
            int n = imageIndex;
            this.tileCount[n] = this.tileCount[n] * dimension.size;
            this.tileBytesInc[imageIndex] = dimension.bytesInc;
        }
    }

    public String getDimensionOrder(int imageIndex) {
        this.sortDimensions(imageIndex);
        String dimensionOrder = "";
        ArrayList<Dimension.DimensionKey> standardDimensions = new ArrayList<Dimension.DimensionKey>(Arrays.asList(Dimension.DimensionKey.X, Dimension.DimensionKey.Y, Dimension.DimensionKey.Z, Dimension.DimensionKey.C, Dimension.DimensionKey.T));
        for (Dimension dimension : this.dimensions.get(imageIndex)) {
            if (!standardDimensions.contains((Object)dimension.key)) continue;
            dimensionOrder = dimensionOrder + dimension.key.token;
        }
        return dimensionOrder;
    }

    private void sortDimensions(int coreIndex) {
        List dims = this.dimensions.get(coreIndex);
        dims.sort((dim1, dim2) -> Long.compare(dim1.bytesInc, dim2.bytesInc));
        Dimension dimX = this.getDimension(coreIndex, Dimension.DimensionKey.X);
        Dimension dimY = this.getDimension(coreIndex, Dimension.DimensionKey.Y);
        this.dimensions.get(coreIndex).remove(dimX);
        this.dimensions.get(coreIndex).remove(dimY);
        if (dimX.bytesInc < dimY.bytesInc) {
            this.dimensions.get(coreIndex).add(0, dimX);
            this.dimensions.get(coreIndex).add(1, dimY);
        } else {
            this.dimensions.get(coreIndex).add(0, dimY);
            this.dimensions.get(coreIndex).add(1, dimX);
        }
        Dimension dimS = this.getDimension(coreIndex, Dimension.DimensionKey.S);
        this.dimensions.get(coreIndex).remove(dimS);
        this.dimensions.get(coreIndex).add(dimS);
    }

    public ArrayList<Dimension> getDimensions(int imageIndex) {
        this.sortDimensions(imageIndex);
        return this.dimensions.get(imageIndex);
    }

    public void addMissingDimensions(int imageIndex) {
        this.dimensions.get(imageIndex).sort((dim1, dim2) -> Long.compare(dim1.bytesInc, dim2.bytesInc));
        Dimension lastDimension = this.dimensions.get(imageIndex).get(this.dimensions.get(imageIndex).size() - 1);
        if (this.getDimension(imageIndex, Dimension.DimensionKey.Z) == null) {
            this.addDimension(imageIndex, new Dimension(Dimension.DimensionKey.Z, 1, lastDimension.bytesInc, "m", 1.0, lastDimension.oldPhysicalSize));
        }
        if (this.getDimension(imageIndex, Dimension.DimensionKey.T) == null) {
            this.addDimension(imageIndex, new Dimension(Dimension.DimensionKey.T, 1, lastDimension.bytesInc, "s", 1.0, lastDimension.oldPhysicalSize));
        }
        if (this.getDimension(imageIndex, Dimension.DimensionKey.S) == null) {
            this.addDimension(imageIndex, new Dimension(Dimension.DimensionKey.S, 1, lastDimension.bytesInc, "", 1.0, lastDimension.oldPhysicalSize));
        }
    }

    public void addChannelDimension(int coreIndex) {
        boolean rgb = this.getDimension((int)coreIndex, (Dimension.DimensionKey)Dimension.DimensionKey.X).bytesInc % 3L == 0L;
        int sizeC = rgb ? this.channels.get(coreIndex).size() / 3 : this.channels.get(coreIndex).size();
        long channelBytesInc = this.getChannelDimensionBytesInc(coreIndex);
        this.addDimension(coreIndex, Dimension.createChannelDimension(sizeC, channelBytesInc));
    }

    private long getChannelDimensionBytesInc(int coreIndex) {
        boolean rgb = this.getDimension((int)coreIndex, (Dimension.DimensionKey)Dimension.DimensionKey.X).bytesInc % 3L == 0L;
        long maxBytesInc = 0L;
        if (rgb) {
            for (int i = 0; i < this.channels.get(coreIndex).size(); ++i) {
                Channel channel = this.channels.get(coreIndex).get(i);
                if (channel.channelTag != 3) continue;
                maxBytesInc = channel.bytesInc > maxBytesInc ? channel.bytesInc : maxBytesInc;
            }
        } else {
            for (Channel channel : this.channels.get(coreIndex)) {
                maxBytesInc = channel.bytesInc > maxBytesInc ? channel.bytesInc : maxBytesInc;
            }
        }
        if (maxBytesInc == 0L) {
            Dimension yDim = this.getDimension(coreIndex, Dimension.DimensionKey.Y);
            maxBytesInc = yDim.bytesInc * (long)yDim.size;
        }
        return maxBytesInc;
    }

    private <T> ArrayList<ArrayList<T>> ArrayListOfArrayLists(int rows, Class<T> type) {
        ArrayList<ArrayList<T>> lst = new ArrayList<ArrayList<T>>();
        for (int i = 0; i < rows; ++i) {
            lst.add(new ArrayList());
        }
        return lst;
    }

    private <T, S> ArrayList<HashMap<T, S>> ArrayListOfHashMaps(int rows, Class<T> key, Class<S> value) {
        ArrayList<HashMap<T, S>> lst = new ArrayList<HashMap<T, S>>();
        for (int i = 0; i < rows; ++i) {
            lst.add(new HashMap());
        }
        return lst;
    }
}

