/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import loci.common.RandomAccessInputStream;

public class SDTInfo {
    public static final short BH_HEADER_CHKSUM = 21930;
    public static final short BH_HEADER_NOT_VALID = 4369;
    public static final short BH_HEADER_VALID = 21845;
    public static final String SETUP_IDENTIFIER = "\u0004SPC Setup Script File\u0004";
    public static final String DATA_IDENTIFIER = "\u0004SPC Setup & Data File\u0004";
    public static final String FLOW_DATA_IDENTIFIER = "\u0004SPC Flow Data File\u0004";
    public static final String DLL_DATA_IDENTIFIER = "\u0004SPC DLL Data File\u0004";
    public static final String FCS_DATA_IDENTIFIER = "\u0004SPC FCS Data File\u0004";
    public static final String X_STRING = "#SP [SP_SCAN_X,I,";
    public static final String Y_STRING = "#SP [SP_SCAN_Y,I,";
    public static final String T_STRING = "#SP [SP_ADC_RE,I,";
    public static final String C_STRING = "#SP [SP_SCAN_RX,I,";
    public static final String X_IMG_STRING = "#SP [SP_IMG_X,I,";
    public static final String Y_IMG_STRING = "#SP [SP_IMG_Y,I,";
    public static final String BINARY_SETUP = "BIN_PARA_BEGIN:\u0000";
    public int width;
    public int height;
    public int timeBins;
    public int channels;
    public int timepoints;
    public short revision;
    public int infoOffs;
    public short infoLength;
    public int setupOffs;
    public short setupLength;
    public int dataBlockOffs;
    public short noOfDataBlocks;
    public int dataBlockLength;
    public int measDescBlockOffs;
    public short noOfMeasDescBlocks;
    public short measDescBlockLength;
    public int headerValid;
    public long reserved1;
    public int reserved2;
    public int chksum;
    public String info;
    public String setup;
    public boolean hasMeasureInfo;
    public String time;
    public String date;
    public String modSerNo;
    public short measMode;
    public float cfdLL;
    public float cfdLH;
    public float cfdZC;
    public float cfdHF;
    public float synZC;
    public short synFD;
    public float synHF;
    public float tacR;
    public short tacG;
    public float tacOF;
    public float tacLL;
    public float tacLH;
    public short adcRE;
    public short ealDE;
    public short ncx;
    public short ncy;
    public int page;
    public float colT;
    public float repT;
    public short stopt;
    public int overfl;
    public short useMotor;
    public int steps;
    public float offset;
    public short dither;
    public short incr;
    public short memBank;
    public String modType;
    public float synTH;
    public short deadTimeComp;
    public short polarityL;
    public short polarityF;
    public short polarityP;
    public short linediv;
    public short accumulate;
    public int flbckY;
    public int flbckX;
    public int bordU;
    public int bordL;
    public float pixTime;
    public short pixClk;
    public short trigger;
    public int scanX;
    public int scanY;
    public int scanRX;
    public int scanRY;
    public short fifoTyp;
    public int epxDiv;
    public int modTypeCode;
    public int modFpgaVer;
    public float overflowCorrFactor;
    public int adcZoom;
    public int cycles;
    public boolean hasMeasStopInfo;
    public int status;
    public int flags;
    public float stopTime;
    public int curStep;
    public int curCycle;
    public int curPage;
    public float minSyncRate;
    public float minCfdRate;
    public float minTacRate;
    public float minAdcRate;
    public float maxSyncRate;
    public float maxCfdRate;
    public float maxTacRate;
    public float maxAdcRate;
    public int mReserved1;
    public float mReserved2;
    public boolean hasMeasFCSInfo;
    public int chan;
    public int fcsDecayCalc;
    public long mtResol;
    public float cortime;
    public long calcPhotons;
    public int fcsPoints;
    public float endTime;
    public int overruns;
    public int fcsType;
    public int crossChan;
    public int mod;
    public int crossMod;
    public long crossMtResol;
    public boolean hasExtendedMeasureInfo;
    public int imageX;
    public int imageY;
    public int imageRX;
    public int imageRY;
    public short xyGain;
    public short masterClock;
    public short adcDE;
    public short detType;
    public short xAxis;
    public boolean hasMeasHISTInfo;
    public float fidaTime;
    public float fildaTime;
    public int fidaPoints;
    public int fildaPoints;
    public float mcsTime;
    public int mcsPoints;
    public int mcstaPoints;
    public short blockNo;
    public int dataOffs;
    public int nextBlockOffs;
    public long[] allBlockOffsets;
    public long[] allBlockLengths;
    public int blockType;
    public short measDescBlockNo;
    public long lblockNo;
    public long blockLength;

    public SDTInfo(RandomAccessInputStream in, Hashtable meta) throws IOException {
        this.revision = in.readShort();
        this.infoOffs = in.readInt();
        this.infoLength = in.readShort();
        this.setupOffs = in.readInt();
        this.setupLength = in.readShort();
        this.dataBlockOffs = in.readInt();
        this.noOfDataBlocks = in.readShort();
        this.dataBlockLength = in.readInt();
        this.measDescBlockOffs = in.readInt();
        this.noOfMeasDescBlocks = in.readShort();
        this.measDescBlockLength = in.readShort();
        this.headerValid = in.readUnsignedShort();
        this.reserved1 = 0xFFFFFFFFL & (long)in.readInt();
        this.reserved2 = in.readUnsignedShort();
        this.chksum = in.readUnsignedShort();
        if (meta != null) {
            String bhfileHeader = "bhfileHeader.";
            meta.put("bhfileHeader.revision", this.revision);
            meta.put("bhfileHeader.infoOffs", this.infoOffs);
            meta.put("bhfileHeader.infoLength", this.infoLength);
            meta.put("bhfileHeader.setupOffs", this.setupOffs);
            meta.put("bhfileHeader.dataBlockOffs", this.dataBlockOffs);
            meta.put("bhfileHeader.noOfDataBlocks", this.noOfDataBlocks);
            meta.put("bhfileHeader.dataBlockLength", this.dataBlockLength);
            meta.put("bhfileHeader.measDescBlockOffs", this.measDescBlockOffs);
            meta.put("bhfileHeader.noOfMeasDescBlocks", this.noOfMeasDescBlocks);
            meta.put("bhfileHeader.measDescBlockLength", Integer.valueOf(this.measDescBlockLength));
            meta.put("bhfileHeader.headerValid", this.headerValid);
            meta.put("bhfileHeader.reserved1", this.reserved1);
            meta.put("bhfileHeader.reserved2", this.reserved2);
            meta.put("bhfileHeader.chksum", this.chksum);
        }
        in.seek(this.infoOffs);
        byte[] infoBytes = new byte[this.infoLength];
        in.readFully(infoBytes);
        this.info = new String(infoBytes, "UTF-8");
        StringTokenizer st = new StringTokenizer(this.info, "\n");
        int count = st.countTokens();
        st.nextToken();
        String key = null;
        String value = null;
        for (int i = 1; i < count - 1; ++i) {
            String token = st.nextToken().trim();
            if (token.indexOf(58) == -1) continue;
            key = token.substring(0, token.indexOf(58)).trim();
            value = token.substring(token.indexOf(58) + 1).trim();
            meta.put(key, value);
        }
        in.seek(this.setupOffs);
        byte[] setupBytes = new byte[this.setupLength];
        in.readFully(setupBytes);
        this.setup = new String(setupBytes, "UTF-8");
        int textEnd = this.setup.indexOf(BINARY_SETUP);
        if (textEnd > 0) {
            this.setup = this.setup.substring(0, textEnd);
            in.seek(this.setupOffs + (textEnd += BINARY_SETUP.length()));
        }
        int mode13width = 0;
        int mode13height = 0;
        st = new StringTokenizer(this.setup, "\n");
        while (st.hasMoreTokens()) {
            int end;
            int ndx;
            String token = st.nextToken().trim();
            if (token.startsWith("#SP") || token.startsWith("#DI") || token.startsWith("#PR") || token.startsWith("#MP")) {
                int open = token.indexOf(91);
                key = token.substring(open + 1, token.indexOf(",", open));
                value = token.substring(token.lastIndexOf(",") + 1, token.length() - 1);
            } else if (token.startsWith("#TR") || token.startsWith("#WI")) {
                key = token.substring(0, token.indexOf(91)).trim();
                value = token.substring(token.indexOf(91) + 1, token.indexOf(93));
            }
            if (key != null && value != null) {
                meta.put(key, value);
            }
            if (token.indexOf(X_STRING) != -1) {
                ndx = token.indexOf(X_STRING) + X_STRING.length();
                end = token.indexOf("]", ndx);
                this.width = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(Y_STRING) != -1) {
                ndx = token.indexOf(Y_STRING) + Y_STRING.length();
                end = token.indexOf("]", ndx);
                this.height = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(T_STRING) != -1) {
                ndx = token.indexOf(T_STRING) + T_STRING.length();
                end = token.indexOf("]", ndx);
                this.timeBins = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(C_STRING) != -1) {
                ndx = token.indexOf(C_STRING) + C_STRING.length();
                end = token.indexOf("]", ndx);
                this.channels = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(X_IMG_STRING) != -1) {
                ndx = token.indexOf(X_IMG_STRING) + X_IMG_STRING.length();
                end = token.indexOf("]", ndx);
                mode13width = Integer.parseInt(token.substring(ndx, end));
                continue;
            }
            if (token.indexOf(Y_IMG_STRING) == -1) continue;
            ndx = token.indexOf(Y_IMG_STRING) + Y_IMG_STRING.length();
            end = token.indexOf("]", ndx);
            mode13height = Integer.parseInt(token.substring(ndx, end));
        }
        if (in.getFilePointer() < (long)(this.setupOffs + this.setupLength)) {
            in.skipBytes(4);
            long baseOffset = in.getFilePointer();
            long softwareRevision = this.readUnsignedLong(in);
            long paramLength = this.readUnsignedLong(in);
            long reserved1 = this.readUnsignedLong(in);
            int reserved2 = in.readShort() & 0xFFFF;
            long fcsOldOffset = this.readUnsignedLong(in);
            long fcsOldSize = this.readUnsignedLong(in);
            long gr1Offset = this.readUnsignedLong(in);
            long gr1Size = this.readUnsignedLong(in);
            long fcsOffset = this.readUnsignedLong(in);
            long fcsSize = this.readUnsignedLong(in);
            long fidaOffset = this.readUnsignedLong(in);
            long fidaSize = this.readUnsignedLong(in);
            long fildaOffset = this.readUnsignedLong(in);
            long fildaSize = this.readUnsignedLong(in);
            long gr2Offset = this.readUnsignedLong(in);
            int grNo = in.readShort() & 0xFFFF;
            int hstNo = in.readShort() & 0xFFFF;
            long hstOffset = this.readUnsignedLong(in);
            long gvdOffset = this.readUnsignedLong(in);
            int gvdSize = in.readShort() & 0xFFFF;
            int fitOffset = in.readShort() & 0xFFFF;
            int fitSize = in.readShort() & 0xFFFF;
            int extdevOffset = in.readShort() & 0xFFFF;
            int extdevSize = in.readShort() & 0xFFFF;
            long binhdrextOffset = this.readUnsignedLong(in);
            int binhdrextSize = in.readShort() & 0xFFFF;
            if (binhdrextOffset != 0L) {
                in.seek(baseOffset + binhdrextOffset);
                long mcsImgOffset = this.readUnsignedLong(in);
                long mcsImgSize = this.readUnsignedLong(in);
                int momNo = in.readShort() & 0xFFFF;
                int momSize = in.readShort() & 0xFFFF;
                long momOffset = this.readUnsignedLong(in);
                long sysparExtOffset = this.readUnsignedLong(in);
                long sysparExtSize = this.readUnsignedLong(in);
                long mosaicOffset = this.readUnsignedLong(in);
                long mosaicSize = this.readUnsignedLong(in);
                if (mcsImgOffset != 0L) {
                    in.seek(baseOffset + mcsImgOffset);
                    int mcsActive = in.readInt();
                    in.skipBytes(4);
                    this.mcstaPoints = in.readShort() & 0xFFFF;
                    int mcstaFlags = in.readShort() & 0xFFFF;
                    int mcstaTimePerPoint = in.readShort() & 0xFFFF;
                    float mcsOffset = in.readFloat();
                    float mcsTpp = in.readFloat();
                    if (meta != null) {
                        meta.put("MCS_TA.active", mcsActive);
                        meta.put("MCS_TA.points", this.mcstaPoints);
                        meta.put("MCS_TA.flags", mcstaFlags);
                        meta.put("MCS_TA.time per point", mcstaTimePerPoint);
                    }
                }
            }
        }
        if (this.noOfMeasDescBlocks > 0) {
            in.seek(this.measDescBlockOffs);
            this.hasMeasureInfo = this.measDescBlockLength >= 211;
            this.hasMeasStopInfo = this.measDescBlockLength >= 271;
            this.hasMeasFCSInfo = this.measDescBlockLength >= 309;
            this.hasExtendedMeasureInfo = this.measDescBlockLength >= 335;
            boolean bl = this.hasMeasHISTInfo = this.measDescBlockLength >= 359;
            if (this.hasMeasureInfo) {
                this.time = in.readString(9).trim();
                this.date = in.readString(11).trim();
                this.modSerNo = in.readString(16).trim();
                this.measMode = in.readShort();
                this.cfdLL = in.readFloat();
                this.cfdLH = in.readFloat();
                this.cfdZC = in.readFloat();
                this.cfdHF = in.readFloat();
                this.synZC = in.readFloat();
                this.synFD = in.readShort();
                this.synHF = in.readFloat();
                this.tacR = in.readFloat();
                this.tacG = in.readShort();
                this.tacOF = in.readFloat();
                this.tacLL = in.readFloat();
                this.tacLH = in.readFloat();
                this.adcRE = in.readShort();
                this.ealDE = in.readShort();
                this.ncx = in.readShort();
                this.ncy = in.readShort();
                this.page = in.readUnsignedShort();
                this.colT = in.readFloat();
                this.repT = in.readFloat();
                this.stopt = in.readShort();
                this.overfl = in.readUnsignedByte();
                this.useMotor = in.readShort();
                this.steps = in.readUnsignedShort();
                this.offset = in.readFloat();
                this.dither = in.readShort();
                this.incr = in.readShort();
                this.memBank = in.readShort();
                this.modType = in.readString(16).trim();
                this.synTH = in.readFloat();
                this.deadTimeComp = in.readShort();
                this.polarityL = in.readShort();
                this.polarityF = in.readShort();
                this.polarityP = in.readShort();
                this.linediv = in.readShort();
                this.accumulate = in.readShort();
                this.flbckY = in.readInt();
                this.flbckX = in.readInt();
                this.bordU = in.readInt();
                this.bordL = in.readInt();
                this.pixTime = in.readFloat();
                this.pixClk = in.readShort();
                this.trigger = in.readShort();
                this.scanX = in.readInt();
                this.scanY = in.readInt();
                this.scanRX = in.readInt();
                this.scanRY = in.readInt();
                this.fifoTyp = in.readShort();
                this.epxDiv = in.readInt();
                this.modTypeCode = in.readUnsignedShort();
                this.modFpgaVer = in.readUnsignedShort();
                this.overflowCorrFactor = in.readFloat();
                this.adcZoom = in.readInt();
                this.cycles = in.readInt();
                this.timepoints = this.stopt;
                if (meta != null) {
                    String measureInfo = "MeasureInfo.";
                    meta.put("MeasureInfo.time", this.time);
                    meta.put("MeasureInfo.date", this.date);
                    meta.put("MeasureInfo.modSerNo", this.modSerNo);
                    meta.put("MeasureInfo.measMode", this.measMode);
                    meta.put("MeasureInfo.cfdLL", Float.valueOf(this.cfdLL));
                    meta.put("MeasureInfo.cfdLH", Float.valueOf(this.cfdLH));
                    meta.put("MeasureInfo.cfdZC", Float.valueOf(this.cfdZC));
                    meta.put("MeasureInfo.cfdHF", Float.valueOf(this.cfdHF));
                    meta.put("MeasureInfo.synZC", Float.valueOf(this.synZC));
                    meta.put("MeasureInfo.synFD", this.synFD);
                    meta.put("MeasureInfo.synHF", Float.valueOf(this.synHF));
                    meta.put("MeasureInfo.tacR", Float.valueOf(this.tacR));
                    meta.put("MeasureInfo.tacG", this.tacG);
                    meta.put("MeasureInfo.tacOF", Float.valueOf(this.tacOF));
                    meta.put("MeasureInfo.tacLL", Float.valueOf(this.tacLL));
                    meta.put("MeasureInfo.tacLH", Float.valueOf(this.tacLH));
                    meta.put("MeasureInfo.adcRE", this.adcRE);
                    meta.put("MeasureInfo.ealDE", this.ealDE);
                    meta.put("MeasureInfo.ncx", this.ncx);
                    meta.put("MeasureInfo.ncy", this.ncy);
                    meta.put("MeasureInfo.page", this.page);
                    meta.put("MeasureInfo.colT", Float.valueOf(this.colT));
                    meta.put("MeasureInfo.repT", Float.valueOf(this.repT));
                    meta.put("MeasureInfo.stopt", this.stopt);
                    meta.put("MeasureInfo.overfl", this.overfl);
                    meta.put("MeasureInfo.useMotor", this.useMotor);
                    meta.put("MeasureInfo.steps", this.steps);
                    meta.put("MeasureInfo.offset", Float.valueOf(this.offset));
                    meta.put("MeasureInfo.dither", this.dither);
                    meta.put("MeasureInfo.incr", this.incr);
                    meta.put("MeasureInfo.memBank", this.memBank);
                    meta.put("MeasureInfo.modType", this.modType);
                    meta.put("MeasureInfo.synTH", Float.valueOf(this.synTH));
                    meta.put("MeasureInfo.deadTimeComp", this.deadTimeComp);
                    meta.put("MeasureInfo.polarityL", this.polarityL);
                    meta.put("MeasureInfo.polarityF", this.polarityF);
                    meta.put("MeasureInfo.polarityP", this.polarityP);
                    meta.put("MeasureInfo.linediv", this.linediv);
                    meta.put("MeasureInfo.accumulate", this.accumulate);
                    meta.put("MeasureInfo.flbckY", this.flbckY);
                    meta.put("MeasureInfo.flbckX", this.flbckX);
                    meta.put("MeasureInfo.bordU", this.bordU);
                    meta.put("MeasureInfo.bordL", this.bordL);
                    meta.put("MeasureInfo.pixTime", Float.valueOf(this.pixTime));
                    meta.put("MeasureInfo.pixClk", this.pixClk);
                    meta.put("MeasureInfo.trigger", this.trigger);
                    meta.put("MeasureInfo.scanX", this.scanX);
                    meta.put("MeasureInfo.scanY", this.scanY);
                    meta.put("MeasureInfo.scanRX", this.scanRX);
                    meta.put("MeasureInfo.scanRY", this.scanRY);
                    meta.put("MeasureInfo.fifoTyp", this.fifoTyp);
                    meta.put("MeasureInfo.epxDiv", this.epxDiv);
                    meta.put("MeasureInfo.modTypeCode", this.modTypeCode);
                    meta.put("MeasureInfo.modFpgaVer", this.modFpgaVer);
                    meta.put("MeasureInfo.overflowCorrFactor", Float.valueOf(this.overflowCorrFactor));
                    meta.put("MeasureInfo.adcZoom", this.adcZoom);
                    meta.put("MeasureInfo.cycles", this.cycles);
                }
                if (this.scanX > 0) {
                    this.width = this.scanX;
                }
                if (this.scanY > 0) {
                    this.height = this.scanY;
                }
                if (this.adcRE > 0) {
                    this.timeBins = this.adcRE;
                }
                if (this.scanRX > 0) {
                    this.channels = this.scanRX;
                }
                if (this.measMode == 0 || this.measMode == 1) {
                    this.width = 1;
                    this.height = 1;
                }
                if (this.measMode == 13) {
                    this.width = mode13width;
                    this.height = mode13height;
                    this.channels = this.noOfMeasDescBlocks;
                }
            }
            if (this.hasMeasStopInfo) {
                this.status = in.readUnsignedShort();
                this.flags = in.readUnsignedShort();
                this.stopTime = in.readFloat();
                this.curStep = in.readInt();
                this.curCycle = in.readInt();
                this.curPage = in.readInt();
                this.minSyncRate = in.readFloat();
                this.minCfdRate = in.readFloat();
                this.minTacRate = in.readFloat();
                this.minAdcRate = in.readFloat();
                this.maxSyncRate = in.readFloat();
                this.maxCfdRate = in.readFloat();
                this.maxTacRate = in.readFloat();
                this.maxAdcRate = in.readFloat();
                this.mReserved1 = in.readInt();
                this.mReserved2 = in.readFloat();
                if (meta != null) {
                    String measStopInfo = "MeasStopInfo.";
                    meta.put("MeasStopInfo.status", this.status);
                    meta.put("MeasStopInfo.flags", this.flags);
                    meta.put("MeasStopInfo.stopTime", Float.valueOf(this.stopTime));
                    meta.put("MeasStopInfo.curStep", this.curStep);
                    meta.put("MeasStopInfo.curCycle", this.curCycle);
                    meta.put("MeasStopInfo.curPage", this.curPage);
                    meta.put("MeasStopInfo.minSyncRate", Float.valueOf(this.minSyncRate));
                    meta.put("MeasStopInfo.minCfdRate", Float.valueOf(this.minCfdRate));
                    meta.put("MeasStopInfo.minTacRate", Float.valueOf(this.minTacRate));
                    meta.put("MeasStopInfo.minAdcRate", Float.valueOf(this.minAdcRate));
                    meta.put("MeasStopInfo.maxSyncRate", Float.valueOf(this.maxSyncRate));
                    meta.put("MeasStopInfo.maxCfdRate", Float.valueOf(this.maxCfdRate));
                    meta.put("MeasStopInfo.maxTacRate", Float.valueOf(this.maxTacRate));
                    meta.put("MeasStopInfo.maxAdcRate", Float.valueOf(this.maxAdcRate));
                    meta.put("MeasStopInfo.reserved1", this.mReserved1);
                    meta.put("MeasStopInfo.reserved2", Float.valueOf(this.mReserved2));
                }
            }
            if (this.hasMeasFCSInfo) {
                this.chan = in.readUnsignedShort();
                this.fcsDecayCalc = in.readUnsignedShort();
                this.mtResol = 0xFFFFFFFFL & (long)in.readInt();
                this.cortime = in.readFloat();
                this.calcPhotons = 0xFFFFFFFFL & (long)in.readInt();
                this.fcsPoints = in.readInt();
                this.endTime = in.readFloat();
                this.overruns = in.readUnsignedShort();
                this.fcsType = in.readUnsignedShort();
                this.crossChan = in.readUnsignedShort();
                this.mod = in.readUnsignedShort();
                this.crossMod = in.readUnsignedShort();
                this.crossMtResol = 0xFFFFFFFFL & (long)in.readInt();
                if (meta != null) {
                    String measFCSInfo = "MeasFCSInfo.";
                    meta.put("MeasFCSInfo.chan", this.chan);
                    meta.put("MeasFCSInfo.fcsDecayCalc", this.fcsDecayCalc);
                    meta.put("MeasFCSInfo.mtResol", this.mtResol);
                    meta.put("MeasFCSInfo.cortime", Float.valueOf(this.cortime));
                    meta.put("MeasFCSInfo.calcPhotons", this.calcPhotons);
                    meta.put("MeasFCSInfo.fcsPoints", this.fcsPoints);
                    meta.put("MeasFCSInfo.endTime", Float.valueOf(this.endTime));
                    meta.put("MeasFCSInfo.overruns", this.overruns);
                    meta.put("MeasFCSInfo.fcsType", this.fcsType);
                    meta.put("MeasFCSInfo.crossChan", this.crossChan);
                    meta.put("MeasFCSInfo.mod", this.mod);
                    meta.put("MeasFCSInfo.crossMod", this.crossMod);
                    meta.put("MeasFCSInfo.crossMtResol", Float.valueOf(this.crossMtResol));
                }
            }
            if (this.hasExtendedMeasureInfo) {
                this.imageX = in.readInt();
                this.imageY = in.readInt();
                this.imageRX = in.readInt();
                this.imageRY = in.readInt();
                this.xyGain = in.readShort();
                this.masterClock = in.readShort();
                this.adcDE = in.readShort();
                this.detType = in.readShort();
                this.xAxis = in.readShort();
                if (meta != null) {
                    String measureInfo = "MeasureInfo.";
                    meta.put("MeasureInfo.imageX", this.imageX);
                    meta.put("MeasureInfo.imageY", this.imageY);
                    meta.put("MeasureInfo.imageRX", this.imageRX);
                    meta.put("MeasureInfo.imageRY", this.imageRY);
                    meta.put("MeasureInfo.xyGain", this.xyGain);
                    meta.put("MeasureInfo.masterClock", this.masterClock);
                    meta.put("MeasureInfo.adcDE", this.adcDE);
                    meta.put("MeasureInfo.detType", this.detType);
                    meta.put("MeasureInfo.xAxis", this.xAxis);
                }
            }
            if (this.hasMeasHISTInfo) {
                this.fidaTime = in.readFloat();
                this.fildaTime = in.readFloat();
                this.fidaPoints = in.readInt();
                this.fildaPoints = in.readInt();
                this.mcsTime = in.readFloat();
                this.mcsPoints = in.readInt();
                if (meta != null) {
                    String measHISTInfo = "MeasHISTInfo.";
                    meta.put("MeasHISTInfo.fidaTime", Float.valueOf(this.fidaTime));
                    meta.put("MeasHISTInfo.fildaTime", Float.valueOf(this.fildaTime));
                    meta.put("MeasHISTInfo.fidaPoints", this.fidaPoints);
                    meta.put("MeasHISTInfo.fildaPoints", this.fildaPoints);
                    meta.put("MeasHISTInfo.mcsTime", Float.valueOf(this.mcsTime));
                    meta.put("MeasHISTInfo.mcsPoints", this.mcsPoints);
                }
            }
        }
        in.seek(this.dataBlockOffs);
        this.allBlockOffsets = new long[this.noOfDataBlocks];
        this.allBlockLengths = new long[this.noOfDataBlocks];
        for (int i = 0; i < this.noOfDataBlocks; ++i) {
            this.blockNo = in.readShort();
            this.dataOffs = in.readInt();
            this.nextBlockOffs = in.readInt();
            this.blockType = in.readUnsignedShort();
            this.measDescBlockNo = in.readShort();
            this.lblockNo = 0xFFFFFFFFL & (long)in.readInt();
            int len = in.readInt();
            this.blockLength = 0xFFFFFFFFL & (long)len;
            this.allBlockOffsets[i] = in.getFilePointer();
            this.allBlockLengths[i] = this.blockLength;
            if (meta != null) {
                String bhFileBlockHeader = "BHFileBlockHeader.";
                meta.put("BHFileBlockHeader.blockNo", this.blockNo);
                meta.put("BHFileBlockHeader.dataOffs", this.dataOffs);
                meta.put("BHFileBlockHeader.nextBlockOffs", this.nextBlockOffs);
                meta.put("BHFileBlockHeader.blockType", this.blockType);
                meta.put("BHFileBlockHeader.measDescBlockNo", this.measDescBlockNo);
                meta.put("BHFileBlockHeader.lblockNo", this.lblockNo);
                meta.put("BHFileBlockHeader.blockLength", this.blockLength);
            }
            in.seek(this.nextBlockOffs);
        }
    }

    private long readUnsignedLong(RandomAccessInputStream in) throws IOException {
        return (long)in.readInt() & 0xFFFFFFFFL;
    }
}

