/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionManagerCatalog;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.MFileCollectionManager;
import thredds.inventory.NcmlCollectionReader;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.FmrInv;
import ucar.nc2.ft.fmrc.FmrcDataset;
import ucar.nc2.ft.fmrc.FmrcInv;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;

@ThreadSafe
public class Fmrc
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(Fmrc.class);
    private static final Namespace ncNSHttps = Catalog.ncmlNSHttps;
    private static NcMLWriter ncmlWriter = new NcMLWriter();
    private final MCollection manager;
    private final FeatureCollectionConfig config;
    private final Object lock = new Object();
    private FmrcDataset fmrcDataset;
    private volatile boolean forceProto;
    private volatile long lastInvChanged;
    private volatile long lastProtoChanged;

    public static Fmrc open(String collection, Formatter errlog) throws IOException {
        if (collection.startsWith("catalog:")) {
            CollectionManagerCatalog manager = new CollectionManagerCatalog(collection, collection, null, errlog);
            return new Fmrc(manager, new FeatureCollectionConfig());
        }
        if (collection.endsWith(".ncml")) {
            NcmlCollectionReader ncmlCollection = NcmlCollectionReader.open(collection, errlog);
            if (ncmlCollection == null) {
                return null;
            }
            Fmrc fmrc = new Fmrc(ncmlCollection.getCollectionManager(), new FeatureCollectionConfig());
            fmrc.setNcml(ncmlCollection.getNcmlOuter(), ncmlCollection.getNcmlInner());
            return fmrc;
        }
        return new Fmrc(collection, errlog);
    }

    public static Fmrc readNcML(String ncmlString, Formatter errlog) throws IOException {
        NcmlCollectionReader ncmlCollection = NcmlCollectionReader.readNcML(ncmlString, errlog);
        if (ncmlCollection == null) {
            return null;
        }
        Fmrc fmrc = new Fmrc(ncmlCollection.getCollectionManager(), new FeatureCollectionConfig());
        fmrc.setNcml(ncmlCollection.getNcmlOuter(), ncmlCollection.getNcmlInner());
        return fmrc;
    }

    public static Fmrc open(FeatureCollectionConfig config, Formatter errlog) {
        if (config.spec.startsWith("catalog:")) {
            String name = config.collectionName != null ? config.collectionName : config.spec;
            CollectionManagerCatalog manager = new CollectionManagerCatalog(name, config.spec, null, errlog);
            return new Fmrc(manager, config);
        }
        return new Fmrc(config, errlog);
    }

    private Fmrc(String collectionSpec, Formatter errlog) {
        this.manager = MFileCollectionManager.open(collectionSpec, collectionSpec, null, errlog);
        this.config = new FeatureCollectionConfig();
        this.config.spec = collectionSpec;
    }

    private Fmrc(FeatureCollectionConfig config, Formatter errlog) {
        this.manager = new MFileCollectionManager(config, errlog, null);
        this.config = config;
    }

    public Fmrc(MCollection manager, FeatureCollectionConfig config) {
        this.manager = manager;
        this.config = config;
    }

    public void setNcml(Element outerNcml, Element innerNcml) {
        this.config.protoConfig.outerNcml = outerNcml;
        this.config.innerNcml = innerNcml;
    }

    @Override
    public void close() {
        if (this.manager != null) {
            this.manager.close();
        }
    }

    public MCollection getManager() {
        return this.manager;
    }

    public FmrcInv getFmrcInv(Formatter debug) {
        return this.makeFmrcInv(debug);
    }

    public CalendarDateRange getDateRangeForRun(CalendarDate run) {
        return this.fmrcDataset.getDateRangeForRun(run);
    }

    public CalendarDateRange getDateRangeForOffset(double offset) {
        return this.fmrcDataset.getDateRangeForOffset(offset);
    }

    public List<CalendarDate> getRunDates() {
        this.checkNeeded(false);
        return this.fmrcDataset.getRunDates();
    }

    public List<CalendarDate> getForecastDates() {
        this.checkNeeded(false);
        return this.fmrcDataset.getForecastDates();
    }

    public double[] getForecastOffsets() {
        this.checkNeeded(false);
        return this.fmrcDataset.getForecastOffsets();
    }

    public GridDataset getDataset2D(NetcdfDataset result) throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getNetcdfDataset2D(result);
    }

    public GridDataset getDatasetBest() throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getBest();
    }

    public GridDataset getDatasetBest(FeatureCollectionConfig.BestDataset bd) throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getBest(bd);
    }

    public GridDataset getRunTimeDataset(CalendarDate run) throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getRunTimeDataset(run);
    }

    public GridDataset getConstantForecastDataset(CalendarDate time) throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getConstantForecastDataset(time);
    }

    public GridDataset getConstantOffsetDataset(double hour) throws IOException {
        this.checkNeeded(false);
        return this.fmrcDataset.getConstantOffsetDataset(hour);
    }

    public void updateProto() {
        this.forceProto = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.lock;
        synchronized (object) {
            boolean forceProtoLocal = this.forceProto;
            if (this.fmrcDataset == null) {
                try {
                    this.fmrcDataset = new FmrcDataset(this.config);
                }
                catch (Throwable t2) {
                    logger.error(this.config.name + ": initial fmrcDataset creation failed", t2);
                }
            }
            try {
                FmrcInv fmrcInv = this.makeFmrcInv(null);
                this.fmrcDataset.setInventory(fmrcInv, forceProtoLocal);
                logger.debug("{}: make new Dataset, new proto = {}", (Object)this.config.name, (Object)forceProtoLocal);
                if (forceProtoLocal) {
                    this.forceProto = false;
                }
                this.lastInvChanged = System.currentTimeMillis();
                if (forceProtoLocal) {
                    this.lastProtoChanged = this.lastInvChanged;
                }
            }
            catch (Throwable t3) {
                logger.error(this.config.name + ": makeFmrcInv failed", t3);
            }
        }
    }

    public boolean checkInvState(long lastInvChange) {
        return this.lastInvChanged > lastInvChange;
    }

    public boolean checkProtoState(long lastProtoChanged) {
        return this.lastProtoChanged > lastProtoChanged;
    }

    private void checkNeeded(boolean force) {
        if (this.fmrcDataset == null) {
            try {
                this.update();
            }
            catch (Throwable t2) {
                logger.error(this.config.name + ": rescan failed");
                throw new RuntimeException(t2);
            }
        }
    }

    private FmrcInv makeFmrcInv(Formatter debug) {
        try {
            HashMap<CalendarDate, FmrInv> fmrMap = new HashMap<CalendarDate, FmrInv>();
            ArrayList<FmrInv> fmrList = new ArrayList<FmrInv>();
            for (MFile f : this.manager.getFilesSorted()) {
                FmrInv fmr;
                GridDatasetInv inv;
                CalendarDate runDate;
                Map<String, String> filesRunDateMap = ((MFileCollectionManager)this.manager).getFilesRunDateMap();
                if (!filesRunDateMap.isEmpty()) {
                    runDate = CalendarDate.parseISOformat(null, filesRunDateMap.get(f.getPath()));
                    Element element = new Element("netcdf", ncNSHttps);
                    Element runDateAttr = ncmlWriter.makeAttributeElement(new Attribute("_CoordinateModelRunDate", runDate.toString()));
                    this.config.innerNcml = element.addContent((Content)runDateAttr);
                }
                try {
                    inv = GridDatasetInv.open(this.manager, f, this.config.innerNcml);
                }
                catch (IOException ioe) {
                    logger.warn("Error opening " + f.getPath() + "(skipped)", ioe);
                    continue;
                }
                runDate = inv.getRunDate();
                if (debug != null) {
                    debug.format("  opened %s rundate = %s%n", f.getPath(), inv.getRunDateString());
                }
                if ((fmr = (FmrInv)fmrMap.get(runDate)) == null) {
                    fmr = new FmrInv(runDate);
                    fmrMap.put(runDate, fmr);
                    fmrList.add(fmr);
                }
                fmr.addDataset(inv, debug);
            }
            if (debug != null) {
                debug.format("%n", new Object[0]);
            }
            Collections.sort(fmrList);
            for (FmrInv fmr : fmrList) {
                fmr.finish();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Fmrc:" + this.config.name + ": made fmr with rundate=" + fmr.getRunDate() + " nfiles= " + fmr.getFiles().size());
            }
            return new FmrcInv("fmrc:" + this.manager.getCollectionName(), fmrList, this.config.fmrcConfig.regularize);
        }
        catch (Throwable t2) {
            logger.error("makeFmrcInv", t2);
            throw new RuntimeException(t2);
        }
    }

    public void showDetails(Formatter out) {
        this.checkNeeded(false);
        this.fmrcDataset.showDetails(out);
    }
}

