/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Misc;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;

@ThreadSafe
public class FileCacheARC
implements FileCacheIF {
    protected static final Logger log = LoggerFactory.getLogger(FileCacheARC.class);
    protected static final Logger cacheLog = LoggerFactory.getLogger("cacheLogger");
    static boolean debug;
    static boolean debugPrint;
    static boolean trackAll;
    protected String name;
    protected final int softLimit;
    protected final int minElements;
    protected final int hardLimit;
    protected final int period;
    private final AtomicBoolean disabled = new AtomicBoolean(false);
    protected final ConcurrentSkipListMap<CacheElement, CacheElement> shadowCache;
    protected final ConcurrentHashMap<Object, CacheElement> cache;
    protected final ConcurrentHashMap<Integer, CacheElement.CacheFile> files;
    protected final AtomicInteger hits = new AtomicInteger();
    protected final AtomicInteger miss = new AtomicInteger();
    protected ConcurrentHashMap<Object, Tracker> track;
    private AtomicInteger cacheSize = new AtomicInteger();

    public FileCacheARC(String name, int minElementsInMemory, int softLimit, int hardLimit, int period) {
        this.name = name;
        this.minElements = minElementsInMemory;
        this.softLimit = softLimit;
        this.hardLimit = hardLimit;
        this.period = period;
        this.shadowCache = new ConcurrentSkipListMap(new CacheElementComparator());
        this.cache = new ConcurrentHashMap(2 * softLimit, 0.75f, 8);
        this.files = new ConcurrentHashMap(4 * softLimit, 0.75f, 8);
        if (trackAll) {
            this.track = new ConcurrentHashMap(5000);
        }
    }

    @Override
    public void disable() {
        this.disabled.set(true);
        this.clearCache(true);
    }

    @Override
    public void enable() {
        this.disabled.set(false);
    }

    @Override
    public FileCacheable acquire(FileFactory factory, DatasetUrl location) throws IOException {
        return this.acquire(factory, location.trueurl, location, -1, null, null);
    }

    @Override
    public FileCacheable acquire(FileFactory factory, Object hashKey, DatasetUrl location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        FileCacheable ncfile;
        Tracker prev;
        if (null == hashKey) {
            hashKey = location.trueurl;
        }
        if (null == hashKey) {
            throw new IllegalArgumentException();
        }
        Tracker t2 = null;
        if (trackAll && (prev = this.track.putIfAbsent(hashKey, t2 = new Tracker(hashKey))) != null) {
            t2 = prev;
        }
        if ((ncfile = this.acquireCacheOnly(hashKey)) != null) {
            this.hits.incrementAndGet();
            if (t2 != null) {
                ++t2.hit;
            }
            return ncfile;
        }
        this.miss.incrementAndGet();
        if (t2 != null) {
            ++t2.miss;
        }
        ncfile = factory.open(location, buffer_size, cancelTask, spiObject);
        if (cacheLog.isDebugEnabled()) {
            cacheLog.debug("FileCacheARC " + this.name + " acquire " + hashKey + " " + ncfile.getLocation());
        }
        if (debugPrint) {
            System.out.println("  FileCacheARC " + this.name + " acquire " + hashKey + " " + ncfile.getLocation());
        }
        if (cancelTask != null && cancelTask.isCancel()) {
            if (ncfile != null) {
                ncfile.close();
            }
            return null;
        }
        if (this.disabled.get()) {
            return ncfile;
        }
        this.addToCache(hashKey, ncfile);
        return ncfile;
    }

    private FileCacheable acquireCacheOnly(Object hashKey) {
        if (this.disabled.get()) {
            return null;
        }
        CacheElement wantCacheElem = this.cache.get(hashKey);
        if (wantCacheElem == null) {
            return null;
        }
        CacheElement.CacheFile want = null;
        for (CacheElement.CacheFile file2 : wantCacheElem.list) {
            if (!file2.isLocked.compareAndSet(false, true)) continue;
            want = file2;
            break;
        }
        if (want == null) {
            return null;
        }
        if (want.ncfile != null) {
            boolean changed;
            long lastModified = want.ncfile.getLastModified();
            boolean bl = changed = lastModified != wantCacheElem.lastModified.get();
            if (changed) {
                if (cacheLog.isDebugEnabled()) {
                    cacheLog.debug("FileCacheARC " + this.name + ": acquire from cache " + hashKey + " " + want.ncfile.getLocation() + " was changed; discard");
                }
                this.expireFromCache(wantCacheElem);
                return null;
            }
        }
        this.updateInCache(wantCacheElem);
        return want.ncfile;
    }

    private CacheElement updateInCache(CacheElement elem) {
        if (this.shadowCache.firstKey() == elem) {
            return elem;
        }
        elem.updateAccessed();
        CacheElement prev = this.shadowCache.put(elem, elem);
        if (prev != null && elem != prev) {
            CacheElementComparator cc = new CacheElementComparator();
            log.error("elem != prev compare={} hash elem ={} prev={}", cc.compare(elem, prev), elem.hashCode(), prev.hashCode());
        }
        return elem;
    }

    private void expireFromCache(CacheElement elem) {
        for (CacheElement.CacheFile cacheFile : elem.list) {
            cacheFile.ncfile.setFileCache(null);
            this.cacheSize.getAndDecrement();
        }
        this.cache.remove(elem.hashKey);
        this.shadowCache.remove(elem);
    }

    @Override
    public void eject(Object hashKey) {
    }

    private void addToCache(Object hashKey, FileCacheable ncfile) {
        CacheElement newCacheElem = new CacheElement(hashKey);
        CacheElement previous = this.cache.putIfAbsent(hashKey, newCacheElem);
        CacheElement elem = previous != null ? previous : newCacheElem;
        elem.addFile(ncfile);
        this.shadowCache.put(newCacheElem, newCacheElem);
        int size = this.cacheSize.getAndIncrement();
        if (size > this.softLimit) {
            this.removeFromCache(size - this.softLimit);
        }
    }

    private void removeFromCache(int count) {
        CacheElement elem;
        for (int done = 0; count > done; done += elem.list.size()) {
            elem = this.shadowCache.lastKey();
            this.expireFromCache(elem);
        }
    }

    @Override
    public boolean release(FileCacheable ncfile) throws IOException {
        if (ncfile == null) {
            return false;
        }
        if (this.disabled.get()) {
            ncfile.setFileCache(null);
            ncfile.close();
            return false;
        }
        int hashcode = System.identityHashCode(ncfile);
        CacheElement.CacheFile file2 = this.files.get(hashcode);
        if (file2 != null) {
            if (!file2.isLocked.get()) {
                Exception e = new Exception("Stack trace");
                cacheLog.warn("FileCacheARC " + this.name + " release " + ncfile.getLocation() + " not locked; hash= " + ncfile.hashCode(), e);
            }
            file2.isLocked.set(false);
            if (cacheLog.isDebugEnabled()) {
                cacheLog.debug("FileCacheARC " + this.name + " release " + ncfile.getLocation() + "; hash= " + ncfile.hashCode());
            }
            if (debugPrint) {
                System.out.println("  FileCacheARC " + this.name + " release " + ncfile.getLocation());
            }
            return true;
        }
        return false;
    }

    public String getInfo(FileCacheable ncfile) {
        if (ncfile == null) {
            return "";
        }
        int hashcode = System.identityHashCode(ncfile);
        CacheElement.CacheFile file2 = this.files.get(hashcode);
        if (file2 != null) {
            return "File is in cache= " + file2;
        }
        return "File not in cache";
    }

    Map<Object, CacheElement> getCache() {
        return this.cache;
    }

    @Override
    public synchronized void clearCache(boolean force) {
        ArrayList<Object> deleteList = new ArrayList<Object>(2 * this.cache.size());
        if (force) {
            this.cache.clear();
            deleteList.addAll(this.files.values());
            this.files.clear();
        } else {
            Iterator<CacheElement.CacheFile> iter = this.files.values().iterator();
            while (iter.hasNext()) {
                Object file2 = iter.next();
                if (!((CacheElement.CacheFile)file2).isLocked.compareAndSet(false, true)) continue;
                ((CacheElement.CacheFile)file2).remove();
                deleteList.add(file2);
                iter.remove();
            }
            for (CacheElement elem : this.cache.values()) {
                if (!elem.list.isEmpty()) continue;
                this.cache.remove(elem.hashKey);
            }
        }
        for (Object file2 : deleteList) {
            if (force && ((CacheElement.CacheFile)file2).isLocked.get()) {
                cacheLog.warn("FileCacheARC " + this.name + " force close locked file= " + file2);
            }
            if (((CacheElement.CacheFile)file2).ncfile == null) continue;
            try {
                ((CacheElement.CacheFile)file2).ncfile.setFileCache(null);
                ((CacheElement.CacheFile)file2).ncfile.close();
                ((CacheElement.CacheFile)file2).ncfile = null;
            }
            catch (IOException e) {
                log.error("FileCacheARC " + this.name + " close failed on " + file2);
            }
        }
        if (cacheLog.isDebugEnabled()) {
            cacheLog.debug("*FileCacheARC " + this.name + " clearCache force= " + force + " deleted= " + deleteList.size() + " left=" + this.files.size());
        }
    }

    @Override
    public void showCache(Formatter format) {
        ArrayList<CacheElement.CacheFile> allFiles = new ArrayList<CacheElement.CacheFile>(this.files.size());
        for (CacheElement elem : this.cache.values()) {
            allFiles.addAll(elem.list);
        }
        Collections.sort(allFiles);
        format.format("%nFileCacheARC %s (min=%d softLimit=%d hardLimit=%d scour=%d):%n", this.name, this.minElements, this.softLimit, this.hardLimit, this.period);
        format.format("isLocked  accesses lastAccess                   location %n", new Object[0]);
        for (CacheElement.CacheFile file2 : allFiles) {
            String loc = file2.ncfile != null ? file2.ncfile.getLocation() : "null";
            CalendarDate cd2 = CalendarDate.of(file2.getLastAccessed());
            format.format("%8s %9d %s %s %n", file2.isLocked, file2.getCountAccessed(), CalendarDateFormatter.toTimeUnits(cd2), loc);
        }
        this.showStats(format);
    }

    @Override
    public List<String> showCache() {
        ArrayList<CacheElement.CacheFile> allFiles = new ArrayList<CacheElement.CacheFile>(this.files.size());
        for (CacheElement elem : this.cache.values()) {
            allFiles.addAll(elem.list);
        }
        Collections.sort(allFiles);
        ArrayList<String> result = new ArrayList<String>(allFiles.size());
        for (CacheElement.CacheFile file2 : allFiles) {
            result.add(file2.toString());
        }
        return result;
    }

    @Override
    public void showStats(Formatter format) {
        format.format("  hits= %d miss= %d nfiles= %d elems= %d shadow=%d%n", this.hits.get(), this.miss.get(), this.files.size(), this.cache.values().size(), this.shadowCache.size());
    }

    @Override
    public void showTracking(Formatter format) {
        if (this.track == null) {
            return;
        }
        ArrayList<Tracker> all = new ArrayList<Tracker>(this.track.size());
        all.addAll(this.track.values());
        Collections.sort(all);
        int count = 0;
        int countAll = 0;
        format.format("%nTrack of all files in FileCacheARC%n", new Object[0]);
        format.format("   seq  accum   hit   miss  file%n", new Object[0]);
        for (Tracker t2 : all) {
            format.format("%6d  %6d : %5d %5d %s%n", ++count, countAll += t2.hit + t2.miss, t2.hit, t2.miss, t2.key);
        }
        format.format("%n", new Object[0]);
    }

    @Override
    public void resetTracking() {
        this.track = new ConcurrentHashMap(5000);
    }

    static {
        trackAll = true;
    }

    private static class Tracker
    implements Comparable<Tracker> {
        Object key;
        int hit;
        int miss;

        private Tracker(Object key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tracker tracker = (Tracker)o;
            return this.key.equals(tracker.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public int compareTo(Tracker o) {
            return Misc.compare(this.hit + this.miss, o.hit + o.miss);
        }
    }

    private static class CacheElementComparator
    implements Comparator<CacheElement> {
        private CacheElementComparator() {
        }

        @Override
        public int compare(CacheElement o1, CacheElement o2) {
            return Misc.compare(o1.getLastAccessed(), o2.getLastAccessed());
        }
    }

    class CacheElement {
        final Object hashKey;
        final List<CacheFile> list = new CopyOnWriteArrayList<CacheFile>();
        final AtomicLong lastModified = new AtomicLong();
        final AtomicLong lastAccessed = new AtomicLong();
        final AtomicInteger countAccessed = new AtomicInteger();

        CacheElement(Object hashKey) {
            this.hashKey = hashKey;
        }

        CacheFile addFile(FileCacheable ncfile) {
            CacheFile file2 = new CacheFile(ncfile);
            this.list.add(file2);
            this.lastModified.set(ncfile.getLastModified());
            this.lastAccessed.set(System.currentTimeMillis());
            this.countAccessed.incrementAndGet();
            int hashcode = System.identityHashCode(ncfile);
            if (debug && FileCacheARC.this.files.get(hashcode) != null) {
                cacheLog.error("files (2) already has " + this.hashKey + " " + FileCacheARC.this.name);
            }
            FileCacheARC.this.files.put(hashcode, file2);
            if (cacheLog.isDebugEnabled()) {
                cacheLog.debug("CacheElement add to cache " + this.hashKey + " " + FileCacheARC.this.name);
            }
            return file2;
        }

        public long getLastAccessed() {
            return this.lastAccessed.get();
        }

        public void updateAccessed() {
            this.lastAccessed.set(System.currentTimeMillis());
            this.countAccessed.incrementAndGet();
        }

        public String toString() {
            return this.hashKey + " count=" + this.list.size() + " countAccessed=" + this.countAccessed + " lastAccessed=" + new Date(this.getLastAccessed());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheElement that = (CacheElement)o;
            return that.hashCode() == this.hashCode();
        }

        public int hashCode() {
            return this.hashKey.hashCode();
        }

        class CacheFile
        implements Comparable<CacheFile> {
            FileCacheable ncfile;
            final AtomicBoolean isLocked = new AtomicBoolean(true);

            private CacheFile(FileCacheable ncfile) {
                this.ncfile = ncfile;
                ncfile.setFileCache(FileCacheARC.this);
                if (cacheLog.isDebugEnabled()) {
                    cacheLog.debug("FileCacheARC " + FileCacheARC.this.name + " add to cache " + CacheElement.this.hashKey);
                }
                if (debugPrint) {
                    System.out.println("  FileCacheARC " + FileCacheARC.this.name + " add to cache " + CacheElement.this.hashKey);
                }
            }

            public long getLastAccessed() {
                return CacheElement.this.lastAccessed.get();
            }

            public int getCountAccessed() {
                return CacheElement.this.countAccessed.get();
            }

            void remove() {
                int hashcode = System.identityHashCode(this.ncfile);
                if (null == FileCacheARC.this.files.remove(hashcode)) {
                    cacheLog.warn("FileCacheARC {} could not remove {} from files", (Object)FileCacheARC.this.name, (Object)this.ncfile.getLocation());
                }
                if (!CacheElement.this.list.remove(this)) {
                    cacheLog.warn("FileCacheARC {} could not remove {} from list", (Object)FileCacheARC.this.name, (Object)this.ncfile.getLocation());
                }
                this.close();
            }

            void close() {
                this.ncfile.setFileCache(null);
                try {
                    this.ncfile.close();
                }
                catch (IOException e) {
                    log.error("close failed on " + this.ncfile.getLocation(), e);
                }
                if (cacheLog.isDebugEnabled()) {
                    cacheLog.debug("FileCacheARC " + FileCacheARC.this.name + " remove " + this.ncfile.getLocation());
                }
                if (debugPrint) {
                    System.out.println("  FileCacheARC " + FileCacheARC.this.name + " remove " + this.ncfile.getLocation());
                }
                this.ncfile = null;
            }

            public String toString() {
                return this.isLocked + " " + this.ncfile.getLocation();
            }

            @Override
            public int compareTo(CacheFile o) {
                return Misc.compare(CacheElement.this.lastAccessed.get(), o.getLastAccessed());
            }
        }
    }
}

