

defaultNC = {   '#': set(['+word_boundary']),
    'AA1': set([   '+back',
                   '+low',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-round',
                   '-word_boundary']),
    'AA2': set([   '+back',
                   '+low',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'AE1': set([   '+low',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AE2': set([   '+low',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-mainstress',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AH0': set([   '+back',
                   '+sonorant',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-rhotic',
                   '-round',
                   '-stress',
                   '-tense',
                   '-word_boundary']),
    'AH1': set([   '+back',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-rhotic',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AH2': set([   '+back',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-rhotic',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AO1': set([   '+back',
                   '+low',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-word_boundary']),
    'AO2': set([   '+back',
                   '+low',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-mainstress',
                   '-word_boundary']),
    'AW1': set([   '+back',
                   '+diphthong',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-low',
                   '-word_boundary']),
    'AW2': set([   '+back',
                   '+diphthong',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-low',
                   '-mainstress',
                   '-word_boundary']),
    'AY1': set([   '+diphthong',
                   '+high',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'AY2': set([   '+diphthong',
                   '+high',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'B': set([   '+LABIAL',
                 '+consonantal',
                 '+voice',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'BCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+rhyme',
                     '+voice',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'CH': set([   '+CORONAL',
                  '+consonantal',
                  '+strident',
                  '-DORSAL',
                  '-LABIAL',
                  '-anterior',
                  '-approximant',
                  '-continuant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'CHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+rhyme',
                      '+strident',
                      '-DORSAL',
                      '-LABIAL',
                      '-anterior',
                      '-approximant',
                      '-continuant',
                      '-sonorant',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'D': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+voice',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'DCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+rhyme',
                     '+voice',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'DH': set([   '+CORONAL',
                  '+anterior',
                  '+consonantal',
                  '+continuant',
                  '+voice',
                  '-DORSAL',
                  '-LABIAL',
                  '-approximant',
                  '-rhyme',
                  '-sonorant',
                  '-strident',
                  '-syllabic',
                  '-word_boundary']),
    'DHCoda': set([   '+CORONAL',
                      '+anterior',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '+voice',
                      '-DORSAL',
                      '-LABIAL',
                      '-approximant',
                      '-sonorant',
                      '-strident',
                      '-syllabic',
                      '-word_boundary']),
    'EH1': set([   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'EH2': set([   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'ER0': set([   '+back',
                   '+rhotic',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-stress',
                   '-word_boundary']),
    'ER1': set([   '+back',
                   '+mainstress',
                   '+rhotic',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'ER2': set([   '+back',
                   '+rhotic',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'EY1': set([   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'EY2': set([   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'F': set([   '+LABIAL',
                 '+consonantal',
                 '+continuant',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'FCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'G': set([   '+DORSAL',
                 '+consonantal',
                 '+voice',
                 '-CORONAL',
                 '-LABIAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'GCoda': set([   '+DORSAL',
                     '+consonantal',
                     '+rhyme',
                     '+voice',
                     '-CORONAL',
                     '-LABIAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'HH': set([   '+continuant',
                  '-CORONAL',
                  '-DORSAL',
                  '-LABIAL',
                  '-approximant',
                  '-consonantal',
                  '-rhyme',
                  '-sonorant',
                  '-strident',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'HHCoda': set([   '+continuant',
                      '+rhyme',
                      '-CORONAL',
                      '-DORSAL',
                      '-LABIAL',
                      '-approximant',
                      '-consonantal',
                      '-sonorant',
                      '-strident',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'IH0': set([   '+high',
                   '+sonorant',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-stress',
                   '-tense',
                   '-word_boundary']),
    'IH1': set([   '+high',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'IH2': set([   '+high',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'IY0': set([   '+high',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-stress',
                   '-word_boundary']),
    'IY1': set([   '+high',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'IY2': set([   '+high',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'JH': set([   '+CORONAL',
                  '+consonantal',
                  '+strident',
                  '+voice',
                  '-DORSAL',
                  '-LABIAL',
                  '-anterior',
                  '-approximant',
                  '-continuant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-word_boundary']),
    'JHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+rhyme',
                      '+strident',
                      '+voice',
                      '-DORSAL',
                      '-LABIAL',
                      '-anterior',
                      '-approximant',
                      '-continuant',
                      '-sonorant',
                      '-syllabic',
                      '-word_boundary']),
    'K': set([   '+DORSAL',
                 '+consonantal',
                 '-CORONAL',
                 '-LABIAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'KCoda': set([   '+DORSAL',
                     '+consonantal',
                     '+rhyme',
                     '-CORONAL',
                     '-LABIAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'L': set([   '+CORONAL',
                 '+anterior',
                 '+approximant',
                 '+consonantal',
                 '+lateral',
                 '+sonorant',
                 '-DORSAL',
                 '-LABIAL',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'LCoda': set([   '+CORONAL',
                     '+anterior',
                     '+approximant',
                     '+consonantal',
                     '+lateral',
                     '+rhyme',
                     '+sonorant',
                     '-DORSAL',
                     '-LABIAL',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'M': set([   '+LABIAL',
                 '+consonantal',
                 '+nasal',
                 '+sonorant',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'MCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+nasal',
                     '+rhyme',
                     '+sonorant',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'N': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+nasal',
                 '+sonorant',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'NCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+nasal',
                     '+rhyme',
                     '+sonorant',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'NG': set([   '+DORSAL',
                  '+consonantal',
                  '+nasal',
                  '+sonorant',
                  '-CORONAL',
                  '-LABIAL',
                  '-approximant',
                  '-rhyme',
                  '-strident',
                  '-syllabic',
                  '-word_boundary']),
    'NGCoda': set([   '+DORSAL',
                      '+consonantal',
                      '+nasal',
                      '+rhyme',
                      '+sonorant',
                      '-CORONAL',
                      '-LABIAL',
                      '-approximant',
                      '-strident',
                      '-syllabic',
                      '-word_boundary']),
    'OW0': set([   '+back',
                   '+round',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-stress',
                   '-word_boundary']),
    'OW1': set([   '+back',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-word_boundary']),
    'OW2': set([   '+back',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-word_boundary']),
    'OY1': set([   '+diphthong',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-word_boundary']),
    'OY2': set([   '+diphthong',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-mainstress',
                   '-word_boundary']),
    'P': set([   '+LABIAL',
                 '+consonantal',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'PCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+rhyme',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'R': set([   '+CORONAL',
                 '+approximant',
                 '+sonorant',
                 '-DORSAL',
                 '-LABIAL',
                 '-anterior',
                 '-consonantal',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'RCoda': set([   '+CORONAL',
                     '+approximant',
                     '+rhyme',
                     '+sonorant',
                     '-DORSAL',
                     '-LABIAL',
                     '-anterior',
                     '-consonantal',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'S': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+continuant',
                 '+strident',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'SCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '+strident',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-sonorant',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'SH': set([   '+CORONAL',
                  '+consonantal',
                  '+continuant',
                  '+strident',
                  '-DORSAL',
                  '-LABIAL',
                  '-anterior',
                  '-approximant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'SHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '+strident',
                      '-DORSAL',
                      '-LABIAL',
                      '-anterior',
                      '-approximant',
                      '-sonorant',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'T': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'TCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+rhyme',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'TH': set([   '+CORONAL',
                  '+anterior',
                  '+consonantal',
                  '+continuant',
                  '-DORSAL',
                  '-LABIAL',
                  '-approximant',
                  '-rhyme',
                  '-sonorant',
                  '-strident',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'THCoda': set([   '+CORONAL',
                      '+anterior',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '-DORSAL',
                      '-LABIAL',
                      '-approximant',
                      '-sonorant',
                      '-strident',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'UH1': set([   '+back',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-tense',
                   '-word_boundary']),
    'UH2': set([   '+back',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-tense',
                   '-word_boundary']),
    'UW0': set([   '+back',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-stress',
                   '-word_boundary']),
    'UW1': set([   '+back',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-word_boundary']),
    'UW2': set([   '+back',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-word_boundary']),
    'V': set([   '+LABIAL',
                 '+consonantal',
                 '+continuant',
                 '+voice',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'VCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '+voice',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'W': set([   '+LABIAL',
                 '+approximant',
                 '+back',
                 '+high',
                 '+round',
                 '+sonorant',
                 '-CORONAL',
                 '-DORSAL',
                 '-consonantal',
                 '-low',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'WCoda': set([   '+LABIAL',
                     '+approximant',
                     '+back',
                     '+high',
                     '+rhyme',
                     '+round',
                     '+sonorant',
                     '-CORONAL',
                     '-DORSAL',
                     '-consonantal',
                     '-low',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'Y': set([   '+approximant',
                 '+high',
                 '+sonorant',
                 '-CORONAL',
                 '-DORSAL',
                 '-LABIAL',
                 '-back',
                 '-consonantal',
                 '-low',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'YCoda': set([   '+approximant',
                     '+high',
                     '+rhyme',
                     '+sonorant',
                     '-CORONAL',
                     '-DORSAL',
                     '-LABIAL',
                     '-back',
                     '-consonantal',
                     '-low',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'Z': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+continuant',
                 '+strident',
                 '+voice',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-word_boundary']),
    'ZCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '+strident',
                     '+voice',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'ZH': set([   '+CORONAL',
                  '+consonantal',
                  '+continuant',
                  '+strident',
                  '+voice',
                  '-DORSAL',
                  '-LABIAL',
                  '-anterior',
                  '-approximant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-word_boundary']),
    'ZHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '+strident',
                      '+voice',
                      '-DORSAL',
                      '-LABIAL',
                      '-anterior',
                      '-approximant',
                      '-sonorant',
                      '-syllabic',
                      '-word_boundary'])}

hayesWhiteNC = {   '#': set(['+word_boundary']),
    'AA1': set([   '+back',
                   '+low',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-round',
                   '-word_boundary']),
    'AA2': set([   '+back',
                   '+low',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-round',
                   '-word_boundary']),
    'AE1': set([   '+low',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AE2': set([   '+low',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AH0': set([   '+back',
                   '+sonorant',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-rhotic',
                   '-round',
                   '-stress',
                   '-tense',
                   '-word_boundary']),
    'AH1': set([   '+back',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-rhotic',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AH2': set([   '+back',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-rhotic',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AO1': set([   '+back',
                   '+low',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-word_boundary']),
    'AO2': set([   '+back',
                   '+low',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-word_boundary']),
    'AW1': set([   '+back',
                   '+diphthong',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-low',
                   '-word_boundary']),
    'AW2': set([   '+back',
                   '+diphthong',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-low',
                   '-word_boundary']),
    'AY1': set([   '+diphthong',
                   '+high',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'AY2': set([   '+diphthong',
                   '+high',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'B': set([   '+LABIAL',
                 '+consonantal',
                 '+voice',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-word_boundary']),
    'BCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+rhyme',
                     '+voice',
                     '-continuant',
                     '-sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'CH': set([   '+CORONAL',
                  '+consonantal',
                  '+strident',
                  '-anterior',
                  '-continuant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'CHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+rhyme',
                      '+strident',
                      '-anterior',
                      '-continuant',
                      '-sonorant',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'D': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+voice',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-word_boundary']),
    'DCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+rhyme',
                     '+voice',
                     '-continuant',
                     '-sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'DH': set([   '+CORONAL',
                  '+anterior',
                  '+consonantal',
                  '+continuant',
                  '+voice',
                  '-rhyme',
                  '-sonorant',
                  '-strident',
                  '-syllabic',
                  '-word_boundary']),
    'DHCoda': set([   '+CORONAL',
                      '+anterior',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '+voice',
                      '-sonorant',
                      '-strident',
                      '-syllabic',
                      '-word_boundary']),
    'EH1': set([   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'EH2': set([   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'ER0': set([   '+back',
                   '+rhotic',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-stress',
                   '-word_boundary']),
    'ER1': set([   '+back',
                   '+mainstress',
                   '+rhotic',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'ER2': set([   '+back',
                   '+rhotic',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'EY1': set([   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'EY2': set([   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'F': set([   '+LABIAL',
                 '+consonantal',
                 '+continuant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'FCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '-sonorant',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'G': set([   '+DORSAL',
                 '+consonantal',
                 '+voice',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-word_boundary']),
    'GCoda': set([   '+DORSAL',
                     '+consonantal',
                     '+rhyme',
                     '+voice',
                     '-continuant',
                     '-sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'HH': set([   '+continuant',
                  '-consonantal',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'HHCoda': set([   '+continuant',
                      '+rhyme',
                      '-consonantal',
                      '-sonorant',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'IH0': set([   '+high',
                   '+sonorant',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-stress',
                   '-tense',
                   '-word_boundary']),
    'IH1': set([   '+high',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'IH2': set([   '+high',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'IY0': set([   '+high',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-stress',
                   '-word_boundary']),
    'IY1': set([   '+high',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'IY2': set([   '+high',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'JH': set([   '+CORONAL',
                  '+consonantal',
                  '+strident',
                  '+voice',
                  '-anterior',
                  '-continuant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-word_boundary']),
    'JHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+rhyme',
                      '+strident',
                      '+voice',
                      '-anterior',
                      '-continuant',
                      '-sonorant',
                      '-syllabic',
                      '-word_boundary']),
    'K': set([   '+DORSAL',
                 '+consonantal',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'KCoda': set([   '+DORSAL',
                     '+consonantal',
                     '+rhyme',
                     '-continuant',
                     '-sonorant',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'L': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+lateral',
                 '+sonorant',
                 '-rhyme',
                 '-syllabic',
                 '-word_boundary']),
    'LCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+lateral',
                     '+rhyme',
                     '+sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'M': set([   '+LABIAL',
                 '+consonantal',
                 '+nasal',
                 '+sonorant',
                 '-rhyme',
                 '-syllabic',
                 '-word_boundary']),
    'MCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+nasal',
                     '+rhyme',
                     '+sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'N': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+nasal',
                 '+sonorant',
                 '-rhyme',
                 '-syllabic',
                 '-word_boundary']),
    'NCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+nasal',
                     '+rhyme',
                     '+sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'NG': set([   '+DORSAL',
                  '+consonantal',
                  '+nasal',
                  '+sonorant',
                  '-rhyme',
                  '-syllabic',
                  '-word_boundary']),
    'NGCoda': set([   '+DORSAL',
                      '+consonantal',
                      '+nasal',
                      '+rhyme',
                      '+sonorant',
                      '-syllabic',
                      '-word_boundary']),
    'OW0': set([   '+back',
                   '+round',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-stress',
                   '-word_boundary']),
    'OW1': set([   '+back',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-word_boundary']),
    'OW2': set([   '+back',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-word_boundary']),
    'OY1': set([   '+diphthong',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-word_boundary']),
    'OY2': set([   '+diphthong',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-word_boundary']),
    'P': set([   '+LABIAL',
                 '+consonantal',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'PCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+rhyme',
                     '-continuant',
                     '-sonorant',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'R': set([   '+CORONAL',
                 '+sonorant',
                 '-anterior',
                 '-consonantal',
                 '-rhyme',
                 '-syllabic',
                 '-word_boundary']),
    'RCoda': set([   '+CORONAL',
                     '+rhyme',
                     '+sonorant',
                     '-anterior',
                     '-consonantal',
                     '-syllabic',
                     '-word_boundary']),
    'S': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+continuant',
                 '+strident',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'SCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '+strident',
                     '-sonorant',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'SH': set([   '+CORONAL',
                  '+consonantal',
                  '+continuant',
                  '+strident',
                  '-anterior',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'SHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '+strident',
                      '-anterior',
                      '-sonorant',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'T': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'TCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+rhyme',
                     '-continuant',
                     '-sonorant',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'TH': set([   '+CORONAL',
                  '+anterior',
                  '+consonantal',
                  '+continuant',
                  '-rhyme',
                  '-sonorant',
                  '-strident',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'THCoda': set([   '+CORONAL',
                      '+anterior',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '-sonorant',
                      '-strident',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'UH1': set([   '+back',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-tense',
                   '-word_boundary']),
    'UH2': set([   '+back',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-tense',
                   '-word_boundary']),
    'UW0': set([   '+back',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-stress',
                   '-word_boundary']),
    'UW1': set([   '+back',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-word_boundary']),
    'UW2': set([   '+back',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-word_boundary']),
    'V': set([   '+LABIAL',
                 '+consonantal',
                 '+continuant',
                 '+voice',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-word_boundary']),
    'VCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '+voice',
                     '-sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'W': set([   '+LABIAL',
                 '+back',
                 '+high',
                 '+round',
                 '+sonorant',
                 '-consonantal',
                 '-low',
                 '-rhyme',
                 '-syllabic',
                 '-word_boundary']),
    'WCoda': set([   '+LABIAL',
                     '+back',
                     '+high',
                     '+rhyme',
                     '+round',
                     '+sonorant',
                     '-consonantal',
                     '-low',
                     '-syllabic',
                     '-word_boundary']),
    'Y': set([   '+high',
                 '+sonorant',
                 '-back',
                 '-consonantal',
                 '-low',
                 '-rhyme',
                 '-syllabic',
                 '-word_boundary']),
    'YCoda': set([   '+high',
                     '+rhyme',
                     '+sonorant',
                     '-back',
                     '-consonantal',
                     '-low',
                     '-syllabic',
                     '-word_boundary']),
    'Z': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+continuant',
                 '+strident',
                 '+voice',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-word_boundary']),
    'ZCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '+strident',
                     '+voice',
                     '-sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'ZH': set([   '+CORONAL',
                  '+consonantal',
                  '+continuant',
                  '+strident',
                  '+voice',
                  '-anterior',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-word_boundary']),
    'ZHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '+strident',
                      '+voice',
                      '-anterior',
                      '-sonorant',
                      '-syllabic',
                      '-word_boundary'])}

noStressNC = {   '#': set(['+word_boundary']),
    'AA1': set([   '+back',
                   '+low',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-round',
                   '-word_boundary']),
    'AA2': set([   '+back',
                   '+low',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'AE1': set([   '+low',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AE2': set([   '+low',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-mainstress',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AH0': set([   '+back',
                   '+sonorant',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-rhotic',
                   '-round',
                   '-stress',
                   '-tense',
                   '-word_boundary']),
    'AH1': set([   '+back',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-rhotic',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AH2': set([   '+back',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-rhotic',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'AO1': set([   '+back',
                   '+low',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-word_boundary']),
    'AO2': set([   '+back',
                   '+low',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-mainstress',
                   '-word_boundary']),
    'AW1': set([   '+back',
                   '+diphthong',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-low',
                   '-word_boundary']),
    'AW2': set([   '+back',
                   '+diphthong',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-low',
                   '-mainstress',
                   '-word_boundary']),
    'AY1': set([   '+diphthong',
                   '+high',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'AY2': set([   '+diphthong',
                   '+high',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'B': set([   '+LABIAL',
                 '+consonantal',
                 '+voice',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'BCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+rhyme',
                     '+voice',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'CH': set([   '+CORONAL',
                  '+consonantal',
                  '+strident',
                  '-DORSAL',
                  '-LABIAL',
                  '-anterior',
                  '-approximant',
                  '-continuant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'CHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+rhyme',
                      '+strident',
                      '-DORSAL',
                      '-LABIAL',
                      '-anterior',
                      '-approximant',
                      '-continuant',
                      '-sonorant',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'D': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+voice',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'DCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+rhyme',
                     '+voice',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'DH': set([   '+CORONAL',
                  '+anterior',
                  '+consonantal',
                  '+continuant',
                  '+voice',
                  '-DORSAL',
                  '-LABIAL',
                  '-approximant',
                  '-rhyme',
                  '-sonorant',
                  '-strident',
                  '-syllabic',
                  '-word_boundary']),
    'DHCoda': set([   '+CORONAL',
                      '+anterior',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '+voice',
                      '-DORSAL',
                      '-LABIAL',
                      '-approximant',
                      '-sonorant',
                      '-strident',
                      '-syllabic',
                      '-word_boundary']),
    'EH1': set([   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'EH2': set([   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'ER0': set([   '+back',
                   '+rhotic',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-stress',
                   '-word_boundary']),
    'ER1': set([   '+back',
                   '+mainstress',
                   '+rhotic',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'ER2': set([   '+back',
                   '+rhotic',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'EY1': set([   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'EY2': set([   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'F': set([   '+LABIAL',
                 '+consonantal',
                 '+continuant',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'FCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'G': set([   '+DORSAL',
                 '+consonantal',
                 '+voice',
                 '-CORONAL',
                 '-LABIAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'GCoda': set([   '+DORSAL',
                     '+consonantal',
                     '+rhyme',
                     '+voice',
                     '-CORONAL',
                     '-LABIAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'HH': set([   '+continuant',
                  '-CORONAL',
                  '-DORSAL',
                  '-LABIAL',
                  '-approximant',
                  '-consonantal',
                  '-rhyme',
                  '-sonorant',
                  '-strident',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'HHCoda': set([   '+continuant',
                      '+rhyme',
                      '-CORONAL',
                      '-DORSAL',
                      '-LABIAL',
                      '-approximant',
                      '-consonantal',
                      '-sonorant',
                      '-strident',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'IH0': set([   '+high',
                   '+sonorant',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-stress',
                   '-tense',
                   '-word_boundary']),
    'IH1': set([   '+high',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'IH2': set([   '+high',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-tense',
                   '-word_boundary']),
    'IY0': set([   '+high',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-stress',
                   '-word_boundary']),
    'IY1': set([   '+high',
                   '+mainstress',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-round',
                   '-word_boundary']),
    'IY2': set([   '+high',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-round',
                   '-word_boundary']),
    'JH': set([   '+CORONAL',
                  '+consonantal',
                  '+strident',
                  '+voice',
                  '-DORSAL',
                  '-LABIAL',
                  '-anterior',
                  '-approximant',
                  '-continuant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-word_boundary']),
    'JHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+rhyme',
                      '+strident',
                      '+voice',
                      '-DORSAL',
                      '-LABIAL',
                      '-anterior',
                      '-approximant',
                      '-continuant',
                      '-sonorant',
                      '-syllabic',
                      '-word_boundary']),
    'K': set([   '+DORSAL',
                 '+consonantal',
                 '-CORONAL',
                 '-LABIAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'KCoda': set([   '+DORSAL',
                     '+consonantal',
                     '+rhyme',
                     '-CORONAL',
                     '-LABIAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'L': set([   '+CORONAL',
                 '+anterior',
                 '+approximant',
                 '+consonantal',
                 '+lateral',
                 '+sonorant',
                 '-DORSAL',
                 '-LABIAL',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'LCoda': set([   '+CORONAL',
                     '+anterior',
                     '+approximant',
                     '+consonantal',
                     '+lateral',
                     '+rhyme',
                     '+sonorant',
                     '-DORSAL',
                     '-LABIAL',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'M': set([   '+LABIAL',
                 '+consonantal',
                 '+nasal',
                 '+sonorant',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'MCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+nasal',
                     '+rhyme',
                     '+sonorant',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'N': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+nasal',
                 '+sonorant',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'NCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+nasal',
                     '+rhyme',
                     '+sonorant',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'NG': set([   '+DORSAL',
                  '+consonantal',
                  '+nasal',
                  '+sonorant',
                  '-CORONAL',
                  '-LABIAL',
                  '-approximant',
                  '-rhyme',
                  '-strident',
                  '-syllabic',
                  '-word_boundary']),
    'NGCoda': set([   '+DORSAL',
                      '+consonantal',
                      '+nasal',
                      '+rhyme',
                      '+sonorant',
                      '-CORONAL',
                      '-LABIAL',
                      '-approximant',
                      '-strident',
                      '-syllabic',
                      '-word_boundary']),
    'OW0': set([   '+back',
                   '+round',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-stress',
                   '-word_boundary']),
    'OW1': set([   '+back',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-word_boundary']),
    'OW2': set([   '+back',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-high',
                   '-low',
                   '-mainstress',
                   '-word_boundary']),
    'OY1': set([   '+diphthong',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-word_boundary']),
    'OY2': set([   '+diphthong',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-back',
                   '-consonantal',
                   '-low',
                   '-mainstress',
                   '-word_boundary']),
    'P': set([   '+LABIAL',
                 '+consonantal',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'PCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+rhyme',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'R': set([   '+CORONAL',
                 '+approximant',
                 '+sonorant',
                 '-DORSAL',
                 '-LABIAL',
                 '-anterior',
                 '-consonantal',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'RCoda': set([   '+CORONAL',
                     '+approximant',
                     '+rhyme',
                     '+sonorant',
                     '-DORSAL',
                     '-LABIAL',
                     '-anterior',
                     '-consonantal',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'S': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+continuant',
                 '+strident',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'SCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '+strident',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-sonorant',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'SH': set([   '+CORONAL',
                  '+consonantal',
                  '+continuant',
                  '+strident',
                  '-DORSAL',
                  '-LABIAL',
                  '-anterior',
                  '-approximant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'SHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '+strident',
                      '-DORSAL',
                      '-LABIAL',
                      '-anterior',
                      '-approximant',
                      '-sonorant',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'T': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-continuant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-voice',
                 '-word_boundary']),
    'TCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+rhyme',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-continuant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-voice',
                     '-word_boundary']),
    'TH': set([   '+CORONAL',
                  '+anterior',
                  '+consonantal',
                  '+continuant',
                  '-DORSAL',
                  '-LABIAL',
                  '-approximant',
                  '-rhyme',
                  '-sonorant',
                  '-strident',
                  '-syllabic',
                  '-voice',
                  '-word_boundary']),
    'THCoda': set([   '+CORONAL',
                      '+anterior',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '-DORSAL',
                      '-LABIAL',
                      '-approximant',
                      '-sonorant',
                      '-strident',
                      '-syllabic',
                      '-voice',
                      '-word_boundary']),
    'UH1': set([   '+back',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-tense',
                   '-word_boundary']),
    'UH2': set([   '+back',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-tense',
                   '-word_boundary']),
    'UW0': set([   '+back',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-stress',
                   '-word_boundary']),
    'UW1': set([   '+back',
                   '+high',
                   '+mainstress',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-word_boundary']),
    'UW2': set([   '+back',
                   '+high',
                   '+round',
                   '+sonorant',
                   '+stress',
                   '+syllabic',
                   '+tense',
                   '-consonantal',
                   '-diphthong',
                   '-low',
                   '-mainstress',
                   '-word_boundary']),
    'V': set([   '+LABIAL',
                 '+consonantal',
                 '+continuant',
                 '+voice',
                 '-CORONAL',
                 '-DORSAL',
                 '-approximant',
                 '-rhyme',
                 '-sonorant',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'VCoda': set([   '+LABIAL',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '+voice',
                     '-CORONAL',
                     '-DORSAL',
                     '-approximant',
                     '-sonorant',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'W': set([   '+LABIAL',
                 '+approximant',
                 '+back',
                 '+high',
                 '+round',
                 '+sonorant',
                 '-CORONAL',
                 '-DORSAL',
                 '-consonantal',
                 '-low',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'WCoda': set([   '+LABIAL',
                     '+approximant',
                     '+back',
                     '+high',
                     '+rhyme',
                     '+round',
                     '+sonorant',
                     '-CORONAL',
                     '-DORSAL',
                     '-consonantal',
                     '-low',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'Y': set([   '+approximant',
                 '+high',
                 '+sonorant',
                 '-CORONAL',
                 '-DORSAL',
                 '-LABIAL',
                 '-back',
                 '-consonantal',
                 '-low',
                 '-rhyme',
                 '-strident',
                 '-syllabic',
                 '-word_boundary']),
    'YCoda': set([   '+approximant',
                     '+high',
                     '+rhyme',
                     '+sonorant',
                     '-CORONAL',
                     '-DORSAL',
                     '-LABIAL',
                     '-back',
                     '-consonantal',
                     '-low',
                     '-strident',
                     '-syllabic',
                     '-word_boundary']),
    'Z': set([   '+CORONAL',
                 '+anterior',
                 '+consonantal',
                 '+continuant',
                 '+strident',
                 '+voice',
                 '-DORSAL',
                 '-LABIAL',
                 '-approximant',
                 '-rhyme',
                 '-sonorant',
                 '-syllabic',
                 '-word_boundary']),
    'ZCoda': set([   '+CORONAL',
                     '+anterior',
                     '+consonantal',
                     '+continuant',
                     '+rhyme',
                     '+strident',
                     '+voice',
                     '-DORSAL',
                     '-LABIAL',
                     '-approximant',
                     '-sonorant',
                     '-syllabic',
                     '-word_boundary']),
    'ZH': set([   '+CORONAL',
                  '+consonantal',
                  '+continuant',
                  '+strident',
                  '+voice',
                  '-DORSAL',
                  '-LABIAL',
                  '-anterior',
                  '-approximant',
                  '-rhyme',
                  '-sonorant',
                  '-syllabic',
                  '-word_boundary']),
    'ZHCoda': set([   '+CORONAL',
                      '+consonantal',
                      '+continuant',
                      '+rhyme',
                      '+strident',
                      '+voice',
                      '-DORSAL',
                      '-LABIAL',
                      '-anterior',
                      '-approximant',
                      '-sonorant',
                      '-syllabic',
                      '-word_boundary'])}
