#!/usr/bin/env python
# -*- coding: utf-8 -*-

from bls_py.fields import Fq, Fq2, Fq6, Fq12, bls12381_q as Q


qint_list = [
    1869456695022563883032824896096400917508876187780974182855602319250203159746650889199570748041371712120293636655047,
    1333812112656471293386512545613468356122845558349311013349940669103328967785996108095236087914122651293918800460689,
    1469267016709964906855378319530817551040684891904363713392358367060663716075802527984486633481478204983297136291241,
    2045502431699315922682598494227201383147576245162634834999878184394814220943091772270051507901190455994440947531388,

    719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013,
    305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135,
    3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737,
    2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307,

    895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640,
    3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756,
    2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574,
    976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817,

    1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094,
    2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109,
    2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553,
    2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679,

    3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682,
    3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977,
    2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234,
    3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424,

    3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167,
    470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698,
    2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417,
    87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107,

    241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293,
    1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955,
    1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049,
    553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619,

    3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076,
    1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987,
    3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381,
    3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000,

    1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248,
    1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190,
    3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435,
    2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217,

    1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162,
    2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007,
    3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656,
    1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388,

    2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775,
    2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273,
    3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750,
    3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165,

    188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260,
    1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312,
    2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970,
    2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201,
]


len_qint_list = len(qint_list)


fq_list = []
for i in range(4):
    fq_list.append(Fq(Q, qint_list[i]))


fq2_list = []
for i in range(4):
    fq_1 = Fq(Q, qint_list[i])
    fq_2 = Fq(Q, qint_list[i+4])
    fq2_list.append(Fq2(Q, fq_1, fq_2))


fq6_list = []
for i in range(4):
    l1 = [Fq(Q, qint_list[i+j]) for j in range(0, 24, 4)]
    l2 = [Fq2(Q, l1[j], l1[j+1]) for j in range(0, 6, 2)]
    fq6_list.append(Fq6(Q, *l2))


fq12_list = []
for i in range(4):
    l1 = [Fq(Q, qint_list[i+j]) for j in range(0, 48, 4)]
    l2 = [Fq2(Q, l1[j], l1[j+1]) for j in range(0, 12, 2)]
    l3 = [Fq6(Q, l2[j], l2[j+1], l2[j+2]) for j in range(0, 6, 3)]
    fq12_list.append(Fq12(Q, *l3))


fq_res_list = [
    Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736),
    Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288),
    Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435),
    Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930),
    Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077),
    Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629),
    Fq(Q, 73511129852917215430117665442932969686381201097577315366839676860858736702829118135516255560032984078494668357975),
    Fq(Q, 1711797489568616583434146621422538673233444794009731352316131919899927017977837896877331399843341475889254457279480),
    Fq(Q, 606412287420852147510355256915883920871639472600949273462625871567737033901651002715167115631897903830887166236977),
    Fq(Q, 396161667274950507585561902166368883051657512476655244387126442886647046202250508302105492204377657577670624819270),
    Fq(Q, 3987271041785576987156819481352825941440692198600617902798823449095197460402013016484271416158707080120631314480417),
    Fq(Q, 3912953593301214097359025577539250046153482475193812226238890530646088854489871769531875731315657768393838264598570),
    Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358),
    Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806),
    Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446),
    Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235),
    Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088),
    Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640),
    Fq(Q, 2132952860199103510384964929639503239048006632158033702476455816873828490744186975243116881087643951917600635904740),
    Fq(Q, 2668597442565196100031277280122435800434037261589696871982117467020702682704841756347451541214893012743975472099098),
    Fq(Q, 1099816316533408933204668954501883468712635851056365986721471440615081951443209549316452630382721060889319992399912),
    Fq(Q, 56058419996888119675781310291403262833910090500020919309111022308234688733790650582786270516486147427054660427082),

    Fq(Q, 0),
]


fq2_res_list = [
    Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 1025407231273636406944101243528487744178571069791551455264012691226440928360355533843269054467543027936990360636148)),
    Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3785814930612185622711884608383468863741456200121603180818271937625477847554411284756984725802743250387927011668750)),
    Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 3319431804555652834780724622411544164241045313933925223137456455519065651294648609396407378461300488039330034297320)),
    Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3371348709352602244718327618342380424888498781585790184301669580615381437214612553531422624873618952124934090746872)),
    Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2904965583296069456787167632370455725388087895398112226620854098508969240954849878170845277532176189776337113375442)),
    Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 1662963727412951279137161171489532688394090205789156066843055208783974509658067764641873319738360748189379491848257)),
    Fq2(Q, Fq(Q, 877447069861743471558744907726386870343346652339923383574545007635112345744606332209754017059040731780983880312192), Fq(Q, 1004515062225896383633895867885374593975409632574484600523177157636057715826048803227400830210847117657589851148278)),
    Fq2(Q, Fq(Q, 198611095528669814491819784930028092283831359481111699896026753692264899514634797825901946348101593552169843656028), Fq(Q, 2396916264283631074223937060996845735665611736761272139820256917935773581131240120932476314844881177060927182472581)),
    Fq2(Q, Fq(Q, 2966387193521126141849075070423387987246030404828497756557780526817720010523934326532571670944056977052491480390115), Fq(Q, 2338584106356611690179803129664002492149705962909468731229456325629490885456425934621588830628181831187464064933755)),
    Fq2(Q, Fq(Q, 2260308507373785812856380714311963592630215313438780464134197969153518368048105540560731055552404425154719507945568), Fq(Q, 3902299314573171213094088813389476800107457738322735663658191090398842473122781164961962216614758831897694981055759)),
    Fq2(Q, Fq(Q, 336644073594518398371084049749262810673070732748389186112541264104468479280909639729434258644927002202457459876917), Fq(Q, 225767967117245824570724410525122107821216015291112798814640774459593548319948696415626265472071010965589103859438)),
    Fq2(Q, Fq(Q, 2445778776045587586620394992223935627756918809754419669239611124577562885493463571458147813364363268199998228280575), Fq(Q, 2662356018069904985875227188282036548887778281730255157103508566470405845853320669647450627287944655440672138725592)),
    Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 414466221259583377993556990041088438852957418535812996516602357010096410339798731225562100929124298262992920921878)),
    Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 1656468077142701555643563450922011475846955108144769156294401246735091141636580844754534058722939739849950542449063)),
    Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 2122851203199234343574723436893936175347365994332447113975216728841503337896343520115111406064382502198547519820493)),
    Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 1242001855883118177650006460880923036993997689608956159777798889724994731296782113528971957793815441586957621527185)),
    Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1708384981939650965581166446852847736494408575796634117458614371831406927556544788889549305135258203935554598898615)),
    Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 466383126056532787931159985971924699500410886187677957680815482106412196259762675360577347341442762348596977371430)),
    Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)),
    Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)),
    Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307)),
    Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)),
    Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307)),
    Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307)),
    Fq2(Q, Fq(Q, 73511129852917215430117665442932969686381201097577315366839676860858736702829118135516255560032984078494668357975), Fq(Q, 1789076427305895402220635374945357560972524858210729060295676724761167857035182925911612600560973730112977343126985)),
    Fq2(Q, Fq(Q, 1711797489568616583434146621422538673233444794009731352316131919899927017977837896877331399843341475889254457279480), Fq(Q, 1925470021225289286149082376590015884192837705791362736511734327669841899965072675074306663605072884615479779184059)),
    Fq2(Q, Fq(Q, 606412287420852147510355256915883920871639472600949273462625871567737033901651002715167115631897903830887166236977), Fq(Q, 596964300953226707489596985125029404930548576827721932328498713712706185928033703435189539136973008617007359213367)),
    Fq2(Q, Fq(Q, 396161667274950507585561902166368883051657512476655244387126442886647046202250508302105492204377657577670624819270), Fq(Q, 3849368591335503388044532343034301505908611466391971767392433108669278632712639509090447753654654253881929706255460)),
    Fq2(Q, Fq(Q, 3987271041785576987156819481352825941440692198600617902798823449095197460402013016484271416158707080120631314480417), Fq(Q, 2776729915488145394056711049470400182077995689328648944410359059986324672577074840657808997778501050795190820606958)),
    Fq2(Q, Fq(Q, 3912953593301214097359025577539250046153482475193812226238890530646088854489871769531875731315657768393838264598570), Fq(Q, 766853752077287394741786255013291168173020538982872649867985308154699263055973990323505296207412173774556996020997)),
    Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 3696939050214640878942517698992204503894075994311138655958352969015859391480559463133834152359806299200895552702652)),
    Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 936531350876091663174734334137223384331190863981086930404093722616822472286503712220118481024606076749958901670050)),
    Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 1402914476932624451105894320109148083831601750168764888084909204723234668546266387580695828366048839098555879041480)),
    Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 936531350876091663174734334137223384331190863981086930404093722616822472286503712220118481024606076749958901670050)),
    Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1402914476932624451105894320109148083831601750168764888084909204723234668546266387580695828366048839098555879041480)),
    Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 1402914476932624451105894320109148083831601750168764888084909204723234668546266387580695828366048839098555879041480)),
    Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)),
    Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)),
    Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)),
    Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)),
    Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)),
    Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)),
    Fq2(Q, Fq(Q, 73511129852917215430117665442932969686381201097577315366839676860858736702829118135516255560032984078494668357975), Fq(Q, 3217848190141668374831050318675921189559767594302763425559558568998921509281703741758475858778889051582506780581080)),
    Fq2(Q, Fq(Q, 1711797489568616583434146621422538673233444794009731352316131919899927017977837896877331399843341475889254457279480), Fq(Q, 471446243058341788074854684406829851472774030969909403308522590265931681166167445858169651239808292445447403288522)),
    Fq2(Q, Fq(Q, 606412287420852147510355256915883920871639472600949273462625871567737033901651002715167115631897903830887166236977), Fq(Q, 1741619805403384982690206144538973087219157386081746798900957611916784699528392231186399291491208822570456705720388)),
    Fq2(Q, Fq(Q, 396161667274950507585561902166368883051657512476655244387126442886647046202250508302105492204377657577670624819270), Fq(Q, 52930723237667825049556470355175294198846271930763896265757981729563840410141655871514462960104578015765274800299)),
    Fq2(Q, Fq(Q, 3987271041785576987156819481352825941440692198600617902798823449095197460402013016484271416158707080120631314480417), Fq(Q, 1451447606850767823931803186790626082300103145901471739736339850597300526233711720200504896822585624208292555812267)),
    Fq2(Q, Fq(Q, 3912953593301214097359025577539250046153482475193812226238890530646088854489871769531875731315657768393838264598570), Fq(Q, 1895502265992617591133440933268745380714757742747382507235523258315706582797346679323945331080532481666115142704595)),
    Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)),
    Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)),
    Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)),
    Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)),
    Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)),
    Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)),
    Fq2(Q, Fq(Q, 2132952860199103510384964929639503239048006632158033702476455816873828490744186975243116881087643951917600635904740), Fq(Q, 3282472828955057500948960708951116065041118575775325659441750612005762981140760731908272051430682000937902631780774)),
    Fq2(Q, Fq(Q, 2668597442565196100031277280122435800434037261589696871982117467020702682704841756347451541214893012743975472099098), Fq(Q, 3696939050214640878942517698992204503894075994311138655958352969015859391480559463133834152359806299200895552702652)),
    Fq2(Q, Fq(Q, 3707248697746509457612393892765497086610240274325039663677455355151350368615143517938708069190759498867681182008342), Fq(Q, 3313053184045850964145559278565286560864786629361258832091282925790031770165799967069966661818175976661985529232979)),
    Fq2(Q, Fq(Q, 3021890775501286231107949847713096763920098190071598470095628250828857690063682039208356008330422777032930591795223), Fq(Q, 1913366727923564855958820914627681331696901672116458136269957763575696275436304880799520165482390882242643687629227)),

    Fq2(Q, Fq(Q, 0), Fq(Q, 0))
]


fq6_res_list = [
    Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 1025407231273636406944101243528487744178571069791551455264012691226440928360355533843269054467543027936990360636148)), Fq2(Q, Fq(Q, 258066216657524927979403051584820291135621845274807280122621551302953838229944968651870140174444448670933321904609), Fq(Q, 153648160743842587374354268027995179728920743432920270043555333381033988413019413346190155703849802386639076716416)), Fq2(Q, Fq(Q, 3551312213391417611729068989577202022724064296314128168974881333285242974392094506413773318369402730380606667260872), Fq(Q, 375210620363240435945365119971584928401305211458283006882600674201056944870829002570351058661355646964382173282078))),
    Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3785814930612185622711884608383468863741456200121603180818271937625477847554411284756984725802743250387927011668750)), Fq2(Q, Fq(Q, 3731918433716138189396253828003798660534810571905961070968534805701783667401609706529387082459721142543503322598214), Fq(Q, 220354749446141926951040004120623745776059249069702661981046662631741335310281379058827130608671547518895914161860)), Fq2(Q, Fq(Q, 1995175401474457115363328834949742556793966927115180882117913401909087528326763664272348147405077487217061832064129), Fq(Q, 2179692018855534530874294250803014764903596058520618229139193776106023560111102496453134547434966972333367208346797))),
    Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 3319431804555652834780724622411544164241045313933925223137456455519065651294648609396407378461300488039330034297320)), Fq2(Q, Fq(Q, 1872212493152585914035456746954081813285486724989778347957739626925457209116063951093620242138271399369198659733457), Fq(Q, 3916174122599961280400471533556637076778907580203947517077812891118155214273617439221057115136151022142124982042773)), Fq2(Q, Fq(Q, 3538513019787255257313125285475584232115164022924123687293598163918448839960346868135871851596680799044583054277319), Fq(Q, 3994570245369309876121480669661654884145381817741417372774857049909724631150715766113950796182798704545565210915274))),
    Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3371348709352602244718327618342380424888498781585790184301669580615381437214612553531422624873618952124934090746872)), Fq2(Q, Fq(Q, 2199147706428555260210808694230813652587823109075705748038997055380510384146336635031084498898951952754414513897543), Fq(Q, 725808682727960774152294783475001240912238847952451383757885473586555264184973286750864425784614725501321221425875)), Fq2(Q, Fq(Q, 1657072226773007438516666113057037045988835029921356122337505156211018583701208924211001035229007556557085559453424), Fq(Q, 2746167718662995967938662804334079552069272603151144017439368584707001080159665651351682490709425851338543753866115))),
    Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2904965583296069456787167632370455725388087895398112226620854098508969240954849878170845277532176189776337113375442)), Fq2(Q, Fq(Q, 339441765865002984850011613181096805338499262159523025028201876604183925860790879595317658577502209580109851032786), Fq(Q, 419218500660112734183936487175110415358204359147688353522593565948937492657471482470406781183078536086656016747001)), Fq2(Q, Fq(Q, 3200409845085805580466462563582878721310032125730298927513189918220379895334792128074524739420610868384606781666614), Fq(Q, 558636389955103919768059397456815514754175542432935275742973722386670500708441056569811110328241919512847483874805))),
    Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 1662963727412951279137161171489532688394090205789156066843055208783974509658067764641873319738360748189379491848257)), Fq2(Q, Fq(Q, 3813293982923616246266862389600075174737687988790676815874115131003013755032455617472834600862778903452679851726391), Fq(Q, 485925089362412073760622223267738981405342864784470745460084895199644839554733448183043756087900281218912854192445)), Fq2(Q, Fq(Q, 1644273033168845084100722408955419255379934756531351640656221986844224449269461285933099568456285625221061946469871), Fq(Q, 2363117788447398014696988528288245351256466389495270497999566824291637115948714550452594599101853244881832518939524))),
    Fq6(Q, Fq2(Q, Fq(Q, 1978715441315260260117495996057795741472590438155234835082583232949239209989669183463423011241668241410325432809144), Fq(Q, 1672206282860153609155521071708999372205617643887555316106421375994789925099729446590261456492501483480714459694561)), Fq2(Q, Fq(Q, 2343484435046268225362162478379266982366371299864327141285669030275052929822032004370900991183873787486189674179485), Fq(Q, 2096650363310161368035366632543706965418260443922138403176571267938511736979250446490791409254517712877756022438609)), Fq2(Q, Fq(Q, 3259905331116579669416617031637063502394533422465259069678835949538649816714954636743299899128041363284359774464168), Fq(Q, 1317146559729042644735092363237961904741766051071659417134920011645921734434220588242548035352603530019624974819077))),
    Fq6(Q, Fq2(Q, Fq(Q, 898858885561780888775537684166070054505866841354321154306258883164867554557991859702587424980375384099385715958701), Fq(Q, 2691730861577908258652991517894460075340464675307534815237744937080226900183346797127039559895311250846507469868300)), Fq2(Q, Fq(Q, 2604562945371840528029558734687860391621835021382421070858938517846881817279680975448456962899021359106021981681609), Fq(Q, 1897341102977912227946001729914881409502095776133873329328806914740415494931189054404841891551402811830184648532842)), Fq2(Q, Fq(Q, 734806989933632053662667214643758512227194981447262725378581329272097010092618558907713564881976259518019563763857), Fq(Q, 842102603445637403607083398291186105463029817692476816322843582545251258860546197621495286505767392658516040333675))),
    Fq6(Q, Fq2(Q, Fq(Q, 999603067119591277324346208881747219968713130045568500733221090175344858161879238788364614794972009221193567387747), Fq(Q, 2049863774688240423993147502016839063970324431030728941323130608997721713178465449464106940224209577125542266662701)), Fq2(Q, Fq(Q, 1272488634543137279969164490720732702860418146110948614476114726047178900536591796476717925815585251408152787070100), Fq(Q, 3734005087328514167409143302853404460041724220010955483391878018415128580905759573677559961021321682314858208452724)), Fq2(Q, Fq(Q, 1767363778141075062362777076400976315927104698159959366948405167595819903823663123971161722372913487968747313776122), Fq(Q, 1004590017925075346421338787273911987523728446369515577475259898553472631375471707293013914996778504423494472513156))),
    Fq6(Q, Fq2(Q, Fq(Q, 1908307339260375312718854838074443589871498031187919412534190672208265609393009853347483789785172197560828714254329), Fq(Q, 2616275827434691639602441613436939761308135661653655608648903585024293719216462302863765158196228384152350096757922)), Fq2(Q, Fq(Q, 394807284889957266679302611008946067436357950350769954581002876825146271784800636307804350299258218056699546907537), Fq(Q, 3086329144672518440235151500421392737490324933591040042317212669814739319037087940510874742726919571628252010882306)), Fq2(Q, Fq(Q, 839154211885017154537425285607334694850178463816026097323805657407241958033133835553256607596119368635164664766464), Fq(Q, 1345208170881100219441628568884772026486500788353445453586528846352398939740487393598034095266748041802731407836205))),
    Fq6(Q, Fq2(Q, Fq(Q, 1289029398056353602991148998275273639282848413276291699429247919535307198334879586423613387247026147602205552184098), Fq(Q, 2513155726121630503175288484087050307754529940544604523864645763758000267917253197003234419214122641148811705766960)), Fq2(Q, Fq(Q, 1685351321666973253598887862355315543263835087765506845230596960315564421622319797571527439083854670884347351263500), Fq(Q, 863393312066475006943700123740820479042422145345176535319068489271898036681315525172799217037251947638563910889689)), Fq2(Q, Fq(Q, 2580396353004057445004391715863125601268272679240379854633798738273026306452646517088133231420992896046942763563291), Fq(Q, 620245733391072904204141949961862696678997130475352732405328439185592434812428209628112791550357752620066163547648))),
    Fq6(Q, Fq2(Q, Fq(Q, 455901004859393587007484457776409667840062302271468677852054894400191264876042812899228055079989912410698781817846), Fq(Q, 3904226797852673125597070126530716929443506686498962906616936643348217597260226685121186616839353118871470975495085)), Fq2(Q, Fq(Q, 2631125341451178443724321554275687665104524122812449519580910240812089397073229059642720306197421637985313156829630), Fq(Q, 356028328487355515133682459068610190113015394640996689238411280293034962506415698637349866142094172265355339751683)), Fq2(Q, Fq(Q, 1387020908201420482456604194410611877193991925874212673605597709116518193803923430457788641345182466165186772406219), Fq(Q, 2309915835935843949390446805964251053951471620187602662578837084116482849055017577505781300390739255630781848511443))),
    Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 414466221259583377993556990041088438852957418535812996516602357010096410339798731225562100929124298262992920921878)), Fq2(Q, Fq(Q, 1532770727287582929185445133772985007946987462830255322929537750321273283255273071498302583560769189789088808700671), Fq(Q, 3496955621939848546216535046381526661420703221056259163555219325169217721616145956750650333953072486055468965295772)), Fq2(Q, Fq(Q, 338103174701449676846662721892705510805131897193824759780408245698068944625554740061347112176069930659976272610705), Fq(Q, 3435933855414205956353421272204839369391206275308482097031883327523054130442274709544139685854556785032717727040469))),
    Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 1656468077142701555643563450922011475846955108144769156294401246735091141636580844754534058722939739849950542449063)), Fq2(Q, Fq(Q, 2061328065450637061186384183089910795104681556138109417415682632046475104574446198063473270404508159954413080566853), Fq(Q, 3430249033237549206639849310288898095373564715419476771617727995918510374718883991038013359048250740923212127850328)), Fq2(Q, Fq(Q, 1894239986618410173212402876520164976735229266392772046637376177074224390690885582202772283140395173823521107807448), Fq(Q, 1631452456921911861424492141373409532888915428246146874775290225618087515202001215661356197080945459663732691975750))),
    Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 2122851203199234343574723436893936175347365994332447113975216728841503337896343520115111406064382502198547519820493)), Fq2(Q, Fq(Q, 3921034006014189336547181264139627642354005403054292140426477810822801562859991953499240110725957903128717743431610), Fq(Q, 3736839215305397246608207606588788920927599204224239801853019903556128146246385795318471003649786930337877332529202)), Fq2(Q, Fq(Q, 350902368305612031262606425994323301414032170583829241461691415064863079057302378339248578948791861995999885594258), Fq(Q, 3818983785629803909595095548250673570204012488964355616471685087938418094653225810443227577462129391489428961967060))),
    Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 1242001855883118177650006460880923036993997689608956159777798889724994731296782113528971957793815441586957621527185)), Fq2(Q, Fq(Q, 528557338163054132000939049316925787157694093307854094486144881725201821319173126565170686843738970165324271866182), Fq(Q, 3935702966519368053841104089643275590509744314302225493394566806873324303593575898730050654224193918905637435114343)), Fq2(Q, Fq(Q, 1556136811916960496365740154627459465930097369198947286856967931376155446065330842141425170964325243163544835196743), Fq(Q, 2197928156729373298488860694904474320054591972876672663075465034219065035250564370559904140355404338668909237495068))),
    Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1708384981939650965581166446852847736494408575796634117458614371831406927556544788889549305135258203935554598898615)), Fq2(Q, Fq(Q, 2388263278726606407361736130366642634407017940224036817496940060501528279604718882000937527165188713339628934730939), Fq(Q, 239883593365548700391672560207262259506895983167980638297800578386910424630239838567820669696714444282408367233430)), Fq2(Q, Fq(Q, 12799193604162354415943704101617790608900273390004481681283169366794134431747638277901466772721931336023612983553), Fq(Q, 383049930215597953241674276045834200812806213655873519439801760415363964210951100899087891607572606456711234926591))),
    Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 466383126056532787931159985971924699500410886187677957680815482106412196259762675360577347341442762348596977371430)), Fq2(Q, Fq(Q, 1859705940563552275360797081049716847249323846916182723010795178776326458285545755435766840321449743174304662864757), Fq(Q, 306590182067848039968358296299890825554034488804763030235291907637617771527501804280457644601536189414665204678874)), Fq2(Q, Fq(Q, 2459071936908869251467993375210062481235685724130065080156373374114670338857254660579163924937412352210373050346597), Fq(Q, 2187531328707892048170603406877264037315097060718208741696394862320330579451224594781871380381183931825696269991310))),
    Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 1025407231273636406944101243528487744178571069791551455264012691226440928360355533843269054467543027936990360636148)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3785814930612185622711884608383468863741456200121603180818271937625477847554411284756984725802743250387927011668750)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))),
    Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 3319431804555652834780724622411544164241045313933925223137456455519065651294648609396407378461300488039330034297320)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))),
    Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3371348709352602244718327618342380424888498781585790184301669580615381437214612553531422624873618952124934090746872)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))),
    Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2904965583296069456787167632370455725388087895398112226620854098508969240954849878170845277532176189776337113375442)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))),
    Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 1662963727412951279137161171489532688394090205789156066843055208783974509658067764641873319738360748189379491848257)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))),
    Fq6(Q, Fq2(Q, Fq(Q, 877447069861743471558744907726386870343346652339923383574545007635112345744606332209754017059040731780983880312192), Fq(Q, 1004515062225896383633895867885374593975409632574484600523177157636057715826048803227400830210847117657589851148278)), Fq2(Q, Fq(Q, 1122231552151397600764231174231382478597621447783306461551512998441918797454816179146915588610749353961886642138155), Fq(Q, 59797678976139506216871153506498033167142516759233742856705569467412133414318283769808612177116873770975648796350)), Fq2(Q, Fq(Q, 1550210159618950315849415034567343244219609006816043580116507922576408905638402002054754973951452724397883311381001), Fq(Q, 1923124964089134604447305250846023641212933235092728014382861944954536380058897335520607270919922463839935083082233))),
    Fq6(Q, Fq2(Q, Fq(Q, 198611095528669814491819784930028092283831359481111699896026753692264899514634797825901946348101593552169843656028), Fq(Q, 2396916264283631074223937060996845735665611736761272139820256917935773581131240120932476314844881177060927182472581)), Fq2(Q, Fq(Q, 3191093683243435540031754541969755764674326373082110292554162318184622357039801899710839896338844630835925960771678), Fq(Q, 2906553864593063607570768367074329710428135437747402297541534161795872027965985204902714213655384862591489535428454)), Fq2(Q, Fq(Q, 3357288701012386356804856362923357271106568081617180126425043361912448353527121764353595104395642841571942632354772), Fq(Q, 2424723268582262131038368381854463645336466117246287217841656822801168755493482455937615169938991780920096060669756))),
    Fq6(Q, Fq2(Q, Fq(Q, 2966387193521126141849075070423387987246030404828497756557780526817720010523934326532571670944056977052491480390115), Fq(Q, 2338584106356611690179803129664002492149705962909468731229456325629490885456425934621588830628181831187464064933755)), Fq2(Q, Fq(Q, 1963082333803031952667552372049015356105435030122257665593456402974722834591047999778964560166327730928490371794279), Fq(Q, 609940950322648946914816247153257056875819257191648108572912264025143961067954391092108114015593792748162364361583)), Fq2(Q, Fq(Q, 2025673636554867192573667918965363143298907160348298050562736181198850293301607170667581049002881554380880374728015), Fq(Q, 2896796133670198297227964033786118688809478560724861961246803427185079701692682333388309804052964988309549037574027))),
    Fq6(Q, Fq2(Q, Fq(Q, 2260308507373785812856380714311963592630215313438780464134197969153518368048105540560731055552404425154719507945568), Fq(Q, 3902299314573171213094088813389476800107457738322735663658191090398842473122781164961962216614758831897694981055759)), Fq2(Q, Fq(Q, 1906114057948334822153503566464967539613486499834928498957106118021944319855118358897982633678823556068311459448749), Fq(Q, 750103453023609185418572320673727612794286998859047994668024650672329080498243454265840542780206241645079274939428)), Fq2(Q, Fq(Q, 3401714449313860062865725363225054390331902640346156190105563220970010592235848550083983959129965998126436305023926), Fq(Q, 408407406860405155317710025716048972978155885031610593405343647019541824894062616188927989529885551602796355897000))),
    Fq6(Q, Fq2(Q, Fq(Q, 336644073594518398371084049749262810673070732748389186112541264104468479280909639729434258644927002202457459876917), Fq(Q, 225767967117245824570724410525122107821216015291112798814640774459593548319948696415626265472071010965589103859438)), Fq2(Q, Fq(Q, 3483436312047944629741785316986182406767817285085644652610851925889313458553977923290712663324716494481981096648260), Fq(Q, 2040630461606927348223568068665901497476056942198339298838773447566203576033983037629913272040298000971425008426495)), Fq2(Q, Fq(Q, 2828607675065403441034881678104484429115341397291898736448903930001728492689251280953176333459108167715406619170292), Fq(Q, 1829183608843190064651443720719125703788026251364220233044358500407762485330553165086688669446134764532309148095933))),
    Fq6(Q, Fq2(Q, Fq(Q, 2445778776045587586620394992223935627756918809754419669239611124577562885493463571458147813364363268199998228280575), Fq(Q, 2662356018069904985875227188282036548887778281730255157103508566470405845853320669647450627287944655440672138725592)), Fq2(Q, Fq(Q, 2653072162220343997089443962899729183003393318442318126948813504282071155443798145568047751525818756741935310896412), Fq(Q, 58250970072110795368242099297692652394017094329423671524650547039932211688700979235262199301907961193605499056168)), Fq2(Q, Fq(Q, 2652398299421002385053302588364115603345981905525532610811662280846710947635427982277679069706352225166123903669113), Fq(Q, 3345865947625749160946111344711661590439120547207178019717179179891892687486656453700832906799230625962861416797807))),
    Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 414466221259583377993556990041088438852957418535812996516602357010096410339798731225562100929124298262992920921878)), Fq2(Q, Fq(Q, 637352255315029000603021041094082358405682808777724021403458099509159722512664051423216221693162370559077743398031), Fq(Q, 1671653730598002979421090389176765740845891238811669446755831995894091866601563271702230089124611341834414944289678)), Fq2(Q, Fq(Q, 394600258265849729267691779025703822318975210409352238068792524268428810362149049045130711467841432158631938954810), Fq(Q, 3531566395136316456912922988984579298773391941894603487740670394723014418031141785708238128161108401053114913159089))),
    Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 1656468077142701555643563450922011475846955108144769156294401246735091141636580844754534058722939739849950542449063)), Fq2(Q, Fq(Q, 1165909593478083132603960090411008145563376902085578115889602981234361543831837177988386908536901340724402015264213), Fq(Q, 1604947141895703639844404653084137174798752733174887054818340666643384519704301305989593114219789596702158106844234)), Fq2(Q, Fq(Q, 1950737070182810225633431933653163288249072579608299524925760455644584256427479891186555882432166675322176774151553), Fq(Q, 1727084996644022361983993858153149462271101094832268265484077292818047802790868291825454639387497075684129878094370))),
    Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 2122851203199234343574723436893936175347365994332447113975216728841503337896343520115111406064382502198547519820493)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))),
    Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 1242001855883118177650006460880923036993997689608956159777798889724994731296782113528971957793815441586957621527185)), Fq2(Q, Fq(Q, 1165909593478083132603960090411008145563376902085578115889602981234361543831837177988386908536901340724402015264213), Fq(Q, 1604947141895703639844404653084137174798752733174887054818340666643384519704301305989593114219789596702158106844234)), Fq2(Q, Fq(Q, 1950737070182810225633431933653163288249072579608299524925760455644584256427479891186555882432166675322176774151553), Fq(Q, 1727084996644022361983993858153149462271101094832268265484077292818047802790868291825454639387497075684129878094370))),
    Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1708384981939650965581166446852847736494408575796634117458614371831406927556544788889549305135258203935554598898615)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))),
    Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 466383126056532787931159985971924699500410886187677957680815482106412196259762675360577347341442762348596977371430)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))),
    Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 1025407231273636406944101243528487744178571069791551455264012691226440928360355533843269054467543027936990360636148)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3785814930612185622711884608383468863741456200121603180818271937625477847554411284756984725802743250387927011668750)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 3319431804555652834780724622411544164241045313933925223137456455519065651294648609396407378461300488039330034297320)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3371348709352602244718327618342380424888498781585790184301669580615381437214612553531422624873618952124934090746872)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2904965583296069456787167632370455725388087895398112226620854098508969240954849878170845277532176189776337113375442)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 1662963727412951279137161171489532688394090205789156066843055208783974509658067764641873319738360748189379491848257)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))),
    Fq6(Q, Fq2(Q, Fq(Q, 877447069861743471558744907726386870343346652339923383574545007635112345744606332209754017059040731780983880312192), Fq(Q, 1004515062225896383633895867885374593975409632574484600523177157636057715826048803227400830210847117657589851148278)), Fq2(Q, Fq(Q, 1784046045572489543183218073160592407653794514402907412437580310626646739315262292139619664890710717760454879760234), Fq(Q, 1810854388609304563586648246800725613518394934482702633723902555434755351151947071927772658410883656999707381323902)), Fq2(Q, Fq(Q, 2704188011239799976303032301956259564869712145318865208704199110299478104868109787057875604466761828600643971436162), Fq(Q, 2063666501494457199697884100341733155131864954394134076265637880159013870363819221443300023796935043513382449813619))),
    Fq6(Q, Fq2(Q, Fq(Q, 198611095528669814491819784930028092283831359481111699896026753692264899514634797825901946348101593552169843656028), Fq(Q, 2396916264283631074223937060996845735665611736761272139820256917935773581131240120932476314844881177060927182472581)), Fq2(Q, Fq(Q, 3183019504431449487831114863325372678566188207516203500763628693832067954707118829576165082712823838769034384411309), Fq(Q, 2579352645875305298792577686304143615878051830667234131546031951238453527891748560385251573617607757741750859298461)), Fq2(Q, Fq(Q, 780703276342933093139296726430709520887762879094776395640052627531221197120470495991537037507639046303826181481383), Fq(Q, 2111303858445440119683874123690513124154286701303241382009623010603346052648130190391264947251339957176738959325370))),
    Fq6(Q, Fq2(Q, Fq(Q, 2966387193521126141849075070423387987246030404828497756557780526817720010523934326532571670944056977052491480390115), Fq(Q, 2338584106356611690179803129664002492149705962909468731229456325629490885456425934621588830628181831187464064933755)), Fq2(Q, Fq(Q, 481856392743758837177077634373056358414024374694260046142641696006974318037079840901985590251490667352625756868651), Fq(Q, 778515631448114665324447174801114256186185722638825321968071899101949412761881637763354245379318793823243051861631)), Fq2(Q, Fq(Q, 92521424193231131380412198262180886169404035612911089810254132798388918893861078277590517077484706981770286503404), Fq(Q, 3392995879365160746704482819249426512060948927048989478510718665671625574997391450783372834525475259205245430744677))),
    Fq6(Q, Fq2(Q, Fq(Q, 2260308507373785812856380714311963592630215313438780464134197969153518368048105540560731055552404425154719507945568), Fq(Q, 3902299314573171213094088813389476800107457738322735663658191090398842473122781164961962216614758831897694981055759)), Fq2(Q, Fq(Q, 490073817089847612693820231514113314088514694323116532792783097311156084527008901079198036435458729469345978859355), Fq(Q, 185886674490026717022501799239203656902777881831191507260008744504143171474862785635430339285879930778805763154547)), Fq2(Q, Fq(Q, 2705374249346021541678339074935859908062623748717896803482156418207243517597279734135127055911473620071556559992658), Fq(Q, 2465050147458777736487836068241121954402848668673657823546046488721333619554007820125550039930937839298454319214499))),
    Fq6(Q, Fq2(Q, Fq(Q, 336644073594518398371084049749262810673070732748389186112541264104468479280909639729434258644927002202457459876917), Fq(Q, 225767967117245824570724410525122107821216015291112798814640774459593548319948696415626265472071010965589103859438)), Fq2(Q, Fq(Q, 1785198025216529315623568924541211171349203442475007901312563937464911230245677945182815609318725255254647543433201), Fq(Q, 1260268420784601566166649698191401044818739916270577382669907322372688989459042456671341650209518312657007652407608)), Fq2(Q, Fq(Q, 2371213262521466042432282449442396340621302569032270383670032423299458224918681964568925988492319423387252853133489), Fq(Q, 1350594283180875346362855593344632362798995268019332288283184088272798070124807999181729675338559236600791496600544))),
    Fq6(Q, Fq2(Q, Fq(Q, 2445778776045587586620394992223935627756918809754419669239611124577562885493463571458147813364363268199998228280575), Fq(Q, 2662356018069904985875227188282036548887778281730255157103508566470405845853320669647450627287944655440672138725592)), Fq2(Q, Fq(Q, 2792819800146001760766504353070877891022523330824248418459647020034809471708845223549202384570759511124159424107873), Fq(Q, 385165215300480076851426151336050580059028401661026913373039395285639661035074223717555496959161540147455892409358)), Fq2(Q, Fq(Q, 3758050381287969181804327848559759413660979034273887071079058108249329420775804691271444110565575020762061039847999), Fq(Q, 1959748159607150608740366436841351482351855841128183518451766210795175905030299647315603746370178585274162180974167))),
    Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 414466221259583377993556990041088438852957418535812996516602357010096410339798731225562100929124298262992920921878)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 1656468077142701555643563450922011475846955108144769156294401246735091141636580844754534058722939739849950542449063)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 2122851203199234343574723436893936175347365994332447113975216728841503337896343520115111406064382502198547519820493)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 1242001855883118177650006460880923036993997689608956159777798889724994731296782113528971957793815441586957621527185)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1708384981939650965581166446852847736494408575796634117458614371831406927556544788889549305135258203935554598898615)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 466383126056532787931159985971924699500410886187677957680815482106412196259762675360577347341442762348596977371430)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))),
    Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))),
    Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))),
    Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))),
    Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))),
    Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))),
    Fq6(Q, Fq2(Q, Fq(Q, 73511129852917215430117665442932969686381201097577315366839676860858736702829118135516255560032984078494668357975), Fq(Q, 1789076427305895402220635374945357560972524858210729060295676724761167857035182925911612600560973730112977343126985)), Fq2(Q, Fq(Q, 2208608838694236332311961854592998731142073940851704397318879657542617444971346192792349425181015881921807181932619), Fq(Q, 3543884315799971400442503786650006461738214817272017446071437583299626223041028629037241843022160186201280537237498)), Fq2(Q, Fq(Q, 791353734953364699713157546212645218606756082684942228602490270826376282990707392523525217812509404037959155059113), Fq(Q, 747651847366790552265365851589930525231426569125112849948955564071666276652746103541622612959783187159173636417561))),
    Fq6(Q, Fq2(Q, Fq(Q, 1711797489568616583434146621422538673233444794009731352316131919899927017977837896877331399843341475889254457279480), Fq(Q, 1925470021225289286149082376590015884192837705791362736511734327669841899965072675074306663605072884615479779184059)), Fq2(Q, Fq(Q, 3749752378243477266182430540676896078205163067910277252522351165806302154479319030426062760609275840595521892229407), Fq(Q, 1519888831650980258102891099986649689898670358783019991469547758159398616743199022058148178428464166641524020347699)), Fq2(Q, Fq(Q, 2542555657034941581198404091595242433116501522331775022144341938465064081594401543835610731266419638017121525679952), Fq(Q, 3860282023960925822213766947049444190252202828366460309002707146632049091067427299222905628282533243566068282680726))),
    Fq6(Q, Fq2(Q, Fq(Q, 606412287420852147510355256915883920871639472600949273462625871567737033901651002715167115631897903830887166236977), Fq(Q, 596964300953226707489596985125029404930548576827721932328498713712706185928033703435189539136973008617007359213367)), Fq2(Q, Fq(Q, 3613157949372900244984669693257023467564205187340502714890905035519427259458811120462564113092201608868649317211527), Fq(Q, 3406611662853814127786113851065530745281238435318274624083464800633557283975892620383255478512193840982660225352078)), Fq2(Q, Fq(Q, 388697824063855736407504039797555706903406557007213882575283590540658313187058383810581619903494077213681921072026), Fq(Q, 2188821117036473090306863511257078466600071573160786437200676554015732604233171021604611541676484354142303543932613))),
    Fq6(Q, Fq2(Q, Fq(Q, 396161667274950507585561902166368883051657512476655244387126442886647046202250508302105492204377657577670624819270), Fq(Q, 3849368591335503388044532343034301505908611466391971767392433108669278632712639509090447753654654253881929706255460)), Fq2(Q, Fq(Q, 2210614238363216085869776004014144766120000365676574121804883787517389670124284653602839156520475156339282854410958), Fq(Q, 411058276023165412891714901122768875166883274830174336382333311552741727669174231309602754483316106867044499028505)), Fq2(Q, Fq(Q, 2565550360631980238404797529449237232423202514917033062767958248507077347413172253520162202223899064675223742984643), Fq(Q, 3534987129329715286713065910644766113162794473336702655642862994389498193383166702313211789910407668648041648650354))),
    Fq6(Q, Fq2(Q, Fq(Q, 3987271041785576987156819481352825941440692198600617902798823449095197460402013016484271416158707080120631314480417), Fq(Q, 2776729915488145394056711049470400182077995689328648944410359059986324672577074840657808997778501050795190820606958)), Fq2(Q, Fq(Q, 3493609239809463884108420014760678258875864444762156220729334791949192306716829773858489914433858828771384864761517), Fq(Q, 2975084261891650312468328189890584835367741486628976605700272238655221534027769034647588884238275265078636612691993)), Fq2(Q, Fq(Q, 429834838441712923099153988637989333653566581422708507480922874446358517310416986854957493784784389315153151733883), Fq(Q, 2563513050972467588040666701170089811626492879694016691270477459298761483291322833039441631484712636046623692714038))),
    Fq6(Q, Fq2(Q, Fq(Q, 3912953593301214097359025577539250046153482475193812226238890530646088854489871769531875731315657768393838264598570), Fq(Q, 766853752077287394741786255013291168173020538982872649867985308154699263055973990323505296207412173774556996020997)), Fq2(Q, Fq(Q, 336766902551064861300404988913560173663735352420600248651892628618716616092901065963864485464361829201117519611141), Fq(Q, 3045835756314184253467168061316476261676797445286405133373549698750738936299150011745660623724304364502250326640361)), Fq2(Q, Fq(Q, 1065384600924786348744226516568337970624555816194946381255337140365166669391126451255365733943449236326892719992789), Fq(Q, 3867239695870667051332267574726964404538906549927040624562153856581592948671730518773064216520437627506826511474840))),
    Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 3696939050214640878942517698992204503894075994311138655958352969015859391480559463133834152359806299200895552702652)), Fq2(Q, Fq(Q, 637352255315029000603021041094082358405682808777724021403458099509159722512664051423216221693162370559077743398031), Fq(Q, 1671653730598002979421090389176765740845891238811669446755831995894091866601563271702230089124611341834414944289678)), Fq2(Q, Fq(Q, 394600258265849729267691779025703822318975210409352238068792524268428810362149049045130711467841432158631938954810), Fq(Q, 3531566395136316456912922988984579298773391941894603487740670394723014418031141785708238128161108401053114913159089))),
    Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 936531350876091663174734334137223384331190863981086930404093722616822472286503712220118481024606076749958901670050)), Fq2(Q, Fq(Q, 1165909593478083132603960090411008145563376902085578115889602981234361543831837177988386908536901340724402015264213), Fq(Q, 1604947141895703639844404653084137174798752733174887054818340666643384519704301305989593114219789596702158106844234)), Fq2(Q, Fq(Q, 1950737070182810225633431933653163288249072579608299524925760455644584256427479891186555882432166675322176774151553), Fq(Q, 1727084996644022361983993858153149462271101094832268265484077292818047802790868291825454639387497075684129878094370))),
    Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 1402914476932624451105894320109148083831601750168764888084909204723234668546266387580695828366048839098555879041480)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))),
    Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 936531350876091663174734334137223384331190863981086930404093722616822472286503712220118481024606076749958901670050)), Fq2(Q, Fq(Q, 1165909593478083132603960090411008145563376902085578115889602981234361543831837177988386908536901340724402015264213), Fq(Q, 1604947141895703639844404653084137174798752733174887054818340666643384519704301305989593114219789596702158106844234)), Fq2(Q, Fq(Q, 1950737070182810225633431933653163288249072579608299524925760455644584256427479891186555882432166675322176774151553), Fq(Q, 1727084996644022361983993858153149462271101094832268265484077292818047802790868291825454639387497075684129878094370))),
    Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1402914476932624451105894320109148083831601750168764888084909204723234668546266387580695828366048839098555879041480)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))),
    Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 1402914476932624451105894320109148083831601750168764888084909204723234668546266387580695828366048839098555879041480)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))),
    Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))),
    Fq6(Q, Fq2(Q, Fq(Q, 73511129852917215430117665442932969686381201097577315366839676860858736702829118135516255560032984078494668357975), Fq(Q, 3217848190141668374831050318675921189559767594302763425559558568998921509281703741758475858778889051582506780581080)), Fq2(Q, Fq(Q, 648450960364454758515914815835903039336343806164342630155559757661414525783569361992487943765558469720311290428420), Fq(Q, 3015304493459735433377319464893524841717500395868238861827520638332311194267791553303700008365643552988570858448997)), Fq2(Q, Fq(Q, 3353023802015658049589427757451615465298434891109233178726407057120107366770851277096812883696491540637124752075715), Fq(Q, 3066165380622691919524406479715957105738336813801915492884296116324404036017421992646199250431188674757127091625453))),
    Fq6(Q, Fq2(Q, Fq(Q, 1711797489568616583434146621422538673233444794009731352316131919899927017977837896877331399843341475889254457279480), Fq(Q, 471446243058341788074854684406829851472774030969909403308522590265931681166167445858169651239808292445447403288522)), Fq2(Q, Fq(Q, 729440306421424633239374882471503492015561566074308487082857102158813556080028353083322691361930976604376117874449), Fq(Q, 1157192852418872920324298751084955842491726587077604837263193704657814123508299544930797055379199846575569669171380)), Fq2(Q, Fq(Q, 725803966212282170013186464116542010184584534048041708686873699380470487521999269593653944547524803176109678632307), Fq(Q, 1902665537993573977949691355326435078194224863841030583720255078289767766095489365822701665854659899007485034939364))),
    Fq6(Q, Fq2(Q, Fq(Q, 606412287420852147510355256915883920871639472600949273462625871567737033901651002715167115631897903830887166236977), Fq(Q, 1741619805403384982690206144538973087219157386081746798900957611916784699528392231186399291491208822570456705720388)), Fq2(Q, Fq(Q, 3076807681008271625043415671445398095151436460913072009050198674849051753435525569856280836109907522679230655841547), Fq(Q, 2864032372821682924490620529894430858550749040263777194864479957344961807767922985588311953522357769772134085380338)), Fq2(Q, Fq(Q, 2005753039711622712932846010240744946574421594398237804801392894015681915412547622907416977014337997609727901324999), Fq(Q, 3245286049312428176470274772357156132621940931691055024949253504884096010168429627871342059429405001708211071525550))),
    Fq6(Q, Fq2(Q, Fq(Q, 396161667274950507585561902166368883051657512476655244387126442886647046202250508302105492204377657577670624819270), Fq(Q, 52930723237667825049556470355175294198846271930763896265757981729563840410141655871514462960104578015765274800299)), Fq2(Q, Fq(Q, 218613779386927984165092970888435879681368550902167687644844810137606354633464253735407524320905692260476222463449), Fq(Q, 3688249817760281980099858848215525530252744264791767910322854480130050687126867510770980142095062711274245825293594)), Fq2(Q, Fq(Q, 330319267845442341048238175987086953151831777504293846939455405092579456621517750586438686648404174676784594304769), Fq(Q, 1952383002890640248145425256672540642509416015973749316254547240428837398470639919699709018954754525497727741665516))),
    Fq6(Q, Fq2(Q, Fq(Q, 3987271041785576987156819481352825941440692198600617902798823449095197460402013016484271416158707080120631314480417), Fq(Q, 1451447606850767823931803186790626082300103145901471739736339850597300526233711720200504896822585624208292555812267)), Fq2(Q, Fq(Q, 2083939589504229557718641452826417580382364157512587211696764377456060647194363246381895693176726164359656652136163), Fq(Q, 68554195112659185237723238677278880268815275810733384169175739373740063720020962421003169861806465266447935031180)), Fq2(Q, Fq(Q, 287014780581083736010722440074311008835565268345841577823686207147926833036731994774756830868590109862305057563289), Fq(Q, 2702707917959160692485226403260115201064572576695179323822128694928141074836036215024635998974315824003356048811562))),
    Fq6(Q, Fq2(Q, Fq(Q, 3912953593301214097359025577539250046153482475193812226238890530646088854489871769531875731315657768393838264598570), Fq(Q, 1895502265992617591133440933268745380714757742747382507235523258315706582797346679323945331080532481666115142704595)), Fq2(Q, Fq(Q, 854317984988623878686582323441538899369901455121944530131926012396634702738439706497324201714133834212983336552433), Fq(Q, 3425828189172673707380466481072798951925184856853101272696413640206410580008423323883511141430531129411092377238228)), Fq2(Q, Fq(Q, 2048501108463182499571485371690131654109054419050170973675210067355142906503509266317865747554779144602824919785891), Fq(Q, 1040562106624918949271461024610451581377342500035142076974648199330302669457775857339982505682071656262490983491607))),
    Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))),
    Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))),
    Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))),
    Fq6(Q, Fq2(Q, Fq(Q, 2132952860199103510384964929639503239048006632158033702476455816873828490744186975243116881087643951917600635904740), Fq(Q, 3282472828955057500948960708951116065041118575775325659441750612005762981140760731908272051430682000937902631780774)), Fq2(Q, Fq(Q, 3106991083249113464835365733057001507015578165886476583805978485311918089748228844367601267261408844807883207257147), Fq(Q, 2177107663879821826622345168531143235982070837694418168532670806848905795476255179394267384300554519816840251553693)), Fq2(Q, Fq(Q, 56497083564400052421029057132998311513843313215527478288384278570359865736594308983783599291771501498655666344105), Fq(Q, 95632539722110500559501716779739929382185666586121390708787067199960287588867076164098442306551616020397186118620))),
    Fq6(Q, Fq2(Q, Fq(Q, 2668597442565196100031277280122435800434037261589696871982117467020702682704841756347451541214893012743975472099098), Fq(Q, 3696939050214640878942517698992204503894075994311138655958352969015859391480559463133834152359806299200895552702652)), Fq2(Q, Fq(Q, 637352255315029000603021041094082358405682808777724021403458099509159722512664051423216221693162370559077743398031), Fq(Q, 1671653730598002979421090389176765740845891238811669446755831995894091866601563271702230089124611341834414944289678)), Fq2(Q, Fq(Q, 394600258265849729267691779025703822318975210409352238068792524268428810362149049045130711467841432158631938954810), Fq(Q, 3531566395136316456912922988984579298773391941894603487740670394723014418031141785708238128161108401053114913159089))),
    Fq6(Q, Fq2(Q, Fq(Q, 326653953550318624552473528933440018369241246351347468644494062901505778444123994123089206502007896127714285632224), Fq(Q, 1050052283676657087458111053686351835303312685365526156474363930242692392349383016194427325825673928467218581991685)), Fq2(Q, Fq(Q, 2663471183390860339130030090357374254626120313504066419549300115041880479557138899031687619822301463499136296108746), Fq(Q, 2868227382944526772651817677255001390463423995052820020771128569394604284638569443681013457784047116868115172062815)), Fq2(Q, Fq(Q, 3626811979073332688930808077762401212292719001175177269108761839999474231634238108764308906420982837774702784838692), Fq(Q, 368716163823887224133138155617581333480362627800895687561490648686780702592699017955299444178417014920588284923982))),
    Fq6(Q, Fq2(Q, Fq(Q, 800849597522721922839644295482571736525193925549018716611584041151937796943339587612112988581108877720787204886308), Fq(Q, 3625289762005322455392545426159164637644512240580384306862962795611562018664339602439196958451372315094845027927109)), Fq2(Q, Fq(Q, 2780473097758119285446032011293943767034499016378425857192157140663479222380923134040762697840446448700214134935630), Fq(Q, 1229958367941556414370230451524141578695250008182164473136503374977948324401475269984909200431023124858104300157820)), Fq2(Q, Fq(Q, 1145258151121623401462156613283383340371950808785245396722268139459238558440886608877431606672621288906453736505704), Fq(Q, 1014517730846181135282774737648384225736300104190305015803662608090363177471019758098714952052119338765930248579647))),

    Fq6(Q, Fq2(Q, Fq(Q, 0), Fq(Q, 0)), Fq2(Q, Fq(Q, 0), Fq(Q, 0)), Fq2(Q, Fq(Q, 0), Fq(Q, 0)))
]


fq12_res_list = [
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 1025407231273636406944101243528487744178571069791551455264012691226440928360355533843269054467543027936990360636148)), Fq2(Q, Fq(Q, 258066216657524927979403051584820291135621845274807280122621551302953838229944968651870140174444448670933321904609), Fq(Q, 153648160743842587374354268027995179728920743432920270043555333381033988413019413346190155703849802386639076716416)), Fq2(Q, Fq(Q, 3551312213391417611729068989577202022724064296314128168974881333285242974392094506413773318369402730380606667260872), Fq(Q, 375210620363240435945365119971584928401305211458283006882600674201056944870829002570351058661355646964382173282078))), Fq6(Q, Fq2(Q, Fq(Q, 2155870599931691261420994746941962609294769163126386481362700029850105726372913996301820655914712670565134957618248), Fq(Q, 888314626200217596223001981621508676837035255329165504322044160254255197346160201016490673340184785599186111782276)), Fq2(Q, Fq(Q, 3425168536714083450698504655324293538482038882433990478856569932643905279236063351707177020063652019363567542261438), Fq(Q, 113860032128930897607277929720378297921146573298180462913476681989215746260706605755791051175141448181458649614382)), Fq2(Q, Fq(Q, 1348669757463132828960699669507205613899218853268879057141880588572690146209683829758767151290521112692962876813261), Fq(Q, 1465327725573623565890475388637335266980682966168859094463798994498921193653402416580213701019606612532984346493572)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3785814930612185622711884608383468863741456200121603180818271937625477847554411284756984725802743250387927011668750)), Fq2(Q, Fq(Q, 3731918433716138189396253828003798660534810571905961070968534805701783667401609706529387082459721142543503322598214), Fq(Q, 220354749446141926951040004120623745776059249069702661981046662631741335310281379058827130608671547518895914161860)), Fq2(Q, Fq(Q, 1995175401474457115363328834949742556793966927115180882117913401909087528326763664272348147405077487217061832064129), Fq(Q, 2179692018855534530874294250803014764903596058520618229139193776106023560111102496453134547434966972333367208346797))), Fq6(Q, Fq2(Q, Fq(Q, 1546068556025326890862526026348541271615476775430091245794636583619057010202289504766933436111108607949640087017342), Fq(Q, 3066550452519747256283812143089379504330292814839556217746141548558373167816962228035537720853568780099214076263670)), Fq2(Q, Fq(Q, 1217547352021368553236647788852384527192583491977829443234029048264125058622949755799936097139469781057010599159896), Fq(Q, 527909002812742400097688385325836826536521531522963076618422751034436196390173808019188679270626585328658601890031)), Fq2(Q, Fq(Q, 1788566152464915473317350635196436975716439724689922483554144129246974021222125254194113926701802901166113609200738), Fq(Q, 2224523377569510927237879584273160916503153055214501038700236243025573355563480335737119559040768910318519733425230)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 3319431804555652834780724622411544164241045313933925223137456455519065651294648609396407378461300488039330034297320)), Fq2(Q, Fq(Q, 1872212493152585914035456746954081813285486724989778347957739626925457209116063951093620242138271399369198659733457), Fq(Q, 3916174122599961280400471533556637076778907580203947517077812891118155214273617439221057115136151022142124982042773)), Fq2(Q, Fq(Q, 3538513019787255257313125285475584232115164022924123687293598163918448839960346868135871851596680799044583054277319), Fq(Q, 3994570245369309876121480669661654884145381817741417372774857049909724631150715766113950796182798704545565210915274))), Fq6(Q, Fq2(Q, Fq(Q, 794975163042514265250714922531389825785786422698475379300873111471083438913279071349043017526177475981518795267912), Fq(Q, 2786907927392588629149953165031317622137397040622318928043020183554766025620402500850584713898215924575255023849289)), Fq2(Q, Fq(Q, 463432441248335334084611860337027440892973943581663795616443322532780689411430767026948253112602321845108300089678), Fq(Q, 2582063213337760833930859722595479319298961125571351689770473388794175076647722053679898198797044392395339248303550)), Fq2(Q, Fq(Q, 1911543130803868096952072544598362675452901611073029833130478772981464661748790564889560248624438036220798392624153), Fq(Q, 2571685508131246424505948085951620002059884830980796804620337525960489366134024983196042601365172771933480571610461)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3371348709352602244718327618342380424888498781585790184301669580615381437214612553531422624873618952124934090746872)), Fq2(Q, Fq(Q, 2199147706428555260210808694230813652587823109075705748038997055380510384146336635031084498898951952754414513897543), Fq(Q, 725808682727960774152294783475001240912238847952451383757885473586555264184973286750864425784614725501321221425875)), Fq2(Q, Fq(Q, 1657072226773007438516666113057037045988835029921356122337505156211018583701208924211001035229007556557085559453424), Fq(Q, 2746167718662995967938662804334079552069272603151144017439368584707001080159665651351682490709425851338543753866115))), Fq6(Q, Fq2(Q, Fq(Q, 3218451299833069658562389635712557628942994111495377024969328617470244770766344877134122544936741929011849137771004), Fq(Q, 574668630964273168404384500055475043465862805654612035427891131752876014722166484202922372122910587236310133255581)), Fq2(Q, Fq(Q, 949986633188004990973283454729128877807092888288968542599494939946154718629805762758957652669341754388414537276838), Fq(Q, 1599221148753615122911087622985399888899999868690717277704798953790311896730713458649658175706917982451220765277876)), Fq2(Q, Fq(Q, 1729897764683366983448073245665003349148420259989937574085503362682275000250669320315442339322069770549826332830236), Fq(Q, 3312648328131602603239793237762735181623898532274510725513586779906347148257003710087295073984034459352680224272282)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2904965583296069456787167632370455725388087895398112226620854098508969240954849878170845277532176189776337113375442)), Fq2(Q, Fq(Q, 339441765865002984850011613181096805338499262159523025028201876604183925860790879595317658577502209580109851032786), Fq(Q, 419218500660112734183936487175110415358204359147688353522593565948937492657471482470406781183078536086656016747001)), Fq2(Q, Fq(Q, 3200409845085805580466462563582878721310032125730298927513189918220379895334792128074524739420610868384606781666614), Fq(Q, 558636389955103919768059397456815514754175542432935275742973722386670500708441056569811110328241919512847483874805))), Fq6(Q, Fq2(Q, Fq(Q, 2467357906850257032950578531895406183113303758763761158475565145322271199477334443716232126351810797043727846021574), Fq(Q, 295026105837114541270525521997413161272967031437374745724769766749268872525606757017969365167557731712351080841200)), Fq2(Q, Fq(Q, 195871722414971771821247526213771791507483339892802894981909214214810349418286773985969808642474295176512238206620), Fq(Q, 3653375359278633556744258960255042381662439462739105890856849591550050776988261704310367695233335789517901411691395)), Fq2(Q, Fq(Q, 1852874743022319607082795155066929048884882146373044923661838006416765640777334631010888661244704905604511116253651), Fq(Q, 3659810458693338100507861739441194267180630308040806491433688062841263158827548357546218116308438320967641062457513)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 1662963727412951279137161171489532688394090205789156066843055208783974509658067764641873319738360748189379491848257)), Fq2(Q, Fq(Q, 3813293982923616246266862389600075174737687988790676815874115131003013755032455617472834600862778903452679851726391), Fq(Q, 485925089362412073760622223267738981405342864784470745460084895199644839554733448183043756087900281218912854192445)), Fq2(Q, Fq(Q, 1644273033168845084100722408955419255379934756531351640656221986844224449269461285933099568456285625221061946469871), Fq(Q, 2363117788447398014696988528288245351256466389495270497999566824291637115948714550452594599101853244881832518939524))), Fq6(Q, Fq2(Q, Fq(Q, 1857555862943892662392109811301984845434011371067465922907501699091222483306709952181344906548206734428232975420668), Fq(Q, 2473261932156644201331335683465283988766224590947765459148867155053386842996408784037016412680941726212379045322594)), Fq2(Q, Fq(Q, 1990660092943924267777180485477766936774910769375649744691426465959061779296011042521416514847307720907849567664865), Fq(Q, 65014774740777665816879590124596753720931601024880619229737524471239576626891042131077694199805262627207091407257)), Fq2(Q, Fq(Q, 2292771138024102251439446120756160410702103017794088350074101547091049515789776055446235436655986694077661848641128), Fq(Q, 416596555467558068437476109341115760146217577147440550338067175243883670246788412260436345200584954715282176829384)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1491769433678746791084007801996611102314358119143462270330576804465080741906434019455431337142429234200450246278202), Fq(Q, 2507621509372044751036700554131029725144196266584036363095563247294559634038422545679868771230870398657555602953728)), Fq2(Q, Fq(Q, 1055723528870371682770888430011545830651829932546910324413061868821652617999640528496666303550475443939303053306543), Fq(Q, 3098871189487133916433658652815876204092098854175324555553627329981618340627532060516725794124479534635830423697948)), Fq2(Q, Fq(Q, 3224226472039826530763942471784600747725278606155820584737779432290304448377451923967494522190962519773967426598401), Fq(Q, 3395874413283296502396459884038023339099127286294561509476594223828999995934077190716914002395988584516867974798010))), Fq6(Q, Fq2(Q, Fq(Q, 2359209632759784300963029603959271998315627137911842624483071959769135039841969015313933024584630612646548393917971), Fq(Q, 127051551737552803548050869304386973412461386095236485737722490393145792156943147687488544128125245071681741833877)), Fq2(Q, Fq(Q, 3316411059026208775746044616010747226216974150183552034307714908243975988035138942367081476493939364720102722578012), Fq(Q, 790654098343999507560801497324057486264191611417604853314488284425163930881831224642385894362168529546935772519616)), Fq2(Q, Fq(Q, 2774148104467572102560408382579006916343527722165252914255252141208038886534650038167400333665585550585414470885471), Fq(Q, 2242801668749523535053048690670428915314752221115562808614079034252992137909756453703937502242275585475072200841201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 263994431620275743191565251572287072652361786648577488937553623757021293923786057902510988327098323874165531272086), Fq(Q, 2462910387406386989829015842527811312161697245815641634386397724347391137658900164404586314339405960311769797063694)), Fq2(Q, Fq(Q, 3105324265143225454762166833827398554673598610067371158222713430184688190748617897584339596712716886646632854464765), Fq(Q, 364603879283570153520691546282815681915175924590196032173838915685394402033748001497576708046487982885854911639883)), Fq2(Q, Fq(Q, 2998805108246183699295916533031035188232070578311911763495267088439792309042383717727487062151163603679771293846786), Fq(Q, 2251106543219556471739440373553621526225022741523166775047296366941750656373003721572291098466642344556229959074028))), Fq6(Q, Fq2(Q, Fq(Q, 1077387479277662776939307070654682168132817396612575228651630467075094409033550039353084876763370132441999664811853), Fq(Q, 3913379919792661119821942777538224792599417995451512183186800157543428121239544333683775051347678231426838334341934)), Fq2(Q, Fq(Q, 2687600666020080966639221638402463128738207404849850317712010600313934539931517488560798257856411929813633161672971), Fq(Q, 363524034032318251998881481722227026127402105113322127283972656774915093063209572068934777920620294574709471088628)), Fq2(Q, Fq(Q, 2627641443167568983081646073872649983944866529601631743746815527201343486459808258333750408071816227066392509081464), Fq(Q, 1061816608458942060224417529673273405817142796398347806473444034448332500644005812535802841250049452161531281227773)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1388212115934372153079078485162686578081419270014191398378628885264699440569084681418324235929561978140201086276287), Fq(Q, 1066041387286562677309424331388898050877365862692208653626840051514403953716747541225040179090678719957435914247459)), Fq2(Q, Fq(Q, 1656592907264427138207615050528588711317785433305270678538131271021682354698092089177970154986018034877026179824305), Fq(Q, 2145104384350135709144061954383030915112134500040108803702464093275359210705493233195563617786629177861833547853614)), Fq2(Q, Fq(Q, 959159512055960965942642889556973502152025259015344555170956589016513013499619567889951831475285737670061498136735), Fq(Q, 697311248095809541431686939529982574299288309116942830936895630167684422941342525220248156851198021836507496522237))), Fq6(Q, Fq2(Q, Fq(Q, 844527195142370612813645851688129689354588926169894643369854931161074646968413399344338935450746278770709469130729), Fq(Q, 3868021880710214227372477093694561918356282303348476606802036773013867481363439570859211487204149832156084919830217)), Fq2(Q, Fq(Q, 1905130008120064521565510637400822890346744247193418632741468546343790499390550478553431494457184984520435556670755), Fq(Q, 2524563499747246996852921477547224892736185804131402251088354976952770792170031506747362772791083213098245170791188)), Fq2(Q, Fq(Q, 9152205929030008555548874268232724205494074151046931386214011035389900559184906018047601951849116452376943701083), Fq(Q, 2013911020942134389979665404659225908708507407634432624714755327757261647352059300768145832933078542020591073328113)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3058866244102440573231301671016010547527826055115923225604643087040177536769585708582133748633728085470095990446476), Fq(Q, 2471849899640519075226900382489979981049969099994478347080495911075509222744307425561130218487411276542950209726463)), Fq2(Q, Fq(Q, 3289910308396278665249714282056714869913079985038610193019885098895062039536602484484000193849200726075610681996977), Fq(Q, 2615043845067019223926787448103766376069548462752559517191757076846907828195115902630789132024797578692061929132529)), Fq2(Q, Fq(Q, 1467466344826017078180520265037801197908377516758339839553829348423540889062972892697850310824937422228128674414332), Fq(Q, 3906643299986121475331757648992505225449075970622530524934163432120620925262801104176571048975617460641218434418458))), Fq6(Q, Fq2(Q, Fq(Q, 2955755361407981346801508825916611393991786175073774786144834925305481398139116263960256246751509194739842749560163), Fq(Q, 42173519627883094942597339528662375471299798977822581501916203021261075459679018970134467050412409451357310303347)), Fq2(Q, Fq(Q, 1219730399795758644784968428173965044307511799564642463923231053110020767785359860420274978834778774828835935639023), Fq(Q, 2934392194439795388233799337233598640843635282729653686423283907524608296060680885930017747586552488353216993580186)), Fq2(Q, Fq(Q, 1665729852868439553681511030735570417023248241170947983268623449567636422992052064506179288900352763870402597377785), Fq(Q, 1871347294207119436844583618406128667169855184242036137678031955531319037061722418678766897809633252677078735332283)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 224029683569613065667562573223428561844216715832350389255504198737049956106792921211759051229223544840400512543126), Fq(Q, 1756126206734519653728452186378348466480066377373803662350812691404121033764396952550014901508093541100628832095417)), Fq2(Q, Fq(Q, 643026449422205611949398757316870215694467857814133844983962940317509690869090520073738801455647215614116131407963), Fq(Q, 2721585314049869403396316568124588561569698743289127581577999917834616284296628365561368111554814697429078135073751)), Fq2(Q, Fq(Q, 961006781784179875446202572519872074763821692830672923539962322172429424462753851161766743110295124726464407155911), Fq(Q, 3418837311588443552408398783439200006653957372423139005541886828460575725848907468691975967705491580758929578985613))), Fq6(Q, Fq2(Q, Fq(Q, 1416711746230533163102310107411757448900863881132302380638284126914896440992812483416873086162708477867470761623741), Fq(Q, 101913973628524244815947698891981061412945267047424983521844817362389630130047955967195489540645099183325549851089)), Fq2(Q, Fq(Q, 29138890877180692050416691885995051989761195115123320933283710338487888508586050719522990217845911739323698776961), Fq(Q, 1412699068599577238262139348330682539138103354638703494248518979278433638438874470096706754845223087971298840100245)), Fq2(Q, Fq(Q, 2625699241823656282369122845998446498257194232690699607613520466913710952141554940528386779746221413153703664903599), Fq(Q, 1026057217298714494608111978340623247786619155264442548828776640956453680431443116283822820745722742639650621460136)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3613327637539978320748705161922635572398467115340816080575184637259756608597828135369446010105085010318554161664130), Fq(Q, 3272159554162498304705737922141647842516840623611114464852534499603077024651443021461495123934823471931399331510444)), Fq2(Q, Fq(Q, 1387113874331582675167013472512793062821231215226941228579594248379234180634688689100182076199510578193960738624875), Fq(Q, 1964307915467234103885777802021038149684092815742495278791115330970776508605653556375488531036882595261261092452816)), Fq2(Q, Fq(Q, 216842685813132462018394076669938534361907812895046396289047763588871132031908727810123241031706077127780314497287), Fq(Q, 2108871797288048760184331734664110277895216884081071947649064864259219088093301840603782671118102545140655454940246))), Fq6(Q, Fq2(Q, Fq(Q, 2865723812838476703313432206987562925204648317782601504957466477002333086618414309075053215641730032205695568055187), Fq(Q, 1979594856166436887732810518882559427871069508720661298890074331602795342610397569419327753433631508477156403156096)), Fq2(Q, Fq(Q, 1203445981243750371562809001049738378873865628817842149989108513215905678580879190757201100991896833980293846233215), Fq(Q, 3300989041541017309508036542026155704212833499889120628259741373940716722832268565052694038595709624340945210695049)), Fq2(Q, Fq(Q, 1924969486723625309433196933845754353432448256019483552516090610542864318617137049940733860492139088195551255748791), Fq(Q, 1827404282787392617401274538746742058177328038886524594065843634819148367124283253456781757539238420680216958679038)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 414466221259583377993556990041088438852957418535812996516602357010096410339798731225562100929124298262992920921878)), Fq2(Q, Fq(Q, 1532770727287582929185445133772985007946987462830255322929537750321273283255273071498302583560769189789088808700671), Fq(Q, 3496955621939848546216535046381526661420703221056259163555219325169217721616145956750650333953072486055468965295772)), Fq2(Q, Fq(Q, 338103174701449676846662721892705510805131897193824759780408245698068944625554740061347112176069930659976272610705), Fq(Q, 3435933855414205956353421272204839369391206275308482097031883327523054130442274709544139685854556785032717727040469))), Fq6(Q, Fq2(Q, Fq(Q, 2330026811413924625717926216371887799229365483873722106157366102272843889926782492075498520303382342975685221806125), Fq(Q, 2491881821555474087879427643033904460864430009184944182318250416805497153094795743832615348730658192862903943008089)), Fq2(Q, Fq(Q, 267560718833363562263364334123255649385490603688860900634534108317970339993143993040978444470128026668596061883058), Fq(Q, 2931097409280794670604390588076341094193404482771253684245681933368155950150298213812218132692724266915332109171942)), Fq2(Q, Fq(Q, 58668387781548489869277389531433626568019464699984909468640766564699020971455933878671587379733130616287276370502), Fq(Q, 2914284604659575717415876172246329891436137342878998198518707599243257857797314490092512114185750115003733781712735)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 1656468077142701555643563450922011475846955108144769156294401246735091141636580844754534058722939739849950542449063)), Fq2(Q, Fq(Q, 2061328065450637061186384183089910795104681556138109417415682632046475104574446198063473270404508159954413080566853), Fq(Q, 3430249033237549206639849310288898095373564715419476771617727995918510374718883991038013359048250740923212127850328)), Fq2(Q, Fq(Q, 1894239986618410173212402876520164976735229266392772046637376177074224390690885582202772283140395173823521107807448), Fq(Q, 1631452456921911861424492141373409532888915428246146874775290225618087515202001215661356197080945459663732691975750))), Fq6(Q, Fq2(Q, Fq(Q, 2939828855320288996276394936965309136908657871570017341725429548503892606097406983610385740106986405591180092407031), Fq(Q, 313645995235944427818617481566033633371172449674553468894153028501379182623993716813568301217274198362875978526695)), Fq2(Q, Fq(Q, 2475181903526078459725221200595164660674945994145021936257074992697750560606257588948219367394310264975153004984600), Fq(Q, 2517048438596983168113980132470882565578029524546471070540735864322935500020831011548820504597239129768132156896293)), Fq2(Q, Fq(Q, 3621181548001433238930416249578106421307681413217949368388435362014446796449852373886012441097467006181030816542812), Fq(Q, 2155088952663688356068471976610504241913667253833356254282270350716605695887236570935606256164587817218198394781077)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 2122851203199234343574723436893936175347365994332447113975216728841503337896343520115111406064382502198547519820493)), Fq2(Q, Fq(Q, 3921034006014189336547181264139627642354005403054292140426477810822801562859991953499240110725957903128717743431610), Fq(Q, 3736839215305397246608207606588788920927599204224239801853019903556128146246385795318471003649786930337877332529202)), Fq2(Q, Fq(Q, 350902368305612031262606425994323301414032170583829241461691415064863079057302378339248578948791861995999885594258), Fq(Q, 3818983785629803909595095548250673570204012488964355616471685087938418094653225810443227577462129391489428961967060))), Fq6(Q, Fq2(Q, Fq(Q, 3690922248303101621888206040782460582738348224301633208219193020651866177386417417028276158691917537559301384156461), Fq(Q, 593288520363103054952476459624095515564068223891790758597274393504986324820553443998521308172627053886835030941076)), Fq2(Q, Fq(Q, 3229296814299111678877257129110521746974555542541187583874660718429094929817776577721207211421177724187055304054818), Fq(Q, 462894228071964734280808795201240072815589930498082457388685226563196619763282765888110985070821322701451510482774)), Fq2(Q, Fq(Q, 3498204569662480615295694340176180721571219526834842018812100718279956155923187063190566119174831871126346033119397), Fq(Q, 1807926822101952858800403474932045156356935478067060488362169067781689685316691923476683213840183955603237556595846)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 1242001855883118177650006460880923036993997689608956159777798889724994731296782113528971957793815441586957621527185)), Fq2(Q, Fq(Q, 528557338163054132000939049316925787157694093307854094486144881725201821319173126565170686843738970165324271866182), Fq(Q, 3935702966519368053841104089643275590509744314302225493394566806873324303593575898730050654224193918905637435114343)), Fq2(Q, Fq(Q, 1556136811916960496365740154627459465930097369198947286856967931376155446065330842141425170964325243163544835196743), Fq(Q, 2197928156729373298488860694904474320054591972876672663075465034219065035250564370559904140355404338668909237495068))), Fq6(Q, Fq2(Q, Fq(Q, 609802043906364370558468720593421337679292387696295235568063446231048716170624491534887219803604062615494870600906), Fq(Q, 1824173728902137733356979664268033329063625260428617171907960747819913680020035837423640581615631669537866308078393)), Fq2(Q, Fq(Q, 2207621184692714897461856866471909011289455390456161035622540884379780220613113595907240922924182238306556943101542), Fq(Q, 3588360584537855890927379370130445627941507861714225271627112067078811200361370662179290001033530526890694320284138)), Fq2(Q, Fq(Q, 3562513160219884749061138860046672794739661948517964458919794595449747775478396440007340853717733875564743540172310), Fq(Q, 3243213903225780032070385630100078507034412730893365941095620887597379488580759945285781771107853366252358885628129)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1708384981939650965581166446852847736494408575796634117458614371831406927556544788889549305135258203935554598898615)), Fq2(Q, Fq(Q, 2388263278726606407361736130366642634407017940224036817496940060501528279604718882000937527165188713339628934730939), Fq(Q, 239883593365548700391672560207262259506895983167980638297800578386910424630239838567820669696714444282408367233430)), Fq2(Q, Fq(Q, 12799193604162354415943704101617790608900273390004481681283169366794134431747638277901466772721931336023612983553), Fq(Q, 383049930215597953241674276045834200812806213655873519439801760415363964210951100899087891607572606456711234926591))), Fq6(Q, Fq2(Q, Fq(Q, 1360895436889176996170279824410572783508982740427911102061826918379022287459634924952777638388535194583616162350336), Fq(Q, 2103816254029296360490838642326095211256521034645854461611082112823520822216595564608593588570984525061825360492774)), Fq2(Q, Fq(Q, 2961736095465748116613892794987266097589064938852326683240126610111124589824632584680228766951049697518459242171760), Fq(Q, 1534206374012837457094208032860803135179068267665836658475061429319072320103822416518580481507112719824013673870619)), Fq2(Q, Fq(Q, 3439536181880932125426416950644747095003200062134857109343459951715257134951731129311894531795098740510058756748895), Fq(Q, 2896051772664044534802317128421619421477680955127070175175519604662463478010215297826858728783449504637398047442898)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 466383126056532787931159985971924699500410886187677957680815482106412196259762675360577347341442762348596977371430)), Fq2(Q, Fq(Q, 1859705940563552275360797081049716847249323846916182723010795178776326458285545755435766840321449743174304662864757), Fq(Q, 306590182067848039968358296299890825554034488804763030235291907637617771527501804280457644601536189414665204678874)), Fq2(Q, Fq(Q, 2459071936908869251467993375210062481235685724130065080156373374114670338857254660579163924937412352210373050346597), Fq(Q, 2187531328707892048170603406877264037315097060718208741696394862320330579451224594781871380381183931825696269991310))), Fq6(Q, Fq2(Q, Fq(Q, 751093392982812625611811103817151445829690352731615866493763472147973571289010433417890418584931131968121291749430), Fq(Q, 279642525127158627133858978058061882192895774217237289703121365003607142196559727184953006955352855523959052414381)), Fq2(Q, Fq(Q, 754114910773033219152035928515357086299609548396165647617585725731344369211518988772987844026867459211902299070218), Fq(Q, 1948255344696648959584618488466261663794443225890619272180007498364292770233289618781978109602597856971213626146268)), Fq2(Q, Fq(Q, 3879432576882714769783067916333978456820420933555900535755723492389541009964172553747241307206380528983209489136372), Fq(Q, 3655247424659931896149721324057445071000151044172712119411956853189115639920293216983764586804611802422933434374556)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 1025407231273636406944101243528487744178571069791551455264012691226440928360355533843269054467543027936990360636148)), Fq2(Q, Fq(Q, 258066216657524927979403051584820291135621845274807280122621551302953838229944968651870140174444448670933321904609), Fq(Q, 153648160743842587374354268027995179728920743432920270043555333381033988413019413346190155703849802386639076716416)), Fq2(Q, Fq(Q, 3551312213391417611729068989577202022724064296314128168974881333285242974392094506413773318369402730380606667260872), Fq(Q, 375210620363240435945365119971584928401305211458283006882600674201056944870829002570351058661355646964382173282078))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3785814930612185622711884608383468863741456200121603180818271937625477847554411284756984725802743250387927011668750)), Fq2(Q, Fq(Q, 3731918433716138189396253828003798660534810571905961070968534805701783667401609706529387082459721142543503322598214), Fq(Q, 220354749446141926951040004120623745776059249069702661981046662631741335310281379058827130608671547518895914161860)), Fq2(Q, Fq(Q, 1995175401474457115363328834949742556793966927115180882117913401909087528326763664272348147405077487217061832064129), Fq(Q, 2179692018855534530874294250803014764903596058520618229139193776106023560111102496453134547434966972333367208346797))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 3319431804555652834780724622411544164241045313933925223137456455519065651294648609396407378461300488039330034297320)), Fq2(Q, Fq(Q, 1872212493152585914035456746954081813285486724989778347957739626925457209116063951093620242138271399369198659733457), Fq(Q, 3916174122599961280400471533556637076778907580203947517077812891118155214273617439221057115136151022142124982042773)), Fq2(Q, Fq(Q, 3538513019787255257313125285475584232115164022924123687293598163918448839960346868135871851596680799044583054277319), Fq(Q, 3994570245369309876121480669661654884145381817741417372774857049909724631150715766113950796182798704545565210915274))), Fq6(Q, Fq2(Q, Fq(Q, 553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619), Fq(Q, 3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000)), Fq2(Q, Fq(Q, 2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217), Fq(Q, 1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388)), Fq2(Q, Fq(Q, 3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165), Fq(Q, 2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3371348709352602244718327618342380424888498781585790184301669580615381437214612553531422624873618952124934090746872)), Fq2(Q, Fq(Q, 2199147706428555260210808694230813652587823109075705748038997055380510384146336635031084498898951952754414513897543), Fq(Q, 725808682727960774152294783475001240912238847952451383757885473586555264184973286750864425784614725501321221425875)), Fq2(Q, Fq(Q, 1657072226773007438516666113057037045988835029921356122337505156211018583701208924211001035229007556557085559453424), Fq(Q, 2746167718662995967938662804334079552069272603151144017439368584707001080159665651351682490709425851338543753866115))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2904965583296069456787167632370455725388087895398112226620854098508969240954849878170845277532176189776337113375442)), Fq2(Q, Fq(Q, 339441765865002984850011613181096805338499262159523025028201876604183925860790879595317658577502209580109851032786), Fq(Q, 419218500660112734183936487175110415358204359147688353522593565948937492657471482470406781183078536086656016747001)), Fq2(Q, Fq(Q, 3200409845085805580466462563582878721310032125730298927513189918220379895334792128074524739420610868384606781666614), Fq(Q, 558636389955103919768059397456815514754175542432935275742973722386670500708441056569811110328241919512847483874805))), Fq6(Q, Fq2(Q, Fq(Q, 553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619), Fq(Q, 3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000)), Fq2(Q, Fq(Q, 2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217), Fq(Q, 1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388)), Fq2(Q, Fq(Q, 3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165), Fq(Q, 2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 1662963727412951279137161171489532688394090205789156066843055208783974509658067764641873319738360748189379491848257)), Fq2(Q, Fq(Q, 3813293982923616246266862389600075174737687988790676815874115131003013755032455617472834600862778903452679851726391), Fq(Q, 485925089362412073760622223267738981405342864784470745460084895199644839554733448183043756087900281218912854192445)), Fq2(Q, Fq(Q, 1644273033168845084100722408955419255379934756531351640656221986844224449269461285933099568456285625221061946469871), Fq(Q, 2363117788447398014696988528288245351256466389495270497999566824291637115948714550452594599101853244881832518939524))), Fq6(Q, Fq2(Q, Fq(Q, 553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619), Fq(Q, 3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000)), Fq2(Q, Fq(Q, 2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217), Fq(Q, 1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388)), Fq2(Q, Fq(Q, 3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165), Fq(Q, 2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1978715441315260260117495996057795741472590438155234835082583232949239209989669183463423011241668241410325432809144), Fq(Q, 1672206282860153609155521071708999372205617643887555316106421375994789925099729446590261456492501483480714459694561)), Fq2(Q, Fq(Q, 2343484435046268225362162478379266982366371299864327141285669030275052929822032004370900991183873787486189674179485), Fq(Q, 2096650363310161368035366632543706965418260443922138403176571267938511736979250446490791409254517712877756022438609)), Fq2(Q, Fq(Q, 3259905331116579669416617031637063502394533422465259069678835949538649816714954636743299899128041363284359774464168), Fq(Q, 1317146559729042644735092363237961904741766051071659417134920011645921734434220588242548035352603530019624974819077))), Fq6(Q, Fq2(Q, Fq(Q, 2992774329928655295953302505015753248928165378160163270940159693244006012991012488975485065979799294420647264232542), Fq(Q, 523033976967242983364847062968319229090359821571043851236921912652045732585635794121319920649414098858242786380287)), Fq2(Q, Fq(Q, 2394871671547489021759461934097887296511878960721015042663879851071030672669813000038595884253964459215005743971792), Fq(Q, 1063851656270505534522323234838502173670115729533744591549292522708313984139194260805102402228567728935883399778254)), Fq2(Q, Fq(Q, 1207073616586708173401730103817159880320812018366185330466867717115793194502763539695168678765087694911549426291163), Fq(Q, 3100134632621299145093888947130175002775605875040558628043653611235541925161473088298154039928943676482208073924091)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 898858885561780888775537684166070054505866841354321154306258883164867554557991859702587424980375384099385715958701), Fq(Q, 2691730861577908258652991517894460075340464675307534815237744937080226900183346797127039559895311250846507469868300)), Fq2(Q, Fq(Q, 2604562945371840528029558734687860391621835021382421070858938517846881817279680975448456962899021359106021981681609), Fq(Q, 1897341102977912227946001729914881409502095776133873329328806914740415494931189054404841891551402811830184648532842)), Fq2(Q, Fq(Q, 734806989933632053662667214643758512227194981447262725378581329272097010092618558907713564881976259518019563763857), Fq(Q, 842102603445637403607083398291186105463029817692476816322843582545251258860546197621495286505767392658516040333675))), Fq6(Q, Fq2(Q, Fq(Q, 2431474169965915941889389551723451721727616914360706709891770230367813608894702326392981236036663239037613854465947), Fq(Q, 1820898775276605905697997861266700209450757870378729090852168055670505601263395410245432753874381375340756681311963)), Fq2(Q, Fq(Q, 3462598260066806475171626228298406253367134395395374652407616495309035216898913691390042244918290429327211745338540), Fq(Q, 3915771641469860429559078893341135185529002059163144371590914375855357936419913508581253229722138649490242151934395)), Fq2(Q, Fq(Q, 1938042640702078175315602007552346000613604745195545165124139677796283487810113363407657723620129068837362721570510), Fq(Q, 3780900667260312707217734008711565396636474100899152708989048690531650519890933313226928389767812447845044471069211)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 999603067119591277324346208881747219968713130045568500733221090175344858161879238788364614794972009221193567387747), Fq(Q, 2049863774688240423993147502016839063970324431030728941323130608997721713178465449464106940224209577125542266662701)), Fq2(Q, Fq(Q, 1272488634543137279969164490720732702860418146110948614476114726047178900536591796476717925815585251408152787070100), Fq(Q, 3734005087328514167409143302853404460041724220010955483391878018415128580905759573677559961021321682314858208452724)), Fq2(Q, Fq(Q, 1767363778141075062362777076400976315927104698159959366948405167595819903823663123971161722372913487968747313776122), Fq(Q, 1004590017925075346421338787273911987523728446369515577475259898553472631375471707293013914996778504423494472513156))), Fq6(Q, Fq2(Q, Fq(Q, 3014499517712254894131536658932717728580082065149393078238592679574489350199112950339703127761290950987484939590802), Fq(Q, 799051106701612136613622494164704699693962184283657545978343629778921028750223775822594786163252532159971056460387)), Fq2(Q, Fq(Q, 1360318803984178824858456001318984077401853710775251164857315805042642178879569504740047883474948430209283531228686), Fq(Q, 3476259660874776640212117427539140107629580206246992358963838539102294962969361360393652704141829146121093332007983)), Fq2(Q, Fq(Q, 545525912549668473991053340208301041019040789461497357774614670628842599375421773854369816174347983066569731744622), Fq(Q, 2659968045810182612590196468697039065049397669905669568452495950183272169141550957860074976014765124738227288879968)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1908307339260375312718854838074443589871498031187919412534190672208265609393009853347483789785172197560828714254329), Fq(Q, 2616275827434691639602441613436939761308135661653655608648903585024293719216462302863765158196228384152350096757922)), Fq2(Q, Fq(Q, 394807284889957266679302611008946067436357950350769954581002876825146271784800636307804350299258218056699546907537), Fq(Q, 3086329144672518440235151500421392737490324933591040042317212669814739319037087940510874742726919571628252010882306)), Fq2(Q, Fq(Q, 839154211885017154537425285607334694850178463816026097323805657407241958033133835553256607596119368635164664766464), Fq(Q, 1345208170881100219441628568884772026486500788353445453586528846352398939740487393598034095266748041802731407836205))), Fq6(Q, Fq2(Q, Fq(Q, 3761621210790123922520383745236466464509895414885938039816079412932728586178897626081292775307294609859711002131466), Fq(Q, 3697450815713225584730359875109714108063561172237763100590399134509985785934096521267017690359255367872094638361173)), Fq2(Q, Fq(Q, 1465241302922392304846737054764053151949504697361249350953490992929835099363003352911878093632463661239294505234335), Fq(Q, 1046664199076227412949105851904435279974741747887275370996185176629808373444101479559518519196370147752624259736639)), Fq2(Q, Fq(Q, 3380403167905026868564280560810939320947767253765702027363542247972721974024376309118899431236423728103690510440470), Fq(Q, 1476075539121906422062705538422966864887477365477800133012106732224356656758789592701863608458650545517663860806688)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1289029398056353602991148998275273639282848413276291699429247919535307198334879586423613387247026147602205552184098), Fq(Q, 2513155726121630503175288484087050307754529940544604523864645763758000267917253197003234419214122641148811705766960)), Fq2(Q, Fq(Q, 1685351321666973253598887862355315543263835087765506845230596960315564421622319797571527439083854670884347351263500), Fq(Q, 863393312066475006943700123740820479042422145345176535319068489271898036681315525172799217037251947638563910889689)), Fq2(Q, Fq(Q, 2580396353004057445004391715863125601268272679240379854633798738273026306452646517088133231420992896046942763563291), Fq(Q, 620245733391072904204141949961862696678997130475352732405328439185592434812428209628112791550357752620066163547648))), Fq6(Q, Fq2(Q, Fq(Q, 1200219321364096597716997346946608263937238525569004450754004815429724779368791940643481501118467313711581068851815), Fq(Q, 1074145151295539661695399657729454387623789065262034997382384704306595403698990903106858636801095278905190646534996)), Fq2(Q, Fq(Q, 3792118794330447498842817989267177081149645268134189996696829243321999869309593538803664109658849587388552851754652), Fq(Q, 959415075374233594919271091190067129211982410545816469116007091869882195441622885624851350189980611887588899418273)), Fq2(Q, Fq(Q, 2717873148091453200061695119570362991724141847744957053130729950340975866074647869727516739292281678321852876787195), Fq(Q, 981282489162534335125546698574731385074666599469021540594568264387113896916292831205538152116770150056315614799939)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 455901004859393587007484457776409667840062302271468677852054894400191264876042812899228055079989912410698781817846), Fq(Q, 3904226797852673125597070126530716929443506686498962906616936643348217597260226685121186616839353118871470975495085)), Fq2(Q, Fq(Q, 2631125341451178443724321554275687665104524122812449519580910240812089397073229059642720306197421637985313156829630), Fq(Q, 356028328487355515133682459068610190113015394640996689238411280293034962506415698637349866142094172265355339751683)), Fq2(Q, Fq(Q, 1387020908201420482456604194410611877193991925874212673605597709116518193803923430457788641345182466165186772406219), Fq(Q, 2309915835935843949390446805964251053951471620187602662578837084116482849055017577505781300390739255630781848511443))), Fq6(Q, Fq2(Q, Fq(Q, 3324906015633154576554505758106143891498728422527330022599734398436595034269056377594559129671472592472413263690380), Fq(Q, 2978048336958036865021193971234617289594772282537710632904470691773622875010144255390345577151437200444359256764694)), Fq2(Q, Fq(Q, 140445473148331396241726072502185987512282381293089492054211356096463416664114522098971441411909311055219510855514), Fq(Q, 3407813091644802591912529557654378611535163085003317061699459275129102618053073829155229929916946652243673743749231)), Fq2(Q, Fq(Q, 512510946609035006351615573689603201558889291354267684672796591819115793568948952932599871774650533175800848632471), Fq(Q, 3022205240009856748419643140580496584529485306814222453065639902909020195278391984064988385533579644427394735079100)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 414466221259583377993556990041088438852957418535812996516602357010096410339798731225562100929124298262992920921878)), Fq2(Q, Fq(Q, 1532770727287582929185445133772985007946987462830255322929537750321273283255273071498302583560769189789088808700671), Fq(Q, 3496955621939848546216535046381526661420703221056259163555219325169217721616145956750650333953072486055468965295772)), Fq2(Q, Fq(Q, 338103174701449676846662721892705510805131897193824759780408245698068944625554740061347112176069930659976272610705), Fq(Q, 3435933855414205956353421272204839369391206275308482097031883327523054130442274709544139685854556785032717727040469))), Fq6(Q, Fq2(Q, Fq(Q, 2088282883351950378857360647582914673245739570343171755063362104273384907022353180108182746758842668224222268373832), Fq(Q, 2802988375288461942537107743574149970292138786897393281664132196337636803119736703629406152259744535650806051892800)), Fq2(Q, Fq(Q, 2423605646281307449200219665135385212008608680566443096221040223961064180869378185109588341332253667690408532370597), Fq(Q, 1408618688575931886498556329177981398136128954736536610666102625689470101944795804028213540758791409366936729778780)), Fq2(Q, Fq(Q, 1356204092770041527163183772880066084612841715685056868829409157058020262626304984281296032609113840980609336058514), Fq(Q, 2725683217153809772471595304672449390506168598324573494693483370434184157317374968977493021147579583254321853889475)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 1656468077142701555643563450922011475846955108144769156294401246735091141636580844754534058722939739849950542449063)), Fq2(Q, Fq(Q, 2061328065450637061186384183089910795104681556138109417415682632046475104574446198063473270404508159954413080566853), Fq(Q, 3430249033237549206639849310288898095373564715419476771617727995918510374718883991038013359048250740923212127850328)), Fq2(Q, Fq(Q, 1894239986618410173212402876520164976735229266392772046637376177074224390690885582202772283140395173823521107807448), Fq(Q, 1631452456921911861424492141373409532888915428246146874775290225618087515202001215661356197080945459663732691975750))), Fq6(Q, Fq2(Q, Fq(Q, 2698084927258314749415829368176336010925031958039466990631425550504433623192977671643069966562446730839717138974738), Fq(Q, 624752548968932282476297582106279142798881227387002568240034808033518832648934676610359104746360541150778087411406)), Fq2(Q, Fq(Q, 628817275752354953244286705871390066741181251083596246511522972216812750991653916574141635127420241959071202912352), Fq(Q, 994569717892120384008145873572522869520753996511753996961156556644249651815328601764815912663306272219736777503131)), Fq2(Q, Fq(Q, 916307697768258882806532807190834722795620844264013442417145616383736387613863559845949257197832052507458603671037), Fq(Q, 1966487565157922411124191109036623740983698509278931550457046121907531995407297049820587163126417285468786466957817)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 2122851203199234343574723436893936175347365994332447113975216728841503337896343520115111406064382502198547519820493)), Fq2(Q, Fq(Q, 3921034006014189336547181264139627642354005403054292140426477810822801562859991953499240110725957903128717743431610), Fq(Q, 3736839215305397246608207606588788920927599204224239801853019903556128146246385795318471003649786930337877332529202)), Fq2(Q, Fq(Q, 350902368305612031262606425994323301414032170583829241461691415064863079057302378339248578948791861995999885594258), Fq(Q, 3818983785629803909595095548250673570204012488964355616471685087938418094653225810443227577462129391489428961967060))), Fq6(Q, Fq2(Q, Fq(Q, 3449178320241127375027640471993487456754722310771082857125189022652407194481988105060960385147377862807838430724168), Fq(Q, 904395074096090909610156560164341024991777001604239857943156173037125974845494403795312111701713396674737139825787)), Fq2(Q, Fq(Q, 1382932186525388172396322634386747153040790799479761894129108697948157120203172905347129479154287701170973501982570), Fq(Q, 2942825062588769343592764362038784533315197222402373269141164055008542422048618220546794022265904129190950403649399)), Fq2(Q, Fq(Q, 793330719429306259171810897788909023059158957880906092840810972649245747087198249150502935275196917452773820247622), Fq(Q, 1619325434596186913856122607358164655426966733512635784536944838972615984836752402361664120802013423853825628772586)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 1242001855883118177650006460880923036993997689608956159777798889724994731296782113528971957793815441586957621527185)), Fq2(Q, Fq(Q, 528557338163054132000939049316925787157694093307854094486144881725201821319173126565170686843738970165324271866182), Fq(Q, 3935702966519368053841104089643275590509744314302225493394566806873324303593575898730050654224193918905637435114343)), Fq2(Q, Fq(Q, 1556136811916960496365740154627459465930097369198947286856967931376155446065330842141425170964325243163544835196743), Fq(Q, 2197928156729373298488860694904474320054591972876672663075465034219065035250564370559904140355404338668909237495068))), Fq6(Q, Fq2(Q, Fq(Q, 2698084927258314749415829368176336010925031958039466990631425550504433623192977671643069966562446730839717138974738), Fq(Q, 624752548968932282476297582106279142798881227387002568240034808033518832648934676610359104746360541150778087411406)), Fq2(Q, Fq(Q, 628817275752354953244286705871390066741181251083596246511522972216812750991653916574141635127420241959071202912352), Fq(Q, 994569717892120384008145873572522869520753996511753996961156556644249651815328601764815912663306272219736777503131)), Fq2(Q, Fq(Q, 916307697768258882806532807190834722795620844264013442417145616383736387613863559845949257197832052507458603671037), Fq(Q, 1966487565157922411124191109036623740983698509278931550457046121907531995407297049820587163126417285468786466957817)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1708384981939650965581166446852847736494408575796634117458614371831406927556544788889549305135258203935554598898615)), Fq2(Q, Fq(Q, 2388263278726606407361736130366642634407017940224036817496940060501528279604718882000937527165188713339628934730939), Fq(Q, 239883593365548700391672560207262259506895983167980638297800578386910424630239838567820669696714444282408367233430)), Fq2(Q, Fq(Q, 12799193604162354415943704101617790608900273390004481681283169366794134431747638277901466772721931336023612983553), Fq(Q, 383049930215597953241674276045834200812806213655873519439801760415363964210951100899087891607572606456711234926591))), Fq6(Q, Fq2(Q, Fq(Q, 3449178320241127375027640471993487456754722310771082857125189022652407194481988105060960385147377862807838430724168), Fq(Q, 904395074096090909610156560164341024991777001604239857943156173037125974845494403795312111701713396674737139825787)), Fq2(Q, Fq(Q, 1382932186525388172396322634386747153040790799479761894129108697948157120203172905347129479154287701170973501982570), Fq(Q, 2942825062588769343592764362038784533315197222402373269141164055008542422048618220546794022265904129190950403649399)), Fq2(Q, Fq(Q, 793330719429306259171810897788909023059158957880906092840810972649245747087198249150502935275196917452773820247622), Fq(Q, 1619325434596186913856122607358164655426966733512635784536944838972615984836752402361664120802013423853825628772586)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 466383126056532787931159985971924699500410886187677957680815482106412196259762675360577347341442762348596977371430)), Fq2(Q, Fq(Q, 1859705940563552275360797081049716847249323846916182723010795178776326458285545755435766840321449743174304662864757), Fq(Q, 306590182067848039968358296299890825554034488804763030235291907637617771527501804280457644601536189414665204678874)), Fq2(Q, Fq(Q, 2459071936908869251467993375210062481235685724130065080156373374114670338857254660579163924937412352210373050346597), Fq(Q, 2187531328707892048170603406877264037315097060718208741696394862320330579451224594781871380381183931825696269991310))), Fq6(Q, Fq2(Q, Fq(Q, 3449178320241127375027640471993487456754722310771082857125189022652407194481988105060960385147377862807838430724168), Fq(Q, 904395074096090909610156560164341024991777001604239857943156173037125974845494403795312111701713396674737139825787)), Fq2(Q, Fq(Q, 1382932186525388172396322634386747153040790799479761894129108697948157120203172905347129479154287701170973501982570), Fq(Q, 2942825062588769343592764362038784533315197222402373269141164055008542422048618220546794022265904129190950403649399)), Fq2(Q, Fq(Q, 793330719429306259171810897788909023059158957880906092840810972649245747087198249150502935275196917452773820247622), Fq(Q, 1619325434596186913856122607358164655426966733512635784536944838972615984836752402361664120802013423853825628772586)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 1025407231273636406944101243528487744178571069791551455264012691226440928360355533843269054467543027936990360636148)), Fq2(Q, Fq(Q, 258066216657524927979403051584820291135621845274807280122621551302953838229944968651870140174444448670933321904609), Fq(Q, 153648160743842587374354268027995179728920743432920270043555333381033988413019413346190155703849802386639076716416)), Fq2(Q, Fq(Q, 3551312213391417611729068989577202022724064296314128168974881333285242974392094506413773318369402730380606667260872), Fq(Q, 375210620363240435945365119971584928401305211458283006882600674201056944870829002570351058661355646964382173282078))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3785814930612185622711884608383468863741456200121603180818271937625477847554411284756984725802743250387927011668750)), Fq2(Q, Fq(Q, 3731918433716138189396253828003798660534810571905961070968534805701783667401609706529387082459721142543503322598214), Fq(Q, 220354749446141926951040004120623745776059249069702661981046662631741335310281379058827130608671547518895914161860)), Fq2(Q, Fq(Q, 1995175401474457115363328834949742556793966927115180882117913401909087528326763664272348147405077487217061832064129), Fq(Q, 2179692018855534530874294250803014764903596058520618229139193776106023560111102496453134547434966972333367208346797))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 3319431804555652834780724622411544164241045313933925223137456455519065651294648609396407378461300488039330034297320)), Fq2(Q, Fq(Q, 1872212493152585914035456746954081813285486724989778347957739626925457209116063951093620242138271399369198659733457), Fq(Q, 3916174122599961280400471533556637076778907580203947517077812891118155214273617439221057115136151022142124982042773)), Fq2(Q, Fq(Q, 3538513019787255257313125285475584232115164022924123687293598163918448839960346868135871851596680799044583054277319), Fq(Q, 3994570245369309876121480669661654884145381817741417372774857049909724631150715766113950796182798704545565210915274))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3371348709352602244718327618342380424888498781585790184301669580615381437214612553531422624873618952124934090746872)), Fq2(Q, Fq(Q, 2199147706428555260210808694230813652587823109075705748038997055380510384146336635031084498898951952754414513897543), Fq(Q, 725808682727960774152294783475001240912238847952451383757885473586555264184973286750864425784614725501321221425875)), Fq2(Q, Fq(Q, 1657072226773007438516666113057037045988835029921356122337505156211018583701208924211001035229007556557085559453424), Fq(Q, 2746167718662995967938662804334079552069272603151144017439368584707001080159665651351682490709425851338543753866115))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2904965583296069456787167632370455725388087895398112226620854098508969240954849878170845277532176189776337113375442)), Fq2(Q, Fq(Q, 339441765865002984850011613181096805338499262159523025028201876604183925860790879595317658577502209580109851032786), Fq(Q, 419218500660112734183936487175110415358204359147688353522593565948937492657471482470406781183078536086656016747001)), Fq2(Q, Fq(Q, 3200409845085805580466462563582878721310032125730298927513189918220379895334792128074524739420610868384606781666614), Fq(Q, 558636389955103919768059397456815514754175542432935275742973722386670500708441056569811110328241919512847483874805))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 1662963727412951279137161171489532688394090205789156066843055208783974509658067764641873319738360748189379491848257)), Fq2(Q, Fq(Q, 3813293982923616246266862389600075174737687988790676815874115131003013755032455617472834600862778903452679851726391), Fq(Q, 485925089362412073760622223267738981405342864784470745460084895199644839554733448183043756087900281218912854192445)), Fq2(Q, Fq(Q, 1644273033168845084100722408955419255379934756531351640656221986844224449269461285933099568456285625221061946469871), Fq(Q, 2363117788447398014696988528288245351256466389495270497999566824291637115948714550452594599101853244881832518939524))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1978715441315260260117495996057795741472590438155234835082583232949239209989669183463423011241668241410325432809144), Fq(Q, 1672206282860153609155521071708999372205617643887555316106421375994789925099729446590261456492501483480714459694561)), Fq2(Q, Fq(Q, 2343484435046268225362162478379266982366371299864327141285669030275052929822032004370900991183873787486189674179485), Fq(Q, 2096650363310161368035366632543706965418260443922138403176571267938511736979250446490791409254517712877756022438609)), Fq2(Q, Fq(Q, 3259905331116579669416617031637063502394533422465259069678835949538649816714954636743299899128041363284359774464168), Fq(Q, 1317146559729042644735092363237961904741766051071659417134920011645921734434220588242548035352603530019624974819077))), Fq6(Q, Fq2(Q, Fq(Q, 3368844858052796398427516924679422905944344579690687238874970402649160677341794390781135587733846982263795402245216), Fq(Q, 3606427129991977213600993632071971900878984384463200519832858713865131710062145218008856252607726810251333228013377)), Fq2(Q, Fq(Q, 921539387478719753986582681912859929705095189462536991643835057172945315365325942328485592239974905505096978606220), Fq(Q, 3729211997295161366456268088221459469150958701822868147097253897840881597233474828279971121262616464648946645301149)), Fq2(Q, Fq(Q, 1567074487880863929158678278761847036022715703799067583788384424092245692031886498472231654900497855673865044594308), Fq(Q, 3145076591349891783376949569276158069096029166014012065902483559141481863239121229848471091442347573030758399476897)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 898858885561780888775537684166070054505866841354321154306258883164867554557991859702587424980375384099385715958701), Fq(Q, 2691730861577908258652991517894460075340464675307534815237744937080226900183346797127039559895311250846507469868300)), Fq2(Q, Fq(Q, 2604562945371840528029558734687860391621835021382421070858938517846881817279680975448456962899021359106021981681609), Fq(Q, 1897341102977912227946001729914881409502095776133873329328806914740415494931189054404841891551402811830184648532842)), Fq2(Q, Fq(Q, 734806989933632053662667214643758512227194981447262725378581329272097010092618558907713564881976259518019563763857), Fq(Q, 842102603445637403607083398291186105463029817692476816322843582545251258860546197621495286505767392658516040333675))), Fq6(Q, Fq2(Q, Fq(Q, 2648322864533414228467707344667134602962083302190876404091918372831312450629685577402791269855722557442280082905693), Fq(Q, 2092481144516055214123944916271524583148660125072783092334632101872922519976148923438342297473296856086081653029971)), Fq2(Q, Fq(Q, 3227411961174941884885385235839961031927955829393483550636452241128930973523441661613443642067137164524315688894218), Fq(Q, 450161947784125215857592414116995997155282865889185641025116417043588807134133927930369177327497309122361591714020)), Fq2(Q, Fq(Q, 689598802465490807766044066320303983331261784406086578622675849405059998649694894926092684451687158229029787510954), Fq(Q, 1283325496420296746424473346697612165737551515438202982816453480040713631243910363751562080611252668354381082718349)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 999603067119591277324346208881747219968713130045568500733221090175344858161879238788364614794972009221193567387747), Fq(Q, 2049863774688240423993147502016839063970324431030728941323130608997721713178465449464106940224209577125542266662701)), Fq2(Q, Fq(Q, 1272488634543137279969164490720732702860418146110948614476114726047178900536591796476717925815585251408152787070100), Fq(Q, 3734005087328514167409143302853404460041724220010955483391878018415128580905759573677559961021321682314858208452724)), Fq2(Q, Fq(Q, 1767363778141075062362777076400976315927104698159959366948405167595819903823663123971161722372913487968747313776122), Fq(Q, 1004590017925075346421338787273911987523728446369515577475259898553472631375471707293013914996778504423494472513156))), Fq6(Q, Fq2(Q, Fq(Q, 1832437232651783112099899018491316117331389680959509450463320387710616947260138313447323436818470991821118802099714), Fq(Q, 3068970774008602090758854599529857218662320119064819060823693143234946452613215795036616701040897299996113863369830)), Fq2(Q, Fq(Q, 544811204135885696707054636081838812944890536418167467884152741301148320510980973813383610982236554311152025442069), Fq(Q, 3050713394094137750058593875743988941663488417823417777456574573974507479691508010796397697778269731015046111342992)), Fq2(Q, Fq(Q, 3466035848601028927982285359795835839743336104628557458943657476530578951674600996606365414906516797423701484516248), Fq(Q, 3356352530353619170807258761698091000215992557667770941594317513698021128701346207350758486047329081320258057007932)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1908307339260375312718854838074443589871498031187919412534190672208265609393009853347483789785172197560828714254329), Fq(Q, 2616275827434691639602441613436939761308135661653655608648903585024293719216462302863765158196228384152350096757922)), Fq2(Q, Fq(Q, 394807284889957266679302611008946067436357950350769954581002876825146271784800636307804350299258218056699546907537), Fq(Q, 3086329144672518440235151500421392737490324933591040042317212669814739319037087940510874742726919571628252010882306)), Fq2(Q, Fq(Q, 839154211885017154537425285607334694850178463816026097323805657407241958033133835553256607596119368635164664766464), Fq(Q, 1345208170881100219441628568884772026486500788353445453586528846352398939740487393598034095266748041802731407836205))), Fq6(Q, Fq2(Q, Fq(Q, 3196543705839524817698914906416049086038773580126844631660813648496784462451056502321651100573230248918026019988484), Fq(Q, 347132259136324903630027290154852423964621446679067366243575204635306940016420362145804405820172705617156944501961)), Fq2(Q, Fq(Q, 3756898652095033733356021199145816048914889922142400998301798196304217318913194371951084514331330777627435702964475), Fq(Q, 1887727995363567975284693485329163360868893534842378315427098730894799922616579406370499228390182340600592733843547)), Fq2(Q, Fq(Q, 2287736240185080078535020295660535252632363807344253841237139337718946099458513619829967486792944699804606359497102), Fq(Q, 395271755085213014781878079983161802282377818764236004665925223306962380302932825976903289350982707159414874525595)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1289029398056353602991148998275273639282848413276291699429247919535307198334879586423613387247026147602205552184098), Fq(Q, 2513155726121630503175288484087050307754529940544604523864645763758000267917253197003234419214122641148811705766960)), Fq2(Q, Fq(Q, 1685351321666973253598887862355315543263835087765506845230596960315564421622319797571527439083854670884347351263500), Fq(Q, 863393312066475006943700123740820479042422145345176535319068489271898036681315525172799217037251947638563910889689)), Fq2(Q, Fq(Q, 2580396353004057445004391715863125601268272679240379854633798738273026306452646517088133231420992896046942763563291), Fq(Q, 620245733391072904204141949961862696678997130475352732405328439185592434812428209628112791550357752620066163547648))), Fq6(Q, Fq2(Q, Fq(Q, 216492424866436565385312760465149184963625355563297929884279311485171661624020542773391585044241164155889692771926), Fq(Q, 3030178377554651976538337866898430830346039021724397871471518249179825876921894917303024481868565484316029175875880)), Fq2(Q, Fq(Q, 239429651768400586625388528354722127396998746919941209568512603140519669689830376358546509688011988388665119582096), Fq(Q, 453283993225343643342868257140615409926120944092887025132511887408551442997251584471855404655242476083709940681972)), Fq2(Q, Fq(Q, 3910235648953870475725217552163987663089935204884750439814848652696766736557744935243557669582955398869745060676191), Fq(Q, 44774728136180159482565279765891862711952555795421008234208376569339783515150285078284668628952592583335006660197)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 455901004859393587007484457776409667840062302271468677852054894400191264876042812899228055079989912410698781817846), Fq(Q, 3904226797852673125597070126530716929443506686498962906616936643348217597260226685121186616839353118871470975495085)), Fq2(Q, Fq(Q, 2631125341451178443724321554275687665104524122812449519580910240812089397073229059642720306197421637985313156829630), Fq(Q, 356028328487355515133682459068610190113015394640996689238411280293034962506415698637349866142094172265355339751683)), Fq2(Q, Fq(Q, 1387020908201420482456604194410611877193991925874212673605597709116518193803923430457788641345182466165186772406219), Fq(Q, 2309915835935843949390446805964251053951471620187602662578837084116482849055017577505781300390739255630781848511443))), Fq6(Q, Fq2(Q, Fq(Q, 3543227352426989520176716274617323190262802715194279367689790214689769702840195795923181715099273103771176576924594), Fq(Q, 3003956074430067416129406373383846294833180046121958551317661775953204118091091178471669805411209972070691418951189)), Fq2(Q, Fq(Q, 1063000508095418975321082928547552391361583247524752657934897157119442261916764668658229659579987522925074335377701), Fq(Q, 3895585505117882111013296810107681249234553234824811451892340234935645755270032600340151737807778636135165739505605)), Fq2(Q, Fq(Q, 1412458540114590303081581360156151151873558964665215867843294018723748525048188097008133988717488555019750407116320), Fq(Q, 2807608597999203262399421223902149630204725552011310026332261868034159822336729133834481001134674440290716496159725)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 414466221259583377993556990041088438852957418535812996516602357010096410339798731225562100929124298262992920921878)), Fq2(Q, Fq(Q, 1532770727287582929185445133772985007946987462830255322929537750321273283255273071498302583560769189789088808700671), Fq(Q, 3496955621939848546216535046381526661420703221056259163555219325169217721616145956750650333953072486055468965295772)), Fq2(Q, Fq(Q, 338103174701449676846662721892705510805131897193824759780408245698068944625554740061347112176069930659976272610705), Fq(Q, 3435933855414205956353421272204839369391206275308482097031883327523054130442274709544139685854556785032717727040469))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 1656468077142701555643563450922011475846955108144769156294401246735091141636580844754534058722939739849950542449063)), Fq2(Q, Fq(Q, 2061328065450637061186384183089910795104681556138109417415682632046475104574446198063473270404508159954413080566853), Fq(Q, 3430249033237549206639849310288898095373564715419476771617727995918510374718883991038013359048250740923212127850328)), Fq2(Q, Fq(Q, 1894239986618410173212402876520164976735229266392772046637376177074224390690885582202772283140395173823521107807448), Fq(Q, 1631452456921911861424492141373409532888915428246146874775290225618087515202001215661356197080945459663732691975750))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 2122851203199234343574723436893936175347365994332447113975216728841503337896343520115111406064382502198547519820493)), Fq2(Q, Fq(Q, 3921034006014189336547181264139627642354005403054292140426477810822801562859991953499240110725957903128717743431610), Fq(Q, 3736839215305397246608207606588788920927599204224239801853019903556128146246385795318471003649786930337877332529202)), Fq2(Q, Fq(Q, 350902368305612031262606425994323301414032170583829241461691415064863079057302378339248578948791861995999885594258), Fq(Q, 3818983785629803909595095548250673570204012488964355616471685087938418094653225810443227577462129391489428961967060))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 1242001855883118177650006460880923036993997689608956159777798889724994731296782113528971957793815441586957621527185)), Fq2(Q, Fq(Q, 528557338163054132000939049316925787157694093307854094486144881725201821319173126565170686843738970165324271866182), Fq(Q, 3935702966519368053841104089643275590509744314302225493394566806873324303593575898730050654224193918905637435114343)), Fq2(Q, Fq(Q, 1556136811916960496365740154627459465930097369198947286856967931376155446065330842141425170964325243163544835196743), Fq(Q, 2197928156729373298488860694904474320054591972876672663075465034219065035250564370559904140355404338668909237495068))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1708384981939650965581166446852847736494408575796634117458614371831406927556544788889549305135258203935554598898615)), Fq2(Q, Fq(Q, 2388263278726606407361736130366642634407017940224036817496940060501528279604718882000937527165188713339628934730939), Fq(Q, 239883593365548700391672560207262259506895983167980638297800578386910424630239838567820669696714444282408367233430)), Fq2(Q, Fq(Q, 12799193604162354415943704101617790608900273390004481681283169366794134431747638277901466772721931336023612983553), Fq(Q, 383049930215597953241674276045834200812806213655873519439801760415363964210951100899087891607572606456711234926591))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 466383126056532787931159985971924699500410886187677957680815482106412196259762675360577347341442762348596977371430)), Fq2(Q, Fq(Q, 1859705940563552275360797081049716847249323846916182723010795178776326458285545755435766840321449743174304662864757), Fq(Q, 306590182067848039968358296299890825554034488804763030235291907637617771527501804280457644601536189414665204678874)), Fq2(Q, Fq(Q, 2459071936908869251467993375210062481235685724130065080156373374114670338857254660579163924937412352210373050346597), Fq(Q, 2187531328707892048170603406877264037315097060718208741696394862320330579451224594781871380381183931825696269991310))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 1025407231273636406944101243528487744178571069791551455264012691226440928360355533843269054467543027936990360636148)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3785814930612185622711884608383468863741456200121603180818271937625477847554411284756984725802743250387927011668750)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 3319431804555652834780724622411544164241045313933925223137456455519065651294648609396407378461300488039330034297320)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))), Fq6(Q, Fq2(Q, Fq(Q, 553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619), Fq(Q, 3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000)), Fq2(Q, Fq(Q, 2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217), Fq(Q, 1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388)), Fq2(Q, Fq(Q, 3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165), Fq(Q, 2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3371348709352602244718327618342380424888498781585790184301669580615381437214612553531422624873618952124934090746872)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2904965583296069456787167632370455725388087895398112226620854098508969240954849878170845277532176189776337113375442)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))), Fq6(Q, Fq2(Q, Fq(Q, 553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619), Fq(Q, 3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000)), Fq2(Q, Fq(Q, 2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217), Fq(Q, 1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388)), Fq2(Q, Fq(Q, 3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165), Fq(Q, 2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 1662963727412951279137161171489532688394090205789156066843055208783974509658067764641873319738360748189379491848257)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))), Fq6(Q, Fq2(Q, Fq(Q, 553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619), Fq(Q, 3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000)), Fq2(Q, Fq(Q, 2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217), Fq(Q, 1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388)), Fq2(Q, Fq(Q, 3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165), Fq(Q, 2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 877447069861743471558744907726386870343346652339923383574545007635112345744606332209754017059040731780983880312192), Fq(Q, 1004515062225896383633895867885374593975409632574484600523177157636057715826048803227400830210847117657589851148278)), Fq2(Q, Fq(Q, 1122231552151397600764231174231382478597621447783306461551512998441918797454816179146915588610749353961886642138155), Fq(Q, 59797678976139506216871153506498033167142516759233742856705569467412133414318283769808612177116873770975648796350)), Fq2(Q, Fq(Q, 1550210159618950315849415034567343244219609006816043580116507922576408905638402002054754973951452724397883311381001), Fq(Q, 1923124964089134604447305250846023641212933235092728014382861944954536380058897335520607270919922463839935083082233))), Fq6(Q, Fq2(Q, Fq(Q, 1712254010580712504253888861909198664911105459505939061913643675371111366329106200569652508761710719563567970933872), Fq(Q, 3454380958855106232167311072767784983516450573121876327215453387402479312214267886672047188999063650412892821604217)), Fq2(Q, Fq(Q, 2163888186767541118983703958518301386648641922192830531158748887447781427964035241728532309132481172601173035645316), Fq(Q, 443067917025907272858052712732608318958597269969993957683793689696452851341670974001892449721031017415958148810027)), Fq2(Q, Fq(Q, 2942376454079922868724439975912124308406060396859629780150141470351290362493581396542290149393845760876983261826112), Fq(Q, 12943886549113742872015210804887466007656464988889597606558194421546318637565117794033487354918112745356827625701)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 198611095528669814491819784930028092283831359481111699896026753692264899514634797825901946348101593552169843656028), Fq(Q, 2396916264283631074223937060996845735665611736761272139820256917935773581131240120932476314844881177060927182472581)), Fq2(Q, Fq(Q, 3191093683243435540031754541969755764674326373082110292554162318184622357039801899710839896338844630835925960771678), Fq(Q, 2906553864593063607570768367074329710428135437747402297541534161795872027965985204902714213655384862591489535428454)), Fq2(Q, Fq(Q, 3357288701012386356804856362923357271106568081617180126425043361912448353527121764353595104395642841571942632354772), Fq(Q, 2424723268582262131038368381854463645336466117246287217841656822801168755493482455937615169938991780920096060669756))), Fq6(Q, Fq2(Q, Fq(Q, 2568558571239172461248678377814548060027342412894105745091963212752152252719867168650653883170855195777638126877943), Fq(Q, 2333261628153628714247683583831182687636594087584512512332478076809736997410524260408378276768118916781206769704029)), Fq2(Q, Fq(Q, 3133482446770027840829672692762339414707631334802731858658383642198664660581131917819403682686609303713625111193737), Fq(Q, 3148378670806674909766452899324360348102117340032548923373922832872359588957117927582770425193807781501404486939322)), Fq2(Q, Fq(Q, 3423922015714833453375396935547297936216452628611045862651842207856091346409161086190031502927189722802186772355994), Fq(Q, 626433819168236393136647894346347434665004800660012109951231652789671775341376164447956080625886100715715960662814)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2966387193521126141849075070423387987246030404828497756557780526817720010523934326532571670944056977052491480390115), Fq(Q, 2338584106356611690179803129664002492149705962909468731229456325629490885456425934621588830628181831187464064933755)), Fq2(Q, Fq(Q, 1963082333803031952667552372049015356105435030122257665593456402974722834591047999778964560166327730928490371794279), Fq(Q, 609940950322648946914816247153257056875819257191648108572912264025143961067954391092108114015593792748162364361583)), Fq2(Q, Fq(Q, 2025673636554867192573667918965363143298907160348298050562736181198850293301607170667581049002881554380880374728015), Fq(Q, 2896796133670198297227964033786118688809478560724861961246803427185079701692682333388309804052964988309549037574027))), Fq6(Q, Fq2(Q, Fq(Q, 3867796804138183461902396271340801829538768308605694212701544995976548456585347474454631538205393014096930812184494), Fq(Q, 1278619317196897595343129469444009797914091194959165495204441076849363060968032265997452138770319072728737108954890)), Fq2(Q, Fq(Q, 170931816731788857525890570244972786429640668073904564003077152403686415591960675352486725537319570767147685137620), Fq(Q, 2706804755335998622857978833769224192853466184305066139249720749447896703639292046941129655244975183405857239143081)), Fq2(Q, Fq(Q, 2769078609156645015074827185733702166585384393469272476120139874373870785689633231582300191959749817497497242718032), Fq(Q, 163043326922972829855420121396410755332340939841466478423010892824759548080983419176022066916387332401156390013137)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2260308507373785812856380714311963592630215313438780464134197969153518368048105540560731055552404425154719507945568), Fq(Q, 3902299314573171213094088813389476800107457738322735663658191090398842473122781164961962216614758831897694981055759)), Fq2(Q, Fq(Q, 1906114057948334822153503566464967539613486499834928498957106118021944319855118358897982633678823556068311459448749), Fq(Q, 750103453023609185418572320673727612794286998859047994668024650672329080498243454265840542780206241645079274939428)), Fq2(Q, Fq(Q, 3401714449313860062865725363225054390331902640346156190105563220970010592235848550083983959129965998126436305023926), Fq(Q, 408407406860405155317710025716048972978155885031610593405343647019541824894062616188927989529885551602796355897000))), Fq6(Q, Fq2(Q, Fq(Q, 1897296914210162199814954444631201133586898320352276661711410233483979448438776989026595661591508490555007141450166), Fq(Q, 3321551379155160781610429266343522390404908115653088317325485893307460439709103441937941160847524859067260087901917)), Fq2(Q, Fq(Q, 2052764092918910743434377243943166115810371112613351855017837950253807639850414567103605252267458607669580971205006), Fq(Q, 3674791833499039545723247712775648113085706394511515636760654535178607208661518622326186097793200259956039986559673)), Fq2(Q, Fq(Q, 3787368149681348309546361411807005094511149557561637158895004863899578906447242471251523871954423578534552580656394), Fq(Q, 1988745676741873999725305180444423805381130784210921441809337905466985507779055597212352126107736073585673368716342)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 336644073594518398371084049749262810673070732748389186112541264104468479280909639729434258644927002202457459876917), Fq(Q, 225767967117245824570724410525122107821216015291112798814640774459593548319948696415626265472071010965589103859438)), Fq2(Q, Fq(Q, 3483436312047944629741785316986182406767817285085644652610851925889313458553977923290712663324716494481981096648260), Fq(Q, 2040630461606927348223568068665901497476056942198339298838773447566203576033983037629913272040298000971425008426495)), Fq2(Q, Fq(Q, 2828607675065403441034881678104484429115341397291898736448903930001728492689251280953176333459108167715406619170292), Fq(Q, 1829183608843190064651443720719125703788026251364220233044358500407762485330553165086688669446134764532309148095933))), Fq6(Q, Fq2(Q, Fq(Q, 484657277908640655727187908563356184467774426658833263118292099457503822504840992501418999529109267510201535391809), Fq(Q, 12669307807801770777129017181908802343085882142056289482855092317145208172972496114974405825841946313207098984519)), Fq2(Q, Fq(Q, 1405706095538703105773509479093443170520300236769189539927475314633488563757590858958379278670145534140651497062198), Fq(Q, 2864135277164767888896016181670466702879776219657497483660464266355010078137190557707191246697900495246032177043743)), Fq2(Q, Fq(Q, 2282545597589051618967911951960987782540219658739871838801642281404239576727844215914821101935276647155589821627738), Fq(Q, 3761582487913040061943072386880386747377124884072688547085168766907727082472969681561437672982360843674814025468638)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2445778776045587586620394992223935627756918809754419669239611124577562885493463571458147813364363268199998228280575), Fq(Q, 2662356018069904985875227188282036548887778281730255157103508566470405845853320669647450627287944655440672138725592)), Fq2(Q, Fq(Q, 2653072162220343997089443962899729183003393318442318126948813504282071155443798145568047751525818756741935310896412), Fq(Q, 58250970072110795368242099297692652394017094329423671524650547039932211688700979235262199301907961193605499056168)), Fq2(Q, Fq(Q, 2652398299421002385053302588364115603345981905525532610811662280846710947635427982277679069706352225166123903669113), Fq(Q, 3345865947625749160946111344711661590439120547207178019717179179891892687486656453700832906799230625962861416797807))), Fq6(Q, Fq2(Q, Fq(Q, 1328290068087821209022745799787451336864652550416831517950418190290805498146498271500883647515467604159467962978392), Fq(Q, 932481408728051061645540412406381885272502632772543534310550852041273920260771000022209965721293614891039881562894)), Fq2(Q, Fq(Q, 2848250954958750937196748100818700456377245061658441043770913407081410201328336088045844922796457322346995306535105), Fq(Q, 512846164864984210332025337729022633143816318718854958807071466474803266814820617939970633173250825667531131817959)), Fq2(Q, Fq(Q, 512349093070368223249362405570214581695671161560184488218236495907120025938088687816670989560430145772935005943220), Fq(Q, 1266033609873268875235185138823634415106479367768793323186345220295260417839304357424339785537460298228353023126562)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 414466221259583377993556990041088438852957418535812996516602357010096410339798731225562100929124298262992920921878)), Fq2(Q, Fq(Q, 637352255315029000603021041094082358405682808777724021403458099509159722512664051423216221693162370559077743398031), Fq(Q, 1671653730598002979421090389176765740845891238811669446755831995894091866601563271702230089124611341834414944289678)), Fq2(Q, Fq(Q, 394600258265849729267691779025703822318975210409352238068792524268428810362149049045130711467841432158631938954810), Fq(Q, 3531566395136316456912922988984579298773391941894603487740670394723014418031141785708238128161108401053114913159089))), Fq6(Q, Fq2(Q, Fq(Q, 2088282883351950378857360647582914673245739570343171755063362104273384907022353180108182746758842668224222268373832), Fq(Q, 2802988375288461942537107743574149970292138786897393281664132196337636803119736703629406152259744535650806051892800)), Fq2(Q, Fq(Q, 2423605646281307449200219665135385212008608680566443096221040223961064180869378185109588341332253667690408532370597), Fq(Q, 1408618688575931886498556329177981398136128954736536610666102625689470101944795804028213540758791409366936729778780)), Fq2(Q, Fq(Q, 1356204092770041527163183772880066084612841715685056868829409157058020262626304984281296032609113840980609336058514), Fq(Q, 2725683217153809772471595304672449390506168598324573494693483370434184157317374968977493021147579583254321853889475)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 1656468077142701555643563450922011475846955108144769156294401246735091141636580844754534058722939739849950542449063)), Fq2(Q, Fq(Q, 1165909593478083132603960090411008145563376902085578115889602981234361543831837177988386908536901340724402015264213), Fq(Q, 1604947141895703639844404653084137174798752733174887054818340666643384519704301305989593114219789596702158106844234)), Fq2(Q, Fq(Q, 1950737070182810225633431933653163288249072579608299524925760455644584256427479891186555882432166675322176774151553), Fq(Q, 1727084996644022361983993858153149462271101094832268265484077292818047802790868291825454639387497075684129878094370))), Fq6(Q, Fq2(Q, Fq(Q, 2698084927258314749415829368176336010925031958039466990631425550504433623192977671643069966562446730839717138974738), Fq(Q, 624752548968932282476297582106279142798881227387002568240034808033518832648934676610359104746360541150778087411406)), Fq2(Q, Fq(Q, 628817275752354953244286705871390066741181251083596246511522972216812750991653916574141635127420241959071202912352), Fq(Q, 994569717892120384008145873572522869520753996511753996961156556644249651815328601764815912663306272219736777503131)), Fq2(Q, Fq(Q, 916307697768258882806532807190834722795620844264013442417145616383736387613863559845949257197832052507458603671037), Fq(Q, 1966487565157922411124191109036623740983698509278931550457046121907531995407297049820587163126417285468786466957817)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 2122851203199234343574723436893936175347365994332447113975216728841503337896343520115111406064382502198547519820493)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))), Fq6(Q, Fq2(Q, Fq(Q, 3449178320241127375027640471993487456754722310771082857125189022652407194481988105060960385147377862807838430724168), Fq(Q, 904395074096090909610156560164341024991777001604239857943156173037125974845494403795312111701713396674737139825787)), Fq2(Q, Fq(Q, 1382932186525388172396322634386747153040790799479761894129108697948157120203172905347129479154287701170973501982570), Fq(Q, 2942825062588769343592764362038784533315197222402373269141164055008542422048618220546794022265904129190950403649399)), Fq2(Q, Fq(Q, 793330719429306259171810897788909023059158957880906092840810972649245747087198249150502935275196917452773820247622), Fq(Q, 1619325434596186913856122607358164655426966733512635784536944838972615984836752402361664120802013423853825628772586)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 1242001855883118177650006460880923036993997689608956159777798889724994731296782113528971957793815441586957621527185)), Fq2(Q, Fq(Q, 1165909593478083132603960090411008145563376902085578115889602981234361543831837177988386908536901340724402015264213), Fq(Q, 1604947141895703639844404653084137174798752733174887054818340666643384519704301305989593114219789596702158106844234)), Fq2(Q, Fq(Q, 1950737070182810225633431933653163288249072579608299524925760455644584256427479891186555882432166675322176774151553), Fq(Q, 1727084996644022361983993858153149462271101094832268265484077292818047802790868291825454639387497075684129878094370))), Fq6(Q, Fq2(Q, Fq(Q, 2698084927258314749415829368176336010925031958039466990631425550504433623192977671643069966562446730839717138974738), Fq(Q, 624752548968932282476297582106279142798881227387002568240034808033518832648934676610359104746360541150778087411406)), Fq2(Q, Fq(Q, 628817275752354953244286705871390066741181251083596246511522972216812750991653916574141635127420241959071202912352), Fq(Q, 994569717892120384008145873572522869520753996511753996961156556644249651815328601764815912663306272219736777503131)), Fq2(Q, Fq(Q, 916307697768258882806532807190834722795620844264013442417145616383736387613863559845949257197832052507458603671037), Fq(Q, 1966487565157922411124191109036623740983698509278931550457046121907531995407297049820587163126417285468786466957817)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1708384981939650965581166446852847736494408575796634117458614371831406927556544788889549305135258203935554598898615)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))), Fq6(Q, Fq2(Q, Fq(Q, 3449178320241127375027640471993487456754722310771082857125189022652407194481988105060960385147377862807838430724168), Fq(Q, 904395074096090909610156560164341024991777001604239857943156173037125974845494403795312111701713396674737139825787)), Fq2(Q, Fq(Q, 1382932186525388172396322634386747153040790799479761894129108697948157120203172905347129479154287701170973501982570), Fq(Q, 2942825062588769343592764362038784533315197222402373269141164055008542422048618220546794022265904129190950403649399)), Fq2(Q, Fq(Q, 793330719429306259171810897788909023059158957880906092840810972649245747087198249150502935275196917452773820247622), Fq(Q, 1619325434596186913856122607358164655426966733512635784536944838972615984836752402361664120802013423853825628772586)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 466383126056532787931159985971924699500410886187677957680815482106412196259762675360577347341442762348596977371430)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))), Fq6(Q, Fq2(Q, Fq(Q, 3449178320241127375027640471993487456754722310771082857125189022652407194481988105060960385147377862807838430724168), Fq(Q, 904395074096090909610156560164341024991777001604239857943156173037125974845494403795312111701713396674737139825787)), Fq2(Q, Fq(Q, 1382932186525388172396322634386747153040790799479761894129108697948157120203172905347129479154287701170973501982570), Fq(Q, 2942825062588769343592764362038784533315197222402373269141164055008542422048618220546794022265904129190950403649399)), Fq2(Q, Fq(Q, 793330719429306259171810897788909023059158957880906092840810972649245747087198249150502935275196917452773820247622), Fq(Q, 1619325434596186913856122607358164655426966733512635784536944838972615984836752402361664120802013423853825628772586)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 1025407231273636406944101243528487744178571069791551455264012691226440928360355533843269054467543027936990360636148)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3785814930612185622711884608383468863741456200121603180818271937625477847554411284756984725802743250387927011668750)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 3319431804555652834780724622411544164241045313933925223137456455519065651294648609396407378461300488039330034297320)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3371348709352602244718327618342380424888498781585790184301669580615381437214612553531422624873618952124934090746872)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2904965583296069456787167632370455725388087895398112226620854098508969240954849878170845277532176189776337113375442)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 1662963727412951279137161171489532688394090205789156066843055208783974509658067764641873319738360748189379491848257)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 877447069861743471558744907726386870343346652339923383574545007635112345744606332209754017059040731780983880312192), Fq(Q, 1004515062225896383633895867885374593975409632574484600523177157636057715826048803227400830210847117657589851148278)), Fq2(Q, Fq(Q, 1784046045572489543183218073160592407653794514402907412437580310626646739315262292139619664890710717760454879760234), Fq(Q, 1810854388609304563586648246800725613518394934482702633723902555434755351151947071927772658410883656999707381323902)), Fq2(Q, Fq(Q, 2704188011239799976303032301956259564869712145318865208704199110299478104868109787057875604466761828600643971436162), Fq(Q, 2063666501494457199697884100341733155131864954394134076265637880159013870363819221443300023796935043513382449813619))), Fq6(Q, Fq2(Q, Fq(Q, 2824877895285361421894978336937964485949450661077330657758523820400008923497757478065632570592870049756507569026048), Fq(Q, 136819184712996585235238759655911046105441772537026547008018852778916304127178938488226217338086448533775716711538)), Fq2(Q, Fq(Q, 867764504923346487814672462777239734583798925733177277080239924358104428485636573423808029533270937312426682049587), Fq(Q, 279184723537041676657699445680873330565862164976330258739729830798318633803152689256939452631574179666759100281679)), Fq2(Q, Fq(Q, 471896473370525156794682378462046335893304144653073935543786060252407735128521445469256528380370431956652394886999), Fq(Q, 1004081531243511976381942891333174642145046294540003670962490854229335094164834430984126514142436044050661821791690)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 198611095528669814491819784930028092283831359481111699896026753692264899514634797825901946348101593552169843656028), Fq(Q, 2396916264283631074223937060996845735665611736761272139820256917935773581131240120932476314844881177060927182472581)), Fq2(Q, Fq(Q, 3183019504431449487831114863325372678566188207516203500763628693832067954707118829576165082712823838769034384411309), Fq(Q, 2579352645875305298792577686304143615878051830667234131546031951238453527891748560385251573617607757741750859298461)), Fq2(Q, Fq(Q, 780703276342933093139296726430709520887762879094776395640052627531221197120470495991537037507639046303826181481383), Fq(Q, 2111303858445440119683874123690513124154286701303241382009623010603346052648130190391264947251339957176738959325370))), Fq6(Q, Fq2(Q, Fq(Q, 1422091183138368709421699590808475525942861330345901208711922533817918826142903107317053708693881727993972518405429), Fq(Q, 541651023804776802061529920637167846959449665701823219083160334408757720288496910408178196158009572292126186226227)), Fq2(Q, Fq(Q, 2245941983943235339223421664313557116722668639603033066336071845106681179262052667614831962108625123069542045652038), Fq(Q, 884724431953663891619301191320116763274299585427867762820882715333798525037697884942800342598932456993848309426212)), Fq2(Q, Fq(Q, 2881229420979371453471532465471803073199252204714744359799300018346170680855741833914004952291172233628627897029660), Fq(Q, 718210504389047117045666847708993758746588983171281616513640396117293795196619315592060607583322092296145214342794)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2966387193521126141849075070423387987246030404828497756557780526817720010523934326532571670944056977052491480390115), Fq(Q, 2338584106356611690179803129664002492149705962909468731229456325629490885456425934621588830628181831187464064933755)), Fq2(Q, Fq(Q, 481856392743758837177077634373056358414024374694260046142641696006974318037079840901985590251490667352625756868651), Fq(Q, 778515631448114665324447174801114256186185722638825321968071899101949412761881637763354245379318793823243051861631)), Fq2(Q, Fq(Q, 92521424193231131380412198262180886169404035612911089810254132798388918893861078277590517077484706981770286503404), Fq(Q, 3392995879365160746704482819249426512060948927048989478510718665671625574997391450783372834525475259205245430744677))), Fq6(Q, Fq2(Q, Fq(Q, 2880443909723262490547218428756828495586205222113842361401018044455554846308349462595791402417681854480721463413763), Fq(Q, 2763350607853133173937792489412342133249159422874890655007251270544862833926290128204812163308038045498417042518704)), Fq2(Q, Fq(Q, 1455922318781968931998964164140189401865167963067716048314273910081360584699042202767581205569974685484740232053097), Fq(Q, 407661977332433403678581323270650842249032351872051812198344231606580946287557497430101002031818566866955264612833)), Fq2(Q, Fq(Q, 1505924566094171597475079547016591737729548986440107893350267358900944830077541337056940436748731022330438643048302), Fq(Q, 3873985627255181351626713585922245156634459786101836789444096173049266926895490107321596461025830300956355204279673)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2260308507373785812856380714311963592630215313438780464134197969153518368048105540560731055552404425154719507945568), Fq(Q, 3902299314573171213094088813389476800107457738322735663658191090398842473122781164961962216614758831897694981055759)), Fq2(Q, Fq(Q, 490073817089847612693820231514113314088514694323116532792783097311156084527008901079198036435458729469345978859355), Fq(Q, 185886674490026717022501799239203656902777881831191507260008744504143171474862785635430339285879930778805763154547)), Fq2(Q, Fq(Q, 2705374249346021541678339074935859908062623748717896803482156418207243517597279734135127055911473620071556559992658), Fq(Q, 2465050147458777736487836068241121954402848668673657823546046488721333619554007820125550039930937839298454319214499))), Fq6(Q, Fq2(Q, Fq(Q, 2124504543616303328741066235912468305645986276880141234798020833239023676723754801780942337282872879692922945521733), Fq(Q, 2606160296483817370855396256326092031821528966013544556905619101261304759751074599868637390171361061296968326906509)), Fq2(Q, Fq(Q, 2588633657566849771061915982947739721796688258951532140338434191099619600985319321987867368516719941939331350666283), Fq(Q, 984370380398383708060944276988827348368905696541213856118906107735523998212296607215535398418577080650324523828224)), Fq2(Q, Fq(Q, 3202519085937823966061053753562432226872751391048623616738642287098171116543451076623950842320377634477518482873987), Fq(Q, 320699382376126604873266999207161893417053805327326233040515464726907384305916557509110471120872078704830449468772)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 336644073594518398371084049749262810673070732748389186112541264104468479280909639729434258644927002202457459876917), Fq(Q, 225767967117245824570724410525122107821216015291112798814640774459593548319948696415626265472071010965589103859438)), Fq2(Q, Fq(Q, 1785198025216529315623568924541211171349203442475007901312563937464911230245677945182815609318725255254647543433201), Fq(Q, 1260268420784601566166649698191401044818739916270577382669907322372688989459042456671341650209518312657007652407608)), Fq2(Q, Fq(Q, 2371213262521466042432282449442396340621302569032270383670032423299458224918681964568925988492319423387252853133489), Fq(Q, 1350594283180875346362855593344632362798995268019332288283184088272798070124807999181729675338559236600791496600544))), Fq6(Q, Fq2(Q, Fq(Q, 2048417485150585567577116683847405774211649555093737782513561417912781810959403670641843006942740766654176604620825), Fq(Q, 1399568181157352389416750339847222474796014167115565942081973126290927203834818181457267009307314179931263724934531)), Fq2(Q, Fq(Q, 1572748616017767894149167156607262822486949644191295183456260588583274806164030498686064450498890655597379726060153), Fq(Q, 2741442276065432723513959442499148481361689092419960768148286250300306557454872530106167758477156040606217890924142)), Fq2(Q, Fq(Q, 1402872360956014647575237281748986949197201954033907552451867159510134756349912470521504788221432310915135568715991), Fq(Q, 2750475826603450817704069525576921656996648912241185208113635097162948247873500405089094748922193439147031630802293)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2445778776045587586620394992223935627756918809754419669239611124577562885493463571458147813364363268199998228280575), Fq(Q, 2662356018069904985875227188282036548887778281730255157103508566470405845853320669647450627287944655440672138725592)), Fq2(Q, Fq(Q, 2792819800146001760766504353070877891022523330824248418459647020034809471708845223549202384570759511124159424107873), Fq(Q, 385165215300480076851426151336050580059028401661026913373039395285639661035074223717555496959161540147455892409358)), Fq2(Q, Fq(Q, 3758050381287969181804327848559759413660979034273887071079058108249329420775804691271444110565575020762061039847999), Fq(Q, 1959748159607150608740366436841351482351855841128183518451766210795175905030299647315603746370178585274162180974167))), Fq6(Q, Fq2(Q, Fq(Q, 1952154502979716834252591033226810304277000683566635531477219259631208499165973060892747303056676478225697858176197), Fq(Q, 1177206108593611278633669671888231491866508190506505535404121975022925602053103354048576940609579497507609467660549)), Fq2(Q, Fq(Q, 2137281554477120954038396924129545398186635207444142854630235814073612547286585258566626433161344381908841736724867), Fq(Q, 1984521891771589030152279686868718121801311908989973831134221586101499056680457135838843836312490480010828215996907)), Fq2(Q, Fq(Q, 1929088879345599369775233189585193150727765476008416587185356369841385442170205757532940598576133546959487521460324), Fq(Q, 2869652529111369757613220245244807660996271504816535164955312623452361466677169170041547142061548428520389467306251)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 414466221259583377993556990041088438852957418535812996516602357010096410339798731225562100929124298262992920921878)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 1656468077142701555643563450922011475846955108144769156294401246735091141636580844754534058722939739849950542449063)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 2122851203199234343574723436893936175347365994332447113975216728841503337896343520115111406064382502198547519820493)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 1242001855883118177650006460880923036993997689608956159777798889724994731296782113528971957793815441586957621527185)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1708384981939650965581166446852847736494408575796634117458614371831406927556544788889549305135258203935554598898615)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 466383126056532787931159985971924699500410886187677957680815482106412196259762675360577347341442762348596977371430)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))), Fq6(Q, Fq2(Q, Fq(Q, 553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619), Fq(Q, 3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000)), Fq2(Q, Fq(Q, 2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217), Fq(Q, 1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388)), Fq2(Q, Fq(Q, 3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165), Fq(Q, 2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))), Fq6(Q, Fq2(Q, Fq(Q, 553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619), Fq(Q, 3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000)), Fq2(Q, Fq(Q, 2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217), Fq(Q, 1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388)), Fq2(Q, Fq(Q, 3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165), Fq(Q, 2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 2599495078289042942311895505626756072725281069770242997247148931400796981944571476861991800762966824939338393518307)), Fq2(Q, Fq(Q, 976794021180031985453032654275179163744182070937247046431659976113343648373454931018533880270664580139187594430817), Fq(Q, 2090872231258115713605026876351876156204095597959357800278425561843029359259034754172636870307689877921070961036679)), Fq2(Q, Fq(Q, 3595010103351655309734154342608582543629007336139651165581982442488808705696941177119655450888452300543238720621424), Fq(Q, 87793229869752983263192560705490656970684664388530878151585980985653268248744977835361609360334656528068124474107))), Fq6(Q, Fq2(Q, Fq(Q, 553231234980540018390149353742416699802160509167925028206869113471624456008849759381727243981637801230055841835619), Fq(Q, 3098014481125576483807633265571563131565105818334768027388901963086905675645343460647375517427302267363157132734000)), Fq2(Q, Fq(Q, 2619477368696279221021467191349157003516092020459245991202949438175874530287664959095558149974727962866920770577217), Fq(Q, 1059584492632898049825025463697119623241685597536634616190894081115489228442219643895893606863111534846943868910388)), Fq2(Q, Fq(Q, 3209078835792361134245978927946995133497723862058101792491247163474785903403639615292184693853818746585120452312165), Fq(Q, 2383084120625480479561667218377739501129916086426372100795113297151415665654085462081023508327002240184068643787201)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 73511129852917215430117665442932969686381201097577315366839676860858736702829118135516255560032984078494668357975), Fq(Q, 1789076427305895402220635374945357560972524858210729060295676724761167857035182925911612600560973730112977343126985)), Fq2(Q, Fq(Q, 2208608838694236332311961854592998731142073940851704397318879657542617444971346192792349425181015881921807181932619), Fq(Q, 3543884315799971400442503786650006461738214817272017446071437583299626223041028629037241843022160186201280537237498)), Fq2(Q, Fq(Q, 791353734953364699713157546212645218606756082684942228602490270826376282990707392523525217812509404037959155059113), Fq(Q, 747651847366790552265365851589930525231426569125112849948955564071666276652746103541622612959783187159173636417561))), Fq6(Q, Fq2(Q, Fq(Q, 3278705477669185096256873653380552500072025187475623549071161681626612596352927617167475747818544887476101240843561), Fq(Q, 1608028052527127646060571500613318156071258253365614775488924945457006749896105739138037845288655055674116841629095)), Fq2(Q, Fq(Q, 2645525657615379017243321122512162069672919326755888279153774590942781659284562019128733511276169563930266149675358), Fq(Q, 3873675236338299919084745972773782816188799276151876439547251564646377892287293736468962033840514079489928236929945)), Fq2(Q, Fq(Q, 122588298698684247736386373021919572649757264630692113694000235110751716487834524834260582748795687304044586133362), Fq(Q, 1652282445126256335297609579610123934807976891334048324081854686380794382999771437139996594165252944878289773749666)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1711797489568616583434146621422538673233444794009731352316131919899927017977837896877331399843341475889254457279480), Fq(Q, 1925470021225289286149082376590015884192837705791362736511734327669841899965072675074306663605072884615479779184059)), Fq2(Q, Fq(Q, 3749752378243477266182430540676896078205163067910277252522351165806302154479319030426062760609275840595521892229407), Fq(Q, 1519888831650980258102891099986649689898670358783019991469547758159398616743199022058148178428464166641524020347699)), Fq2(Q, Fq(Q, 2542555657034941581198404091595242433116501522331775022144341938465064081594401543835610731266419638017121525679952), Fq(Q, 3860282023960925822213766947049444190252202828366460309002707146632049091067427299222905628282533243566068282680726))), Fq6(Q, Fq2(Q, Fq(Q, 1049458484263255428802258059383053421955829338945277441737702081289198093291342281484042379026234734469783591905539), Fq(Q, 30470995467840423546951594797442026245296378193958010993329921626850079305474404632846750362865832148571016365471)), Fq2(Q, Fq(Q, 1242153212100721785039683367404029061483891906406733838599421070180015993282112281831708282582398514013782577357758), Fq(Q, 1364352372612931630691117880279131084463986161725384028399582154855868890314102734923284250112830437501794770544590)), Fq2(Q, Fq(Q, 1005176841181657711409116727925731964921623635662050281870445693768516566295787872547039004217211908833946161065837), Fq(Q, 1088121696081859856687208778829442738806039634656199144011818379458324442671943182277834328239463149298375932598048)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 606412287420852147510355256915883920871639472600949273462625871567737033901651002715167115631897903830887166236977), Fq(Q, 596964300953226707489596985125029404930548576827721932328498713712706185928033703435189539136973008617007359213367)), Fq2(Q, Fq(Q, 3613157949372900244984669693257023467564205187340502714890905035519427259458811120462564113092201608868649317211527), Fq(Q, 3406611662853814127786113851065530745281238435318274624083464800633557283975892620383255478512193840982660225352078)), Fq2(Q, Fq(Q, 388697824063855736407504039797555706903406557007213882575283590540658313187058383810581619903494077213681921072026), Fq(Q, 2188821117036473090306863511257078466600071573160786437200676554015732604233171021604611541676484354142303543932613))), Fq6(Q, Fq2(Q, Fq(Q, 3861414458804119210316118206909727663904313295943139140696265142392598974410573511459534353649263602481219596881538), Fq(Q, 3788539523192126396641343595812920650397377228079176168465995111835766947668715345466792578826531231220463949393885)), Fq2(Q, Fq(Q, 2186652069989931808536851300828601718784010391272574423441352797263388252376331140528042822640474348702895615183230), Fq(Q, 3711362310107983345238259528679290459280754138571767065382642964541445224244166193045529118168876233591474323948535)), Fq2(Q, Fq(Q, 3112573842602332282764711843427084912222351115390378573409555920376637023256323916379307634560281319877417551714499), Fq(Q, 1907695034053810922074508308768030442366395140723069658744157518574660003075822217443163281670081947693427608700410)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 396161667274950507585561902166368883051657512476655244387126442886647046202250508302105492204377657577670624819270), Fq(Q, 3849368591335503388044532343034301505908611466391971767392433108669278632712639509090447753654654253881929706255460)), Fq2(Q, Fq(Q, 2210614238363216085869776004014144766120000365676574121804883787517389670124284653602839156520475156339282854410958), Fq(Q, 411058276023165412891714901122768875166883274830174336382333311552741727669174231309602754483316106867044499028505)), Fq2(Q, Fq(Q, 2565550360631980238404797529449237232423202514917033062767958248507077347413172253520162202223899064675223742984643), Fq(Q, 3534987129329715286713065910644766113162794473336702655642862994389498193383166702313211789910407668648041648650354))), Fq6(Q, Fq2(Q, Fq(Q, 2039139531737834505516748281856462964847160022832712753046066565881509346634523324511576634660709922559495367749874), Fq(Q, 1035749237948456517930247969777398943558639958441081009285463348274941008844780043379510775852242855432027344783481)), Fq2(Q, Fq(Q, 2110911407512431513272141401594890852049768965448297791415407679453773945899850713476520079683452315640539307944709), Fq(Q, 1895187071172351114170533511450419459065563683372265775694036991957766812957135729406146751911882205187118838317967)), Fq2(Q, Fq(Q, 1721970406009300051265500728825238105210201295196757806442254071164886983494029191612788109615554896609153854340909), Fq(Q, 36161694336534996753761172048848290656097819394493369261261940307641938300601724420202985030218233796843010201655)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3987271041785576987156819481352825941440692198600617902798823449095197460402013016484271416158707080120631314480417), Fq(Q, 2776729915488145394056711049470400182077995689328648944410359059986324672577074840657808997778501050795190820606958)), Fq2(Q, Fq(Q, 3493609239809463884108420014760678258875864444762156220729334791949192306716829773858489914433858828771384864761517), Fq(Q, 2975084261891650312468328189890584835367741486628976605700272238655221534027769034647588884238275265078636612691993)), Fq2(Q, Fq(Q, 429834838441712923099153988637989333653566581422708507480922874446358517310416986854957493784784389315153151733883), Fq(Q, 2563513050972467588040666701170089811626492879694016691270477459298761483291322833039441631484712636046623692714038))), Fq6(Q, Fq2(Q, Fq(Q, 2178337731305636156302278233823440704670640637922942483088646902068972959418294803877405499124088174555608275224214), Fq(Q, 2320770189770805182850588644171877184079299083369160155018166030200985159745366319271715648581267719562361140553837)), Fq2(Q, Fq(Q, 542788359733740798014686940980188546986014036840294013896295824368656072995751525521240423428654632289086658390729), Fq(Q, 1624985402051977610032038235579164576826906729666454358822551808145046981190145716474352000397492821404674862807278)), Fq2(Q, Fq(Q, 1209474389426365882835120129324178884912205758135189301439528165097995571687710183279260333331926781846080927642971), Fq(Q, 3225523415577757521919247530733695434093263632809550282064651750361901445257799593066849177322805686995835777646513)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3912953593301214097359025577539250046153482475193812226238890530646088854489871769531875731315657768393838264598570), Fq(Q, 766853752077287394741786255013291168173020538982872649867985308154699263055973990323505296207412173774556996020997)), Fq2(Q, Fq(Q, 336766902551064861300404988913560173663735352420600248651892628618716616092901065963864485464361829201117519611141), Fq(Q, 3045835756314184253467168061316476261676797445286405133373549698750738936299150011745660623724304364502250326640361)), Fq2(Q, Fq(Q, 1065384600924786348744226516568337970624555816194946381255337140365166669391126451255365733943449236326892719992789), Fq(Q, 3867239695870667051332267574726964404538906549927040624562153856581592948671730518773064216520437627506826511474840))), Fq6(Q, Fq2(Q, Fq(Q, 797160670039151438586451329970099448563646755711813307324565904349838724153339934144939614101305546158205773572914), Fq(Q, 2446115015381270952990528802185810529358246227604473914977529929973843996081381943956783567669960234301664714238802)), Fq2(Q, Fq(Q, 2487021907267400460170723737459164580535212955543616163002679612651039141343410567919703629983335163885118564002976), Fq(Q, 92140707563947743754960112062448891078256917265592652251280840277116738354176281238472554441107362824728352743425)), Fq2(Q, Fq(Q, 1510162443067819623282979639926690130769269606621205962121434192404929805820249205474057273585417589428295394899215), Fq(Q, 1820789623873352745795643256502255046586077251506213577828394712659128427362803353433646202128805101972228002939560)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 3696939050214640878942517698992204503894075994311138655958352969015859391480559463133834152359806299200895552702652)), Fq2(Q, Fq(Q, 637352255315029000603021041094082358405682808777724021403458099509159722512664051423216221693162370559077743398031), Fq(Q, 1671653730598002979421090389176765740845891238811669446755831995894091866601563271702230089124611341834414944289678)), Fq2(Q, Fq(Q, 394600258265849729267691779025703822318975210409352238068792524268428810362149049045130711467841432158631938954810), Fq(Q, 3531566395136316456912922988984579298773391941894603487740670394723014418031141785708238128161108401053114913159089))), Fq6(Q, Fq2(Q, Fq(Q, 2088282883351950378857360647582914673245739570343171755063362104273384907022353180108182746758842668224222268373832), Fq(Q, 2802988375288461942537107743574149970292138786897393281664132196337636803119736703629406152259744535650806051892800)), Fq2(Q, Fq(Q, 2423605646281307449200219665135385212008608680566443096221040223961064180869378185109588341332253667690408532370597), Fq(Q, 1408618688575931886498556329177981398136128954736536610666102625689470101944795804028213540758791409366936729778780)), Fq2(Q, Fq(Q, 1356204092770041527163183772880066084612841715685056868829409157058020262626304984281296032609113840980609336058514), Fq(Q, 2725683217153809772471595304672449390506168598324573494693483370434184157317374968977493021147579583254321853889475)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 936531350876091663174734334137223384331190863981086930404093722616822472286503712220118481024606076749958901670050)), Fq2(Q, Fq(Q, 1165909593478083132603960090411008145563376902085578115889602981234361543831837177988386908536901340724402015264213), Fq(Q, 1604947141895703639844404653084137174798752733174887054818340666643384519704301305989593114219789596702158106844234)), Fq2(Q, Fq(Q, 1950737070182810225633431933653163288249072579608299524925760455644584256427479891186555882432166675322176774151553), Fq(Q, 1727084996644022361983993858153149462271101094832268265484077292818047802790868291825454639387497075684129878094370))), Fq6(Q, Fq2(Q, Fq(Q, 2698084927258314749415829368176336010925031958039466990631425550504433623192977671643069966562446730839717138974738), Fq(Q, 624752548968932282476297582106279142798881227387002568240034808033518832648934676610359104746360541150778087411406)), Fq2(Q, Fq(Q, 628817275752354953244286705871390066741181251083596246511522972216812750991653916574141635127420241959071202912352), Fq(Q, 994569717892120384008145873572522869520753996511753996961156556644249651815328601764815912663306272219736777503131)), Fq2(Q, Fq(Q, 916307697768258882806532807190834722795620844264013442417145616383736387613863559845949257197832052507458603671037), Fq(Q, 1966487565157922411124191109036623740983698509278931550457046121907531995407297049820587163126417285468786466957817)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 1402914476932624451105894320109148083831601750168764888084909204723234668546266387580695828366048839098555879041480)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))), Fq6(Q, Fq2(Q, Fq(Q, 3449178320241127375027640471993487456754722310771082857125189022652407194481988105060960385147377862807838430724168), Fq(Q, 904395074096090909610156560164341024991777001604239857943156173037125974845494403795312111701713396674737139825787)), Fq2(Q, Fq(Q, 1382932186525388172396322634386747153040790799479761894129108697948157120203172905347129479154287701170973501982570), Fq(Q, 2942825062588769343592764362038784533315197222402373269141164055008542422048618220546794022265904129190950403649399)), Fq2(Q, Fq(Q, 793330719429306259171810897788909023059158957880906092840810972649245747087198249150502935275196917452773820247622), Fq(Q, 1619325434596186913856122607358164655426966733512635784536944838972615984836752402361664120802013423853825628772586)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 936531350876091663174734334137223384331190863981086930404093722616822472286503712220118481024606076749958901670050)), Fq2(Q, Fq(Q, 1165909593478083132603960090411008145563376902085578115889602981234361543831837177988386908536901340724402015264213), Fq(Q, 1604947141895703639844404653084137174798752733174887054818340666643384519704301305989593114219789596702158106844234)), Fq2(Q, Fq(Q, 1950737070182810225633431933653163288249072579608299524925760455644584256427479891186555882432166675322176774151553), Fq(Q, 1727084996644022361983993858153149462271101094832268265484077292818047802790868291825454639387497075684129878094370))), Fq6(Q, Fq2(Q, Fq(Q, 2698084927258314749415829368176336010925031958039466990631425550504433623192977671643069966562446730839717138974738), Fq(Q, 624752548968932282476297582106279142798881227387002568240034808033518832648934676610359104746360541150778087411406)), Fq2(Q, Fq(Q, 628817275752354953244286705871390066741181251083596246511522972216812750991653916574141635127420241959071202912352), Fq(Q, 994569717892120384008145873572522869520753996511753996961156556644249651815328601764815912663306272219736777503131)), Fq2(Q, Fq(Q, 916307697768258882806532807190834722795620844264013442417145616383736387613863559845949257197832052507458603671037), Fq(Q, 1966487565157922411124191109036623740983698509278931550457046121907531995407297049820587163126417285468786466957817)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 1402914476932624451105894320109148083831601750168764888084909204723234668546266387580695828366048839098555879041480)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))), Fq6(Q, Fq2(Q, Fq(Q, 3449178320241127375027640471993487456754722310771082857125189022652407194481988105060960385147377862807838430724168), Fq(Q, 904395074096090909610156560164341024991777001604239857943156173037125974845494403795312111701713396674737139825787)), Fq2(Q, Fq(Q, 1382932186525388172396322634386747153040790799479761894129108697948157120203172905347129479154287701170973501982570), Fq(Q, 2942825062588769343592764362038784533315197222402373269141164055008542422048618220546794022265904129190950403649399)), Fq2(Q, Fq(Q, 793330719429306259171810897788909023059158957880906092840810972649245747087198249150502935275196917452773820247622), Fq(Q, 1619325434596186913856122607358164655426966733512635784536944838972615984836752402361664120802013423853825628772586)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 1402914476932624451105894320109148083831601750168764888084909204723234668546266387580695828366048839098555879041480)), Fq2(Q, Fq(Q, 3025615534041635407964757171460724992812700749001760838900398160010688002117382933424153748858351083898706678128970), Fq(Q, 1911537323963551679812762949384028000352787221979650085053632574281002291231803110270050758821325786116823311523108)), Fq2(Q, Fq(Q, 407399451870012083683635483127321612927875483799356719750075693635222944793896687323032178240563363494655551938363), Fq(Q, 3914616325351914410154597265030413499586198155550477007180472155138378382242092886607326019768681007509826148085680))), Fq6(Q, Fq2(Q, Fq(Q, 3449178320241127375027640471993487456754722310771082857125189022652407194481988105060960385147377862807838430724168), Fq(Q, 904395074096090909610156560164341024991777001604239857943156173037125974845494403795312111701713396674737139825787)), Fq2(Q, Fq(Q, 1382932186525388172396322634386747153040790799479761894129108697948157120203172905347129479154287701170973501982570), Fq(Q, 2942825062588769343592764362038784533315197222402373269141164055008542422048618220546794022265904129190950403649399)), Fq2(Q, Fq(Q, 793330719429306259171810897788909023059158957880906092840810972649245747087198249150502935275196917452773820247622), Fq(Q, 1619325434596186913856122607358164655426966733512635784536944838972615984836752402361664120802013423853825628772586)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3203268807679035176419337441709869273631721746130285196205542988353532127532646997294806835955494363414212437115736), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3338723711732528789888203215627218468549561079685337896247960686310866875822453417184057381522849917103590772946288), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3914959126721879805715423390323602300656452432943609017855480503645017380689742661469622255942562168114734584186435), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2803079129366436200241890865144285907163530450253674726742299036163992683861798636079722721395600856277215936751930), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3379314544355787216069111039840669739270421803511945848349818853498143188729087880365287595815313107288359747992077), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3514769448409280829537976813758018934188261137066998548392236551455477937018894300254538141382668660977738083822629), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 73511129852917215430117665442932969686381201097577315366839676860858736702829118135516255560032984078494668357975), Fq(Q, 3217848190141668374831050318675921189559767594302763425559558568998921509281703741758475858778889051582506780581080)), Fq2(Q, Fq(Q, 648450960364454758515914815835903039336343806164342630155559757661414525783569361992487943765558469720311290428420), Fq(Q, 3015304493459735433377319464893524841717500395868238861827520638332311194267791553303700008365643552988570858448997)), Fq2(Q, Fq(Q, 3353023802015658049589427757451615465298434891109233178726407057120107366770851277096812883696491540637124752075715), Fq(Q, 3066165380622691919524406479715957105738336813801915492884296116324404036017421992646199250431188674757127091625453))), Fq6(Q, Fq2(Q, Fq(Q, 2022227706074699853942860980980965702911640417445928868529887075099633478896340907130938954617860444134684854079029), Fq(Q, 587569973055516418736471314823846485507530964370728877067483252500433621295819923802191212142581265111614646308171)), Fq2(Q, Fq(Q, 2768213778304807774396097579944486333205353999806090711435600353611238593874865978990004455300088219225784260508612), Fq(Q, 1927804158373970424584228504806097560206133403804657223835938773648542218638383092145225161996246232754826376044288)), Fq2(Q, Fq(Q, 1896108359745949045637950034750551147872241570254412898690153055253906274211422538378139476236333836742410451039737), Fq(Q, 2788893794845394526572682883010998334114468176496236310112597057269927847871142584100953389092421163671403096586918)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1711797489568616583434146621422538673233444794009731352316131919899927017977837896877331399843341475889254457279480), Fq(Q, 471446243058341788074854684406829851472774030969909403308522590265931681166167445858169651239808292445447403288522)), Fq2(Q, Fq(Q, 729440306421424633239374882471503492015561566074308487082857102158813556080028353083322691361930976604376117874449), Fq(Q, 1157192852418872920324298751084955842491726587077604837263193704657814123508299544930797055379199846575569669171380)), Fq2(Q, Fq(Q, 725803966212282170013186464116542010184584534048041708686873699380470487521999269593653944547524803176109678632307), Fq(Q, 1902665537993573977949691355326435078194224863841030583720255078289767766095489365822701665854659899007485034939364))), Fq6(Q, Fq2(Q, Fq(Q, 2629197664342880097317981636224028124791674695860937355131103742188953731261486397245955587634849512134849304850545), Fq(Q, 1040515771278508089172366180809407062202732852454274616739488674180480857990214524319457504885974092741059715113277)), Fq2(Q, Fq(Q, 3777851139607335756999808330292650641002982624213598168737670307818216759010257816740196908354352622393050737048542), Fq(Q, 930155725386272833108078976483035588374315902155468236808004966173660406447694141537947383217176558497449962056409)), Fq2(Q, Fq(Q, 999241162604116828087758405056591276299933292366745420419489921679333261674910558141848183838205443604408954682206), Fq(Q, 1234321521593926171258701242610494687194871663120247083670404550008261261296408662022585959070886821776566643356186)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 606412287420852147510355256915883920871639472600949273462625871567737033901651002715167115631897903830887166236977), Fq(Q, 1741619805403384982690206144538973087219157386081746798900957611916784699528392231186399291491208822570456705720388)), Fq2(Q, Fq(Q, 3076807681008271625043415671445398095151436460913072009050198674849051753435525569856280836109907522679230655841547), Fq(Q, 2864032372821682924490620529894430858550749040263777194864479957344961807767922985588311953522357769772134085380338)), Fq2(Q, Fq(Q, 2005753039711622712932846010240744946574421594398237804801392894015681915412547622907416977014337997609727901324999), Fq(Q, 3245286049312428176470274772357156132621940931691055024949253504884096010168429627871342059429405001708211071525550))), Fq6(Q, Fq2(Q, Fq(Q, 2269666334741705803158816806429709681585733115266390187794882516838508844381819908447847437695994127686736313374021), Fq(Q, 2685404935447186378355853309553634680946235441392172180994867252346339883087277635896719374558598597027779574516915)), Fq2(Q, Fq(Q, 1089772990752450921967262423392786697272214909732768882118906447648191735244756435518845748772594745967873783724993), Fq(Q, 2308740383891877734760531870900667487634860576552918327246529289269889417182489016190700278921322401006315018105049)), Fq2(Q, Fq(Q, 3380265326495454669560198913273128387902518468326457436206649222501678936096778058775972022261995575751959765115125), Fq(Q, 2324148087710636709180856299879520477982554596613057522702046706490894515783848104111097123308626920324618542975230)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 396161667274950507585561902166368883051657512476655244387126442886647046202250508302105492204377657577670624819270), Fq(Q, 52930723237667825049556470355175294198846271930763896265757981729563840410141655871514462960104578015765274800299)), Fq2(Q, Fq(Q, 218613779386927984165092970888435879681368550902167687644844810137606354633464253735407524320905692260476222463449), Fq(Q, 3688249817760281980099858848215525530252744264791767910322854480130050687126867510770980142095062711274245825293594)), Fq2(Q, Fq(Q, 330319267845442341048238175987086953151831777504293846939455405092579456621517750586438686648404174676784594304769), Fq(Q, 1952383002890640248145425256672540642509416015973749316254547240428837398470639919699709018954754525497727741665516))), Fq6(Q, Fq2(Q, Fq(Q, 2167318861400647582321451080893854479548259121244663954276129663747847251373972075889192562472089421946065330175416), Fq(Q, 2109646814254834265503842371667616382449562161407498108483324612821536203682216527485451316630368213935365567853418)), Fq2(Q, Fq(Q, 1680329233845805839590908579252641970606029439931694662597022249438473326339585175485958845811419000023333396922155), Fq(Q, 3997222771347165222103833925279282951552051717349867932157471812916106994961522360609942672533955905978921601526530)), Fq2(Q, Fq(Q, 1353304109578337174030216390536013133960442927366134207683594581751578628460260292956006209044195831439710233640708), Fq(Q, 3882303384923445938871245183837764358039007107301301332403814190115684671641850679393803949835893335032663385609846)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3987271041785576987156819481352825941440692198600617902798823449095197460402013016484271416158707080120631314480417), Fq(Q, 1451447606850767823931803186790626082300103145901471739736339850597300526233711720200504896822585624208292555812267)), Fq2(Q, Fq(Q, 2083939589504229557718641452826417580382364157512587211696764377456060647194363246381895693176726164359656652136163), Fq(Q, 68554195112659185237723238677278880268815275810733384169175739373740063720020962421003169861806465266447935031180)), Fq2(Q, Fq(Q, 287014780581083736010722440074311008835565268345841577823686207147926833036731994774756830868590109862305057563289), Fq(Q, 2702707917959160692485226403260115201064572576695179323822128694928141074836036215024635998974315824003356048811562))), Fq6(Q, Fq2(Q, Fq(Q, 3333999872585018049282569279754532356849477835386177645434057101863964194849701890432790393017942900353462190212138), Fq(Q, 3926012755568246956346973168281276711467192354465310862679901845937045300138286512156067421920404685788325544989330)), Fq2(Q, Fq(Q, 3543670528059952507733528827576659902728716513091679050174278373167916862672070445792452479305789316010310344441074), Fq(Q, 3604091718291839835610572489312641774777179006622343766868731056800723677627206838609273238150601846018530992684904)), Fq2(Q, Fq(Q, 2469111569190687339668036648463152685308481527105315738937060558314946426732341023680180024831970215918537730250895), Fq(Q, 3749425569921527535109289011828810705539845021319570255834252911415784804677686605808622306142053766386225882425145)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3912953593301214097359025577539250046153482475193812226238890530646088854489871769531875731315657768393838264598570), Fq(Q, 1895502265992617591133440933268745380714757742747382507235523258315706582797346679323945331080532481666115142704595)), Fq2(Q, Fq(Q, 854317984988623878686582323441538899369901455121944530131926012396634702738439706497324201714133834212983336552433), Fq(Q, 3425828189172673707380466481072798951925184856853101272696413640206410580008423323883511141430531129411092377238228)), Fq2(Q, Fq(Q, 2048501108463182499571485371690131654109054419050170973675210067355142906503509266317865747554779144602824919785891), Fq(Q, 1040562106624918949271461024610451581377342500035142076974648199330302669457775857339982505682071656262490983491607))), Fq6(Q, Fq2(Q, Fq(Q, 2011214420968354759424761927794179572292610829538056201711244400729159325473807300063290716040464212350956598695922), Fq(Q, 1293373522227283195504704162040835100797120952046376500000655379825343477503278801576768198192580686125353069111539)), Fq2(Q, Fq(Q, 511807103252679819667403485166950372536927908199015542189285427298266436764448254214367381635299061360415290871172), Fq(Q, 2931657343850675017132024619069329345253895812489910114468577342855040229154831532240713063197514317547336266128347)), Fq2(Q, Fq(Q, 413854374903495190879141969380936901585866389956679523526770571287291368766540837258973537520722086765171590495611), Fq(Q, 656294174566904019364891666453659964701920935868928366910912167004682376216260856137442451541129368438341838620336)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 535644582366092589646312350482932561386030629431663169505661650146874191960654781104334660127249060826374836194358), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 400189678312598976177446576565583366468191295876610469463243952189539443670848361215084114559893507136996500363806), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3826363818544915353768016227605103690918182762557347233187782270979420589294396981372206869269196920163746961683446), Fq(Q, 719936726266609892468829116784788091515764244163682225890307524118268669350077132534415577698333663099991640779013)), Fq2(Q, Fq(Q, 895418471972553928582424092678902649541304654052531301526079650812113560742609020075086361867606819230011065302640), Fq(Q, 1825301891341845566795444657204760920574811982244589716799387329275125855014582685048420244828461144221054021006094)), Fq2(Q, Fq(Q, 3945912471657267340996760768602905845043039506723480407043673857553671784754243555458904029837244162539238606215682), Fq(Q, 3906777015499556892858288108956164227174697153352886494623271068924071362901970788278589186822464048017497086441167))), Fq6(Q, Fq2(Q, Fq(Q, 241743928061974246860565568788973125983625913530550351094003997999458982904429311967315773544539674751462953432293), Fq(Q, 3691303001488679538760109725195658647129174042226558785986176356591892000465896904645896825599929321249992163675076)), Fq2(Q, Fq(Q, 1846364627773723506480934494723774593933764743061425689745552020480937809614603672374077732266890023016081802072248), Fq(Q, 1522478720704862784105834258898359696057275528034717073579579307678685848205502409784004591933932857548395379393162)), Fq2(Q, Fq(Q, 2704873850233174356123883442387271698512060568953935925971289745630710408835988814040063183899634953673572212871775), Fq(Q, 188601387505765944944280867573880500929968744554424703825224228809073700479939521115019093038170531749411927823260)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3866954651168173779948924051818554961639043486383955185289640438166696902201031444553437083561660110348515936729235), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3290719236178822764121703877122171129532152133125684063682120620832546397333742200267872209141947859337372125489088), Fq(Q, 305470505007026514475272126743699652662806825627869229373705167108172259010278401308853476769209364836998719857135)), Fq2(Q, Fq(Q, 3365057299906638392814768784641821798151200011161283863928600036614871927978173813019471407435853293478816529161756), Fq(Q, 2330755824623664413996699436559138415710991581127338438576226140229939783889274592740457540004404322203479328270109)), Fq2(Q, Fq(Q, 3607809296955817664150098046710200334237907609529655647263265611855602840128688815397556917661174231879262333604977), Fq(Q, 470843160085350936504866836751324857783490878044404397591387741401017232459696078734449500967907262984779359400698))), Fq6(Q, Fq2(Q, Fq(Q, 1914126671869717014560429178152989483311143249595836130268696031850646743468484684334504882370172995813672004185955), Fq(Q, 1199421179933205450880682082161754186264744033041614603667925939786394847371101160813281476869271128387088220666987)), Fq2(Q, Fq(Q, 1578803908940359944217570160600518944548274139372564789111017912162967469621459679333099287796761996347485740189190), Fq(Q, 2593790866645735506919233496557922758420753865202471274665955510434561548546042060414474088370224254670957542781007)), Fq2(Q, Fq(Q, 2646205462451625866254606052855838071944041104253951016502648979066011387864532880161391596519901823057284936501273), Fq(Q, 1276726338067857620946194521063454766050714221614434390638574765689847493173462895465194607981436080783572418670312)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 3426174140232316377590569651039520324449991466680736763724538318789881145623548620157122754709303413026750461319640), Fq(Q, 3065878204345575730243055491598680772225691955957920954927964413507209178204334152222569148104409587287935370889737)), Fq2(Q, Fq(Q, 2836499961743584260813829735324896010993505917853429769442455154889670106659000686454300720592114323313492257295574), Fq(Q, 2397462413325963753573385172651766981758130086764120830513717469480647130786536558453094514909226067335736165715553)), Fq2(Q, Fq(Q, 2051672485038857167784357892082740868307810240330708360406297680479447394063357973256131746696848988715717498408234), Fq(Q, 2275324558577645031433795967582754694285781725106739619847980843305983847699969572617232989741518588353764394465417))), Fq6(Q, Fq2(Q, Fq(Q, 1304324627963352644001960457559568145631850861899540894700632585619598027297860192799617662566568933198177133585049), Fq(Q, 3377657006252735110941492243629625013758001592552005317092023328090512817841903187832328524382655122887116185148381)), Fq2(Q, Fq(Q, 3373592279469312440173503119864514089815701568855411638820535163907218899499183947868545994001595422078823069647435), Fq(Q, 3007839837329547009409643952163381287036128823427253888370901579479781998675509262677871716465709391818157495056656)), Fq2(Q, Fq(Q, 3086101857453408510611257018545069433761261975674994442914912519740295262876974304596738371931183611530435668888750), Fq(Q, 2035921990063744982293598716699280415573184310660076334875012014216499655083540814622100466002598378569107805601970)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2132952860199103510384964929639503239048006632158033702476455816873828490744186975243116881087643951917600635904740), Fq(Q, 3282472828955057500948960708951116065041118575775325659441750612005762981140760731908272051430682000937902631780774)), Fq2(Q, Fq(Q, 3106991083249113464835365733057001507015578165886476583805978485311918089748228844367601267261408844807883207257147), Fq(Q, 2177107663879821826622345168531143235982070837694418168532670806848905795476255179394267384300554519816840251553693)), Fq2(Q, Fq(Q, 56497083564400052421029057132998311513843313215527478288384278570359865736594308983783599291771501498655666344105), Fq(Q, 95632539722110500559501716779739929382185666586121390708787067199960287588867076164098442306551616020397186118620))), Fq6(Q, Fq2(Q, Fq(Q, 3760665627159693146557224256946931030573256906408457534238054138124572667586408552475371855584475989286431319127494), Fq(Q, 311106553732987854657680100540245509427708777712449099345881779532139650024940959796790803529086342787902108884711)), Fq2(Q, Fq(Q, 2156044927447943886936855331012129562623118076877582195586506115643093840876234192068609896862125641021812470487539), Fq(Q, 2479930834516804609311955566837544460499607291904290811752478828445345802285335454658683037195082806489498893166625)), Fq2(Q, Fq(Q, 1297535704988493037293906383348632458044822250985071959360768390493321241654849050402624445229380710364322059688012), Fq(Q, 3813808167715901448473508958162023655626914075384583181506833907314957950010898343327668536090845132288482344736527)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2668597442565196100031277280122435800434037261589696871982117467020702682704841756347451541214893012743975472099098), Fq(Q, 3696939050214640878942517698992204503894075994311138655958352969015859391480559463133834152359806299200895552702652)), Fq2(Q, Fq(Q, 637352255315029000603021041094082358405682808777724021403458099509159722512664051423216221693162370559077743398031), Fq(Q, 1671653730598002979421090389176765740845891238811669446755831995894091866601563271702230089124611341834414944289678)), Fq2(Q, Fq(Q, 394600258265849729267691779025703822318975210409352238068792524268428810362149049045130711467841432158631938954810), Fq(Q, 3531566395136316456912922988984579298773391941894603487740670394723014418031141785708238128161108401053114913159089))), Fq6(Q, Fq2(Q, Fq(Q, 2088282883351950378857360647582914673245739570343171755063362104273384907022353180108182746758842668224222268373832), Fq(Q, 2802988375288461942537107743574149970292138786897393281664132196337636803119736703629406152259744535650806051892800)), Fq2(Q, Fq(Q, 2423605646281307449200219665135385212008608680566443096221040223961064180869378185109588341332253667690408532370597), Fq(Q, 1408618688575931886498556329177981398136128954736536610666102625689470101944795804028213540758791409366936729778780)), Fq2(Q, Fq(Q, 1356204092770041527163183772880066084612841715685056868829409157058020262626304984281296032609113840980609336058514), Fq(Q, 2725683217153809772471595304672449390506168598324573494693483370434184157317374968977493021147579583254321853889475)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 1351398306883628755215465511955693876201877731562088054585223236949031293303677580826327852007868063307349962557870), Fq(Q, 2670743550223635222418040350728334860206009328614738766490519785496371217882724674678021929168548762357693705729297)), Fq2(Q, Fq(Q, 310657014464282863809708697873498773952271103848252588079682506341932583137104750820725655810549936197288031544524), Fq(Q, 516681422128338929140264950640295171894254181820114366623190956277469170191367040627603655150040362048145725512966)), Fq2(Q, Fq(Q, 2851411223454921287571379391642475653952219847739613971800217269132388847064152522022427819171797915908108043211208), Fq(Q, 2037738257017577728593024301123549657297234737110384023575458121750762662398278023788147582071732333231834596474745))), Fq6(Q, Fq2(Q, Fq(Q, 2376965065031368185280992125134462337383843179507578891049895407865578859606348517695394702977258704600983048069245), Fq(Q, 2820292038394142094116695690402116976606214137135591252990928338131219607415496282165767962191130767836359825741776)), Fq2(Q, Fq(Q, 3941313456076941665491938944202163793880772249680214374097763200784902581432048838519555770201078756491753493469558), Fq(Q, 3616109058633880794527467398032171877808792499351043837154881457252624424009997488447720648581061262504137192388361)), Fq2(Q, Fq(Q, 2040868407079261116462591624833926922397483386319536456552488883871007161262114501394591332965854366000433202789870), Fq(Q, 2385992350270847786913267471286508208352436799011856721746481700632010926617038956302362438164421888576857632590219)))),
    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 2297448075580941631616798512060971805515281098877869559056200546935059688596422906262292792981303514778580917299395), Fq(Q, 1412570569447055455513158051426363980637125600660647392398427214886225243916660713034456429604703768364561800981904)), Fq2(Q, Fq(Q, 1812121937110865506463327171214379420900612161637082206737731229087555366228196221061621324764224814777074599838735), Fq(Q, 3860540617160575082615111531454806213573971004697797573891658539958537229904685239016213271758120704573247254294827)), Fq2(Q, Fq(Q, 3692212393150230889858017496792622287703590342989964188011901488283532088339929400124348582625395918337585010251763), Fq(Q, 2051355843979387613097946019521578485911286335567764699906303579573342925077941545607974046470567413703254245359588))), Fq6(Q, Fq2(Q, Fq(Q, 1883835830289439891137016135763360378638832815470837742966723726139021222639332222519628929037449422911437225724173), Fq(Q, 1228923667431175017602780230627622395421238266085757960767033478425227900349677514194194828673529963725955150068116)), Fq2(Q, Fq(Q, 2041762675798130006178353239859286195373149513274664927221503884033204354772672889816081666091260911834281026743038), Fq(Q, 2965379145724652927074923193949331421803151758299759400053094627726248635045306663362945301705884156780207825975906)), Fq2(Q, Fq(Q, 2541158639561818348668369920133815030566257472997823087714929771408273080117052578866587872240361568770426754670568), Fq(Q, 1872283996183916295677310656588853619751379095129282133293267189734212462424346268237827061780698932077526240452973)))),

    Fq12(Q, Fq6(Q, Fq2(Q, Fq(Q, 0), Fq(Q, 0)), Fq2(Q, Fq(Q, 0), Fq(Q, 0)), Fq2(Q, Fq(Q, 0), Fq(Q, 0))), Fq6(Q, Fq2(Q, Fq(Q, 0), Fq(Q, 0)), Fq2(Q, Fq(Q, 0), Fq(Q, 0)), Fq2(Q, Fq(Q, 0), Fq(Q, 0))))
]
