ZERO = b'\x00'

HEADER_SIZE_BYTES = 4
HEADER_SIZE_OFFSET = 14
HEADER_SIZE_PLACEHOLDER = ZERO*HEADER_SIZE_BYTES

PIXELS_WIDTH_BYTES = 4
PIXELS_WIDTH_OFFSET = 18
PIXELS_WIDTH_PLACEHOLDER = ZERO*PIXELS_WIDTH_BYTES

PIXELS_HEIGHT_BYTES = 4
PIXELS_HEIGHT_OFFSET = 22
PIXELS_HEIGHT_PLACEHOLDER = ZERO*PIXELS_HEIGHT_BYTES

NUMBER_OF_COLOR_PLANES_BYTES = 2
NUMBER_OF_COLOR_PLANES_OFFSET = 26
NUMBER_OF_COLOR_PLANES_PLACEHOLDER = ZERO*NUMBER_OF_COLOR_PLANES_BYTES

PIXEL_DEPTH_BYTES = 2
PIXEL_DEPTH_OFFSET = 28
PIXEL_DEPTH_PLACEHOLDER = ZERO*PIXEL_DEPTH_BYTES

BI_RGB_FLAG_VALUE = ZERO
COMPRESSION_METHOD_FLAG_BYTES = 4
COMPRESSION_METHOD_FLAG_OFFSET = 30

# This is not needed when no compression is used.
# Zero is just a dummy value.
IMAGE_SIZE_BYTES = 4
IMAGE_SIZE_OFFSET = 34

# It appears that DPI is not structurally important and usually ignored.
# Setting to an arbitrary value of 99 for now.
HORIZONTAL_PIXEL_PER_METER_BYTES = 4
HORIZONTAL_PIXEL_PER_METER_OFFSET = 38
VERTICAL_PIXEL_PER_METER_BYTES = 4
VERTICAL_PIXEL_PER_METER_OFFSET = 42

NUMBER_OF_COLORS_BYTES = 4
NUMBER_OF_COLORS_OFFSET = 46

# Generally ignored. A value of Zero indicates that every color is important.
IMPORTANT_COLORS_BYTES = 4
IMPORTANT_COLORS_OFFSET = 50

BMP_INFO_HEADER_SIZE = HEADER_SIZE_BYTES + PIXELS_WIDTH_BYTES + PIXELS_HEIGHT_BYTES + NUMBER_OF_COLOR_PLANES_BYTES + PIXEL_DEPTH_BYTES + COMPRESSION_METHOD_FLAG_BYTES + IMAGE_SIZE_BYTES + HORIZONTAL_PIXEL_PER_METER_BYTES + VERTICAL_PIXEL_PER_METER_BYTES + NUMBER_OF_COLORS_BYTES + IMPORTANT_COLORS_BYTES
