from collections.abc import Mapping
from os import PathLike
from typing import Any, Dict, Generator, List, Optional, Tuple, Union

class Box(dict):
    def __new__(
        cls: Any,
        *args: Any,
        default_box: bool = ...,
        default_box_attr: Any = ...,
        default_box_none_transform: bool = ...,
        default_box_create_on_get: bool = ...,
        frozen_box: bool = ...,
        camel_killer_box: bool = ...,
        conversion_box: bool = ...,
        modify_tuples_box: bool = ...,
        box_safe_prefix: str = ...,
        box_duplicates: str = ...,
        box_intact_types: Union[Tuple, List] = ...,
        box_recast: Dict = ...,
        box_dots: bool = ...,
        box_class: Union[Dict, Box] = ...,
        **kwargs: Any,
    ) -> Any: ...
    def __init__(
        self,
        *args: Any,
        default_box: bool = ...,
        default_box_attr: Any = ...,
        default_box_none_transform: bool = ...,
        default_box_create_on_get: bool = ...,
        frozen_box: bool = ...,
        camel_killer_box: bool = ...,
        conversion_box: bool = ...,
        modify_tuples_box: bool = ...,
        box_safe_prefix: str = ...,
        box_duplicates: str = ...,
        box_intact_types: Union[Tuple, List] = ...,
        box_recast: Dict = ...,
        box_dots: bool = ...,
        box_class: Union[Dict, Box] = ...,
        **kwargs: Any,
    ) -> None: ...
    def __add__(self, other: Mapping[Any, Any]) -> Any: ...
    def __radd__(self, other: Mapping[Any, Any]) -> Any: ...
    def __iadd__(self, other: Mapping[Any, Any]) -> Any: ...
    def __or__(self, other: Mapping[Any, Any]) -> Any: ...
    def __ror__(self, other: Mapping[Any, Any]) -> Any: ...
    def __ior__(self, other: Mapping[Any, Any]) -> Any: ...  # type: ignore[override]
    def __sub__(self, other: Mapping[Any, Any]) -> Any: ...
    def __hash__(self) -> Any: ...  # type: ignore[override]
    def __dir__(self): ...
    def keys(self, dotted: Union[bool] = ...) -> Any: ...
    def items(self, dotted: Union[bool] = ...) -> Any: ...
    def get(self, key: Any, default: Any = ...): ...
    def copy(self) -> Box: ...
    def __copy__(self) -> Box: ...
    def __deepcopy__(self, memodict: Any = ...) -> Box: ...
    def __getitem__(self, item: Any, _ignore_default: bool = ...) -> Any: ...
    def __getattr__(self, item: Any) -> Any: ...
    def __setitem__(self, key: Any, value: Any): ...
    def __setattr__(self, key: Any, value: Any): ...
    def __delitem__(self, key: Any): ...
    def __delattr__(self, item: Any) -> None: ...
    def pop(self, key: Any, *args: Any): ...
    def clear(self) -> None: ...
    def popitem(self): ...
    def __iter__(self) -> Generator: ...
    def __reversed__(self) -> Generator: ...
    def to_dict(self) -> Dict: ...
    def update(self, __m: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def merge_update(self, __m: Optional[Any] = ..., **kwargs: Any) -> None: ...
    def setdefault(self, item: Any, default: Optional[Any] = ...): ...
    def to_json(
        self, filename: Union[str, PathLike] = ..., encoding: str = ..., errors: str = ..., **json_kwargs: Any
    ) -> Any: ...
    @classmethod
    def from_json(
        cls: Any,
        json_string: str = ...,
        filename: Union[str, PathLike] = ...,
        encoding: str = ...,
        errors: str = ...,
        **kwargs: Any,
    ) -> Box: ...
    def to_yaml(
        self,
        filename: Union[str, PathLike] = ...,
        default_flow_style: bool = ...,
        encoding: str = ...,
        errors: str = ...,
        **yaml_kwargs: Any,
    ) -> Any: ...
    @classmethod
    def from_yaml(
        cls: Any,
        yaml_string: str = ...,
        filename: Union[str, PathLike] = ...,
        encoding: str = ...,
        errors: str = ...,
        **kwargs: Any,
    ) -> Box: ...
    def to_toml(self, filename: Union[str, PathLike] = ..., encoding: str = ..., errors: str = ...) -> Any: ...
    @classmethod
    def from_toml(
        cls: Any,
        toml_string: str = ...,
        filename: Union[str, PathLike] = ...,
        encoding: str = ...,
        errors: str = ...,
        **kwargs: Any,
    ) -> Box: ...
    def to_msgpack(self, filename: Union[str, PathLike] = ..., **kwargs: Any) -> Any: ...
    @classmethod
    def from_msgpack(
        cls: Any, msgpack_bytes: bytes = ..., filename: Union[str, PathLike] = ..., **kwargs: Any
    ) -> Box: ...
