import box
from box.converters import (
    BOX_PARAMETERS,
    msgpack_available,
    yaml_available,
    toml_read_library,
    toml_write_library,
)
from box.exceptions import BoxError as BoxError, BoxTypeError as BoxTypeError
from os import PathLike as PathLike
from typing import Any, Iterable, Optional, Type, Union

class BoxList(list):
    def __new__(cls, *args: Any, **kwargs: Any): ...
    box_options: Any = ...
    box_org_ref: Any = ...
    def __init__(self, iterable: Iterable = ..., box_class: Type[box.Box] = ..., **box_options: Any) -> None: ...
    def __getitem__(self, item: Any): ...
    def __delitem__(self, key: Any): ...
    def __setitem__(self, key: Any, value: Any): ...
    def append(self, p_object: Any) -> None: ...
    def extend(self, iterable: Any) -> None: ...
    def insert(self, index: Any, p_object: Any) -> None: ...
    def __copy__(self): ...
    def __deepcopy__(self, memo: Optional[Any] = ...): ...
    def __hash__(self) -> Any: ...  # type: ignore[override]
    def to_list(self): ...
    def to_json(
        self,
        filename: Union[str, PathLike] = ...,
        encoding: str = ...,
        errors: str = ...,
        multiline: bool = ...,
        **json_kwargs: Any,
    ) -> Any: ...
    @classmethod
    def from_json(
        cls: Any,
        json_string: str = ...,
        filename: Union[str, PathLike] = ...,
        encoding: str = ...,
        errors: str = ...,
        multiline: bool = ...,
        **kwargs: Any,
    ) -> Any: ...
    def to_yaml(
        self,
        filename: Union[str, PathLike] = ...,
        default_flow_style: bool = ...,
        encoding: str = ...,
        errors: str = ...,
        **yaml_kwargs: Any,
    ) -> Any: ...
    @classmethod
    def from_yaml(
        cls: Any,
        yaml_string: str = ...,
        filename: Union[str, PathLike] = ...,
        encoding: str = ...,
        errors: str = ...,
        **kwargs: Any,
    ) -> Any: ...
    def to_toml(
        self, filename: Union[str, PathLike] = ..., key_name: str = ..., encoding: str = ..., errors: str = ...
    ) -> Any: ...
    @classmethod
    def from_toml(
        cls: Any,
        toml_string: str = ...,
        filename: Union[str, PathLike] = ...,
        key_name: str = ...,
        encoding: str = ...,
        errors: str = ...,
        **kwargs: Any,
    ) -> Any: ...
    def to_msgpack(self, filename: Union[str, PathLike] = ..., **kwargs: Any) -> Any: ...
    @classmethod
    def from_msgpack(
        cls: Any, msgpack_bytes: bytes = ..., filename: Union[str, PathLike] = ..., **kwargs: Any
    ) -> Any: ...
    def to_csv(self, filename: Union[str, PathLike] = ..., encoding: str = ..., errors: str = ...) -> Any: ...
    @classmethod
    def from_csv(
        cls: Any, csv_string: str = ..., filename: Union[str, PathLike] = ..., encoding: str = ..., errors: str = ...
    ) -> Any: ...
    def _dotted_helper(self) -> Any: ...
