from __future__ import annotations

from datetime import date, datetime, time

ValueT = int | float | str | bool | time | date | datetime

class CalamineSheet:
    name: str
    @property
    def height(self) -> int: ...
    @property
    def width(self) -> int: ...
    @property
    def total_height(self) -> int: ...
    @property
    def total_width(self) -> int: ...
    @property
    def start(self) -> tuple[int, int] | None: ...
    @property
    def end(self) -> tuple[int, int] | None: ...
    def to_python(self, skip_empty_area: bool = True) -> list[list[ValueT]]: ...

class CalamineReader:
    sheet_names: list[str]
    @classmethod
    def from_path(cls, path: str) -> "CalamineReader": ...
    def get_sheet_by_name(self, name: str) -> CalamineSheet: ...
    def get_sheet_by_index(self, index: int) -> CalamineSheet: ...

def get_sheet_data(
    path: str, sheet: int, skip_empty_area: bool = True
) -> list[list[ValueT]]: ...
def get_sheet_names(path: str) -> list[str]: ...

class CalamineError(Exception): ...
