from canaerospace.datatypes import DataType
from canaerospace.units import unit_map as units


#  @TODO Replace the norms unit with the correct unit per parameter
def get_aircraft_engine_parameters():
    """Aircraft Engine 5.3"""
    return [
        {"name": "engine_1_n1_ecs_channel_a", "can_id": 500,
            "data_type": DataType.FLOAT, "unit": units.get("rpms")},
        {"name": "engine_2_n1_ecs_channel_a", "can_id": 501,
            "data_type": DataType.FLOAT, "unit": units.get("rpms")},
        {"name": "engine_3_n1_ecs_channel_a", "can_id": 502,
            "data_type": DataType.FLOAT, "unit": units.get("rpms")},
        {"name": "engine_4_n1_ecs_channel_a", "can_id": 503,
            "data_type": DataType.FLOAT, "unit": units.get("rpms")},

        {"name": "engine_1_n2_ecs_channel_a", "can_id": 504,
            "data_type": DataType.FLOAT, "unit": units.get("rpms")},
        {"name": "engine_2_n2_ecs_channel_a", "can_id": 505,
            "data_type": DataType.FLOAT, "unit": units.get("rpms")},
        {"name": "engine_3_n2_ecs_channel_a", "can_id": 506,
            "data_type": DataType.FLOAT, "unit": units.get("rpms")},
        {"name": "engine_4_n2_ecs_channel_a", "can_id": 507,
            "data_type": DataType.FLOAT, "unit": units.get("rpms")},

        {"name": "engine_1_torque_ecs_channel_a", "can_id": 508, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine_2_torque_ecs_channel_a", "can_id": 509, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine_3_torque_ecs_channel_a", "can_id": 510, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine_4_torque_ecs_channel_a", "can_id": 511, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},

        {"name": "engine_1_turbine_inlet_temperature_ecs_channel_a", "can_id": 512, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_2_turbine_inlet_temperature_ecs_channel_a", "can_id": 513, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_3_turbine_inlet_temperature_ecs_channel_a", "can_id": 514, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_4_turbine_inlet_temperature_ecs_channel_a", "can_id": 515, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},

        {"name": "engine_1_inter_turbine_temperature_ecs_channel_a", "can_id": 516, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_2_inter_turbine_temperature_ecs_channel_a", "can_id": 517, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_3_inter_turbine_temperature_ecs_channel_a", "can_id": 518, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_4_inter_turbine_temperature_ecs_channel_a", "can_id": 519, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},

        {"name": "engine_1_turbine_outlet_temperature_ecs_channel_a", "can_id": 520, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_2_turbine_outlet_temperature_ecs_channel_a", "can_id": 521, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_3_turbine_outlet_temperature_ecs_channel_a", "can_id": 522, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_4_turbine_outlet_temperature_ecs_channel_a", "can_id": 523, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},

        {"name": "engine_1_fuel_flow_rate_ecs_channel_a", "can_id": 524,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "engine_2_fuel_flow_rate_ecs_channel_a", "can_id": 525,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "engine_3_fuel_flow_rate_ecs_channel_a", "can_id": 526,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "engine_4_fuel_flow_rate_ecs_channel_a", "can_id": 527,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},

        {"name": "engine_1_manifold_pressure_ecs_channel_a", "can_id": 528, "data_type": DataType.FLOAT,
         "unit": units.get("hpa")},
        {"name": "engine_2_manifold_pressure_ecs_channel_a", "can_id": 529, "data_type": DataType.FLOAT,
         "unit": units.get("hpa")},
        {"name": "engine_3_manifold_pressure_ecs_channel_a", "can_id": 530, "data_type": DataType.FLOAT,
         "unit": units.get("hpa")},
        {"name": "engine_4_manifold_pressure_ecs_channel_a", "can_id": 531, "data_type": DataType.FLOAT,
         "unit": units.get("hpa")},

        {"name": "engine_1_oil_pressure_ecs_channel_a", "can_id": 532, "data_type": DataType.FLOAT,
         "unit": units.get("hpa")},
        {"name": "engine_2_oil_pressure_ecs_channel_a", "can_id": 533, "data_type": DataType.FLOAT,
         "unit": units.get("hpa")},
        {"name": "engine_3_oil_pressure_ecs_channel_a", "can_id": 534, "data_type": DataType.FLOAT,
         "unit": units.get("hpa")},
        {"name": "engine_4_oil_pressure_ecs_channel_a", "can_id": 535, "data_type": DataType.FLOAT,
         "unit": units.get("hpa")},

        {"name": "engine_1_oil_temperature_ecs_channel_a", "can_id": 536, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_2_oil_temperature_ecs_channel_a", "can_id": 537, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_3_oil_temperature_ecs_channel_a", "can_id": 538, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_4_oil_temperature_ecs_channel_a", "can_id": 539, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},

        {"name": "engine_1_cylinder_head_temperature_ecs_channel_a", "can_id": 540, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_2_cylinder_head_temperature_ecs_channel_a", "can_id": 541, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_3_cylinder_head_temperature_ecs_channel_a", "can_id": 542, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_4_cylinder_head_temperature_ecs_channel_a", "can_id": 543, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},

        {"name": "engine_1_oil_quantity_ecs_channel_a", "can_id": 544,
            "data_type": DataType.FLOAT, "unit": units.get("temp")},
        {"name": "engine_2_oil_quantity_ecs_channel_a", "can_id": 545,
            "data_type": DataType.FLOAT, "unit": units.get("temp")},
        {"name": "engine_3_oil_quantity_ecs_channel_a", "can_id": 546,
            "data_type": DataType.FLOAT, "unit": units.get("temp")},
        {"name": "engine_4_oil_quantity_ecs_channel_a", "can_id": 547,
            "data_type": DataType.FLOAT, "unit": units.get("temp")},

        {"name": "engine_1_cooland_temperature_ecs_channel_a", "can_id": 548, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_2_cooland_temperature_ecs_channel_a", "can_id": 549, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_3_cooland_temperature_ecs_channel_a", "can_id": 550, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_4_cooland_temperature_ecs_channel_a", "can_id": 551, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},

        {"name": "engine_1_power_rating_ecs_channel_a", "can_id": 552, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine_2_power_rating_ecs_channel_a", "can_id": 553, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine_3_power_rating_ecs_channel_a", "can_id": 554, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine_4_power_rating_ecs_channel_a", "can_id": 555, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},

        {"name": "engine_1_status_1_ecs_channel_a", "can_id": 556,
            "data_type": DataType.BLONG, "unit": units.get("norm")},
        {"name": "engine_2_status_1_ecs_channel_a", "can_id": 557,
            "data_type": DataType.BLONG, "unit": units.get("norm")},
        {"name": "engine_3_status_1_ecs_channel_a", "can_id": 558,
            "data_type": DataType.BLONG, "unit": units.get("norm")},
        {"name": "engine_4_status_1_ecs_channel_a", "can_id": 559,
            "data_type": DataType.BLONG, "unit": units.get("norm")},

        {"name": "engine_1_status_2_ecs_channel_a", "can_id": 560,
            "data_type": DataType.BLONG, "unit": units.get("norm")},
        {"name": "engine_2_status_2_ecs_channel_a", "can_id": 561,
            "data_type": DataType.BLONG, "unit": units.get("norm")},
        {"name": "engine_3_status_2_ecs_channel_a", "can_id": 562,
            "data_type": DataType.BLONG, "unit": units.get("norm")},
        {"name": "engine_4_status_2_ecs_channel_a", "can_id": 563,
            "data_type": DataType.BLONG, "unit": units.get("norm")},
        {"name": "engine_1_oil_temperature_ecs_channel_b", "can_id": 600, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_2_oil_temperature_ecs_channel_b", "can_id": 601, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_3_oil_temperature_ecs_channel_b", "can_id": 602, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_4_oil_temperature_ecs_channel_b", "can_id": 603, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},

        {"name": "engine_1_cylinder_head_temperature_ecs_channel_b", "can_id": 604, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_2_cylinder_head_temperature_ecs_channel_b", "can_id": 605, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_3_cylinder_head_temperature_ecs_channel_b", "can_id": 606, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_4_cylinder_head_temperature_ecs_channel_b", "can_id": 607, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},

        {"name": "engine_1_oil_quantity_ecs_channel_b", "can_id": 608, "data_type": DataType.FLOAT,
         "unit": units.get("liter")},
        {"name": "engine_2_oil_quantity_ecs_channel_b", "can_id": 609, "data_type": DataType.FLOAT,
         "unit": units.get("liter")},
        {"name": "engine_3_oil_quantity_ecs_channel_b", "can_id": 610, "data_type": DataType.FLOAT,
         "unit": units.get("liter")},
        {"name": "engine_4_oil_quantity_ecs_channel_b", "can_id": 611, "data_type": DataType.FLOAT,
         "unit": units.get("liter")},

        {"name": "engine_1_coolant_temperature_ecs_channel_b", "can_id": 612, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_2_coolant_temperature_ecs_channel_b", "can_id": 613, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_3_coolant_temperature_ecs_channel_b", "can_id": 614, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},
        {"name": "engine_4_coolant_temperature_ecs_channel_b", "can_id": 615, "data_type": DataType.FLOAT,
         "unit": units.get("kelvin")},

        {"name": "engine_1_power_rating_ecs_channel_b", "can_id": 616, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine_2_power_rating_ecs_channel_b", "can_id": 617, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine_3_power_rating_ecs_channel_b", "can_id": 618, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine_4_power_rating_ecs_channel_b", "can_id": 619, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},

        {"name": "engine_1_status_1_ecs_channel_b", "can_id": 620,
            "data_type": DataType.BLONG, "unit": units.get('norm')},
        {"name": "engine_2_status_1_ecs_channel_b", "can_id": 621,
            "data_type": DataType.BLONG, "unit": units.get('norm')},
        {"name": "engine_3_status_1_ecs_channel_b", "can_id": 622,
            "data_type": DataType.BLONG, "unit": units.get('norm')},
        {"name": "engine_4_status_1_ecs_channel_b", "can_id": 623,
            "data_type": DataType.BLONG, "unit": units.get('norm')},

        {"name": "engine_1_status_2_ecs_channel_b", "can_id": 624,
            "data_type": DataType.BLONG, "unit": units.get('norm')},
        {"name": "engine_2_status_2_ecs_channel_b", "can_id": 625,
            "data_type": DataType.BLONG, "unit": units.get('norm')},
        {"name": "engine_3_status_2_ecs_channel_b", "can_id": 626,
            "data_type": DataType.BLONG, "unit": units.get('norm')},
        {"name": "engine_4_status_2_ecs_channel_b", "can_id": 627,
            "data_type": DataType.BLONG, "unit": units.get('norm')},

        {"name": "fuel_pump_1_flow_rate", "can_id": 660, "data_type": DataType.FLOAT,
         "unit": units.get("liter_per_hour")},
        {"name": "fuel_pump_2_flow_rate", "can_id": 661, "data_type": DataType.FLOAT,
         "unit": units.get("liter_per_hour")},
        {"name": "fuel_pump_3_flow_rate", "can_id": 662, "data_type": DataType.FLOAT,
         "unit": units.get("liter_per_hour")},
        {"name": "fuel_pump_4_flow_rate", "can_id": 663, "data_type": DataType.FLOAT,
         "unit": units.get("liter_per_hour")},
        {"name": "fuel_pump_5_flow_rate", "can_id": 664, "data_type": DataType.FLOAT,
         "unit": units.get("liter_per_hour")},
        {"name": "fuel_pump_6_flow_rate", "can_id": 665, "data_type": DataType.FLOAT,
         "unit": units.get("liter_per_hour")},
        {"name": "fuel_pump_7_flow_rate", "can_id": 666, "data_type": DataType.FLOAT,
         "unit": units.get("liter_per_hour")},
        {"name": "fuel_pump_8_flow_rate", "can_id": 667, "data_type": DataType.FLOAT,
         "unit": units.get("liter_per_hour")},

        {"name": "fuel_tank_1_quantity", "can_id": 668,
            "data_type": DataType.FLOAT, "unit": units.get("kilogram")},
        {"name": "fuel_tank_2_quantity", "can_id": 669,
            "data_type": DataType.FLOAT, "unit": units.get("kilogram")},
        {"name": "fuel_tank_3_quantity", "can_id": 670,
            "data_type": DataType.FLOAT, "unit": units.get("kilogram")},
        {"name": "fuel_tank_4_quantity", "can_id": 671,
            "data_type": DataType.FLOAT, "unit": units.get("kilogram")},
        {"name": "fuel_tank_5_quantity", "can_id": 672,
            "data_type": DataType.FLOAT, "unit": units.get("kilogram")},
        {"name": "fuel_tank_6_quantity", "can_id": 673,
            "data_type": DataType.FLOAT, "unit": units.get("kilogram")},
        {"name": "fuel_tank_7_quantity", "can_id": 674,
            "data_type": DataType.FLOAT, "unit": units.get("kilogram")},
        {"name": "fuel_tank_8_quantity", "can_id": 675,
            "data_type": DataType.FLOAT, "unit": units.get("kilogram")},

        {"name": "fuel_tank_1_temperature", "can_id": 676,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "fuel_tank_2_temperature", "can_id": 677,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "fuel_tank_3_temperature", "can_id": 678,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "fuel_tank_4_temperature", "can_id": 679,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "fuel_tank_5_temperature", "can_id": 680,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "fuel_tank_6_temperature", "can_id": 681,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "fuel_tank_7_temperature", "can_id": 682,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},
        {"name": "fuel_tank_8_temperature", "can_id": 683,
            "data_type": DataType.FLOAT, "unit": units.get("kelvin")},

        {"name": "fuel_system_1_pressure", "can_id": 684,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "fuel_system_2_pressure", "can_id": 685,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "fuel_system_3_pressure", "can_id": 686,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "fuel_system_4_pressure", "can_id": 687,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "fuel_system_5_pressure", "can_id": 688,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "fuel_system_6_pressure", "can_id": 689,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "fuel_system_7_pressure", "can_id": 690,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
        {"name": "fuel_system_8_pressure", "can_id": 691,
            "data_type": DataType.FLOAT, "unit": units.get("hpa")},
    ]
