from canaerospace.datatypes import DataType
from canaerospace.units import unit_map as units


#  @TODO Replace the norms unit with the correct unit per parameter
def get_flight_controls_parameters():
    """Flight controls data, CANAS 17 5.2"""
    return [
        {"name": "roll_control_position", "can_id": 401,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "lateral_stick_trim_position_command", "can_id": 402,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "yaw_control_position", "can_id": 403,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "collective_control_position", "can_id": 404,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "longitudinal_stick_trim_position_command", "can_id": 405, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "directional_pedals_trim_position_command", "can_id": 406, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "collective_lever_trim_position_command", "can_id": 407, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "cyclic_control_stick_switches", "can_id": 408,
            "data_type": DataType.BSHORT, "unit": units.get("none")},
        {"name": "lateral_trim_speed", "can_id": 409,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "longitudinal_trim_speed", "can_id": 410,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "pedal_trim_speed", "can_id": 411,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "collective_trim_speed", "can_id": 412,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "nose_wheel_steering_handle_position", "can_id": 413,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "engine1_throttle_lever_position_channel_a", "can_id": 414, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine2_throttle_lever_position_channel_a", "can_id": 415, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine3_throttle_lever_position_channel_a", "can_id": 416, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine4_throttle_lever_position_channel_a", "can_id": 417, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine1_condition_lever_position_channel_a", "can_id": 418, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine2_condition_lever_position_channel_a", "can_id": 419, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine3_condition_lever_position_channel_a", "can_id": 420, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine4_condition_lever_position_channel_a", "can_id": 421, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine1_throttle_lever_position_channel_b", "can_id": 422, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine2_throttle_lever_position_channel_b", "can_id": 423, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine3_throttle_lever_position_channel_b", "can_id": 424, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine4_throttle_lever_position_channel_b", "can_id": 425, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine1_condition_lever_position_channel_b", "can_id": 426, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine2_condition_lever_position_channel_b", "can_id": 427, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine3_condition_lever_position_channel_b", "can_id": 428, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "engine4_condition_lever_position_channel_b", "can_id": 429, "data_type": DataType.FLOAT,
         "unit": units.get("norm")},
        {"name": "flaps_lever_position", "can_id": 430,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "slats_lever_position", "can_id": 431,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "park_brake_lever_position", "can_id": 432,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "speedbrake_lever_position", "can_id": 433,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "throttle_max_lever_position", "can_id": 434,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "pilot_left_brake_pedal_position", "can_id": 435,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "pilot_right_brake_pedal_position", "can_id": 436,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "copilot_left_brake_pedal_position", "can_id": 437,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "copilot_right_brake_pedal_position", "can_id": 438,
            "data_type": DataType.FLOAT, "unit": units.get("norm")},
        {"name": "trim_system_switches", "can_id": 439,
            "data_type": DataType.BSHORT, "unit": units.get("none")},
        {"name": "trim_system_lights", "can_id": 440,
            "data_type": DataType.BSHORT, "unit": units.get("none")},
        {"name": "collective_control_stick_switches", "can_id": 441,
            "data_type": DataType.BSHORT, "unit": units.get("norm")},
        {"name": "stick_shaker_stall_warning_device", "can_id": 442,
            "data_type": DataType.BSHORT, "unit": units.get("norm")},
    ]
